/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.json;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public final class CalculatorJsonArrayExtractPath
extends CalculatorBase {
    public CalculatorJsonArrayExtractPath(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 2 || objParams.length > 3) {
            throw new IllegalArgumentException("Wrong parameter count, which should be 2 or 3.");
        }
        String resultIfNan = "NaN";
        if (objParams.length > 2 && null != objParams[2]) {
            resultIfNan = objParams[2].toString();
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return "[]";
        }
        Object objJson = objParams[0];
        if (null == objParams[1] || objParams[1].toString().isEmpty()) {
            return "[]";
        }
        String path = objParams[1].toString();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonParsed = jsonParser.parse(objJson.toString());
            if (null == jsonParsed) {
                return "[]";
            }
            JsonArray jsonArray = CalculatorJsonArrayExtractPath.getJsonArray(jsonParsed, path, this.decimalSymbol, this.digitGroupingSymbol);
            if (null == jsonArray) {
                return "[]";
            }
            String result = "[ ";
            boolean isFirst = true;
            for (JsonElement elem : jsonArray) {
                if (!isFirst) {
                    result = result + ", ";
                } else {
                    isFirst = false;
                }
                result = result + (null == elem || elem.isJsonNull() ? "\"" + resultIfNan + "\"" : elem.toString());
            }
            result = result + " ]";
            return result;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }

    public static JsonArray getJsonArray(JsonElement json, String path, char decimalSymbol, String digitGroupingSymbol) throws Exception {
        JsonArray result = new JsonArray();
        if (json instanceof JsonArray) {
            for (JsonElement elem : (JsonArray)json) {
                JsonElement elemOnPath = CalculatorJsonArrayExtractPath.getJsonElement(elem, path, decimalSymbol, digitGroupingSymbol);
                result.add(elemOnPath);
            }
        } else {
            JsonElement elemOnPath = CalculatorJsonArrayExtractPath.getJsonElement(json, path, decimalSymbol, digitGroupingSymbol);
            if (elemOnPath instanceof JsonArray) {
                result = (JsonArray)elemOnPath;
            } else {
                result.add(elemOnPath);
            }
        }
        return result;
    }

    public static JsonElement getJsonElement(JsonElement json, String path, char decimalSymbol, String digitGroupingSymbol) throws Exception {
        String[] parts = path.split("\\.|\\[|\\]");
        JsonElement result = json;
        for (String key : parts) {
            if ((key = key.trim()).isEmpty()) continue;
            if (result == null) {
                result = null;
                break;
            }
            if (result.isJsonObject()) {
                result = ((JsonObject)result).get(key);
                continue;
            }
            if (!result.isJsonArray()) break;
            if (!Conversion.isLong(key, decimalSymbol, digitGroupingSymbol)) {
                throw new Exception("Json array index is supposed to be specified, but '" + key + "' value is specified instead.");
            }
            int ix = new Long(Conversion.objectToLong(key, decimalSymbol, digitGroupingSymbol)).intValue();
            if (ix < 0 || ix >= ((JsonArray)result).size()) {
                return null;
            }
            result = ((JsonArray)result).get(ix);
        }
        return result;
    }
}

