/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorIrr
extends CalculatorBase {
    public CalculatorIrr(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    protected void checkToBeDouble(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isDoubleOrLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Double.");
        }
    }

    @Override
    public Object Calculate(Object[] objParams) {
        objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams);
        double[] Values2 = Conversion.objectArrayToDoubleArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        double Guess = 0.1;
        return new Double(CalculatorIrr.irr(Values2, Guess));
    }

    public static double irr(double[] values, double guess) {
        int maxIterationCount = 20;
        double absoluteAccuracy = 1.0E-7;
        double x0 = guess;
        for (int i = 0; i < maxIterationCount; ++i) {
            double fValue = 0.0;
            double fDerivative = 0.0;
            for (int k = 0; k < values.length; ++k) {
                fValue += values[k] / Math.pow(1.0 + x0, k);
                fDerivative += (double)(-k) * values[k] / Math.pow(1.0 + x0, k + 1);
            }
            double x1 = x0 - fValue / fDerivative;
            if (Math.abs(x1 - x0) <= absoluteAccuracy) {
                return x1;
            }
            x0 = x1;
        }
        return Double.NaN;
    }
}

