/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.ss.usermodel.DateUtil;

public final class CalculatorDateDif
extends CalculatorBase {
    public CalculatorDateDif(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 3);
        super.CheckForNotHavingRanges(objParams);
        DateTime d0 = Conversion.objectToDateTime(objParams[0]);
        DateTime d1 = Conversion.objectToDateTime(objParams[1]);
        Unit unit = this.parseUnit(Conversion.sanitizeFromVariableValue(objParams[2]));
        if (null == d0 || null == d1 || Unit.Unspecified == unit) {
            return -1L;
        }
        try {
            Date jd0 = DateTime.getClearDate(DateUtil.getJavaDate(d0.getValue()));
            Date jd1 = DateTime.getClearDate(DateUtil.getJavaDate(d1.getValue()));
            long res = -1L;
            if (jd0.getTime() > jd1.getTime()) {
                throw new IllegalArgumentException("The date in parameter 'Start_date' should be earlier than \\'\" + \"End_date\" + \"\\' .");
            }
            res = this.dateDif(jd0, jd1, unit);
            return new Long(res);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long dateDif(Date d0, Date d1, Unit unit) {
        GregorianCalendar gc0 = new GregorianCalendar();
        gc0.setTime(d0);
        GregorianCalendar gc1 = new GregorianCalendar();
        gc1.setTime(d1);
        long max = 99999999L;
        GregorianCalendar gcCalc = new GregorianCalendar();
        long counter = -1L;
        int calendarField = 6;
        switch (unit) {
            case Y: {
                gcCalc.setTime(d0);
                counter = -1L;
                calendarField = 1;
                break;
            }
            case M: {
                gcCalc.setTime(d0);
                counter = -1L;
                calendarField = 2;
                break;
            }
            case D: {
                gcCalc.setTime(d0);
                counter = 0L;
                calendarField = 6;
                break;
            }
            case MD: {
                break;
            }
            case YM: {
                gcCalc.setTime(d0);
                counter = -1L;
                calendarField = 2;
                break;
            }
            case YD: {
                break;
            }
            default: {
                return -1L;
            }
        }
        if (Unit.MD == unit) {
            gc1.set(1, gc0.get(1));
            gc1.set(2, gc0.get(2));
            long days1 = gc1.get(5);
            long days0 = gc0.get(5);
            counter = days1 - days0;
            if (counter < 0L) {
                long daysInMonth = gc0.getActualMaximum(5);
                counter += daysInMonth;
            }
        } else if (Unit.YD == unit) {
            gc1.set(1, gc0.get(1));
            long days1 = gc1.get(6);
            long days0 = gc0.get(6);
            counter = days1 - days0;
            if (counter < 0L) {
                long daysInYear = gc0.getActualMaximum(6);
                counter += daysInYear;
            }
        } else {
            while (gcCalc.compareTo(gc1) < 0 && counter < max) {
                gcCalc.add(calendarField, 1);
                Date tmp = gcCalc.getTime();
                ++counter;
            }
            counter = Math.max(0L, counter);
            if (Unit.YM == unit) {
                counter = Math.floorMod(counter, 12L);
            }
        }
        return counter;
    }

    protected Unit parseUnit(Object objUnit) {
        String strUnit;
        String string = strUnit = null == objUnit ? "" : objUnit.toString();
        if (strUnit.equalsIgnoreCase("Y")) {
            return Unit.Y;
        }
        if (strUnit.equalsIgnoreCase("M")) {
            return Unit.M;
        }
        if (strUnit.equalsIgnoreCase("D")) {
            return Unit.D;
        }
        if (strUnit.equalsIgnoreCase("MD")) {
            return Unit.MD;
        }
        if (strUnit.equalsIgnoreCase("YM")) {
            return Unit.YM;
        }
        if (strUnit.equalsIgnoreCase("YD")) {
            return Unit.YD;
        }
        return Unit.Unspecified;
    }

    static enum Unit {
        Y,
        M,
        D,
        MD,
        YM,
        YD,
        Unspecified;

    }
}

