/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.usermodel.DateUtil;

public final class CalculatorDate
extends CalculatorBase {
    public CalculatorDate(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 3);
        super.CheckForNotHavingRanges(objParams);
        if (!(Conversion.isLong(objParams[0], this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol))) {
            return "";
        }
        Long d0 = Conversion.objectToLong(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        Long d1 = Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
        Long d2 = Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
        try {
            double res = CalculatorDate.evaluate(CalculatorDate.getYear(d0.longValue()), d1.intValue() - 1, d2.intValue());
            return new DateTime(res);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static double evaluate(int year, int month, int pDay) throws EvaluationException {
        if (year < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        while (month < 0) {
            --year;
            month += 12;
        }
        if (year == 1900 && month == 1 && pDay == 29) {
            return 60.0;
        }
        int day = pDay;
        if (year == 1900 && (month == 0 && day >= 60 || month == 1 && day >= 30)) {
            --day;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, month, day, 0, 0, 0);
        c.set(14, 0);
        if (pDay < 0 && c.get(1) == 1900 && month > 1 && c.get(2) < 2) {
            ((Calendar)c).add(5, 1);
        }
        boolean use1904windowing = false;
        return DateUtil.getExcelDate(c.getTime(), use1904windowing);
    }

    private static int getYear(double d) {
        int year = (int)d;
        if (year < 0) {
            return -1;
        }
        return year < 1900 ? 1900 + year : year;
    }
}

