/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Variable;
import com.celestecs.expression.VariableValue;

public final class VariableRange
extends Variable {
    private String name;
    private VariableValue[][] variables;
    private int rowCount = 0;
    private int colCount = 0;

    public Object[][] getVariables() {
        return this.variables;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.colCount;
    }

    public int getVarCount() {
        return this.rowCount * this.colCount;
    }

    public VariableValue getVariableValue(int row, int col) {
        if (row < 0 || row >= this.rowCount) {
            return null;
        }
        if (col < 0 || col >= this.colCount) {
            return null;
        }
        return this.variables[row][col];
    }

    public VariableRange(String name, VariableValue[][] varValues) {
        if (null == varValues) {
            throw new IllegalArgumentException("variableNames");
        }
        this.name = name;
        this.rowCount = varValues.length;
        if (this.rowCount < 1) {
            throw new IllegalArgumentException("Variable Names array is empty.");
        }
        this.colCount = varValues[0].length;
        if (this.colCount < 1) {
            throw new IllegalArgumentException("Variable Names array has no columns.");
        }
        this.variables = new VariableValue[this.rowCount][this.colCount];
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                this.variables[i][j] = varValues[i][j];
            }
        }
    }

    @Override
    public Variable.VariableType getVariableType() {
        return Variable.VariableType.RANGE;
    }

    @Override
    public Object getValue() {
        return this.variables;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    public String toString() {
        int rowCount;
        if (null == this.variables) {
            return "[]";
        }
        int n = rowCount = null == this.variables ? 0 : this.variables.length;
        if (1 == rowCount) {
            String result = "[ ";
            boolean bFirstValue = true;
            this.colCount = this.variables[0].length;
            for (int i = 0; i < this.colCount; ++i) {
                String value;
                String string = value = null == this.variables[0][i] || null == this.variables[0][i].getValue() ? "\"\"" : this.variables[0][i].getValue().toString();
                if (!bFirstValue) {
                    result = result + ", ";
                } else {
                    bFirstValue = false;
                }
                result = result + value;
            }
            result = result + " ]";
            return result;
        }
        String result = "[ ";
        boolean bFirstRowValue = true;
        for (int j = 0; j < rowCount; ++j) {
            if (!bFirstRowValue) {
                result = result + ", ";
            } else {
                bFirstRowValue = false;
            }
            result = result + "[ ";
            boolean bFirstColumnValue = true;
            this.colCount = this.variables[j].length;
            for (int i = 0; i < this.colCount; ++i) {
                String value;
                String string = value = null == this.variables[j][i] || null == this.variables[j][i].getValue() ? "\"\"" : this.variables[j][i].getValue().toString();
                if (!bFirstColumnValue) {
                    result = result + ", ";
                } else {
                    bFirstColumnValue = false;
                }
                result = result + value;
            }
            result = result + " ]";
        }
        result = result + " ]";
        return result;
    }
}

