/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.servlet;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.celestecs.confluence.math.NumericalExpressionMacro;
import com.celestecs.confluence.server.ConfluenceServerMacroPageContentProvider;
import com.celestecs.confluence.server.ConfluenceServerMacroTextResolver;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.MacroResultCache;
import com.celestecs.expression.MathServletTextResolver;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.NumericalExpressionMacroParams;
import com.celestecs.expression.ServletTools;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NumericalExpressionServlet
extends HttpServlet {
    private final XhtmlContent xhtmlUtils;
    private final I18nResolver i18n;
    protected final PluginLicenseManager licenseManager;
    protected final UserAccessor userAccessor;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    ConfluenceServerMacroPageContentProvider pageContentProvider;
    MathTextResolver mathTextResolver;

    public NumericalExpressionServlet(XhtmlContent xhtmlUtils, I18nResolver i18nResolver, PluginLicenseManager licenseMgr, UserAccessor userAccessor, PageManager pageManager, PermissionManager permissionManager) {
        this.xhtmlUtils = xhtmlUtils;
        this.i18n = i18nResolver;
        this.licenseManager = licenseMgr;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.pageContentProvider = new ConfluenceServerMacroPageContentProvider(this.pageManager, this.permissionManager, this.xhtmlUtils);
        this.mathTextResolver = new ConfluenceServerMacroTextResolver(this.i18n);
    }

    protected Map<String, String> decodeParamMap(Map<String, String> paramMap) {
        HashMap<String, String> resultParamMap = new HashMap<String, String>();
        if (null == paramMap) {
            return resultParamMap;
        }
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            if (null == paramName || paramName.isEmpty()) continue;
            String encodedParamValue = entry.getValue();
            if (null == encodedParamValue || encodedParamValue.isEmpty()) {
                resultParamMap.put(paramName, "");
                continue;
            }
            String decodedParamValue = URLDecoder.decode(encodedParamValue);
            if (null == decodedParamValue || decodedParamValue.isEmpty()) {
                resultParamMap.put(paramName, "");
                continue;
            }
            resultParamMap.put(paramName, decodedParamValue);
        }
        return resultParamMap;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MacroHelper.Log("Math doGet: Started");
        String macroId = "";
        Map<String, String> parameters = null;
        String bodyContent = "";
        String strPageId = "";
        try {
            MacroHelper.Log("Math doGet: Reading param map");
            MacroHelper.Log("Math doGet: Uri:" + req.getRequestURI());
            Map<String, String> encodedParamMap = MacroHelper.getParamMap(req.getParameterMap());
            Map<String, String> paramMap = this.decodeParamMap(encodedParamMap);
            MacroHelper.Log("Math doGet: parameters: " + ServletTools.mapToStr(paramMap));
            NumericalExpressionMacroParams param = new NumericalExpressionMacroParams(paramMap);
            MacroHelper.Log("Math doGet: param: " + param.toString());
            MathServletTextResolver mathTextResolver = new MathServletTextResolver();
            MacroHelper.Log("Math doGet: Verifying request");
            bodyContent = paramMap.get("body");
            String tr = paramMap.get("tr");
            strPageId = paramMap.get("pageId");
            String strMacroId = paramMap.get("macroId");
            String curTblIdx = paramMap.get("curTblIdx");
            String strPreviewMode = paramMap.get("preiew");
            int currentTableIndexOneBased = -1;
            try {
                if (null != curTblIdx && curTblIdx.length() > 0) {
                    currentTableIndexOneBased = Integer.parseInt(curTblIdx);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MacroHelper.Log("Math doGet: All checks passed");
            resp.setContentType("text/html");
            long pageId = Long.parseLong(strPageId);
            boolean isTrialLicense = null != tr && tr.equalsIgnoreCase("true");
            boolean isInPreviewMode = false;
            if (null != strPreviewMode && strPreviewMode.equalsIgnoreCase("true")) {
                isInPreviewMode = true;
            }
            AbstractPage page = this.pageManager.getAbstractPage(pageId);
            PageContext pageContext = page.toPageContext();
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)pageContext);
            this.pageContentProvider.setChangableParams(bodyContent, (ConversionContext)conversionContext, param.otherConfluencePage, param.decimalSymbol, param.digitGroupingSymbol, param.backwardCompatibilityMode, mathTextResolver, strPageId);
            this.pageContentProvider.setMacroId(strMacroId);
            this.pageContentProvider.setCurrentTableIndexOneBased(currentTableIndexOneBased);
            String result = NumericalExpressionMacro.doCalc(parameters, isInPreviewMode, bodyContent, (ConversionContext)conversionContext, this.pageContentProvider, this.xhtmlUtils, mathTextResolver, param, strPageId, isTrialLicense);
            MacroHelper.Log("Math doGet result: " + result);
            ServletTools.setOk(resp, result);
            return;
        }
        catch (Exception exception) {
            MacroHelper.Log("Math doGet exception: Class: '" + exception.getClass() + "', Message: '" + exception.getMessage() + "'");
            String errMsg = exception.getMessage().replace(MacroHelper.UNIQUE_BRACES, "");
            ServletTools.setError(resp, errMsg);
            if (Features.BREAK_RENDER_LOOP_2 && null != MacroResultCache.macroResultCache) {
                String strKey = ConfluenceServerMacroPageContentProvider.makeKeyFromMacroDef(macroId, bodyContent, parameters, strPageId);
                MacroResultCache.macroResultCache.remove(strKey);
            }
            MacroHelper.Log("Math doGet: Returning after some error");
            return;
        }
    }
}

