/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.server;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.celestecs.expression.Features;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.PageAttachmentProvider;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ConfluenceServerAttachmentProvider
implements PageAttachmentProvider {
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private AttachmentManager attachmentManager;
    private MathTextResolver mathTextResolver;

    public ConfluenceServerAttachmentProvider(PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, MathTextResolver mathTextResolver) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.attachmentManager = attachmentManager;
        this.mathTextResolver = mathTextResolver;
    }

    @Override
    public String getAttachmentData(String space, String title, String attachmentFileName) throws Exception {
        Attachment attachment;
        User user;
        Page page;
        if (null == this.pageManager || null == this.attachmentManager || null == attachmentFileName || attachmentFileName.length() < 1) {
            return "";
        }
        Page contentObject = null;
        if (null != this.pageManager && null != space && space.length() > 0 && null != title && title.length() > 0 && null != (page = this.pageManager.getPage(space, title)) && null != (user = AuthenticatedUserThreadLocal.getUser())) {
            String userName = user.getName();
            if (null != this.permissionManager && !ConfluenceServerAttachmentProvider.isUserAuthorizedToReadThePage(this.permissionManager, user, page)) {
                throw new ExpressionCalculationException(String.format(null == this.mathTextResolver ? "Not enough permissions to read the outer page" : this.mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.UserNotAuthorised"), userName, page.getTitle()));
            }
            contentObject = page;
        }
        if (null != contentObject && null != this.attachmentManager && null != (attachment = this.attachmentManager.getAttachment(contentObject, attachmentFileName))) {
            BufferedReader in;
            long fileSize = attachment.getFileSize();
            if (fileSize < 1L) {
                throw new ExpressionCalculationException("Unable to retrieve the file size data for the attachment with name '" + attachmentFileName + "' on the page '" + title + "'.");
            }
            if (fileSize > Features.MAX_REPORTING_ATTACHMENT_FILE_SIZE) {
                throw new ExpressionCalculationException("Unable to retrieve the exact file size data for the attachment with name '" + attachmentFileName + "' on the page '" + title + "'.");
            }
            InputStream is = this.attachmentManager.getAttachmentData(attachment);
            if (null != is && null != (in = new BufferedReader(new InputStreamReader(is, "UTF-8")))) {
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                return response.toString();
            }
        }
        return "";
    }

    public static boolean isUserAuthorizedToReadThePage(PermissionManager permissionManager, User user, Page page) {
        return null != permissionManager && user != null && permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }
}

