/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.math;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.net.Request;
import com.celestecs.expression.Features;
import com.celestecs.expression.JiraIssueFieldDescriptor;
import com.celestecs.expression.QueryExecutor;
import com.celestecs.expression.ServletTools;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MathJqlQueryExecutor
implements QueryExecutor {
    protected String DUMMY_JIRA_RESPONSE = "{\"expand\":\"schema,names\",\"startAt\":0,\"maxResults\":1000,\"total\":3,\"issues\":[{\"expand\":\"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\":\"10002\",\"self\":\"http://lexus:2990/jira/rest/api/2/issue/10002\",\"key\":\"TEST-3\",\"fields\":{\"issuetype\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\":\"10000\",\"description\":\"Task.\",\"iconUrl\":\"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\":\"Task\",\"subtask\":false,\"avatarId\":10318},\"components\":[],\"timespent\":null,\"timeoriginalestimate\":null,\"description\":null,\"project\":{\"self\":\"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\":\"10001\",\"key\":\"TEST\",\"name\":\"Test\",\"projectTypeKey\":\"business\",\"avatarUrls\":{\"48x48\":\"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\":\"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\":\"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\":\"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\":[],\"aggregatetimespent\":null,\"resolution\":null,\"aggregatetimeestimate\":null,\"resolutiondate\":null,\"workratio\":-1,\"summary\":\"Task 3\",\"lastViewed\":\"2021-06-21T22:09:13.905+0300\",\"watches\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-3/watchers\",\"watchCount\":1,\"isWatching\":true},\"creator\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"subtasks\":[],\"created\":\"2021-05-30T23:40:37.000+0300\",\"reporter\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"aggregateprogress\":{\"progress\":0,\"total\":0},\"priority\":{\"self\":\"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\":\"Medium\",\"id\":\"3\"},\"labels\":[],\"environment\":null,\"timeestimate\":null,\"aggregatetimeoriginalestimate\":null,\"versions\":[],\"duedate\":null,\"progress\":{\"progress\":0,\"total\":0},\"issuelinks\":[],\"votes\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-3/votes\",\"votes\":0,\"hasVoted\":false},\"assignee\":null,\"updated\":\"2021-05-30T23:40:37.000+0300\",\"status\":{\"self\":\"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\":\"\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\":\"To Do\",\"id\":\"10000\",\"statusCategory\":{\"self\":\"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\":2,\"key\":\"new\",\"colorName\":\"blue-gray\",\"name\":\"To Do\"}}}},{\"expand\":\"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\":\"10001\",\"self\":\"http://lexus:2990/jira/rest/api/2/issue/10001\",\"key\":\"TEST-2\",\"fields\":{\"issuetype\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\":\"10000\",\"description\":\"Task.\",\"iconUrl\":\"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\":\"Task\",\"subtask\":false,\"avatarId\":10318},\"components\":[],\"timespent\":null,\"timeoriginalestimate\":null,\"description\":null,\"project\":{\"self\":\"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\":\"10001\",\"key\":\"TEST\",\"name\":\"Test\",\"projectTypeKey\":\"business\",\"avatarUrls\":{\"48x48\":\"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\":\"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\":\"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\":\"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\":[],\"aggregatetimespent\":null,\"resolution\":null,\"aggregatetimeestimate\":null,\"resolutiondate\":null,\"workratio\":-1,\"summary\":\"Task 2\",\"lastViewed\":\"2021-05-30T23:40:32.448+0300\",\"watches\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-2/watchers\",\"watchCount\":1,\"isWatching\":true},\"creator\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"subtasks\":[],\"created\":\"2021-05-30T23:40:32.000+0300\",\"reporter\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"aggregateprogress\":{\"progress\":0,\"total\":0},\"priority\":{\"self\":\"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\":\"Medium\",\"id\":\"3\"},\"labels\":[],\"environment\":null,\"timeestimate\":null,\"aggregatetimeoriginalestimate\":null,\"versions\":[],\"duedate\":null,\"progress\":{\"progress\":0,\"total\":0},\"issuelinks\":[],\"votes\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-2/votes\",\"votes\":0,\"hasVoted\":false},\"assignee\":null,\"updated\":\"2021-05-30T23:40:32.000+0300\",\"status\":{\"self\":\"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\":\"\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\":\"To Do\",\"id\":\"10000\",\"statusCategory\":{\"self\":\"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\":2,\"key\":\"new\",\"colorName\":\"blue-gray\",\"name\":\"To Do\"}}}},{\"expand\":\"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\":\"10000\",\"self\":\"http://lexus:2990/jira/rest/api/2/issue/10000\",\"key\":\"TEST-1\",\"fields\":{\"issuetype\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\":\"10000\",\"description\":\"Task.\",\"iconUrl\":\"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\":\"Task\",\"subtask\":false,\"avatarId\":10318},\"components\":[],\"timespent\":null,\"timeoriginalestimate\":null,\"description\":null,\"project\":{\"self\":\"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\":\"10001\",\"key\":\"TEST\",\"name\":\"Test\",\"projectTypeKey\":\"business\",\"avatarUrls\":{\"48x48\":\"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\":\"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\":\"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\":\"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\":[],\"aggregatetimespent\":null,\"resolution\":null,\"aggregatetimeestimate\":null,\"resolutiondate\":null,\"workratio\":-1,\"summary\":\"Task 1\",\"lastViewed\":\"2021-05-30T23:40:21.025+0300\",\"watches\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-1/watchers\",\"watchCount\":1,\"isWatching\":true},\"creator\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"subtasks\":[],\"created\":\"2021-05-30T23:40:18.000+0300\",\"reporter\":{\"self\":\"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\":\"admin\",\"key\":\"admin\",\"emailAddress\":\"admin@admin.com\",\"avatarUrls\":{\"48x48\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\":\"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\":\"admin\",\"active\":true,\"timeZone\":\"Europe/Moscow\"},\"aggregateprogress\":{\"progress\":0,\"total\":0},\"priority\":{\"self\":\"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\":\"Medium\",\"id\":\"3\"},\"labels\":[],\"environment\":null,\"timeestimate\":null,\"aggregatetimeoriginalestimate\":null,\"versions\":[],\"duedate\":null,\"progress\":{\"progress\":0,\"total\":0},\"issuelinks\":[],\"votes\":{\"self\":\"http://lexus:2990/jira/rest/api/2/issue/TEST-1/votes\",\"votes\":0,\"hasVoted\":false},\"assignee\":null,\"updated\":\"2021-05-30T23:40:18.000+0300\",\"status\":{\"self\":\"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\":\"\",\"iconUrl\":\"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\":\"To Do\",\"id\":\"10000\",\"statusCategory\":{\"self\":\"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\":2,\"key\":\"new\",\"colorName\":\"blue-gray\",\"name\":\"To Do\"}}}},{\"expand\": \"operations,versionedRepresentations,editmeta,changelog,renderedFields\",\"id\": \"10000\",\"self\": \"http://lexus:2990/jira/rest/api/2/issue/10000\",\"key\": \"TEST-1\",\"fields\": {\"issuetype\": {\"self\": \"http://lexus:2990/jira/rest/api/2/issuetype/10000\",\"id\": \"10000\",\"description\": \"Task.\",\"iconUrl\": \"http://lexus:2990/jira/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype\",\"name\": \"Task\",\"subtask\": false,\"avatarId\": 10318},\"components\": [],\"timespent\": null,\"timeoriginalestimate\": null,\"description\": null,\"project\": {\"self\": \"http://lexus:2990/jira/rest/api/2/project/10001\",\"id\": \"10001\",\"key\": \"TEST\",\"name\": \"Test\",\"projectTypeKey\": \"business\",\"avatarUrls\": {\"48x48\": \"http://lexus:2990/jira/secure/projectavatar?avatarId=10324\",\"24x24\": \"http://lexus:2990/jira/secure/projectavatar?size=small&avatarId=10324\",\"16x16\": \"http://lexus:2990/jira/secure/projectavatar?size=xsmall&avatarId=10324\",\"32x32\": \"http://lexus:2990/jira/secure/projectavatar?size=medium&avatarId=10324\"}},\"fixVersions\": [],\"aggregatetimespent\": null,\"resolution\": null,\"aggregatetimeestimate\": null,\"resolutiondate\": null,\"workratio\": -1,\"summary\": \"Task 1\",\"lastViewed\": \"2021-05-30T23:40:21.025+0300\",\"watches\": {\"self\": \"http://lexus:2990/jira/rest/api/2/issue/TEST-1/watchers\",\"watchCount\": 1,\"isWatching\": true},\"creator\": {\"self\": \"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\": \"admin\",\"key\": \"admin\",\"emailAddress\": \"admin@admin.com\",\"avatarUrls\": {\"48x48\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\": \"admin\",\"active\": true,\"timeZone\": \"Europe/Moscow\"},\"subtasks\": [],\"created\": \"2021-05-30T23:40:18.000+0300\",\"reporter\": {\"self\": \"http://lexus:2990/jira/rest/api/2/user?username=admin\",\"name\": \"admin\",\"key\": \"admin\",\"emailAddress\": \"admin@admin.com\",\"avatarUrls\": {\"48x48\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=48\",\"24x24\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=24\",\"16x16\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=16\",\"32x32\": \"https://www.gravatar.com/avatar/64e1b8d34f425d19e1ee2ea7236d3028?d=mm&s=32\"},\"displayName\": \"admin\",\"active\": true,\"timeZone\": \"Europe/Moscow\"},\"aggregateprogress\": {\"progress\": 0,\"total\": 0},\"priority\": {\"self\": \"http://lexus:2990/jira/rest/api/2/priority/3\",\"iconUrl\": \"http://lexus:2990/jira/images/icons/priorities/medium.svg\",\"name\": \"Medium\",\"id\": \"3\"},\"labels\": [],\"environment\": null,\"timeestimate\": null,\"aggregatetimeoriginalestimate\": null,\"versions\": [],\"duedate\": null,\"progress\": {\"progress\": 0,\"total\": 0},\"issuelinks\": [],\"votes\": {\"self\": \"http://lexus:2990/jira/rest/api/2/issue/TEST-1/votes\",\"votes\": 0,\"hasVoted\": false},\"assignee\": null,\"updated\": \"2021-05-30T23:40:18.000+0300\",\"status\": {\"self\": \"http://lexus:2990/jira/rest/api/2/status/10000\",\"description\": \"\",\"iconUrl\": \"http://lexus:2990/jira/images/icons/status_generic.gif\",\"name\": \"To Do\",\"id\": \"10000\",\"statusCategory\": {\"self\": \"http://lexus:2990/jira/rest/api/2/statuscategory/2\",\"id\": 2,\"key\": \"new\",\"colorName\": \"blue-gray\",\"name\": \"To Do\"}}}}]}";
    protected final ApplicationLinkService applicationLinkService;

    public MathJqlQueryExecutor(ApplicationLinkService _applicationLinkService) {
        this.applicationLinkService = _applicationLinkService;
    }

    @Override
    public long getNumberOfResults(String jqlRequest, String appLinkName) throws Exception {
        String fields = "";
        if (null != jqlRequest && jqlRequest.indexOf(Features.UNIQUE_SEPARATOR) > -1) {
            String req = jqlRequest;
            jqlRequest = req.substring(0, req.indexOf(Features.UNIQUE_SEPARATOR));
            fields = req.substring(req.indexOf(Features.UNIQUE_SEPARATOR) + Features.UNIQUE_SEPARATOR.length(), req.length());
        }
        ApplicationLink appLink = this.getAppLink(appLinkName);
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        String apiPath = applicationUrl + "/rest/api/2/search?jql=" + ServletTools.URLEncode(jqlRequest);
        apiPath = apiPath + "&fields=id";
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath);
        request.addHeader("Content-Type", "application/json");
        String jsRoot = request.execute();
        String strTotal = ServletTools.extractValueFromJsonString(jsRoot, "total");
        if (null == strTotal || strTotal.isEmpty()) {
            throw new Exception("Unable to retrieve the 'total' field value from the REST API 'search' function result.");
        }
        long intTotal = Long.parseLong(strTotal);
        return intTotal;
    }

    @Override
    public Object[] getResultsByQuery(String jqlRequest, String appLinkName, long startAt, long maxResults) throws Exception {
        int count;
        ApplicationLink appLink;
        String fields = "";
        if (null != jqlRequest && jqlRequest.indexOf(Features.UNIQUE_SEPARATOR) > -1) {
            String req = jqlRequest;
            jqlRequest = req.substring(0, req.indexOf(Features.UNIQUE_SEPARATOR));
            fields = req.substring(req.indexOf(Features.UNIQUE_SEPARATOR) + Features.UNIQUE_SEPARATOR.length(), req.length());
        }
        if (null != fields && fields.length() > 0 && !fields.matches("^[0-9a-zA-Z.\\-\\*]+(,[0-9a-zA-Z.\\-\\*]+)*$")) {
            throw new Exception("The specified field list '" + fields + "' looks to be incorrect. Please, specify comma-separated alhanumeric names with dots, minuses and stars accepted and spaces or other symbols not accepted.");
        }
        ApplicationLink applicationLink = appLink = Features.USE_DUMMY_JIRA ? null : this.getAppLink(appLinkName);
        if (null == appLink && !Features.USE_DUMMY_JIRA) {
            throw new Exception("Unable to open appliction link with name '" + appLinkName + "'.");
        }
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        String applicationUrl = Features.USE_DUMMY_JIRA || Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = Features.USE_DUMMY_JIRA ? null : appLink.createAuthenticatedRequestFactory();
        long realTotal = 0L;
        long counter = 100000L;
        for (maxResults = Math.min(1000L, maxResults); counter > 0L && maxResults >= 1L; maxResults -= (long)count) {
            --counter;
            String apiPath = Features.USE_DUMMY_JIRA ? "" : applicationUrl + "/rest/api/2/search?jql=" + ServletTools.URLEncode(jqlRequest);
            apiPath = apiPath + "&startAt=" + startAt;
            apiPath = apiPath + "&maxResults=" + maxResults;
            if (null != fields && fields.length() > 0) {
                apiPath = apiPath + "&fields=" + ServletTools.URLEncode(fields);
            }
            ApplicationLinkRequest request = Features.USE_DUMMY_JIRA ? null : requestFactory.createRequest(Request.MethodType.GET, apiPath);
            String jsRoot = "";
            jsRoot = Features.USE_DUMMY_JIRA ? (0L == startAt ? this.DUMMY_JIRA_RESPONSE : "{\"expand\":\"schema,names\",\"startAt\":" + startAt + ",\"maxResults\":1000,\"total\":0,\"issues\":[]}") : request.execute();
            JsonElement jsonnElem = ServletTools.extractValueFromJsonStringAsJsonElement(jsRoot, "issues");
            if (null == jsonnElem || !jsonnElem.isJsonArray()) {
                return new Object[0];
            }
            JsonArray issueArray = jsonnElem.getAsJsonArray();
            if (null == issueArray || issueArray.size() < 1) break;
            count = issueArray.size();
            for (int i = 0; i < count; ++i) {
                JsonElement objItem = issueArray.get(i);
                if (null == objItem) continue;
                result.add(objItem);
            }
            startAt = realTotal += (long)count;
            if (realTotal >= maxResults) break;
        }
        return result.toArray();
    }

    @Override
    public Object[] getResultFieldValues(String jqlRequest, String fieldName, Object valueIfNull, String appLinkName, boolean byFieldId) throws Exception {
        if (byFieldId && !fieldName.matches("[A-Za-z0-9 _]+")) {
            throw new Exception("The field '" + fieldName + "' name does not match the regexp \"[A-Za-z0-9 _]+\".");
        }
        ApplicationLink appLink = this.getAppLink(appLinkName);
        if (null == appLink) {
            throw new Exception("Unable to open appliction link with name '" + appLinkName + "'.");
        }
        JiraIssueFieldDescriptor fieldDescriptor = this.loadFieldDescriptor(appLink, byFieldId, fieldName);
        fieldName = fieldDescriptor.id;
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        ArrayList<Object> result = new ArrayList<Object>();
        long startAt = 0L;
        long maxResults = 1000L;
        long counter = 10000L;
        while (counter > 0L) {
            --counter;
            String apiPath = applicationUrl + "/rest/api/2/search?jql=" + ServletTools.URLEncode(jqlRequest);
            apiPath = apiPath + "&startAt=" + startAt;
            apiPath = apiPath + "&maxResults=" + maxResults;
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath = apiPath + "&fields=" + ServletTools.URLEncode(fieldName));
            String jsRoot = request.execute();
            String objTotal = ServletTools.extractValueFromJsonString(jsRoot, "total");
            if (null == objTotal || objTotal.toString().isEmpty()) {
                Object[] tmpResult = ServletTools.extractValuesFromJsonString(jsRoot, fieldDescriptor, valueIfNull);
                if (null == tmpResult || tmpResult.length < 1) {
                    throw new Exception("Unable retrieve the 'total' field value from the result of REST API search function result");
                }
                return tmpResult;
            }
            long realTotal = Long.parseLong(objTotal.toString());
            Object[] tmpResult = ServletTools.extractValuesFromJsonString(jsRoot, fieldDescriptor, valueIfNull);
            if (null == tmpResult || tmpResult.length < 1) break;
            int count = tmpResult.length;
            for (Object obj : tmpResult) {
                result.add(obj);
            }
            if ((startAt += (long)count) < realTotal) continue;
            break;
        }
        return result.toArray();
    }

    protected JiraIssueFieldDescriptor loadFieldDescriptor(ApplicationLink appLink, boolean byFieldId, String fieldNameOrId) throws Exception {
        String apiPath;
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath = applicationUrl + "/rest/api/2/field");
        String jsRoot = request.execute();
        if (null == jsRoot || jsRoot.isEmpty()) {
            throw new Exception("The REST API call for the list of fields in '" + appLink.getName() + "' returned an empty list.");
        }
        JsonObject jsonDescriptor = ServletTools.extractJsonObjectFromJsonString(jsRoot, byFieldId ? "id" : "name", fieldNameOrId);
        if (null == jsonDescriptor) {
            throw new Exception("The REST API call for the list of fields in '" + appLink.getName() + "' returned an empty descriptor.");
        }
        JiraIssueFieldDescriptor jiraIssueFieldDescriptor = ServletTools.getJiraIssueFieldDescriptorFromJsonObject(jsonDescriptor);
        return jiraIssueFieldDescriptor;
    }

    public Map<String, String> loadFieldDescriptions(String appLinkName) throws Exception {
        String apiPath;
        HashMap<String, String> result = new HashMap();
        ApplicationLink appLink = this.getAppLink(appLinkName);
        if (null == appLink) {
            throw new Exception("Unable to retrieve application link for '" + appLinkName + "'.");
        }
        String applicationUrl = Features.DONT_SPECIFY_HOSTNAME_FOR_REST_API ? "" : appLink.getRpcUrl().toString();
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, apiPath = applicationUrl + "/rest/api/2/field");
        String jsRoot = request.execute();
        if (null == jsRoot || jsRoot.isEmpty()) {
            throw new Exception("The REST API call for the list of fields in '" + appLinkName + "' returned an empty list.");
        }
        result = ServletTools.extractMapFromJsonString(jsRoot, "name", "id");
        return result;
    }

    protected ApplicationLink getAppLink(String appLinkName) throws Exception {
        if (null == this.applicationLinkService) {
            throw new Exception("Unable to retrieve the application link for '" + appLinkName + "' due to not initialized application link service object.");
        }
        Iterable appLinks = null;
        if (null != appLinkName && !appLinkName.isEmpty()) {
            appLinks = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
            if (null == appLinks) {
                throw new Exception("Unable to retrieve the list of application links.");
            }
            for (ApplicationLink appLink : appLinks) {
                String thisLinkName;
                if (null == appLink || null == (thisLinkName = appLink.getName()) || 0 != thisLinkName.compareTo(appLinkName)) continue;
                return appLink;
            }
            throw new Exception("Unable to find the application link '" + appLinkName + "' in the list of application links.");
        }
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
        if (null == appLink) {
            throw new Exception("Unable to retrieve default application link. Try to specify an exact application link name.");
        }
        return appLink;
    }
}

