/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.conditionalrules;

import com.celestecs.conditionalrules.AffectedElementsSpecification;
import com.celestecs.conditionalrules.ConditionalRuleBase;
import com.celestecs.conditionalrules.ConditionalRuleMacroParams;
import com.celestecs.conditionalrules.HtmlTools;
import com.celestecs.conditionalrules.RuleCondition;
import com.celestecs.conditionalrules.RuleSubject;
import com.celestecs.conditionalrules.StyleApplicationType;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ConditionalRule
extends ConditionalRuleBase {
    protected RuleCondition ruleCondition = RuleCondition.ElementValueIsBetween;
    protected String value1 = "";
    protected String value2 = "";
    public boolean isValue1Long = false;
    public boolean isValue1DoubleOrLong = false;
    public long value1AsLong = 0L;
    public double value1AsDouble = 0.0;
    public boolean isValue2Long = false;
    public boolean isValue2DoubleOrLong = false;
    public long value2AsLong = 0L;
    public double value2AsDouble = 0.0;

    public ConditionalRule(RuleCondition ruleCondition, String value1, String value2, String appliesTo, String affectedElements, boolean stopIfTrue, StyleApplicationType bold, StyleApplicationType italic, StyleApplicationType underline, String textColor, String backgroundColor, String replacementText, char decimalSymbol, String digitGroupingSymbol) {
        super(appliesTo, affectedElements, stopIfTrue, bold, italic, underline, textColor, backgroundColor, replacementText, decimalSymbol, digitGroupingSymbol);
        this.ruleCondition = ruleCondition;
        this.value1 = value1;
        this.value2 = value2;
        this.isValue1Long = Conversion.isLong(value1, decimalSymbol, digitGroupingSymbol);
        this.isValue1DoubleOrLong = Conversion.isDoubleOrLong(value1, decimalSymbol, digitGroupingSymbol);
        if (this.isValue1Long) {
            this.value1AsLong = Conversion.objectToLong(value1, this.decimalSymbol, this.digitGroupingSymbol);
        } else if (this.isValue1DoubleOrLong) {
            this.value1AsDouble = Conversion.objectToDouble(value1, this.decimalSymbol, this.digitGroupingSymbol);
        }
        this.isValue2Long = Conversion.isLong(value2, decimalSymbol, digitGroupingSymbol);
        this.isValue2DoubleOrLong = Conversion.isDoubleOrLong(value2, decimalSymbol, digitGroupingSymbol);
        if (this.isValue2Long) {
            this.value2AsLong = Conversion.objectToLong(value2, this.decimalSymbol, this.digitGroupingSymbol);
        } else if (this.isValue2DoubleOrLong) {
            this.value2AsDouble = Conversion.objectToDouble(value2, this.decimalSymbol, this.digitGroupingSymbol);
        }
    }

    public ConditionalRule(ConditionalRuleMacroParams params, char decimalSymbol, String digitGroupingSymbol) {
        this(params.ruleCondition, params.value1, params.value2, params.appliesTo, params.affectedElements, params.stopIfTrue, params.styleBold, params.styleItalic, params.styleUnderline, params.textColor, params.backgroundColor, params.replacementText, decimalSymbol, digitGroupingSymbol);
    }

    protected String getStartTrimmedSpaces(String str) {
        if (null == str || 0 == str.length()) {
            return "";
        }
        String result = "";
        int len = str.length();
        for (int index = 0; index < len && ('\u00a0' == str.charAt(index) || ' ' == str.charAt(index) || '\t' == str.charAt(index)); ++index) {
            result = result + str.charAt(index);
        }
        return result;
    }

    protected String getEndTrimmedSpaces(String str) {
        if (null == str || 0 == str.length()) {
            return "";
        }
        String result = "";
        int len = str.length();
        for (int index = len - 1; index > 0 && ('\u00a0' == str.charAt(index) || ' ' == str.charAt(index) || '\t' == str.charAt(index)); --index) {
            result = result + str.charAt(index);
        }
        return result;
    }

    protected String htmlTrim(String str) {
        int index;
        int len;
        if (null == str) {
            return "";
        }
        if (null == str || 0 == str.length()) {
            return "";
        }
        String result = "";
        for (len = str.length() - 1; len > 0 && ('\u00a0' == str.charAt(len) || ' ' == str.charAt(len) || '\t' == str.charAt(len)); --len) {
        }
        for (index = 0; index <= len && ('\u00a0' == str.charAt(index) || ' ' == str.charAt(index) || '\t' == str.charAt(index)); ++index) {
        }
        if (index > len) {
            return "";
        }
        result = "";
        for (int i = index; i <= len; ++i) {
            result = result + str.charAt(i);
        }
        return result;
    }

    @Override
    public void processWholeText(Document doc) {
        if (!this.appliesTo.toLowerCase().contains(ConditionalRuleMacroParams.VALUE_WHOLE_TEXT.toLowerCase())) {
            return;
        }
        if (RuleCondition.ElementValueIsEqualTo == this.ruleCondition) {
            int elementsAllCount;
            if (null == this.value1 || this.value1.length() < 1) {
                return;
            }
            Elements elementsAll = doc.getElementsContainingOwnText(this.value1);
            int n = elementsAllCount = null == elementsAll ? 0 : elementsAll.size();
            if (0 == elementsAllCount) {
                return;
            }
            for (Element element : elementsAll) {
                String originalText = element.text();
                String trimStart = this.getStartTrimmedSpaces(originalText);
                String trimEnd = this.getEndTrimmedSpaces(originalText);
                String text = this.htmlTrim(originalText);
                Element parent = null;
                if (!text.equalsIgnoreCase(this.value1)) continue;
                parent = element.parent();
                for (int counter = 5; counter > 0 && null != (parent = element.parent()) && this.htmlTrim(parent.text()).equalsIgnoreCase(this.value1) && (parent.tagName().equalsIgnoreCase("string") || parent.tagName().equalsIgnoreCase("em") || parent.tagName().equalsIgnoreCase("u")); --counter) {
                    element = parent;
                }
                HtmlTools.applyAnyElementChangesForConditionalRule(element, this.bold, this.italic, this.underline, this.textColor, this.backgroundColor, this.replacementText, trimStart, trimEnd);
            }
            elementsAll = doc.getElementsContainingOwnText(this.value1);
            int n2 = elementsAllCount = null == elementsAll ? 0 : elementsAll.size();
            if (0 == elementsAllCount) {
                return;
            }
            for (Element element : elementsAll) {
                String html = element.html();
                String newHtml = HtmlTools.replaceAll(html, this.value1, this.bold, this.italic, this.underline, this.textColor, this.backgroundColor, this.replacementText);
                element.html(newHtml);
            }
        }
    }

    @Override
    public void processElements(RuleSubject[][][] ruleSubjects, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        this.processIndividualValueBasedConditions(ruleSubjects, pageContentProvider, i18n);
    }

    protected Object getValueFromRuleSubject(RuleSubject[][][] ruleSubjects, int tableIndexZeroBased, int rowZeroBased, int colZeroBased) {
        if (tableIndexZeroBased >= 0 && tableIndexZeroBased < ruleSubjects.length && rowZeroBased >= 0 && rowZeroBased < ruleSubjects[tableIndexZeroBased].length && colZeroBased >= 0 && colZeroBased < ruleSubjects[tableIndexZeroBased][rowZeroBased].length) {
            RuleSubject ruleSubject = ruleSubjects[tableIndexZeroBased][rowZeroBased][colZeroBased];
            if (null != ruleSubject) {
                return ruleSubject.originalValue;
            }
            return null;
        }
        return null;
    }

    public void processIndividualValueBasedConditions(RuleSubject[][][] ruleSubjects, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        ArrayList<VariableValue> variables = null;
        MinMaxHolder minMaxColumnOneBased = null;
        MinMaxHolder minMaxRowOneBased = null;
        String formula = "";
        if (Features.FORMULA_SUPPORT_IN_CONDITIONS && RuleCondition.FormulaResultValueIsTrue == this.ruleCondition) {
            try {
                String string = formula = null == this.value1 ? "" : this.value1;
                if (formula.length() < 1) {
                    // empty if block
                }
                variables = new ArrayList<VariableValue>();
                MacroHelper.findVariablesForConditions(formula, "", pageContentProvider, variables, i18n, this.decimalSymbol, this.digitGroupingSymbol);
                minMaxColumnOneBased = ConditionalRule.getMinMaxColumn(variables);
                minMaxRowOneBased = ConditionalRule.getMinMaxRow(variables);
            }
            catch (ExpressionCalculationException expressionCalculationException) {
                // empty catch block
            }
        }
        int countI = ruleSubjects.length;
        boolean[][][] appliedSubjects = this.prepareAppliedSubjectsArray(ruleSubjects, this.appliesTo);
        for (int i = 0; i < countI; ++i) {
            if (null == ruleSubjects[i]) continue;
            int countJ = ruleSubjects[i].length;
            if (Features.FORMULA_SUPPORT_IN_CONDITIONS && RuleCondition.FormulaResultValueIsTrue == this.ruleCondition) {
                for (VariableValue variableValue : variables) {
                    if (VariableValue.VariableDollarType.DollarADollar1 != variableValue.getVariableDollarType()) continue;
                    int rowZeroBased = variableValue.getRowOneBased() - 1;
                    int colZeroBased = variableValue.getColumnOneBased() - 1;
                    Object value = this.getValueFromRuleSubject(ruleSubjects, i, rowZeroBased, colZeroBased);
                    variableValue.setValue(Conversion.objectToSpecificType(value, this.decimalSymbol, this.digitGroupingSymbol));
                }
            }
            for (int j = 0; j < countJ; ++j) {
                if (null == ruleSubjects[i][j]) continue;
                int countK = ruleSubjects[i][j].length;
                for (int k = 0; k < countK; ++k) {
                    RuleSubject ruleSubject = ruleSubjects[i][j][k];
                    if (null == ruleSubject || !appliedSubjects[i][j][k]) continue;
                    boolean skipThisElementDueToBorders = false;
                    if (Features.FORMULA_SUPPORT_IN_CONDITIONS && RuleCondition.FormulaResultValueIsTrue == this.ruleCondition) {
                        for (VariableValue variableValue : variables) {
                            int rowZeroBased = variableValue.getRowOneBased() - 1;
                            int colZeroBased = variableValue.getColumnOneBased() - 1;
                            VariableValue.VariableDollarType variableDollarType = variableValue.getVariableDollarType();
                            boolean needToApplyValue = false;
                            if (VariableValue.VariableDollarType.DollarA1 == variableDollarType || VariableValue.VariableDollarType.A1 == variableDollarType) {
                                rowZeroBased = variableValue.getRowOneBased() - minMaxRowOneBased.min + j;
                                needToApplyValue = true;
                            }
                            if (VariableValue.VariableDollarType.ADollar1 == variableDollarType || VariableValue.VariableDollarType.A1 == variableDollarType) {
                                colZeroBased = variableValue.getColumnOneBased() - minMaxColumnOneBased.min + k;
                                needToApplyValue = true;
                            }
                            if (rowZeroBased < 0 || rowZeroBased >= ruleSubjects[i].length) {
                                skipThisElementDueToBorders = true;
                            }
                            if (colZeroBased < 0 || colZeroBased >= ruleSubjects[i][j].length) {
                                skipThisElementDueToBorders = true;
                            }
                            if (skipThisElementDueToBorders || !needToApplyValue) continue;
                            Object value = this.getValueFromRuleSubject(ruleSubjects, i, rowZeroBased, colZeroBased);
                            variableValue.setValue(Conversion.objectToSpecificType(value, this.decimalSymbol, this.digitGroupingSymbol));
                        }
                        if (skipThisElementDueToBorders) continue;
                        this.applyFormulaForRuleSubject(ruleSubjects, i, j, k, this.affectedElementsSpecification, formula, variables, pageContentProvider, i18n);
                        continue;
                    }
                    this.applyRuleForRuleSubject(ruleSubjects, i, j, k, this.affectedElementsSpecification);
                }
            }
        }
    }

    public static MinMaxHolder getMinMaxRow(ArrayList<VariableValue> variables) {
        MinMaxHolder result = new MinMaxHolder(-1, -1);
        for (VariableValue variable : variables) {
            int y;
            if (VariableValue.VariableDollarType.DollarA1 != variable.getVariableDollarType() && VariableValue.VariableDollarType.A1 != variable.getVariableDollarType() || (y = variable.getRowOneBased()) < 0) continue;
            if (y > -1 && (result.min == -1 || result.min > y)) {
                result.min = y;
            }
            if (y <= -1 || result.max != -1 && result.max >= y) continue;
            result.max = y;
        }
        return result;
    }

    public static MinMaxHolder getMinMaxColumn(ArrayList<VariableValue> variables) {
        MinMaxHolder result = new MinMaxHolder(-1, -1);
        for (VariableValue variable : variables) {
            if (VariableValue.VariableDollarType.ADollar1 != variable.getVariableDollarType() && VariableValue.VariableDollarType.A1 != variable.getVariableDollarType()) continue;
            int x = variable.getColumnOneBased();
            if (x > -1 && (result.min == -1 || result.min > x)) {
                result.min = x;
            }
            if (x <= -1 || result.max != -1 && result.max >= x) continue;
            result.max = x;
        }
        return result;
    }

    protected boolean[][][] prepareAppliedSubjectsArray(RuleSubject[][][] ruleSubjects, String appliesTo) {
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        boolean shouldProcessAllTables = false;
        if (appliesTo.toLowerCase().contains(ConditionalRuleMacroParams.VALUE_ALL_TABLES.toLowerCase())) {
            shouldProcessAllTables = true;
        }
        boolean[][][] appliedSubjects = ConditionalRule.create3dArray(countI, countJ, countK, shouldProcessAllTables);
        if (shouldProcessAllTables) {
            return appliedSubjects;
        }
        String[] appliesToElems = appliesTo.contains(",") ? appliesTo.split(",") : (appliesTo.contains(";") ? appliesTo.split(";") : appliesTo.split(" "));
        int count = appliesToElems.length;
        for (int i = 0; i < count; ++i) {
            String appliesToElem = appliesToElems[i].trim();
            this.processTable1_A_B(ruleSubjects, appliesToElem, appliedSubjects);
            if (!Features.APPLES_TO_PARAM_ADDITIONAL_VARIANTS) continue;
            this.processA_B(ruleSubjects, appliesToElem, appliedSubjects);
            this.processTable1_1_2(ruleSubjects, appliesToElem, appliedSubjects);
            this.process1_2(ruleSubjects, appliesToElem, appliedSubjects);
            this.processTable1_A2_B3(ruleSubjects, appliesToElem, appliedSubjects);
            this.processA2_B3(ruleSubjects, appliesToElem, appliedSubjects);
        }
        return appliedSubjects;
    }

    protected static boolean[][][] create3dArray(int countI, int countJ, int countK, boolean initialValue) {
        boolean[][][] result = new boolean[countI][countJ][countK];
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                for (int k = 0; k < countK; ++k) {
                    result[i][j][k] = initialValue;
                }
            }
        }
        return result;
    }

    protected void processTable1_A_B(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!ConditionalRule.conformsToPattern(appliesToElem, "Table[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+")) {
            return;
        }
        int idx1 = "Table".length();
        int idx2 = appliesToElem.indexOf(".", idx1 + 1);
        int idx3 = appliesToElem.indexOf("!", idx1 + 1);
        int idx4 = -1;
        if (idx2 > -1) {
            idx4 = idx2;
        }
        if (idx3 > -1) {
            idx4 = idx3;
        }
        if (idx4 < 0) {
            return;
        }
        String strTableIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        if ((idx4 = appliesToElem.indexOf(":", idx1)) < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = Integer.parseInt(strTableIndex);
            firstColumnIndex = MacroHelper.getExcelColumnNumber(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getExcelColumnNumber(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (tableIndex > ruleSubjects.length) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            if (i != tableIndex - 1) continue;
            for (int j = 0; j < countJ; ++j) {
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
    }

    protected void processTable1_A2_B3(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        int tmp;
        if (!ConditionalRule.conformsToPattern(appliesToElem, "Table[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+")) {
            return;
        }
        int idx1 = "Table".length();
        int idx2 = appliesToElem.indexOf(".", idx1 + 1);
        int idx3 = appliesToElem.indexOf("!", idx1 + 1);
        int idx4 = -1;
        if (idx2 > -1) {
            idx4 = idx2;
        }
        if (idx3 > -1) {
            idx4 = idx3;
        }
        if (idx4 < 0) {
            return;
        }
        String strTableIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        if ((idx4 = appliesToElem.indexOf(":", idx1)) < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        try {
            tableIndex = Integer.parseInt(strTableIndex);
            firstColumnIndex = MacroHelper.getColumnIndex(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getColumnIndex(strLastColumnIndex);
            firstRowIndex = MacroHelper.getRowIndex(strFirstColumnIndex);
            lastRowIndex = MacroHelper.getRowIndex(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (tableIndex > ruleSubjects.length) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        if (lastRowIndex < firstRowIndex) {
            tmp = lastRowIndex;
            lastRowIndex = firstRowIndex;
            firstRowIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            if (i != tableIndex - 1) continue;
            for (int j = 0; j < countJ; ++j) {
                if (firstRowIndex - 1 > j || j > lastRowIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
    }

    protected void processA2_B3(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        int tmp;
        if (!ConditionalRule.conformsToPattern(appliesToElem, "[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+")) {
            return;
        }
        int idx1 = -1;
        int idx2 = -1;
        int idx3 = -1;
        int idx4 = -1;
        idx1 = 0;
        idx4 = appliesToElem.indexOf(":", idx1);
        if (idx4 < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        try {
            firstColumnIndex = MacroHelper.getColumnIndex(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getColumnIndex(strLastColumnIndex);
            firstRowIndex = MacroHelper.getRowIndex(strFirstColumnIndex);
            lastRowIndex = MacroHelper.getRowIndex(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        if (lastRowIndex < firstRowIndex) {
            tmp = lastRowIndex;
            lastRowIndex = firstRowIndex;
            firstRowIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                if (firstRowIndex - 1 > j || j > lastRowIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
        long l = 10L;
    }

    protected void processTable1_1_2(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!ConditionalRule.conformsToPattern(appliesToElem, "Table[0-9]+[.!][0-9]+:[0-9]+")) {
            return;
        }
        int idx1 = "Table".length();
        int idx2 = appliesToElem.indexOf(".", idx1 + 1);
        int idx3 = appliesToElem.indexOf("!", idx1 + 1);
        int idx4 = -1;
        if (idx2 > -1) {
            idx4 = idx2;
        }
        if (idx3 > -1) {
            idx4 = idx3;
        }
        if (idx4 < 0) {
            return;
        }
        String strTableIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        if ((idx4 = appliesToElem.indexOf(":", idx1)) < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = Integer.parseInt(strTableIndex);
            firstColumnIndex = Integer.parseInt(strFirstColumnIndex);
            lastColumnIndex = Integer.parseInt(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (tableIndex > ruleSubjects.length) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            if (i != tableIndex - 1) continue;
            for (int j = 0; j < countJ; ++j) {
                if (firstColumnIndex - 1 > j || j > lastColumnIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
    }

    protected void processA_B(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!ConditionalRule.conformsToPattern(appliesToElem, "[a-zA-Z]+:[a-zA-Z]+")) {
            return;
        }
        int idx1 = 0;
        int idx4 = appliesToElem.indexOf(":", idx1);
        if (idx4 < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = -1;
            firstColumnIndex = MacroHelper.getExcelColumnNumber(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getExcelColumnNumber(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
        long l = 10L;
    }

    protected void process1_2(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!ConditionalRule.conformsToPattern(appliesToElem, "[0-9]+:[0-9]+")) {
            return;
        }
        int idx1 = 0;
        int idx4 = appliesToElem.indexOf(":", idx1);
        if (idx4 < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = -1;
            firstColumnIndex = Integer.parseInt(strFirstColumnIndex);
            lastColumnIndex = Integer.parseInt(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                if (firstColumnIndex - 1 > j || j > lastColumnIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
        long l = 10L;
    }

    protected static boolean conformsToPattern(String str, String pattern) {
        String s;
        Pattern p = Pattern.compile(pattern, 2);
        Matcher m = p.matcher(str);
        return m.find() && null != (s = m.group()) && 0 == s.compareToIgnoreCase(str);
    }

    protected void applyRuleForRuleSubject(RuleSubject[][][] ruleSubjects, int i, int j, int k, AffectedElementsSpecification affectedElementsSpecification) {
        if (null == ruleSubjects || null == ruleSubjects[i] || null == ruleSubjects[i][j] || null == ruleSubjects[i][j][k]) {
            return;
        }
        if (null == affectedElementsSpecification) {
            return;
        }
        RuleSubject ruleSubject = ruleSubjects[i][j][k];
        if (null == ruleSubject) {
            return;
        }
        if (!ruleSubject.shouldContinueRuleProcessing) {
            return;
        }
        String value = null == ruleSubject.originalValue ? "" : ruleSubject.originalValue;
        boolean conditionIsMet = false;
        switch (this.ruleCondition) {
            case ElementValueIsBetween: {
                double dValue2;
                double dValue1;
                if (this.isValue1Long && this.isValue2Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue2;
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue >= Math.min(lValue1 = this.value1AsLong, lValue2 = this.value2AsLong) && lValue <= Math.max(lValue1, lValue2);
                    break;
                }
                if (!this.isValue1DoubleOrLong || !this.isValue2DoubleOrLong || !Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                conditionIsMet = dValue >= Math.min(dValue1 = this.value1AsDouble, dValue2 = this.value2AsDouble) && dValue <= Math.max(dValue1, dValue2);
                break;
            }
            case ElementValueIsNotBetween: {
                double dValue2;
                double dValue1;
                if (this.isValue1Long && this.isValue2Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue2;
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue < Math.min(lValue1 = this.value1AsLong, lValue2 = this.value2AsLong) || lValue > Math.max(lValue1, lValue2);
                    break;
                }
                if (!this.isValue1DoubleOrLong || !this.isValue2DoubleOrLong || !Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                conditionIsMet = !(dValue >= Math.min(dValue1 = this.value1AsDouble, dValue2 = this.value2AsDouble)) || !(dValue <= Math.max(dValue1, dValue2));
                break;
            }
            case ElementValueIsEqualTo: {
                if (this.isValue1Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = 0 == Long.compare(lValue, lValue1 = this.value1AsLong);
                    break;
                }
                if (this.isValue1DoubleOrLong && Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    double dValue1;
                    double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = 0 == Double.compare(dValue, dValue1 = this.value1AsDouble);
                    break;
                }
                conditionIsMet = 0 == value.compareToIgnoreCase(this.value1);
                break;
            }
            case ElementValueIsNotEqualTo: {
                if (this.isValue1Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue != (lValue1 = this.value1AsLong);
                    break;
                }
                if (this.isValue1DoubleOrLong && Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    double dValue1;
                    double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = Double.compare(dValue, dValue1 = this.value1AsDouble) != 0;
                    break;
                }
                conditionIsMet = 0 != value.compareToIgnoreCase(this.value1);
                break;
            }
            case ElementValueIsGreaterThan: {
                double dValue1;
                if (this.isValue1Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue > (lValue1 = this.value1AsLong);
                    break;
                }
                if (!this.isValue1DoubleOrLong || !Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                conditionIsMet = Double.compare(dValue, dValue1 = this.value1AsDouble) > 0;
                break;
            }
            case ElementValueIsLessThan: {
                double dValue1;
                if (this.isValue1Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue < (lValue1 = this.value1AsLong);
                    break;
                }
                if (!this.isValue1DoubleOrLong || !Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                conditionIsMet = Double.compare(dValue, dValue1 = this.value1AsDouble) < 0;
                break;
            }
            case ElementValueIsGreaterThanOrEqualTo: {
                double dValue1;
                if (this.isValue1Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue >= (lValue1 = this.value1AsLong);
                    break;
                }
                if (!this.isValue1DoubleOrLong || !Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                conditionIsMet = Double.compare(dValue, dValue1 = this.value1AsDouble) >= 0;
                break;
            }
            case ElementValueIsLessThanOrEqualTo: {
                double dValue1;
                if (this.isValue1Long && Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
                    long lValue1;
                    long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
                    conditionIsMet = lValue <= (lValue1 = this.value1AsLong);
                    break;
                }
                if (!this.isValue1DoubleOrLong || !Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                double dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
                conditionIsMet = Double.compare(dValue, dValue1 = this.value1AsDouble) <= 0;
                break;
            }
            case ElementTextContains: {
                if (!value.toLowerCase().contains(this.value1.toLowerCase())) break;
                conditionIsMet = true;
                break;
            }
            case ElementTextDoesNotContain: {
                if (value.toLowerCase().contains(this.value1.toLowerCase())) break;
                conditionIsMet = true;
                break;
            }
            case ElementTextBeginsWith: {
                if (!value.startsWith(this.value1)) break;
                conditionIsMet = true;
                break;
            }
            case ElementTextEndsWith: {
                if (!value.endsWith(this.value1)) break;
                conditionIsMet = true;
                break;
            }
            case ElementIsBlank: {
                if (0 != value.length()) break;
                conditionIsMet = true;
                break;
            }
            case ElementIsNotBlank: {
                if (value.length() <= 0) break;
                conditionIsMet = true;
                break;
            }
            case ElementIsANumericValue: {
                if (!Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) break;
                conditionIsMet = true;
                break;
            }
            case FormulaResultValueIsTrue: {
                if (Features.FORMULA_SUPPORT_IN_CONDITIONS) {
                    conditionIsMet = false;
                    break;
                }
                conditionIsMet = false;
                break;
            }
            default: {
                return;
            }
        }
        if (conditionIsMet) {
            int minJ = j;
            int maxJ = j;
            int minK = k;
            int maxK = k;
            if (Features.AFFECTED_ELEMENTS_SUPPORT && AffectedElementsSpecification.SpecificationType.Self != affectedElementsSpecification.getSpecificationType()) {
                if (AffectedElementsSpecification.SpecificationType.A_B == affectedElementsSpecification.getSpecificationType()) {
                    minJ = j;
                    maxJ = j;
                    minK = affectedElementsSpecification.getMin() - 1;
                    maxK = affectedElementsSpecification.getMax() - 1;
                } else if (AffectedElementsSpecification.SpecificationType.One_Two == affectedElementsSpecification.getSpecificationType()) {
                    minJ = affectedElementsSpecification.getMin();
                    maxJ = affectedElementsSpecification.getMax();
                    minK = k;
                    maxK = k;
                }
            }
            if (maxJ >= ruleSubjects[i].length) {
                maxJ = ruleSubjects[i].length - 1;
            }
            for (int j1 = minJ; j1 <= maxJ; ++j1) {
                if (maxK >= ruleSubjects[i][j1].length) {
                    maxK = ruleSubjects[i][j1].length - 1;
                }
                for (int k1 = minK; k1 <= maxK; ++k1) {
                    ruleSubject = ruleSubjects[i][j1][k1];
                    if (null == ruleSubject) continue;
                    ruleSubject.bold = this.bold;
                    ruleSubject.italic = this.italic;
                    ruleSubject.underline = this.underline;
                    ruleSubject.textColor = this.textColor;
                    ruleSubject.backgroundColor = this.backgroundColor;
                    ruleSubject.replacementText = this.replacementText;
                }
            }
            if (this.stopIfTrue) {
                ruleSubject.shouldContinueRuleProcessing = false;
            }
        }
    }

    protected void applyFormulaForRuleSubject(RuleSubject[][][] ruleSubjects, int i, int j, int k, AffectedElementsSpecification affectedElementsSpecification, String formula, ArrayList<VariableValue> variables, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        if (null == ruleSubjects || null == ruleSubjects[i] || null == ruleSubjects[i][j] || null == ruleSubjects[i][j][k]) {
            return;
        }
        if (null == affectedElementsSpecification) {
            return;
        }
        RuleSubject ruleSubject = ruleSubjects[i][j][k];
        if (null == ruleSubject || null == variables || null == formula) {
            return;
        }
        if (!ruleSubject.shouldContinueRuleProcessing) {
            return;
        }
        if (RuleCondition.FormulaResultValueIsTrue != this.ruleCondition) {
            return;
        }
        String value = null == ruleSubject.originalValue ? "" : ruleSubject.originalValue;
        boolean conditionIsMet = false;
        try {
            Object result = MacroHelper.calculate(formula, variables, null, pageContentProvider, i18n, true, false, this.decimalSymbol, this.digitGroupingSymbol);
            conditionIsMet = Conversion.objectToBoolean(result, this.decimalSymbol, this.digitGroupingSymbol);
            long l = 10L;
        }
        catch (Exception e) {
            conditionIsMet = false;
        }
        if (conditionIsMet) {
            int minJ = j;
            int maxJ = j;
            int minK = k;
            int maxK = k;
            if (Features.AFFECTED_ELEMENTS_SUPPORT && AffectedElementsSpecification.SpecificationType.Self != affectedElementsSpecification.getSpecificationType()) {
                if (AffectedElementsSpecification.SpecificationType.A_B == affectedElementsSpecification.getSpecificationType()) {
                    minJ = j;
                    maxJ = j;
                    minK = affectedElementsSpecification.getMin() - 1;
                    maxK = affectedElementsSpecification.getMax() - 1;
                } else if (AffectedElementsSpecification.SpecificationType.One_Two == affectedElementsSpecification.getSpecificationType()) {
                    minJ = affectedElementsSpecification.getMin() - 1;
                    maxJ = affectedElementsSpecification.getMax() - 1;
                    minK = k;
                    maxK = k;
                }
            }
            if (maxJ >= ruleSubjects[i].length) {
                maxJ = ruleSubjects[i].length - 1;
            }
            for (int j1 = minJ; j1 <= maxJ; ++j1) {
                if (maxK >= ruleSubjects[i][j1].length) {
                    maxK = ruleSubjects[i][j1].length - 1;
                }
                for (int k1 = minK; k1 <= maxK; ++k1) {
                    ruleSubject = ruleSubjects[i][j1][k1];
                    ruleSubject.bold = this.bold;
                    ruleSubject.italic = this.italic;
                    ruleSubject.underline = this.underline;
                    ruleSubject.textColor = this.textColor;
                    ruleSubject.backgroundColor = this.backgroundColor;
                    ruleSubject.replacementText = this.replacementText;
                }
            }
            if (this.stopIfTrue) {
                ruleSubject.shouldContinueRuleProcessing = false;
            }
        }
    }

    public static class MinMaxHolder {
        public int min = -1;
        public int max = -1;

        public MinMaxHolder(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

