/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.expressions;

import com.celestecs.expression.expressions.DelimiterKind;
import com.celestecs.expression.expressions.PreparedExpressionItemKind;

public final class PreparedExpressionItem {
    private PreparedExpressionItemKind kind = PreparedExpressionItemKind.values()[0];
    private Object constant;
    private String variableName;
    private DelimiterKind delimiterKind = DelimiterKind.values()[0];
    private String signature;

    public PreparedExpressionItemKind getKind() {
        return this.kind;
    }

    public Object getConstant() {
        return this.constant;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public DelimiterKind getDelimiterKind() {
        return this.delimiterKind;
    }

    public String getSignature() {
        return this.signature;
    }

    public PreparedExpressionItem(PreparedExpressionItemKind kind, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        this.kind = kind;
        switch (kind) {
            case Constant: {
                this.constant = value;
                break;
            }
            case Variable: {
                this.variableName = (String)value;
                break;
            }
            case Delimiter: {
                this.delimiterKind = (DelimiterKind)((Object)value);
                break;
            }
            case Signature: {
                this.signature = (String)value;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected item kind.");
            }
        }
    }

    public String toString() {
        return String.format("PreparedExpressionItem %1$s", new Object[]{this.kind});
    }
}

