/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.workwithjira;

import com.celestecs.expression.OperationsRegistry;
import com.celestecs.expression.QueryExecutor;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;

public final class CalculatorJiraIssueFieldValuesByFieldId
extends CalculatorBase {
    protected OperationsRegistry operationsRegistry = null;

    public CalculatorJiraIssueFieldValuesByFieldId(OperationsRegistry operationsRegistry, char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
        this.operationsRegistry = operationsRegistry;
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        String valueIfNull;
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 3) {
            throw new CalculatorException("Wrong parameter count, which should be not less than 3.", this, objParams);
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            throw new CalculatorException("The first parameter, JQL request, should not be empty.", this, objParams);
        }
        if (null == objParams[1] || objParams[1].toString().isEmpty()) {
            throw new CalculatorException("The second parameter, field name, should not be empty.", this, objParams);
        }
        String appLinkName = "";
        if (objParams.length == 4 && null != objParams[3]) {
            appLinkName = objParams[3].toString();
        }
        String jqlRequest = objParams[0].toString();
        String fieldName = objParams[1].toString();
        String string = valueIfNull = null == objParams[2] ? "" : objParams[2];
        if (null == this.operationsRegistry) {
            throw new CalculatorException("Operations registry is not initialized.", this, objParams);
        }
        QueryExecutor jqlQueryExecutor = this.operationsRegistry.getJqlQueryExecutor();
        if (null == jqlQueryExecutor) {
            throw new CalculatorException("JQL query executor is not initialized.", this, objParams);
        }
        try {
            Object[] result = jqlQueryExecutor.getResultFieldValues(jqlRequest, fieldName, valueIfNull, appLinkName, true);
            return result;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }
}

