/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.lookupandreference;

import com.celestecs.expression.Variable;
import com.celestecs.expression.VariableRange;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorHlookup
extends CalculatorBase {
    public CalculatorHlookup(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 3);
        if (Conversion.isRange(objParams[0]) || !Conversion.isRange(objParams[1]) || !Conversion.isLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol)) {
            return new String("");
        }
        Object lookupValue = objParams[0] instanceof VariableValue ? ((VariableValue)objParams[0]).getValue() : objParams[0];
        VariableRange range = (VariableRange)objParams[1];
        int row = new Long(Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol)).intValue() - 1;
        Object[][] variables = range.getVariables();
        if (null == variables || null == variables[0] || variables[0].length < 1) {
            throw new IllegalArgumentException("Wrong lookup source range parameter.");
        }
        int rows = variables.length;
        int columns = variables[0].length;
        if (row >= rows) {
            throw new IllegalArgumentException("Wrong row parameter: '" + row + "'.");
        }
        for (int i = 0; i < columns; ++i) {
            Object var = variables[0][i];
            if (var instanceof VariableValue && ((VariableValue)var).getVariableName().equals(Variable.EMPTY_VAR_NAME)) continue;
            Object object = var = var instanceof VariableValue ? ((VariableValue)var).getValue() : var;
            if (!Conversion.objectsAreEqual(lookupValue, var, this.decimalSymbol, this.digitGroupingSymbol)) continue;
            Object result = variables[row][i];
            return result instanceof VariableValue ? ((VariableValue)result).getValue() : result;
        }
        return new String("");
    }
}

