/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.engineering;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.ErrorEval;
import java.util.Locale;

public final class CalculatorDec2Hex
extends CalculatorBase {
    private static final long MIN_VALUE = Long.parseLong("-549755813888");
    private static final long MAX_VALUE = Long.parseLong("549755813887");
    private static final int DEFAULT_PLACES_VALUE = 10;

    public CalculatorDec2Hex(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 1 || objParams.length > 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 1 and no more than 2.");
        }
        Conversion.checkToBeDouble(objParams[0], "Number", this.decimalSymbol, this.digitGroupingSymbol);
        Double srcNumber = new Double(Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol));
        int placesNumber = 0;
        if (objParams.length > 1) {
            Conversion.checkToBeLong(objParams[1], "Places", this.decimalSymbol, this.digitGroupingSymbol);
            placesNumber = new Long(Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        }
        if (srcNumber.longValue() < MIN_VALUE || srcNumber.longValue() > MAX_VALUE) {
            return ErrorEval.NUM_ERROR;
        }
        if (srcNumber < 0.0) {
            placesNumber = 10;
        }
        String hex = placesNumber != 0 ? String.format(Locale.ROOT, "%0" + placesNumber + "X", srcNumber.intValue()) : Long.toHexString(srcNumber.longValue());
        if (srcNumber.longValue() < 0L) {
            hex = "FF" + hex.substring(2);
        }
        return hex.toUpperCase(Locale.ROOT);
    }
}

