/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;

public final class CalculatorTime
extends CalculatorBase {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;

    public CalculatorTime(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 3);
        super.CheckForNotHavingRanges(objParams);
        if (!(Conversion.isLong(objParams[0], this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol))) {
            return -1;
        }
        Long d0 = Conversion.objectToLong(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        Long d1 = Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
        Long d2 = Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
        try {
            double res = CalculatorTime.evaluate(d0.intValue(), d1.intValue(), d2.intValue());
            return new DateTime(res);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static double evaluate(int hours, int minutes, int seconds) throws EvaluationException {
        if (hours > Short.MAX_VALUE || minutes > Short.MAX_VALUE || seconds > Short.MAX_VALUE) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        int totalSeconds = hours * 3600 + minutes * 60 + seconds;
        if (totalSeconds < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return (double)(totalSeconds % 86400) / 86400.0;
    }
}

