/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.Variable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VariableValue
extends Variable {
    protected int rowOneBased = -1;
    protected int columnOneBased = -1;
    private Object value;
    private String variableName;
    protected VariableDollarType variableDollarType = VariableDollarType.A1;
    protected boolean variableDollarTypeInitialized = false;

    public VariableValue getDuplicate() {
        VariableValue result = new VariableValue(this.variableName, this.value);
        result.rowOneBased = this.rowOneBased;
        result.columnOneBased = this.columnOneBased;
        result.variableDollarType = this.variableDollarType;
        result.variableDollarTypeInitialized = this.variableDollarTypeInitialized;
        return result;
    }

    public VariableDollarType getVariableDollarType() {
        this.initVariableDollarType();
        return this.variableDollarType;
    }

    protected static boolean matchesRegexp(String str, String regexp) {
        if (null == str || str.length() < 1 || null == regexp || regexp.length() < 1) {
            return false;
        }
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public void initVariableDollarType() {
        if (this.variableDollarTypeInitialized) {
            return;
        }
        this.variableDollarTypeInitialized = true;
        this.rowOneBased = VariableValue.getRow(this.variableName);
        this.columnOneBased = VariableValue.getColumn(this.variableName);
        if (null == this.variableName || this.variableName.length() < 1 || !this.variableName.contains("$")) {
            this.variableDollarType = VariableDollarType.A1;
        }
        if (VariableValue.matchesRegexp(this.variableName, "\\$[a-zA-Z]+\\$[0-9]+:\\$[a-zA-Z]+\\$[0-9]+")) {
            this.variableDollarType = VariableDollarType.RangeDollarADollar1;
            return;
        }
        if (VariableValue.matchesRegexp(this.variableName, "\\$[a-zA-Z]+[0-9]+")) {
            this.variableDollarType = VariableDollarType.DollarA1;
            return;
        }
        if (VariableValue.matchesRegexp(this.variableName, "[a-zA-Z]+\\$[0-9]+")) {
            this.variableDollarType = VariableDollarType.ADollar1;
            return;
        }
        if (VariableValue.matchesRegexp(this.variableName, "\\$[a-zA-Z]+\\$[0-9]+")) {
            this.variableDollarType = VariableDollarType.DollarADollar1;
            return;
        }
        this.variableDollarType = VariableDollarType.A1;
    }

    public int getRowOneBased() {
        this.initVariableDollarType();
        return this.rowOneBased;
    }

    public int getColumnOneBased() {
        this.initVariableDollarType();
        return this.columnOneBased;
    }

    public void setColumnOneBased(int columnOneBased) {
        this.columnOneBased = columnOneBased;
    }

    protected static int getRow(String varName) {
        varName = null == varName ? "" : varName;
        String str = "";
        boolean res = false;
        for (int curIndex = varName.length() - 1; curIndex >= 0 && Character.isDigit(varName.charAt(curIndex)); --curIndex) {
            str = varName.charAt(curIndex) + str;
            res = true;
        }
        if (!res) {
            return -1;
        }
        try {
            int row = Integer.parseInt(str);
            return row;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected static int getColumn(String varName) {
        int curIndex;
        varName = null == varName ? "" : varName;
        String str = "";
        boolean res = false;
        for (curIndex = varName.length() - 1; curIndex >= 0 && (varName.charAt(curIndex) == '$' || Character.isDigit(varName.charAt(curIndex))); --curIndex) {
        }
        while (curIndex >= 0 && Character.isLetter(varName.charAt(curIndex))) {
            str = varName.charAt(curIndex) + str;
            --curIndex;
            res = true;
        }
        if (!res) {
            return -1;
        }
        int column = MacroHelper.getExcelColumnNumber(str);
        return column;
    }

    @Override
    public Variable.VariableType getVariableType() {
        return Variable.VariableType.VALUE;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        if (null == this.value) {
            return "";
        }
        return this.value.toString();
    }

    public VariableValue(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("variableName");
        }
        if (!Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && variableName.length() == 0) {
            throw new IllegalArgumentException("Variable Name is empty.");
        }
        this.value = value;
        this.variableName = variableName;
        this.variableDollarTypeInitialized = false;
    }

    public static enum VariableDollarType {
        A1,
        DollarADollar1,
        DollarA1,
        ADollar1,
        RangeDollarADollar1;

    }
}

