/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.OperationsRegistry;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.exceptions.NotValidVariableIdentifierException;
import com.celestecs.expression.expressions.DelimiterKind;
import com.celestecs.expression.expressions.PreparedExpression;
import com.celestecs.expression.expressions.PreparedExpressionItem;
import com.celestecs.expression.expressions.PreparedExpressionItemKind;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Parser {
    public static char firstBracketChar = (char)34;
    public static char lastBracketChar = (char)34;
    private OperationsRegistry _OperationsRegistry;

    public OperationsRegistry getOperationsRegistry() {
        return this._OperationsRegistry;
    }

    public Parser(OperationsRegistry operationsRegistry) {
        if (operationsRegistry == null) {
            throw new IllegalArgumentException("operationsRegistry");
        }
        this._OperationsRegistry = operationsRegistry;
    }

    protected static boolean isStringBrace(char ch, String digitGroupingSymbol) {
        boolean result = '\"' == ch || Features.ADDITIONAL_BRACE_TYPES_SUPPORT && firstBracketChar == ch || '\'' == ch && (!Features.CORRECT_NUMBER_FORMATTING || digitGroupingSymbol.length() != 1 || digitGroupingSymbol.charAt(0) != '\'');
        return result;
    }

    protected static void throwIfTrue(boolean bThrow, String paramName) {
        if (bThrow) {
            throw new IllegalArgumentException(paramName);
        }
    }

    public PreparedExpression Parse(String inputString, boolean allowDollarSigns, boolean allowReportingVariablesOnly, char decimalSymbol, String digitGroupingSymbol) {
        char ch;
        if (inputString == null) {
            throw new IllegalArgumentException("sourceString");
        }
        String sourceString = "";
        for (int i = 0; i < inputString.length(); ++i) {
            ch = inputString.charAt(i);
            if (Parser.isStringBrace(ch, digitGroupingSymbol)) {
                sourceString = sourceString + ch;
                if (Features.ADDITIONAL_BRACE_TYPES_SUPPORT && firstBracketChar == ch) {
                    ch = lastBracketChar;
                }
                ++i;
                if (Features.DOUBLE_APOSTROPHE_ESCAPING_SUPPORT) {
                    while (i < inputString.length()) {
                        if (i + 1 < inputString.length() && inputString.charAt(i) == '\\' && inputString.charAt(i + 1) == ch) {
                            sourceString = sourceString + inputString.charAt(i);
                            sourceString = sourceString + inputString.charAt(i + 1);
                            i += 2;
                            continue;
                        }
                        if (inputString.charAt(i) != ch) {
                            sourceString = sourceString + inputString.charAt(i);
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    while (i < inputString.length() && inputString.charAt(i) != ch) {
                        sourceString = sourceString + inputString.charAt(i);
                        ++i;
                    }
                }
                if (i >= inputString.length()) {
                    throw new IllegalArgumentException("sourceString");
                }
                sourceString = sourceString + ch;
                continue;
            }
            if (inputString.startsWith(MacroHelper.UNIQUE_BRACES, i)) {
                sourceString = sourceString + MacroHelper.UNIQUE_BRACES;
                i += MacroHelper.UNIQUE_BRACES.length();
                while (i < inputString.length() - MacroHelper.UNIQUE_BRACES.length() - 1 && !inputString.startsWith(MacroHelper.UNIQUE_BRACES, i)) {
                    sourceString = sourceString + inputString.charAt(i);
                    ++i;
                }
                if (i >= inputString.length() - MacroHelper.UNIQUE_BRACES.length()) {
                    throw new IllegalArgumentException("sourceString");
                }
                i += MacroHelper.UNIQUE_BRACES.length() - 1;
                sourceString = sourceString + MacroHelper.UNIQUE_BRACES;
                continue;
            }
            if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && inputString.startsWith("[", i)) {
                String endStr = "]Table".toLowerCase();
                int idxStart = i;
                int idxEnd = inputString.toLowerCase().indexOf(endStr, idxStart + 1);
                if (idxEnd <= -1) continue;
                sourceString = sourceString + inputString.substring(idxStart, idxEnd + endStr.length());
                i += idxEnd + endStr.length() - idxStart - 1;
                continue;
            }
            int ich = new Integer(ch);
            if (ich > 127 || inputString.charAt(i) == ' ' || inputString.charAt(i) == '\t' || inputString.charAt(i) == '\n' || inputString.charAt(i) == '\r') continue;
            sourceString = sourceString + inputString.charAt(i);
        }
        if (sourceString.length() == 0) {
            throw new IllegalArgumentException("Source string is empty.");
        }
        int[] lens = this._OperationsRegistry.getSignaturesLens();
        ArrayList<PreparedExpressionItem> res = new ArrayList<PreparedExpressionItem>();
        boolean operandStarted = false;
        int operandStartIndex = 0;
        for (int i = 0; i < sourceString.length(); ++i) {
            String objConstant;
            PreparedExpressionItem additionalItem = null;
            if (sourceString.charAt(i) == '(' || sourceString.charAt(i) == ')' || sourceString.charAt(i) == ',' && (!Features.CORRECT_NUMBER_FORMATTING || ',' != decimalSymbol && (null == digitGroupingSymbol || digitGroupingSymbol.length() != 1 || ',' != digitGroupingSymbol.charAt(0))) || sourceString.charAt(i) == ';') {
                DelimiterKind delimiterKind = DelimiterKind.Comma;
                switch (sourceString.charAt(i)) {
                    case '(': {
                        delimiterKind = DelimiterKind.OpeningBrace;
                        break;
                    }
                    case ')': {
                        delimiterKind = DelimiterKind.ClosingBrace;
                        break;
                    }
                    case ';': {
                        delimiterKind = DelimiterKind.Comma;
                        break;
                    }
                    case ',': {
                        delimiterKind = DelimiterKind.Comma;
                    }
                }
                additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Delimiter, (Object)delimiterKind);
            }
            if (Parser.isStringBrace(sourceString.charAt(i), digitGroupingSymbol)) {
                ch = sourceString.charAt(i);
                if (Features.ADDITIONAL_BRACE_TYPES_SUPPORT && firstBracketChar == ch) {
                    ch = lastBracketChar;
                }
                String stringConstant = "";
                ++i;
                if (Features.DOUBLE_APOSTROPHE_ESCAPING_SUPPORT) {
                    while (i < sourceString.length()) {
                        if (i + 1 < sourceString.length() && sourceString.charAt(i) == '\\' && sourceString.charAt(i + 1) == ch) {
                            stringConstant = stringConstant + sourceString.charAt(i + 1);
                            i += 2;
                            continue;
                        }
                        if (sourceString.charAt(i) != ch) {
                            stringConstant = stringConstant + sourceString.charAt(i);
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    while (i < sourceString.length() && sourceString.charAt(i) != ch) {
                        stringConstant = stringConstant + sourceString.charAt(i);
                        ++i;
                    }
                }
                if (i >= sourceString.length()) {
                    throw new IllegalArgumentException("sourceString");
                }
                objConstant = stringConstant;
                additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Constant, objConstant);
            }
            if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && sourceString.charAt(i) == '[') {
                int startIndex = i;
                int endIdx = sourceString.toLowerCase().indexOf("]Table".toLowerCase(), i);
                Parser.throwIfTrue(endIdx < 0, "sourceString");
                endIdx += "]Table".length();
                while (endIdx < sourceString.length() && Character.isDigit(sourceString.charAt(endIdx))) {
                    ++endIdx;
                }
                Parser.throwIfTrue(endIdx >= sourceString.length(), "sourceString");
                Parser.throwIfTrue(sourceString.charAt(endIdx) != '.', "sourceString");
                ++endIdx;
                while (endIdx < sourceString.length() && Character.isAlphabetic(sourceString.charAt(endIdx))) {
                    ++endIdx;
                }
                Parser.throwIfTrue(endIdx >= sourceString.length(), "sourceString");
                while (endIdx < sourceString.length() && Character.isDigit(sourceString.charAt(endIdx))) {
                    ++endIdx;
                }
                Parser.throwIfTrue(endIdx > sourceString.length(), "sourceString");
                if (endIdx < sourceString.length() && sourceString.charAt(endIdx) == ':') {
                    ++endIdx;
                    while (endIdx < sourceString.length() && Character.isAlphabetic(sourceString.charAt(endIdx))) {
                        ++endIdx;
                    }
                    Parser.throwIfTrue(endIdx >= sourceString.length(), "sourceString");
                    while (endIdx < sourceString.length() && Character.isDigit(sourceString.charAt(endIdx))) {
                        ++endIdx;
                    }
                    Parser.throwIfTrue(endIdx > sourceString.length(), "sourceString");
                }
                String varName = sourceString.substring(startIndex, endIdx);
                additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Variable, varName);
                i = endIdx - 1;
            }
            if (sourceString.startsWith(MacroHelper.UNIQUE_BRACES, i)) {
                String stringConstant = "";
                i += MacroHelper.UNIQUE_BRACES.length();
                while (i < sourceString.length() - MacroHelper.UNIQUE_BRACES.length() - 1 && !sourceString.startsWith(MacroHelper.UNIQUE_BRACES, i)) {
                    stringConstant = stringConstant + sourceString.charAt(i);
                    ++i;
                }
                if (i >= sourceString.length() - MacroHelper.UNIQUE_BRACES.length()) {
                    throw new IllegalArgumentException("sourceString");
                }
                i += MacroHelper.UNIQUE_BRACES.length() - 1;
                objConstant = stringConstant;
                additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Constant, objConstant);
            }
            if (additionalItem == null) {
                for (int j = lens.length - 1; j >= 0; --j) {
                    if (i + lens[j] > sourceString.length()) continue;
                    if (lens[j] == 1 && sourceString.charAt(i) == ':' && i < sourceString.length() - 1 && Character.isLetter(sourceString.charAt(i + 1))) break;
                    if (!Features.SUPPORT_FOR_REPORTS && this._OperationsRegistry.IsSignatureDefined(sourceString.substring(i, i + lens[j]))) {
                        additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Signature, sourceString.substring(i, i + lens[j]));
                        break;
                    }
                    if (Features.SUPPORT_FOR_REPORTS && this._OperationsRegistry.IsOperatorDefined(sourceString.substring(i, i + lens[j]))) {
                        additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Signature, sourceString.substring(i, i + lens[j]));
                        break;
                    }
                    if (!Features.SUPPORT_FOR_REPORTS || i >= 1 && (Character.isLetter(sourceString.charAt(i - 1)) || sourceString.charAt(i - 1) == '.') || !this._OperationsRegistry.IsFunctionDefined(sourceString.substring(i, i + lens[j]))) continue;
                    additionalItem = new PreparedExpressionItem(PreparedExpressionItemKind.Signature, sourceString.substring(i, i + lens[j]));
                    break;
                }
            }
            if (additionalItem == null) {
                if (operandStarted) continue;
                operandStarted = true;
                operandStartIndex = i;
                continue;
            }
            if (operandStarted) {
                String operandString = sourceString.substring(operandStartIndex, i);
                Object constant = 0;
                boolean tempVar = false;
                try {
                    if (Conversion.isDoubleOrLong(operandString, decimalSymbol, digitGroupingSymbol) || Conversion.isBoolean(operandString)) {
                        constant = Conversion.objectToSpecificType(operandString, decimalSymbol, digitGroupingSymbol);
                        tempVar = true;
                    }
                }
                catch (NumberFormatException e) {
                    tempVar = false;
                }
                if (tempVar) {
                    res.add(new PreparedExpressionItem(PreparedExpressionItemKind.Constant, constant));
                } else {
                    if (!Parser.IsValidVariableName(operandString, allowDollarSigns, allowReportingVariablesOnly)) {
                        throw new NotValidVariableIdentifierException(operandString);
                    }
                    res.add(new PreparedExpressionItem(PreparedExpressionItemKind.Variable, operandString));
                }
                operandStarted = false;
            }
            res.add(additionalItem);
            if (additionalItem.getKind() != PreparedExpressionItemKind.Signature) continue;
            i += additionalItem.getSignature().length() - 1;
        }
        if (operandStarted) {
            boolean tempVar2;
            String operandString = sourceString.substring(operandStartIndex);
            double constant = 0.0;
            try {
                constant = Features.CORRECT_NUMBER_FORMATTING ? Conversion.parseDouble(operandString, decimalSymbol, digitGroupingSymbol) : Double.parseDouble(operandString.replace(',', '.'));
                tempVar2 = true;
            }
            catch (NumberFormatException e) {
                tempVar2 = false;
            }
            if (tempVar2) {
                res.add(new PreparedExpressionItem(PreparedExpressionItemKind.Constant, constant));
            } else {
                if (!Parser.IsValidVariableName(operandString, allowDollarSigns, allowReportingVariablesOnly)) {
                    throw new NotValidVariableIdentifierException(operandString);
                }
                res.add(new PreparedExpressionItem(PreparedExpressionItemKind.Variable, operandString));
            }
        }
        return new PreparedExpression(res);
    }

    public static boolean IsValidVariableName(String string, boolean allowDollarSigns, boolean allowReportingVariablesOnly) {
        if (string == null) {
            throw new IllegalArgumentException("string");
        }
        if (string.length() == 0) {
            return false;
        }
        if (!(Character.isLetter(string.charAt(0)) || Features.ANY_PAGE_AS_A_SOURCE && string.charAt(0) == '[' || Features.FORMULA_SUPPORT_IN_CONDITIONS && string.charAt(0) == '$')) {
            return false;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && !allowReportingVariablesOnly) {
            patterns.add("[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+");
            patterns.add("Table[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("Table[0-9]+[.!][a-zA-Z]+[0-9]+");
            patterns.add("CurrentTable[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("CurrentTable[.!][a-zA-Z]+[0-9]+");
            patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+");
            patterns.add("\\x5B.+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("\\x5B.+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+");
        } else if (Features.ANY_PAGE_AS_A_SOURCE && !allowReportingVariablesOnly) {
            patterns.add("[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+");
            patterns.add("Table[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("Table[0-9]+[.!][a-zA-Z]+[0-9]+");
            patterns.add("CurrentTable[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("CurrentTable[.!][a-zA-Z]+[0-9]+");
            patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+");
        } else if (Features.CURRENT_TABLE_SUPPORT && !allowReportingVariablesOnly) {
            patterns.add("[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+.[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+.[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+![a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+.[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+.[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+![a-zA-Z]+[0-9]+");
        } else if (!allowReportingVariablesOnly) {
            patterns.add("[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+.[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+.[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+[0-9]+![a-zA-Z]+[0-9]+");
        }
        if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && !allowReportingVariablesOnly) {
            patterns.add("Table[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+");
            patterns.add("Table[0-9]+[.!][0-9]+:[0-9]+");
            patterns.add("CurrentTable[.!][a-zA-Z]+:[a-zA-Z]+");
            patterns.add("CurrentTable[.!][0-9]+:[0-9]+");
            patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+");
            patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][0-9]+:[0-9]+");
        }
        if (Features.FORMULA_SUPPORT_IN_CONDITIONS && allowDollarSigns && !allowReportingVariablesOnly) {
            patterns.add("\\$[a-zA-Z]+\\$[0-9]+:\\$[a-zA-Z]+\\$[0-9]+");
            patterns.add("\\$[a-zA-Z]+[0-9]+");
            patterns.add("[a-zA-Z]+\\$[0-9]+");
            patterns.add("\\$[a-zA-Z]+\\$[0-9]+");
        }
        if (Features.SUPPORT_FOR_REPORTS && allowReportingVariablesOnly) {
            patterns.add("CurrentItem(.[a-zA-Z_]+[a-zA-Z0-9_]*(\\x5B[0-9]+\\x5D)?)+");
            patterns.add("CurrentItem");
            patterns.add("AllItems(.[a-zA-Z_]+[a-zA-Z0-9_]*(\\x5B[0-9]+\\x5D)?)+");
            patterns.add("AllItems");
            patterns.add("CurrentParentItem(.[a-zA-Z_]+[a-zA-Z0-9_]*(\\x5B[0-9]+\\x5D)?)+");
            patterns.add("CurrentParentItem");
            patterns.add("AllParentItems(.[a-zA-Z_]+[a-zA-Z0-9_]*(\\x5B[0-9]+\\x5D)?)+");
            patterns.add("AllParentItems");
            patterns.add("CurrentGrandParentItem(.[a-zA-Z_]+[a-zA-Z0-9_]*(\\x5B[0-9]+\\x5D)?)+");
            patterns.add("CurrentGrandParentItem");
            patterns.add("AllGrandParentItems(.[a-zA-Z_]+[a-zA-Z0-9_]*(\\x5B[0-9]+\\x5D)?)+");
            patterns.add("AllGrandParentItems");
        }
        for (int i = 0; i < patterns.size(); ++i) {
            String s;
            Pattern p = Pattern.compile((String)patterns.get(i), 2);
            Matcher m = p.matcher(string);
            if (!m.find() || null == (s = m.group()) || 0 != s.compareTo(string)) continue;
            return true;
        }
        return false;
    }

    static {
        char[] charPair = null;
        firstBracketChar = (char)34;
        try {
            charPair = Character.toChars(8220);
            if (null != charPair && charPair.length > 0) {
                firstBracketChar = charPair[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastBracketChar = (char)34;
        try {
            charPair = Character.toChars(8221);
            if (null != charPair && charPair.length > 0) {
                lastBracketChar = charPair[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

