/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Features;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.Operation;
import com.celestecs.expression.OperationsRegistry;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.Variable;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.IOperationCalculator;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageData;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageDataAsHtml;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageElementCount;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageElementData;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageElementDataAsHtml;
import com.celestecs.expression.exceptions.MathProcessorException;
import com.celestecs.expression.exceptions.OperandsDisbalanceException;
import com.celestecs.expression.exceptions.VariableNotInitializedException;
import com.celestecs.expression.expressions.CompiledExpression;
import com.celestecs.expression.expressions.CompiledExpressionItem;
import java.util.ArrayList;

public final class Calculator {
    public static double eps = 1.0E-10;
    private OperationsRegistry operationsRegistry;

    public OperationsRegistry getOperationsRegistry() {
        return this.operationsRegistry;
    }

    public Calculator(OperationsRegistry operationsRegistry) {
        if (operationsRegistry == null) {
            throw new IllegalArgumentException("operationsRegistry");
        }
        this.operationsRegistry = operationsRegistry;
    }

    public Object Calculate(CompiledExpression compiledExpression, ArrayList<VariableValue> variableValues, PageContentProvider pageContentProvider, MathTextResolver i18n) throws CalculatorException {
        if (compiledExpression == null) {
            throw new IllegalArgumentException("compiledExpression");
        }
        if (variableValues == null) {
            throw new IllegalArgumentException("variableValues");
        }
        ArrayList<Object> calculationsStack = new ArrayList<Object>();
        block5: for (int i = 0; i < compiledExpression.getCompiledExpressionItems().size(); ++i) {
            CompiledExpressionItem item = compiledExpression.getCompiledExpressionItems().get(i);
            switch (item.getKind()) {
                case CONSTANT: {
                    calculationsStack.add(item.getConstant());
                    continue block5;
                }
                case VARIABLE: {
                    boolean variableValueFound = false;
                    String variableName = item.getVariableName();
                    Variable var = Variable.makeVariable(variableName, variableValues, pageContentProvider, i18n);
                    if (null != var) {
                        variableValueFound = true;
                        calculationsStack.add(var);
                        continue block5;
                    }
                    if (variableValueFound) continue block5;
                    throw new VariableNotInitializedException(item.getVariableName());
                }
                case OPERATION: {
                    int realOperandsCount;
                    Operation operation = this.operationsRegistry.GetOperationByName(item.getOperationName());
                    int n = realOperandsCount = -1 == operation.getOperandsCount() ? item.getOperationParamCount() : operation.getOperandsCount();
                    if (calculationsStack.size() - realOperandsCount < 0) {
                        throw new MathProcessorException("Stack is empty.");
                    }
                    Object[] parametersArray = new Object[realOperandsCount];
                    for (int j = 0; j < realOperandsCount; ++j) {
                        int index = calculationsStack.size() - realOperandsCount + j;
                        parametersArray[j] = calculationsStack.get(index);
                    }
                    calculationsStack.subList(calculationsStack.size() - realOperandsCount, realOperandsCount + calculationsStack.size() - realOperandsCount).clear();
                    IOperationCalculator calculator = operation.getCalculator();
                    if (Features.FIRST_DATA_ACCESS_FUNCTIONS_SUPPORT) {
                        if (calculator instanceof CalculatorGetConfluencePageData) {
                            CalculatorGetConfluencePageData getPageDataCalculator = (CalculatorGetConfluencePageData)calculator;
                            getPageDataCalculator.setPageContentProvider(pageContentProvider);
                        }
                        if (calculator instanceof CalculatorGetConfluencePageDataAsHtml) {
                            CalculatorGetConfluencePageDataAsHtml getPageDataCalculator = (CalculatorGetConfluencePageDataAsHtml)calculator;
                            getPageDataCalculator.setPageContentProvider(pageContentProvider);
                        }
                        if (calculator instanceof CalculatorGetConfluencePageElementCount) {
                            CalculatorGetConfluencePageElementCount getPageDataCalculator = (CalculatorGetConfluencePageElementCount)calculator;
                            getPageDataCalculator.setPageContentProvider(pageContentProvider);
                        }
                        if (calculator instanceof CalculatorGetConfluencePageElementData) {
                            CalculatorGetConfluencePageElementData getPageDataCalculator = (CalculatorGetConfluencePageElementData)calculator;
                            getPageDataCalculator.setPageContentProvider(pageContentProvider);
                        }
                        if (calculator instanceof CalculatorGetConfluencePageElementDataAsHtml) {
                            CalculatorGetConfluencePageElementDataAsHtml getPageDataCalculator = (CalculatorGetConfluencePageElementDataAsHtml)calculator;
                            getPageDataCalculator.setPageContentProvider(pageContentProvider);
                        }
                    }
                    calculationsStack.add(calculator.Calculate(parametersArray));
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown item kind.");
                }
            }
        }
        if (calculationsStack.size() != 1) {
            throw new OperandsDisbalanceException();
        }
        return calculationsStack.get(0);
    }
}

