/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.math;

import com.atlassian.confluence.api.extension.MetadataProperty;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.Position;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.SubjectType;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationCheckResult;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.fugue.Option;
import com.celestecs.expression.QueryExecutor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;

public class MathCqlQueryExecutor
implements QueryExecutor {
    protected String DATE_TIME_TEMPLATE = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    protected String DUMMY_JIRA_RESPONSE = "{\"results\":[{\"content\":{\"id\":\"884739\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Test\",\"restrictions\":{},\"_links\":{\"webui\":\"/display/ds/Test\",\"tinyui\":\"/x/A4AN\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/884739\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/884739/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Test\",\"excerpt\":\"Result:\\n\\n\\n\\nCurrentItem.id\\n\\n\\n\\n\\nCurrentItem.key\\n\\n\\n\\n\\nTable:\",\"url\":\"/display/ds/Test\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2022-07-17T23:34:34.401+03:00\",\"friendlyLastModified\":\"Jul 17, 2022\",\"timestamp\":1658090074401},{\"content\":{\"id\":\"65537\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Learn the wonders of autoconvert (step 7 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65537\",\"tinyui\":\"/x/AQAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65537\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65537/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Learn the wonders of autoconvert (step 7 of 9)\",\"excerpt\":\"Confluence automatically transforms linked content into rich content. Try it with Confluence pages, JIRA issues, YouTube and Vimeo videos, \\nFlickr photo streams, Tweets, Google maps and many more.\\n\\nHere&#39;s two examples of autoconvert in action.\\n\\n   \\n\\n\\n  \\n\\nTry it yourself:\\n\\n\\n    Edit this page.   \\n\\n   Copy this link http\",\"url\":\"/pages/viewpage.action?pageId=65537\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.340+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238340},{\"content\":{\"id\":\"65538\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Welcome to Confluence\",\"restrictions\":{},\"_links\":{\"webui\":\"/display/ds/Welcome+to+Confluence\",\"tinyui\":\"/x/AgAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65538\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65538/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Welcome to Confluence\",\"excerpt\":\" \\n\\nwelcome.png\\n  With Confluence it is easy to create, edit and share content with your team. \\n  Choose a topic below to start learning how.\\n\\n\\n\\n\\n\\nWhat is Confluence?\\n\\n\\n\\nA quick look at the editor\\n \\n\\nLet&#39;s edit this page\\n\\n\\n\\nPrettify the page with an image\\n\\n\\n\\nGet serious with a table\\n \\n\\nLay out your page \\n\\n\\n\\nLearn the wo\",\"url\":\"/display/ds/Welcome+to+Confluence\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-home\",\"lastModified\":\"2018-09-24T08:33:58.351+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238351},{\"content\":{\"id\":\"65539\",\"type\":\"page\",\"status\":\"current\",\"title\":\"What is Confluence? (step 1 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65539\",\"tinyui\":\"/x/AwAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65539\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65539/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"What is Confluence? (step 1 of 9)\",\"excerpt\":\" \\n\\nConfluence is where you can create, organize and discuss work with your team. \\nUse Confluence for meeting notes, project plans, requirements, sprint planning, how-to guides, or anything you like.\\n\\nClick the Create button on the header to see some of the types of pages you can create.\\n\\nA Confluence page can contain t\",\"url\":\"/pages/viewpage.action?pageId=65539\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.347+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238347},{\"content\":{\"id\":\"65540\",\"type\":\"page\",\"status\":\"current\",\"title\":\"A quick look at the editor (step 2 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65540\",\"tinyui\":\"/x/BAAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65540\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65540/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"A quick look at the editor (step 2 of 9)\",\"excerpt\":\" \\n\\nLet&#39;s start with the editor. You&#39;ll use the Confluence editor to create and edit pages.\\nYou can type in the editor as you would in any document, apply formatting, and embed other content and files into the page.\\n\\nThe editor looks like this (click images for a larger view):\\n\\n\\n\\n\\nstep-2-image-1.png\\n\\n\\n\\n\\nHere is a descri\",\"url\":\"/pages/viewpage.action?pageId=65540\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.345+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238345},{\"content\":{\"id\":\"65543\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Let's edit this page (step 3 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65543\",\"tinyui\":\"/x/BwAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65543\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65543/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Let&#39;s edit this page (step 3 of 9)\",\"excerpt\":\" \\n\\nPages live in spaces. This page is in the &#39;Demonstration Space&#39;. \\n \\n\\nLet&#39;s play with some content. Don&#39;t worry, you won&#39;t break anything:\\n\\n\\nClick Edit at the top of this page. Now you&#39;re in the editor.\\n\\n\\n\\nType some words anywhere on the page.\\n\\n\\n\\nHave some fun: \\n\\n\\n\\n\\n\\nChange the color of the text: Select the text, the\",\"url\":\"/pages/viewpage.action?pageId=65543\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.359+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238359},{\"content\":{\"id\":\"65544\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Prettify the page with an image (step 4 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65544\",\"tinyui\":\"/x/CAAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65544\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65544/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Prettify the page with an image (step 4 of 9)\",\"excerpt\":\" \\n\\nThe Confluence editor helps you create content, fast. You can embed images, Office documents, and even videos. \\nThat&#39;s just the tip of the iceberg when it comes to creating useful content for your team. \\n \\n\\n\\nEdit the page.\\n\\n\\n\\nClick in the right-hand column to position your cursor.\\n\\n\\n\\nClick Files on the editor toolba\",\"url\":\"/pages/viewpage.action?pageId=65544\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.355+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238355},{\"content\":{\"id\":\"65557\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Tell people what you think in a comment (step 8 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65557\",\"tinyui\":\"/x/FQAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65557\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65557/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Tell people what you think in a comment (step 8 of 9)\",\"excerpt\":\"You can start a discussion by simply leaving a comment on a page, like this one.\\n\\nWhy not give it a try?\\n\\nGo to the bottom of this page and start typing in the comment area. When you&#39;re finished just press save! \\n\\nDon&#39;t just confine your comments to the bottom of the page - highlight some text on the page to add an inl\",\"url\":\"/pages/viewpage.action?pageId=65557\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.304+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238304},{\"content\":{\"id\":\"65558\",\"type\":\"page\",\"status\":\"current\",\"title\":\"Share your page with a team member (step 9 of 9)\",\"restrictions\":{},\"_links\":{\"webui\":\"/pages/viewpage.action?pageId=65558\",\"tinyui\":\"/x/FgAB\",\"self\":\"http://LEXUS:1990/confluence/rest/api/content/65558\"},\"_expandable\":{\"container\":\"\",\"metadata\":\"\",\"extensions\":\"\",\"operations\":\"\",\"children\":\"\",\"history\":\"/rest/api/content/65558/history\",\"ancestors\":\"\",\"body\":\"\",\"version\":\"\",\"descendants\":\"\",\"space\":\"/rest/api/space/ds\"}},\"title\":\"Share your page with a team member (step 9 of 9)\",\"excerpt\":\"Once you&#39;ve created content you&#39;ll want to share it with your team members. \\nConfluence can do all the work for you, just click the Share button.\\n\\n\\n\\n\\n\\n\\nLet&#39;s tell someone about this page. \\nClick the Share button at the top right of the page. It looks like this:\\n\\nstep09-01.png\\n \\n\\nType the name of the person or group you\",\"url\":\"/pages/viewpage.action?pageId=65558\",\"resultGlobalContainer\":{\"title\":\"Demonstration Space\",\"displayUrl\":\"/display/ds\"},\"entityType\":\"content\",\"iconCssClass\":\"aui-icon content-type-page\",\"lastModified\":\"2018-09-24T08:33:58.320+03:00\",\"friendlyLastModified\":\"Sep 24, 2018\",\"timestamp\":1537767238320}],\"start\":0,\"limit\":25,\"size\":9,\"totalSize\":9,\"cqlQuery\":\"space=ds and type=page\",\"searchDuration\":49,\"_links\":{\"base\":\"http://LEXUS:1990/confluence\",\"context\":\"/confluence\"}}";
    private final CQLSearchService cqlSearchService;

    public MathCqlQueryExecutor(CQLSearchService cqlSearchService) {
        this.cqlSearchService = cqlSearchService;
    }

    @Override
    public long getNumberOfResults(String jqlRequest, String ignoreThisParameter) throws Exception {
        if (null == this.cqlSearchService) {
            return 0L;
        }
        int count = this.cqlSearchService.countContent(jqlRequest);
        return count;
    }

    protected JsonObject mapToJson(Map<String, Object> map) {
        Set set;
        JsonObject result = new JsonObject();
        if (map instanceof EnrichableMap && map.isEmpty() && null != (set = ((EnrichableMap)map).getCollapsedEntries()) && !set.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            for (Object entry2 : set) {
                String entryValue = entry2.toString();
                jsonObject.addProperty(entryValue, "");
            }
            result = jsonObject;
        }
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                String strValue = null;
                JsonObject jsonValue = null;
                JsonElement jsonArray = null;
                if (value instanceof Reference) {
                    if (((Reference)value).existsAndExpanded()) {
                        strValue = ((Reference)value).get().toString();
                    }
                } else if (value instanceof Position) {
                    Position position = (Position)value;
                    strValue = position.serialise().toString();
                } else if (value instanceof Long) {
                    Long val = (Long)value;
                    strValue = val.toString();
                } else if (value instanceof EnrichableMap) {
                    jsonValue = this.mapToJson((Map<String, Object>)((EnrichableMap)value));
                } else if (value instanceof RestList) {
                    RestList restList = (RestList)value;
                    JsonObject jsonObject = new JsonObject();
                    List results = restList.getResults();
                    JsonArray array = new JsonArray();
                    for (Object listItem : results) {
                        if (listItem instanceof Label) {
                            JsonObject jsonLabel = new JsonObject();
                            Label label = (Label)listItem;
                            jsonLabel.addProperty("id", label.getId());
                            jsonLabel.addProperty("label", label.getLabel());
                            jsonLabel.addProperty("prefix", label.getPrefix());
                            array.add((JsonElement)jsonLabel);
                            continue;
                        }
                        long l = 10L;
                    }
                    jsonObject.add("results", (JsonElement)array);
                    PageRequest pageRequest = restList.getPageRequest();
                    if (null != pageRequest) {
                        jsonObject.addProperty("start", "" + pageRequest.getStart());
                        jsonObject.addProperty("limit", "" + pageRequest.getLimit());
                    }
                    jsonValue = jsonObject;
                } else if (value instanceof String) {
                    strValue = value.toString();
                } else if (null != value) {
                    strValue = value.toString();
                }
                if (null != strValue) {
                    result.addProperty(entry.getKey(), strValue);
                }
                if (null != jsonValue) {
                    result.add(entry.getKey(), (JsonElement)jsonValue);
                }
                if (null == jsonArray) continue;
                result.add(entry.getKey(), jsonArray);
            }
        }
        return result;
    }

    protected JsonObject objectMapToJson(Map<Object, Object> map) {
        JsonObject result = new JsonObject();
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof ContentId) {
                    ContentId contentId = (ContentId)value;
                    result.addProperty(entry.getKey().toString(), "" + contentId.asLong());
                    continue;
                }
                if (value instanceof Reference) {
                    Reference reference = (Reference)value;
                    if (reference.existsAndExpanded()) {
                        Object obj = reference.get();
                        result.addProperty(entry.getKey().toString(), obj.toString());
                        continue;
                    }
                    JsonObject sub = this.objectMapToJson(reference.getIdProperties());
                    result.add(entry.getKey().toString(), (JsonElement)sub);
                    continue;
                }
                result.addProperty(entry.getKey().toString(), null == entry.getValue() ? "" : entry.getValue().toString());
            }
        }
        return result;
    }

    protected JsonObject linksToJson(Map<LinkType, Link> map) {
        JsonObject result = new JsonObject();
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<LinkType, Link> entry : map.entrySet()) {
                result.addProperty(entry.getKey().getType(), null == entry.getValue() ? "" : entry.getValue().getPath());
            }
        }
        return result;
    }

    protected JsonObject formattedBodyToJson(FormattedBody formattedBody) {
        JsonObject result = new JsonObject();
        if (null != formattedBody) {
            result.addProperty("value", formattedBody.getValue());
            result.addProperty("representation", formattedBody.getRepresentation().getValue());
        }
        return result;
    }

    protected JsonObject contentRepresentationMapToJson(Map<ContentRepresentation, FormattedBody> map, boolean addAdditionalFields) {
        JsonObject result = new JsonObject();
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<ContentRepresentation, FormattedBody> entry : map.entrySet()) {
                String type = entry.getKey().getValue();
                result.add(type, (JsonElement)(null == entry.getValue() ? new JsonObject() : this.formattedBodyToJson(entry.getValue())));
            }
        }
        if (addAdditionalFields) {
            JsonObject _expandable = new JsonObject();
            ContentRepresentation contentRepresentation = null;
            String value = "";
            FormattedBody formattedBody = map.get(ContentRepresentation.VIEW);
            contentRepresentation = null == formattedBody ? null : formattedBody.getRepresentation();
            value = null == contentRepresentation ? "" : contentRepresentation.getValue();
            _expandable.addProperty("view", value);
            formattedBody = map.get(ContentRepresentation.PLAIN);
            contentRepresentation = null == formattedBody ? null : formattedBody.getRepresentation();
            value = null == contentRepresentation ? "" : contentRepresentation.getValue();
            _expandable.addProperty("plain", value);
            result.add("_expandable", (JsonElement)_expandable);
        }
        return result;
    }

    protected JsonObject contentRepresentationContentBodyMapToJson(Map<ContentRepresentation, ContentBody> map, boolean addAdditionalFields) {
        JsonObject result = new JsonObject();
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<ContentRepresentation, ContentBody> entry : map.entrySet()) {
                String type = entry.getKey().getValue();
                result.add(type, (JsonElement)(null == entry.getValue() ? new JsonObject() : this.formattedBodyToJson((FormattedBody)entry.getValue())));
            }
        }
        if (addAdditionalFields) {
            JsonObject _expandable = new JsonObject();
            ContentRepresentation contentRepresentation = null;
            String value = "";
            FormattedBody formattedBody = map.isEmpty() ? null : (FormattedBody)map.get(ContentRepresentation.VIEW);
            contentRepresentation = null == formattedBody ? null : formattedBody.getRepresentation();
            value = null == contentRepresentation ? "" : contentRepresentation.getValue();
            _expandable.addProperty("view", value);
            formattedBody = map.isEmpty() ? null : (FormattedBody)map.get(ContentRepresentation.PLAIN);
            contentRepresentation = null == formattedBody ? null : formattedBody.getRepresentation();
            value = null == contentRepresentation ? "" : contentRepresentation.getValue();
            _expandable.addProperty("plain", value);
            _expandable.addProperty("editor", "");
            _expandable.addProperty("export_view", "");
            _expandable.addProperty("styled_view", "");
            _expandable.addProperty("storage", "");
            _expandable.addProperty("anonymous_export_view", "");
            result.add("_expandable", (JsonElement)_expandable);
        }
        return result;
    }

    protected JsonObject homepageRefToJson(Reference<Content> contentRef) {
        JsonObject result = new JsonObject();
        if (null == contentRef || !contentRef.existsAndExpanded()) {
            Map properties = contentRef.getIdProperties();
            if (null != properties) {
                return this.objectMapToJson(properties);
            }
            return result;
        }
        Content content = (Content)contentRef.get();
        if (null == content) {
            return result;
        }
        result.addProperty("id", "" + content.getId().asLong());
        result.addProperty("type", content.getType().getValue());
        result.addProperty("status", content.getStatus().getValue());
        result.addProperty("title", content.getTitle());
        return result;
    }

    protected JsonObject spaceRefToJson(Reference<Space> spaceRef) {
        JsonObject result = new JsonObject();
        if (null == spaceRef) {
            return result;
        }
        if (spaceRef.exists() && !spaceRef.isExpanded()) {
            Map properties = spaceRef.getIdProperties();
            if (null != properties) {
                return this.objectMapToJson(properties);
            }
            return result;
        }
        if (spaceRef.existsAndExpanded()) {
            Space space = (Space)spaceRef.get();
            result.addProperty("id", (Number)space.getId());
            result.addProperty("key", space.getKey());
            result.addProperty("name", space.getName());
            if (null != space.getIconRef() && space.getIconRef().existsAndExpanded()) {
                Icon icon = (Icon)space.getIconRef().get();
                result.add("icon", (JsonElement)this.iconToJson(icon));
            }
            result.add("description", (JsonElement)this.contentRepresentationMapToJson(space.getDescription(), true));
            result.addProperty("type", space.getType().getValue());
            result.add("metadata", (JsonElement)this.mapToJson(space.getMetadata()));
            result.add("operations", (JsonElement)new JsonArray());
            result.add("permissions", (JsonElement)new JsonArray());
            result.addProperty("status", "");
            result.add("settings", (JsonElement)new JsonObject());
            result.add("theme", (JsonElement)new JsonObject());
            result.add("lookAndFeel", (JsonElement)new JsonObject());
            result.add("history", (JsonElement)new JsonObject());
            JsonObject _expandable = new JsonObject();
            _expandable.addProperty("settings", "");
            _expandable.addProperty("metadata", "");
            _expandable.addProperty("operations", "");
            _expandable.addProperty("lookAndFeel", "");
            _expandable.addProperty("permissions", "");
            _expandable.addProperty("icon", "");
            _expandable.addProperty("description", "");
            _expandable.addProperty("theme", "");
            _expandable.addProperty("history", "");
            _expandable.addProperty("homepage", "");
            _expandable.addProperty("identifiers", "");
            result.add("_expandable", (JsonElement)_expandable);
            result.add("_links", (JsonElement)this.linksToJson(space.getLinks()));
            result.add("homepage", (JsonElement)this.homepageRefToJson((Reference<Content>)space.getHomepageRef()));
            result.add("_metadataProperties", (JsonElement)this.metadataPropertiesToJson(Space.getMetadataProperties()));
            result.addProperty("displayUrl", this.getUrlLink(space.getLinks()));
        }
        return result;
    }

    private JsonElement optionalContentToJson(Optional<Content> optionalContent) {
        JsonObject result = new JsonObject();
        if (null != optionalContent && optionalContent.isPresent() && null != optionalContent.orElse(null)) {
            Content content = optionalContent.get();
            result.addProperty("title", content.getTitle());
            result.addProperty("displayUrl", this.getUrlLink(content.getLinks()));
        }
        return result;
    }

    protected JsonObject containerToJson(Reference<? extends Container> containerRef) {
        Map properties;
        if (null != containerRef && containerRef.exists() && !containerRef.isExpanded() && null != (properties = containerRef.getIdProperties())) {
            return this.objectMapToJson(properties);
        }
        JsonObject result = new JsonObject();
        if (null != containerRef && containerRef.existsAndExpanded()) {
            Object obj = containerRef.get();
            if (obj instanceof Page) {
                Page page = (Page)obj;
                result.addProperty("title", page.getTitle());
                result.addProperty("id", "" + page.getId());
                result.addProperty("type", page.getType());
                result.addProperty("displayUrl", page.getUrlPath());
            } else if (obj instanceof Space) {
                Space space = (Space)obj;
                result.addProperty("id", "" + space.getId());
                result.addProperty("key", space.getKey());
                result.addProperty("name", space.getName());
                result.addProperty("type", space.getType().getValue());
                result.add("_links", (JsonElement)this.linksToJson(space.getLinks()));
            } else if (obj instanceof Content) {
                Content content = (Content)obj;
                result.addProperty("id", "" + content.getId());
                result.addProperty("title", content.getTitle());
                result.addProperty("displayUrl", this.getUrlLink(content.getLinks()));
                result.add("extensions", (JsonElement)this.mapToJson(content.getExtensions()));
            }
        }
        return result;
    }

    protected JsonObject iconToJson(Icon icon) {
        JsonObject result = new JsonObject();
        if (null != icon) {
            String path = icon.getPath();
            result.addProperty("path", path);
            int width = icon.getWidth();
            result.addProperty("width", (Number)width);
            int height = icon.getHeight();
            result.addProperty("heigth", (Number)height);
            boolean isDefault = icon.getIsDefault();
            result.addProperty("isDefault", Boolean.valueOf(isDefault));
        }
        return result;
    }

    protected JsonObject personToJson(Person person) {
        JsonObject result = new JsonObject();
        if (null != person) {
            String str;
            Option optionalUsername;
            SubjectType subjectType = person.getSubjectType();
            if (null != subjectType) {
                result.addProperty("type", subjectType.toString());
            }
            if (null != (optionalUsername = person.getOptionalUsername()) && optionalUsername.isDefined() && null != (str = (String)optionalUsername.getOrNull()) && !str.isEmpty()) {
                result.addProperty("username", str);
            }
            result.add("profilePicture", (JsonElement)this.iconToJson(person.getProfilePicture()));
            str = person.getDisplayName();
            if (null != str && !str.isEmpty()) {
                result.addProperty("displayName", str);
            }
        }
        return result;
    }

    protected JsonObject versionRefToJson(Reference<Version> versionRef) {
        Version version;
        JsonObject result = new JsonObject();
        if (null != versionRef && versionRef.existsAndExpanded() && null != (version = (Version)versionRef.get())) {
            result.add("by", (JsonElement)this.personToJson(version.getBy()));
            result.addProperty("when", this.dateTimeToString(version.getWhen()));
            result.addProperty("message", version.getMessage());
            result.addProperty("number", (Number)version.getNumber());
            result.addProperty("minorEdit", Boolean.valueOf(version.isMinorEdit()));
            result.addProperty("hidden", Boolean.valueOf(version.isHidden()));
            result.addProperty("confRev", "");
            result.addProperty("syncRev", version.getSyncRev());
            result.addProperty("syncRevSource", "");
            JsonObject _expandable = new JsonObject();
            _expandable.addProperty("content", "");
            _expandable.addProperty("collaborators", "");
            result.add("_expandable", (JsonElement)_expandable);
        }
        return result;
    }

    protected String dateTimeToString(DateTime dateTime) {
        if (null == dateTime) {
            return "";
        }
        String strTime = dateTime.toString(this.DATE_TIME_TEMPLATE);
        return strTime;
    }

    protected JsonObject historyToJson(Reference<History> historyRef) {
        History history;
        JsonObject result = new JsonObject();
        if (null != historyRef && historyRef.existsAndExpanded() && null != (history = (History)historyRef.get())) {
            result.addProperty("latest", Boolean.valueOf(history.isLatest()));
            result.add("createdBy", (JsonElement)this.personToJson(history.getCreatedBy()));
            result.addProperty("createdDate", this.dateTimeToString(history.getCreatedDate()));
            result.add("lastUpdated", (JsonElement)this.versionRefToJson((Reference<Version>)history.getLastUpdatedRef()));
            result.add("previousVersion", (JsonElement)this.versionRefToJson((Reference<Version>)history.getPreviousVersionRef()));
            result.add("contributors", (JsonElement)new JsonObject());
            result.add("nextVersion", (JsonElement)this.versionRefToJson((Reference<Version>)history.getNextVersionRef()));
            JsonObject _expandable = new JsonObject();
            _expandable.addProperty("lastUpdated", "");
            _expandable.addProperty("previousVersion", "");
            _expandable.addProperty("contributors", "");
            _expandable.addProperty("nextVersion", "");
            result.add("_expandable", (JsonElement)_expandable);
        }
        return result;
    }

    protected String getUrlLink(Map<LinkType, Link> map) {
        if (null != map && !map.isEmpty()) {
            return map.get(LinkType.WEB_UI).getPath();
        }
        return "";
    }

    protected JsonArray operationsToJson(List<OperationCheckResult> list) {
        JsonArray result = new JsonArray();
        if (null != list && !list.isEmpty()) {
            for (OperationCheckResult entry : list) {
                JsonObject item = new JsonObject();
                item.addProperty("operation", null == entry.getOperationKey() ? "" : entry.getOperationKey().getValue());
                item.addProperty("targetType", null == entry.getTargetType() ? "" : entry.getTargetType().getValue());
                result.add((JsonElement)item);
            }
        }
        return result;
    }

    protected JsonObject restrictionsToJson(Map<OperationKey, ContentRestriction> map) {
        JsonObject result = new JsonObject();
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<OperationKey, ContentRestriction> entry : map.entrySet()) {
                JsonObject entryObj = new JsonObject();
                ContentRestriction contentRestriction = entry.getValue();
                if (null != entry.getKey() && null != entry.getKey().getValue()) {
                    entryObj.addProperty("operation", contentRestriction.getOperation().getValue());
                    JsonObject content = this.homepageRefToJson((Reference<Content>)contentRestriction.getContent());
                    entryObj.add("content", (JsonElement)content);
                    entryObj.add("_expandable", (JsonElement)new JsonObject());
                    entryObj.add("_links", (JsonElement)new JsonObject());
                }
                result.add(entry.getKey().getValue(), (JsonElement)entryObj);
            }
            JsonObject _expandable = new JsonObject();
            _expandable.addProperty("read", "");
            _expandable.addProperty("read", "");
            result.add("_expandable", (JsonElement)_expandable);
        }
        return result;
    }

    protected JsonObject childrenToJson(Map<ContentType, PageResponse<Content>> map) {
        Set set;
        JsonObject result = new JsonObject();
        if (null == map) {
            return result;
        }
        if (map instanceof EnrichableMap && null != (set = ((EnrichableMap)map).getCollapsedEntries()) && !set.isEmpty()) {
            for (Object entry : set) {
                String entryValue = entry.toString();
                result.addProperty(entryValue, "");
            }
            return result;
        }
        if (null != map && !map.isEmpty()) {
            for (Map.Entry<ContentType, PageResponse<Content>> entry : map.entrySet()) {
                JsonObject entryObj = new JsonObject();
                List contentList = entry.getValue().getResults();
                if (null == contentList || contentList.isEmpty()) continue;
                if (null != entry.getKey() && null != entry.getKey().getValue() && null != contentList) {
                    JsonArray results = new JsonArray();
                    for (Content content : contentList) {
                        JsonObject jsonContent = new JsonObject();
                        Long contentId = null == content.getId() ? 0L : content.getId().asLong();
                        jsonContent.addProperty("id", "" + contentId);
                        jsonContent.addProperty("type", null == content.getType() ? "" : content.getType().getValue());
                        jsonContent.addProperty("status", null == content.getStatus() ? "" : content.getStatus().getValue());
                        jsonContent.addProperty("title", null == content.getTitle() ? "" : content.getTitle());
                        results.add((JsonElement)jsonContent);
                    }
                    entryObj.addProperty("start", "0");
                    entryObj.addProperty("limit", "10000");
                    entryObj.addProperty("size", "" + results.size());
                    entryObj.addProperty("totalSize", "" + results.size());
                    entryObj.add("results", (JsonElement)results);
                }
                result.add(entry.getKey().getValue(), (JsonElement)entryObj);
            }
        }
        return result;
    }

    protected JsonArray metadataPropertiesToJson(List<MetadataProperty> list) {
        JsonArray result = new JsonArray();
        if (null != list && !list.isEmpty()) {
            for (MetadataProperty entry : list) {
                JsonObject item = new JsonObject();
                item.addProperty(entry.getPropertyName(), entry.getPropertyType().getTypeName());
                result.add((JsonElement)item);
            }
        }
        return result;
    }

    protected long addPageResponseResultsToJsonArray(ArrayList<JsonElement> results, PageResponse<Content> pageResponse) {
        long count = 0L;
        long contentId = 0L;
        for (Content content : pageResponse.getResults()) {
            JsonObject jsonContent = new JsonObject();
            JsonObject jsonResult = new JsonObject();
            jsonResult.add("content", (JsonElement)jsonContent);
            contentId = null == content.getId() ? 0L : content.getId().asLong();
            jsonContent.addProperty("id", "" + contentId);
            jsonContent.addProperty("type", null == content.getType() ? "" : content.getType().getValue());
            jsonContent.addProperty("status", null == content.getStatus() ? "" : content.getStatus().getValue());
            jsonContent.addProperty("title", null == content.getTitle() ? "" : content.getTitle());
            jsonContent.add("space", (JsonElement)this.spaceRefToJson((Reference<Space>)content.getSpaceRef()));
            jsonContent.add("history", (JsonElement)this.historyToJson((Reference<History>)content.getHistoryRef()));
            jsonContent.add("version", (JsonElement)this.versionRefToJson((Reference<Version>)content.getVersionRef()));
            jsonContent.add("ancestors", (JsonElement)new JsonObject());
            jsonContent.add("operations", (JsonElement)this.operationsToJson(content.getOperations()));
            jsonContent.add("children", (JsonElement)this.childrenToJson(content.getChildren()));
            jsonContent.add("childTypes", (JsonElement)new JsonObject());
            jsonContent.add("descendants", (JsonElement)this.childrenToJson(content.getDescendants()));
            jsonContent.add("container", (JsonElement)this.containerToJson((Reference<? extends Container>)content.getContainerRef()));
            jsonContent.add("body", (JsonElement)this.contentRepresentationContentBodyMapToJson(content.getBody(), true));
            jsonContent.add("restrictions", (JsonElement)this.restrictionsToJson(content.getRestrictions()));
            Map metadata = content.getMetadata();
            jsonContent.add("metadata", (JsonElement)this.mapToJson(metadata));
            jsonContent.add("macroRenderedOutput", (JsonElement)new JsonObject());
            jsonContent.add("extensions", (JsonElement)this.mapToJson(content.getExtensions()));
            JsonObject jsonExpandable = new JsonObject();
            jsonExpandable.addProperty("childTypes", "");
            jsonExpandable.addProperty("container", "");
            jsonExpandable.addProperty("metadata", "");
            jsonExpandable.addProperty("operations", "");
            jsonExpandable.addProperty("children", "");
            jsonExpandable.addProperty("restrictions", "");
            jsonExpandable.addProperty("history", "/rest/api/content/" + contentId + "/history");
            jsonExpandable.addProperty("ancestors", "");
            jsonExpandable.addProperty("body", "");
            jsonExpandable.addProperty("version", "");
            jsonExpandable.addProperty("descendants", "");
            jsonExpandable.addProperty("space", !content.getSpaceRef().existsAndExpanded() ? "" : "/rest/api/space/" + ((Space)content.getSpaceRef().get()).getKey());
            jsonExpandable.addProperty("extensions", "");
            jsonExpandable.addProperty("schedulePublishDate", "");
            jsonExpandable.addProperty("macroRenderedOutput", "");
            jsonContent.add("_expandable", (JsonElement)jsonExpandable);
            jsonContent.add("_links", (JsonElement)this.linksToJson(content.getLinks()));
            jsonResult.add("user", (JsonElement)new JsonObject());
            jsonResult.add("space", (JsonElement)this.spaceRefToJson((Reference<Space>)content.getSpaceRef()));
            jsonResult.addProperty("title", null == content.getTitle() ? "" : content.getTitle());
            jsonResult.addProperty("excerpt", "");
            jsonResult.addProperty("url", this.getUrlLink(content.getLinks()));
            jsonResult.add("resultParentContainer", (JsonElement)new JsonObject());
            jsonResult.add("resultGlobalContainer", (JsonElement)this.containerToJson((Reference<? extends Container>)content.getSpaceRef()));
            jsonResult.add("breadcrumbs", (JsonElement)new JsonObject());
            jsonResult.addProperty("entityType", content.getType().getValue());
            jsonResult.add("iconCssClass", (JsonElement)new JsonObject());
            jsonResult.add("lastModified", (JsonElement)new JsonObject());
            jsonResult.add("friendlyLastModified", (JsonElement)new JsonObject());
            jsonResult.add("score", (JsonElement)new JsonObject());
            results.add((JsonElement)jsonResult);
            ++count;
        }
        return count;
    }

    @Override
    public Object[] getResultsByQuery(String cqlRequest, String expand, long startAt, long maxResults) throws Exception {
        if (null == this.cqlSearchService) {
            return new Object[0];
        }
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        ArrayList<JsonElement> results = new ArrayList<JsonElement>();
        maxResults = Math.min(1000L, maxResults);
        long realTotal = 0L;
        long counter = 10000L;
        while (counter > 0L) {
            --counter;
            PageResponse pageResponse = null;
            try {
                pageResponse = this.cqlSearchService.searchContent(cqlRequest, (PageRequest)new SimplePageRequest((int)startAt, (int)maxResults), expansions);
            }
            catch (IllegalArgumentException exception) {
                break;
            }
            this.addPageResponseResultsToJsonArray(results, (PageResponse<Content>)pageResponse);
            boolean hasMore = pageResponse.hasMore();
            long count = pageResponse.size();
            if (!hasMore || count < 1L || (realTotal += count) >= maxResults) break;
            startAt += count;
        }
        return results.toArray();
    }

    @Override
    public Object[] getResultFieldValues(String jqlRequest, String fieldName, Object valueIfNull, String appLinkName, boolean byFieldId) throws Exception {
        throw new Exception("CqlQueryExecutor.getResultFieldValues method is not implemented.");
    }
}

