/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.conditionalrules;

import com.celestecs.conditionalrules.MaximumValueType;
import com.celestecs.conditionalrules.MinimumValueType;
import com.celestecs.conditionalrules.RuleCondition;
import com.celestecs.conditionalrules.StyleApplicationType;
import com.celestecs.expression.Features;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class CommonParamProcessingFunctions {
    public static final Set<String> COLOR_NAMES = new HashSet<String>();
    public static final Set<Pattern> COLOR_PATTERNS = new HashSet<Pattern>();
    public static final Set<ColorSpec> COLOR_SPECS = new HashSet<ColorSpec>();

    protected static MinimumValueType readMinimumValueTypeParamValue(String paramName, Map<String, String> parameters, MinimumValueType defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        String string = s = null == s ? "" : s.trim();
        if (0 == s.length()) {
            return defaultValue;
        }
        if (s.equals("Lowest value")) {
            return MinimumValueType.LowestValue;
        }
        if (s.equals("Number")) {
            return MinimumValueType.Number;
        }
        if (s.equals("Percent")) {
            return MinimumValueType.Percent;
        }
        if (s.equals("Formula")) {
            return MinimumValueType.Formula;
        }
        if (s.equals("Percentile")) {
            return MinimumValueType.Percentile;
        }
        return defaultValue;
    }

    protected static MaximumValueType readMaximumValueTypeParamValue(String paramName, Map<String, String> parameters, MaximumValueType defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        String string = s = null == s ? "" : s.trim();
        if (0 == s.length()) {
            return defaultValue;
        }
        if (s.equals("Highest value")) {
            return MaximumValueType.HighestValue;
        }
        if (s.equals("Number")) {
            return MaximumValueType.Number;
        }
        if (s.equals("Percent")) {
            return MaximumValueType.Percent;
        }
        if (s.equals("Formula")) {
            return MaximumValueType.Formula;
        }
        if (s.equals("Percentile")) {
            return MaximumValueType.Percentile;
        }
        return defaultValue;
    }

    protected static boolean readBooleanParamValue(String paramName, Map<String, String> parameters, boolean defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        if (null != s && s.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (null != s && s.trim().equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    protected static StyleApplicationType readStyleApplicationTypeParamValue(String paramName, Map<String, String> parameters, StyleApplicationType defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        String string = s = null == s ? "" : s.trim();
        if (0 == s.length()) {
            return defaultValue;
        }
        if (s.equals("Keep original")) {
            return StyleApplicationType.KeepOriginal;
        }
        if (s.equals("Apply style")) {
            return StyleApplicationType.ApplyStyle;
        }
        if (s.equals("Remove style")) {
            return StyleApplicationType.RemoveStyle;
        }
        return defaultValue;
    }

    protected static String readColorParamValue(String paramName, Map<String, String> parameters, String defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        if (null != s && (0 == s.length() || 0 == s.compareToIgnoreCase(defaultValue))) {
            return defaultValue;
        }
        if (null != s && s.length() > 0 && CommonParamProcessingFunctions.isValidColor(s)) {
            return s;
        }
        return defaultValue;
    }

    protected static String readStringParamValue(String paramName, Map<String, String> parameters, String defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        if (null != s && s.length() > 0) {
            return s;
        }
        return defaultValue;
    }

    public static String convertAnyColorToHex(String color) {
        if (null == color) {
            return "";
        }
        color = color.toLowerCase();
        for (Pattern p : COLOR_PATTERNS) {
            if (!p.matcher(color).matches()) continue;
            return color;
        }
        for (ColorSpec c : COLOR_SPECS) {
            if (!c.name.equals(color)) continue;
            return c.hex;
        }
        return "";
    }

    public static boolean isValidColor(String color) {
        if (null == color) {
            return false;
        }
        if (Features.SUPPORT_FOR_2_COLOR_SCALE) {
            color = color.toLowerCase();
            for (Pattern p : COLOR_PATTERNS) {
                if (!p.matcher(color).matches()) continue;
                return true;
            }
            for (ColorSpec c : COLOR_SPECS) {
                if (!c.name.equals(color)) continue;
                return true;
            }
        } else {
            if (Features.SUPPORT_FOR_2_COLOR_SCALE && null != color && COLOR_NAMES.contains(color.toLowerCase())) {
                return true;
            }
            for (Pattern p : COLOR_PATTERNS) {
                if (!p.matcher(color).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected static RuleCondition readRuleConditionParamValue(String paramName, Map<String, String> parameters, RuleCondition defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        String string = s = null == s ? "" : s.trim();
        if (0 == s.length()) {
            return defaultValue;
        }
        if (s.equals("Element value is between")) {
            return RuleCondition.ElementValueIsBetween;
        }
        if (s.equals("Element value is not between")) {
            return RuleCondition.ElementValueIsNotBetween;
        }
        if (s.equals("Element value is equal to")) {
            return RuleCondition.ElementValueIsEqualTo;
        }
        if (s.equals("Element value is not equal to")) {
            return RuleCondition.ElementValueIsNotEqualTo;
        }
        if (s.equals("Element value is greater than")) {
            return RuleCondition.ElementValueIsGreaterThan;
        }
        if (s.equals("Element value is less than")) {
            return RuleCondition.ElementValueIsLessThan;
        }
        if (s.equals("Element value is greater than or equal to")) {
            return RuleCondition.ElementValueIsGreaterThanOrEqualTo;
        }
        if (s.equals("Element value is less than or equal to")) {
            return RuleCondition.ElementValueIsLessThanOrEqualTo;
        }
        if (s.equals("Element text contains")) {
            return RuleCondition.ElementTextContains;
        }
        if (s.equals("Element text does not contain")) {
            return RuleCondition.ElementTextDoesNotContain;
        }
        if (s.equals("Element text begins with")) {
            return RuleCondition.ElementTextBeginsWith;
        }
        if (s.equals("Element text ends with")) {
            return RuleCondition.ElementTextEndsWith;
        }
        if (s.equals("Element is blank")) {
            return RuleCondition.ElementIsBlank;
        }
        if (s.equals("Element is not blank")) {
            return RuleCondition.ElementIsNotBlank;
        }
        if (s.equals("Element is a numeric value")) {
            return RuleCondition.ElementIsANumericValue;
        }
        if (s.equals("Formula result value is true")) {
            return RuleCondition.FormulaResultValueIsTrue;
        }
        return defaultValue;
    }

    protected static char readDecimalSymbolParamValue(String paramName, Map<String, String> parameters, char defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        String string = s = null == s ? "" : s.trim();
        if (0 == s.length()) {
            return defaultValue;
        }
        s = parameters.get("decimal-symbol");
        if (s != null && (s.trim().equals(".") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(".(dot)"))) {
            return '.';
        }
        if (s != null && (s.trim().equals(",") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(",(comma)"))) {
            return ',';
        }
        return defaultValue;
    }

    protected static String readDigitGroupingSymbol(String paramName, Map<String, String> parameters, String defaultValue) {
        if (null == parameters || null == paramName) {
            return defaultValue;
        }
        String s = parameters.get(paramName);
        String string = s = null == s ? "" : s.trim();
        if (0 == s.length()) {
            return defaultValue;
        }
        if (null != s && (s.equals(" ") || Features.BETTER_READ_PARAM_VALUES && s.equalsIgnoreCase(" (space)"))) {
            return " ";
        }
        if (null != s && (s.equals(".") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(".(dot)"))) {
            return ".";
        }
        if (null != s && (s.equals(",") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(",(comma)"))) {
            return ",";
        }
        if (null != s && (s.equals("'") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase("'(apostrophe)"))) {
            return "'";
        }
        return defaultValue;
    }

    static {
        COLOR_PATTERNS.add(Pattern.compile("#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})"));
        COLOR_SPECS.addAll(Arrays.asList(new ColorSpec("highlight-grey", "#f0f0f0"), new ColorSpec("highlight-red", "#ffe7e7"), new ColorSpec("highlight-green", "#ddfade"), new ColorSpec("highlight-blue", "#e0f0ff"), new ColorSpec("highlight-yellow", "#ffffdd"), new ColorSpec("aliceblue", "#f0f8ff"), new ColorSpec("antiquewhite", "#faebd7"), new ColorSpec("aqua", "#00ffff"), new ColorSpec("aquamarine", "#7fffd4"), new ColorSpec("azure", "#f0ffff"), new ColorSpec("beige", "#f5f5dc"), new ColorSpec("bisque", "#ffe4c4"), new ColorSpec("black", "#000000"), new ColorSpec("blanchedalmond", "#ffebcd"), new ColorSpec("blue", "#0000ff"), new ColorSpec("blueviolet", "#8a2be2"), new ColorSpec("brown", "#a52a2a"), new ColorSpec("burlywood", "#deb887"), new ColorSpec("cadetblue", "#5f9ea0"), new ColorSpec("chartreuse", "#7fff00"), new ColorSpec("chocolate", "#d2691e"), new ColorSpec("coral", "#ff7f50"), new ColorSpec("cornflowerblue", "#6495ed"), new ColorSpec("cornsilk", "#fff8dc"), new ColorSpec("crimson", "#dc143c"), new ColorSpec("cyan", "#00ffff"), new ColorSpec("darkblue", "#00008b"), new ColorSpec("darkcyan", "#008b8b"), new ColorSpec("darkgoldenrod", "#b8860b"), new ColorSpec("darkgray", "#a9a9a9"), new ColorSpec("darkgrey", "#a9a9a9"), new ColorSpec("darkgreen", "#006400"), new ColorSpec("darkkhaki", "#bdb76b"), new ColorSpec("darkmagenta", "#8b008b"), new ColorSpec("darkolivegreen", "#556b2f"), new ColorSpec("darkorange", "#ff8c00"), new ColorSpec("darkorchid", "#9932cc"), new ColorSpec("darkred", "#8b0000"), new ColorSpec("darksalmon", "#e9967a"), new ColorSpec("darkseagreen", "#8fbc8f"), new ColorSpec("darkslateblue", "#483d8b"), new ColorSpec("darkslategray", "#2f4f4f"), new ColorSpec("darkslategrey", "#2f4f4f"), new ColorSpec("darkturquoise", "#00ced1"), new ColorSpec("darkviolet", "#9400d3"), new ColorSpec("deeppink", "#ff1493"), new ColorSpec("deepskyblue", "#00bfff"), new ColorSpec("dimgray", "#696969"), new ColorSpec("dimgrey", "#696969"), new ColorSpec("dodgerblue", "#1e90ff"), new ColorSpec("firebrick", "#b22222"), new ColorSpec("floralwhite", "#fffaf0"), new ColorSpec("forestgreen", "#228b22"), new ColorSpec("fuchsia", "#ff00ff"), new ColorSpec("gainsboro", "#dcdcdc"), new ColorSpec("ghostwhite", "#f8f8ff"), new ColorSpec("gold", "#ffd700"), new ColorSpec("goldenrod", "#daa520"), new ColorSpec("gray", "#808080"), new ColorSpec("grey", "#808080"), new ColorSpec("green", "#008000"), new ColorSpec("greenyellow", "#adff2f"), new ColorSpec("honeydew", "#f0fff0"), new ColorSpec("hotpink", "#ff69b4"), new ColorSpec("indianred", "#cd5c5c"), new ColorSpec("indigo", "#4b0082"), new ColorSpec("ivory", "#fffff0"), new ColorSpec("khaki", "#f0e68c"), new ColorSpec("lavender", "#e6e6fa"), new ColorSpec("lavenderblush", "#fff0f5"), new ColorSpec("lawngreen", "#7cfc00"), new ColorSpec("lemonchiffon", "#fffacd"), new ColorSpec("lightblue", "#add8e6"), new ColorSpec("lightcoral", "#f08080"), new ColorSpec("lightcyan", "#e0ffff"), new ColorSpec("lightgoldenrodyellow", "#fafad2"), new ColorSpec("lightgray", "#d3d3d3"), new ColorSpec("lightgrey", "#d3d3d3"), new ColorSpec("lightgreen", "#90ee90"), new ColorSpec("lightpink", "#ffb6c1"), new ColorSpec("lightsalmon", "#ffa07a"), new ColorSpec("lightseagreen", "#20b2aa"), new ColorSpec("lightskyblue", "#87cefa"), new ColorSpec("lightslategray", "#778899"), new ColorSpec("lightslategrey", "#778899"), new ColorSpec("lightsteelblue", "#b0c4de"), new ColorSpec("lightyellow", "#ffffe0"), new ColorSpec("lime", "#00ff00"), new ColorSpec("limegreen", "#32cd32"), new ColorSpec("linen", "#faf0e6"), new ColorSpec("magenta", "#ff00ff"), new ColorSpec("maroon", "#800000"), new ColorSpec("mediumaquamarine", "#66cdaa"), new ColorSpec("mediumblue", "#0000cd"), new ColorSpec("mediumorchid", "#ba55d3"), new ColorSpec("mediumpurple", "#9370db"), new ColorSpec("mediumseagreen", "#3cb371"), new ColorSpec("mediumslateblue", "#7b68ee"), new ColorSpec("mediumspringgreen", "#00fa9a"), new ColorSpec("mediumturquoise", "#48d1cc"), new ColorSpec("mediumvioletred", "#c71585"), new ColorSpec("midnightblue", "#191970"), new ColorSpec("mintcream", "#f5fffa"), new ColorSpec("mistyrose", "#ffe4e1"), new ColorSpec("moccasin", "#ffe4b5"), new ColorSpec("navajowhite", "#ffdead"), new ColorSpec("navy", "#000080"), new ColorSpec("oldlace", "#fdf5e6"), new ColorSpec("olive", "#808000"), new ColorSpec("olivedrab", "#6b8e23"), new ColorSpec("orange", "#ffa500"), new ColorSpec("orangered", "#ff4500"), new ColorSpec("orchid", "#da70d6"), new ColorSpec("palegoldenrod", "#eee8aa"), new ColorSpec("palegreen", "#98fb98"), new ColorSpec("paleturquoise", "#afeeee"), new ColorSpec("palevioletred", "#db7093"), new ColorSpec("papayawhip", "#ffefd5"), new ColorSpec("peachpuff", "#ffdab9"), new ColorSpec("peru", "#cd853f"), new ColorSpec("pink", "#ffc0cb"), new ColorSpec("plum", "#dda0dd"), new ColorSpec("powderblue", "#b0e0e6"), new ColorSpec("purple", "#800080"), new ColorSpec("rebeccapurple", "#663399"), new ColorSpec("red", "#ff0000"), new ColorSpec("rosybrown", "#bc8f8f"), new ColorSpec("royalblue", "#4169e1"), new ColorSpec("saddlebrown", "#8b4513"), new ColorSpec("salmon", "#fa8072"), new ColorSpec("sandybrown", "#f4a460"), new ColorSpec("seagreen", "#2e8b57"), new ColorSpec("seashell", "#fff5ee"), new ColorSpec("sienna", "#a0522d"), new ColorSpec("silver", "#c0c0c0"), new ColorSpec("skyblue", "#87ceeb"), new ColorSpec("slateblue", "#6a5acd"), new ColorSpec("slategray", "#708090"), new ColorSpec("slategrey", "#708090"), new ColorSpec("snow", "#fffafa"), new ColorSpec("springgreen", "#00ff7f"), new ColorSpec("steelblue", "#4682b4"), new ColorSpec("tan", "#d2b48c"), new ColorSpec("teal", "#008080"), new ColorSpec("thistle", "#d8bfd8"), new ColorSpec("tomato", "#ff6347"), new ColorSpec("turquoise", "#40e0d0"), new ColorSpec("violet", "#ee82ee"), new ColorSpec("wheat", "#f5deb3"), new ColorSpec("white", "#ffffff"), new ColorSpec("whitesmoke", "#f5f5f5"), new ColorSpec("yellow", "#ffff00"), new ColorSpec("yellowgreen", "#9acd32")));
        COLOR_NAMES.addAll(Arrays.asList("highlight-grey", "highlight-red", "highlight-green", "highlight-blue", "highlight-yellow", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "grey", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"));
    }

    public static class ColorSpec {
        public String name = "";
        public String hex = "";

        public ColorSpec(String name, String hex) {
            this.name = name;
            this.hex = hex;
        }
    }
}

