AJS.$(document).ready(function() {
	window.onbeforeunload = null;
	if(findGetParameter('q') != null) {
		AJS.$('#searchBox').val(findGetParameter('q'));
	}
	user_picker(AJS.$("#user-select"),true);
	group_picker(AJS.$("#group-select"),true);
	AJS.$("#ambassadorsTable tbody").html("<br /><br />").spin();
	fetchTable();
	AJS.$(document.body).on('keyup', '#searchBox', function (){
		AJS.$("#ambassadorsTable tbody").html('<br /><br />').spin();
        fetchTable();
    });
    AJS.dialog2("#browse-dialog").on("hide", function() {
    	AJS.$("#grpsTable tbody").html('');
        document.activeElement.blur();
    });
});

function pagination_show() {
	var total = 0;
	var per_page = 10;
	var currentPage = 1;
	if(findGetParameter('page')!=null) currentPage = parseInt(findGetParameter('page'));
	if(currentPage < 1) currentPage = 1;
	var q = (AJS.$('#searchBox').val().length > 0) ? "&query=" + prepare(AJS.$('#searchBox').val()) : "";
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/ambassadors/?countOnly=true" + q,
		dataType: 'text',
        success: function(data) {
			total = parseInt(data);
			if(total > per_page) {
				AJS.$("#GA_browse_pagination").html('');
				// Previous page
				if(currentPage>1) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-previous" style="cursor:pointer;" onclick="pagination(' + (currentPage - 1) + ')"><span>Previous &gt;&gt;</span></a>&nbsp;&nbsp;');
				}
				var maxPage = Math.ceil(total/per_page);
				if(Math.ceil(total/per_page) > 10) {
					for(i = 1; i < 4; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
					AJS.$("#GA_browse_pagination").append(' ... ');
					if(currentPage > 3 && currentPage < (maxPage - 3)) AJS.$("#GA_browse_pagination").append(i + ' ... ');
					for(i = (maxPage - 3); i < (maxPage + 1); i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				} else {
					for(i = 1; i < maxPage +1; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				}
				AJS.$("#GA_browse_pagination").append('&nbsp;&nbsp;');
				// Next page
				if(total-(currentPage*per_page)>0) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-next" style="cursor:pointer;" onclick="pagination(' + (currentPage + 1) + ')"><span>Next &gt;&gt;</span></a>');
				}
			} else {
				AJS.$("#GA_browse_pagination").html('');
			}
        } 
    });
}

function pagination(page) {
	var q = (AJS.$('#searchBox').val().length > 0) ? "&q=" + prepare(AJS.$('#searchBox').val()) : "";
	window.location.href="GroupAmbassadorsAdmin.jspa?page=" + page.toString() + q;
}

function fetchTable() {
	var page = "";
	var q = (AJS.$('#searchBox').val().length > 0) ? "&query=" + prepare(AJS.$('#searchBox').val()) : "";
	if(findGetParameter('page')!=null) page = "&page=" + findGetParameter('page');
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/ambassadors/?withGroups=true" + page + q,
        success: function(data) {
			if(data.length==0) {
				AJS.$.ajax({
					url: contextPath + "/rest/groupambassadors/1.0/ambassadors/?countOnly=true" + q,
					dataType: 'text',
					success: function(data) {
						var total = parseInt(data);
						if(parseInt(findGetParameter('page')) > 0) pagination(Math.ceil(total/10));
						else {
							AJS.$("#ambassadorsTable tbody").html(AJS.I18n.getText("group-ambassadors-admin-browse.no-results")).spinStop();
						}
					} 
				});
			}
			AJS.$("#ambassadorsTable tbody").html("").spinStop();
			data.forEach(function(a) {
			    var actions = (a.fullname == 'User not retrieved') ? "" : "<a onclick=\"displayManagedGroups('" + prepare(a.username) + "')\" style=\"cursor: pointer\"><span class=\"aui-icon aui-icon-small aui-iconfont-search\"></span>&nbsp;&nbsp;" + AJS.I18n.getText('group-ambassadors-admin-browse.view-managed-groups',a.groups.length) + "</a>";
				AJS.$("#ambassadorsTable tbody").append("<tr><td>" + a.fullname + "<br /><a href=\"mailto:" + a.email + "\">" + a.email + "</a></td><td>" + a.username + "</td><td>" + a.directory + "</td><td>" + actions + "</td></tr>");
			});
			AJS.$(".useless").attr('title',AJS.I18n.getText('group-ambassadors-admin-browse.tooltip-group-deleted')).tooltip();
        } 
    });
	pagination_show();
}

function displayManagedGroups(username) {
    AJS.$.ajax({
    	url: contextPath + "/rest/groupambassadors/1.0/ambassador/" + prepare(username) + "/groups",
    	dataType: 'json',
    	success: function(data) {
            data.forEach(function(g) {
                AJS.$("#grpsTable tbody").append("<tr><td id=\"grp_" + prepare(g.groupname) + "\">" + g.groupname + "</td><td><a style=\"cursor: pointer\" onclick=\"delRelationship('" + prepare(username) + "','" + prepare(g.groupname) + "'); return false;\">" + AJS.I18n.getText("group-ambassadors-admin-browse.remove-link") + "</a></td></tr>");
            });
    	}
    });
    AJS.$('#browse-dialog h2').html(AJS.I18n.getText("group-ambassadors-admin-browsedialog.title",username));
    AJS.dialog2('#browse-dialog').show();
}

function buildRelationships(groupload) {
	if(groupload===undefined) {
		var groupload = {"data": AJS.$("#group-select").select2('data'), "error":0, "success":0, "already":0, "error_text": "<ul>", "already_text": "<ul>", "success_text": "<ul>", "parsed": 0, "unlicensed": 0};
	}
	// Selection not empty
	if(groupload.data.length > 0) {
		// At least one element left
		if(groupload.data.length > groupload.parsed) {
			groupload.parsed++;
			usersToGroup(null,groupload);
		} else {
			groupload.success_text += "</ul>";
			groupload.error_text += "</ul>";
			groupload.already_text += "</ul>";
			AJS.$("#user-select").select2('data',null);
			AJS.$("#group-select").select2('data',null);
			if(groupload.error > 0) {
				createFlag("PARTIAL",groupload.error_text);
			} 
			if(groupload.already > 0) {
				createFlag("ALREADY",groupload.already_text);
			}
			if(groupload.unlicensed > 0) {
				createFlag("UNLICENSED");
			}
			if(groupload.success > 0) {
				createFlag("USER_ADDED",groupload.success_text);
			}
			AJS.$("#ambassadorsTable tbody").html('<br /><br />').spin();
			fetchTable();
		}
	}
}

function usersToGroup(load,groupload) {
	if(load===undefined || load == null) {
		var load = {"data": AJS.$("#user-select").select2('data'), "parsed": 0};
	}
	// Selection not empty
	if(load.data.length > 0) {
		// At least one element left
		if(load.data.length >= load.parsed) {
			load.parsed++;
			AJS.$.ajax({
				url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(groupload.data[groupload.parsed-1].name) + "/users?user=" + prepare(load.data[load.parsed-1].name),
				type: 'PUT',
				dataType: 'text',
				success: function(data) {
					if(data=='USER_ADDED') {
						groupload.success++;
						groupload.success_text += "<li>" + load.data[load.parsed-1].displayName + " <-> " + groupload.data[groupload.parsed-1].name + "</li>";
					}
					else {
						if(data=='ALREADY_AMBASSADOR') {
							groupload.already++;
							groupload.already_text += "<li>" + load.data[load.parsed-1].displayName + " <-> " + groupload.data[groupload.parsed-1].name + "</li>";
						} 
						else if(data=='NOT_LICENSED') {
							groupload.unlicensed++;
						}
						else {
							groupload.error++;
							groupload.error_text += "<li>" + load.data[load.parsed-1].displayName + " <-> " + groupload.data[groupload.parsed-1].name + "</li>";
						}
					}
					// Finished load for this group
					if(load.parsed >= load.data.length) {
						buildRelationships(groupload);
					} else {
						usersToGroup(load,groupload);
					}
				} 
			});
		}
	}
}

function delRelationship(encoded_username,encoded_group) {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + encoded_group + "/users?user=" + encoded_username,
		type: 'DELETE',
		dataType: 'text',
		success: function(data) {
			createFlag(data);
			if(data=="USER_REVOKED") {
				AJS.$("#ambassadorsTable tbody").html("<br /><br />").spin();
				if(AJS.$("td[id='grp_" + escapeSelector(encoded_group) + "']").length > 0) {
				    AJS.$("td[id='grp_" + escapeSelector(encoded_group) + "']").parent().remove();
				    if(AJS.$('#grpsTable tr').length <= 1) AJS.dialog2("#browse-dialog").hide();
				}
				fetchTable();
			}
		} 
	});
}

function createFlag(message,details) {
	var title = "";
	var body = "";
	var type = "info";
	var c = 'auto';
	switch(String(message)) {
		case "USER_ADDED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-body");
			type = 'success';
		break;
		case "USER_REVOKED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-body");
			type = 'success';
		break;
		case "PARTIAL":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-body") + details;
			type = 'error';
			c = 'manual';
		break;
		case "UNLICENSED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-body-unlicensed");
			type = 'error';
			c = 'manual';
		break;
		case "ALREADY":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.warning-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.warning-add-body-already-ambassador") + details;
			type = 'warning';
			c = 'manual';
		break;
		default:
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = "Unknown error";
			type = 'error';
		break;
	}
	var flag = AJS.flag({
		type: type,
		title: title,
		close: c,
		body: body
	});
}