AJS.$(document).ready(function() {
	document.activeElement.blur();	
	window.onbeforeunload=null;
	if(findGetParameter('page') != null && parseInt(findGetParameter('page')) < 1) pagination(1);
	AJS.$("#groupsTable tbody").html("<br /><br />").spin();
	if(findGetParameter('q') != null) {
		AJS.$('#searchBox').val(findGetParameter('q'));
	}

    if(window.document.documentMode) {
        AJS.$('#perpage').html("");
        var pp = (findGetParameter('perPage') != null) ? findGetParameter('perPage') : '10';
        var values = ['10','25','50','-1'];
        values.forEach(function(e) {
            var txt = (pp == e) ? ' selected="selected"' : '';
            var val = (e == "-1") ? 'All' : e;
            AJS.$('#perpage').append('<aui-option value="' + e + '"' + txt + '>' + val + '<aui-option>');
        });
	} else {
        if(findGetParameter('perPage') != null) {
            AJS.$('#perpage').val(findGetParameter('perPage'));
        } else {
            AJS.$('#perpage').val('10');
        }
    }

	fetchTable();
	user_picker(AJS.$("#nominate_keys"),true);
	user_picker(AJS.$("#ex_user"),false);
	AJS.$('#ex_user').on('change', function (e) {
		AJS.$('#grpsTable').show();
		AJS.$("#grpsTable tbody").html('<br /><br />').spin();
		browse_groups();
	});
	AJS.$('aui-select#perpage').on('change', function (e) {
    	fetchTable();
    });
	AJS.$("#cancelLink").click(function(e) {
		e.preventDefault();
		AJS.$("#nominate_keys").select2('data',null);
		AJS.$("#nominate_group").attr('value',"");
		AJS.dialog2("#nominate-dialog").hide();
	});
	AJS.$("#cancelLinkBrowse").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#browse-dialog").hide();
	});
	AJS.$("#dialog-submit-button").click(function (e) {
		e.preventDefault();
		addAmbassadors();
		AJS.dialog2("#nominate-dialog").hide();
	});
	AJS.dialog2("#membership-dialog").on("hide", function() {
		AJS.$('#explorer_name_placeholder').html('');
    	AJS.$('#grpsTable').hide();
    	AJS.$('#ex_s1').show();
    	AJS.$("#ex_user").select2('data',null);
    	document.activeElement.blur();
	});
	AJS.$(document.body).on('keyup', '#searchBox', function (){
		AJS.$("#ambassadorsTable tbody").html('<br /><br />').spin();
        fetchTable();
    });
    AJS.$('#grpsTable').hide();
    if(AJS.$("#explorer").length > 0) {
		AJS.$("#explorer").click(function(e) {
			AJS.dialog2("#membership-dialog").show();
			document.activeElement.blur();
		});
	}
});

function browse_groups() {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/ambassador/expGroups?user=" + prepare(AJS.$("#ex_user").select2('data').name),
		type: 'GET',
		success: function(data) {
			AJS.$('#explorer_name_placeholder').html(AJS.I18n.getText('group-ambassadors-user-explorer-success',AJS.$("#ex_user").select2('data').displayName + ' (' + AJS.$("#ex_user").select2('data').name + ')'));
			AJS.$("#grpsTable tbody").html("").spinStop();
			data.groups.forEach(function(a) {
				AJS.$("#grpsTable tbody").append("<tr><td>" + a.groupname + "</td></tr>");
			});
			if(data.groups.length < 1) {
				AJS.$('#grpsTable tbody').html(AJS.I18n.getText('group-ambassadors-user-browse.no-results'));
			}
		} 
	});
}

function nominate(group) {
	AJS.$("#nominate_group").attr('value',group);
	AJS.dialog2("#nominate-dialog").show();
}

function addAmbassadors(load) {
	if(load===undefined || load == null) {
		var load = {"data": AJS.$("#nominate_keys").select2('data'), "error":0, "success":0, "already":0, "error_text": "<ul>", "already_text": "<ul>", "parsed": 0, "unlicensed": 0};
	}
	// Selection not empty
	if(load.data.length > 0) {
		// At least one element left
		if(load.data.length >= load.parsed) {
			load.parsed++;
			AJS.$.ajax({
				url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(AJS.$("#nominate_group").attr('value')) + "/users?user=" + prepare(load.data[load.parsed-1].name),
				type: 'PUT',
				dataType: 'text',
				statusCode: {
					403: function() {
					  createFlag("","");
					}
				  },
				success: function(data) {
					if(data=='USER_ADDED') {
						load.success++;
					}
					else {
						if(data=='ALREADY_AMBASSADOR') {
							load.already++;
							load.already_text += "<li>" + load.data[load.parsed-1].name + " <-> " + AJS.$("#nominate_group").attr('value') + "</li>";
						} 
						else if(data=='NOT_LICENSED') {
							load.unlicensed++;
						}
						else {
							load.error++;
							load.error_text += "<li>" + load.data[load.parsed-1].name + " <-> " + AJS.$("#nominate_group").attr('value') + "</li>";
						}
					}
					// Finished load ?
					if(load.parsed < load.data.length) {
						addAmbassadors(load);
					} else {
						// Finished
						load.error_text += "</ul>";
						load.already_text += "</ul>";
						if(load.error > 0) {
							createFlag("PARTIAL",load.error_text);
						} 
						if(load.unlicensed > 0) {
							createFlag("UNLICENSED");
						}
						if(load.already > 0) {
							createFlag("ALREADY",load.already_text);
						}
						if(load.success > 0) {
							createFlag("USER_ADDED",load.success);
						}
						AJS.$("#nominate_keys").select2('data',null);
						AJS.$("#nominate_group").attr('value',"");
					}
				} 
			});
		}
	} else {
		AJS.$("#user-select").select2('data',null);
		AJS.$("#group-select").select2('data',null);
		AJS.$("#ambassadorsTable tbody").html('<br /><br />').spin();
		fetchTable();
	}
}

function browse_ambassadors(encoded_group) {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + encoded_group + "/users",
		type: 'GET',
		success: function(data) {
			AJS.$("#ambsTable tbody").html("");
			data.forEach(function(a) {
			    var actRevoke = (a.isRevokable) ? "<a style=\"cursor: pointer\" onclick=\"delRelationship('" + prepare(a.username) + "','" + prepare(encoded_group) + "'); return false;\">" + AJS.I18n.getText("group-ambassadors-admin-browse.remove-link") + "</a>" : "";
				AJS.$("#ambsTable tbody").append("<tr><td id=\"usr_" + prepare(a.username) + "\">" + a.fullname + "<br /><a href=\"mailto:" + a.email + "\">" + a.email + "</a></td><td>" + a.username + "</td><td>" + actRevoke + "</td></tr>");
			});
			AJS.dialog2("#browse-dialog").show();
		} 
	});
}

function delRelationship(encoded_username,encoded_group) {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + encoded_group + "/users?user=" + encoded_username,
		type: 'DELETE',
		dataType: 'text',
		success: function(data) {
			createFlag(data);
			if(data=="USER_REVOKED") {
				if(AJS.$("td[id='usr_" + escapeSelector(encoded_username) + "']").length > 0) {
				    AJS.$("td[id='usr_" + escapeSelector(encoded_username) + "']").parent().remove();
				    if(AJS.$('#ambsTable tr').length <= 1) AJS.dialog2("#browse-dialog").hide();
				}
			}
		},
		statusCode: {
		    403: function() {
		        createFlag(-1);
		    }
		}
	});
}

function fetchTable() {
	var q = (AJS.$('#searchBox').val().length > 0) ? "&query=" + encodeURIComponent(AJS.$('#searchBox').val()) : "";
	var perpage = (AJS.$('aui-select#perpage').val() != -1) ? AJS.$('aui-select#perpage').val() : Number.MAX_SAFE_INTEGER;
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/ambassador/myGroups?withRoles=true" + q,
        success: function(data) {
			AJS.$.ajax({
				url: contextPath + "/rest/groupambassadors/1.0/ambassador/myGroups?countOnly=true" + q,
				dataType: 'text',
				success: function(data) {
					var total = parseInt(data);
					if(total == 0) total++;
					if(findGetParameter('page') > Math.ceil(total/perpage)) pagination(Math.ceil(total/perpage));
				} 
			});
			AJS.$("#groupsTable tbody").html("").spinStop();
			var current = 0;
			var pageNum = (findGetParameter('page') != null) ? parseInt(findGetParameter('page')) : 1;
			data.managed.forEach(function(g) { 
				if(current >= ((pageNum-1) * perpage) && current < (pageNum*perpage)) {
					var privacy = (!g.browsable) ? "&nbsp;<span class=\"aui-icon aui-icon-small aui-iconfont-locked\"></span>&nbsp;" : "";
					var action = "";
					var lic = (g.licenseMessage) ? g.licenseMessage : "";
					if(g.canNominate) {
						action += " - <a onclick=\"nominate('" + prepare(g.groupname) + "')\" style=\"cursor: pointer\">" + AJS.I18n.getText('group-ambassadors-user-browse.actions-nominate') + "</a>";
					}
					var group_displayName = (lic.length > 0) ? "<b>" + g.groupname + "</b>" : g.groupname;
					AJS.$("#groupsTable tbody").append("<tr><td>" + group_displayName + lic + privacy + "&nbsp;<a onclick=\"browse_ambassadors('" + prepare(g.groupname) + "')\" style=\"cursor: pointer\"><span class=\"aui-icon aui-icon-small aui-iconfont-help\"></span></a></td><td style=\"text-align: right\"><a onclick=\"redirect('" + prepare(g.groupname) + "')\" style=\"cursor: pointer\">" + AJS.I18n.getText('group-ambassadors-user-browse.actions-manage') + "</a>" + action + "</td></tr>");
				}
				current++;
			});
			data.jira.forEach(function(g) {
				if(current >= ((pageNum-1) * perpage) && current < (pageNum*perpage)) {
					var privacy = (!g.browsable) ? "&nbsp;<span class=\"aui-icon aui-icon-small aui-iconfont-locked\"></span>" : "";
					var action = (g.browsable) ? "<a onclick=\"redirect('" + prepare(g.groupname) + "')\" style=\"cursor: pointer\">" + AJS.I18n.getText('group-ambassadors-user-browse.actions-view') + "</a>" : "<i>" + AJS.I18n.getText('group-ambassadors-user-browse.actions-restricted') + "</i>";
					AJS.$("#groupsTable tbody").append("<tr><td>" + g.groupname + privacy + "</small></td><td style=\"text-align: right\">" + action + "</td></tr>");
				}
				current++;
			});
			// User in no group should not happen
			if(current == 0) AJS.$("#groupsTable tbody").html(AJS.I18n.getText("group-ambassadors-user-browse.no-results"));
        } 
    });
	pagination_show();
}

function pagination(page) {
	var q = (AJS.$('#searchBox').val() && AJS.$('#searchBox').val().length > 0) ? "&q=" + encodeURIComponent(AJS.$('#searchBox').val()) : "";
	var pp = "&perPage=" + AJS.$('aui-select#perpage').val();
	window.location.href="home.action?page=" + page.toString() + q + pp;
}

function pagination_show() {
	var total = 0;
	var per_page = (AJS.$('aui-select#perpage').val() != -1) ? AJS.$('aui-select#perpage').val() : Number.MAX_SAFE_INTEGER;;
	var currentPage = 1;
	if(findGetParameter('page')!=null) currentPage = parseInt(findGetParameter('page'));
	if(currentPage < 1) currentPage = 1;
	var q = (AJS.$('#searchBox').val().length > 0) ? "&query=" + encodeURIComponent(AJS.$('#searchBox').val()) : ""; 
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/ambassador/myGroups?countOnly=true" +q,
		dataType: 'text',
        success: function(data) {
			total = parseInt(data);
			if(total > per_page) {
				AJS.$("#GA_browse_pagination").html('');
				// Previous page
				if(currentPage>1) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-previous" style="cursor:pointer;" onclick="pagination(' + (currentPage - 1) + ')"><span>Previous &gt;&gt;</span></a>&nbsp;&nbsp;');
				}
				var maxPage = Math.ceil(total/per_page);
				if(Math.ceil(total/per_page) > 10) {
					for(i = 1; i < 4; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
					AJS.$("#GA_browse_pagination").append(' ... ');
					if(currentPage > 3 && currentPage <= (maxPage - 3)) AJS.$("#GA_browse_pagination").append(currentPage + ' ... ');
					for(i = (maxPage - 2); i < (maxPage + 1); i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				} else {
					for(i = 1; i < maxPage +1; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				}
				AJS.$("#GA_browse_pagination").append('&nbsp;&nbsp;');
				// Next page
				if(total-(currentPage*per_page)>0) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-next" style="cursor:pointer;" onclick="pagination(' + (currentPage + 1) + ')"><span>Next &gt;&gt;</span></a>');
				}
			} else {
				AJS.$("#GA_browse_pagination").html('');
			}
        } 
    });
}

function redirect(encoded_group) {
	window.location.href="manage.action?groupName=" + encoded_group;
}

function usage(encoded_group) {
	window.location.href="usage.action?groupName=" + encoded_group;
}

function includes(array,value) {
	for(var elem in array) {
		if(array[elem] == value) return true;
	}
	return false;
}

function createFlag(message,details) {
	var title = "";
	var body = "";
	var type = "info";
	var c = 'auto';
	switch(String(message)) {
		case "USER_ADDED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-body");
			type = 'success';
		break;
		case "USER_REVOKED":
        	title = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-title");
        	body = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-body");
        	type = 'success';
        break;
		case "PARTIAL":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-body") + details;
			type = 'error';
			c = 'manual';
		break;
		case "UNLICENSED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-body-unlicensed");
			type = 'error';
			c = 'manual';
		break;
		case "ALREADY":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.warning-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.warning-add-body-already-ambassador") + details;
			type = 'warning';
			c = 'manual';
		break;
		default:
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = "Unknown error";
			type = 'error';
		break;
	}
	var flag = AJS.flag({
		type: type,
		title: title,
		close: c,
		body: body
	});
}