AJS.$(document).ready(function() {
	document.activeElement.blur();	
	window.onbeforeunload=null;
	user_picker(AJS.$("#user-select"),true);
	fetchTable();
});

function removeUser(user) {
	var group = "";
	if(findGetParameter('groupName')!=null) group = findGetParameter('groupName');
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/user?user=" + prepare(user),
		type: 'DELETE',
		dataType: 'text',
		success: function(data) {
			createFlag(data);
			if(data=="USER_REMOVED") {
				AJS.$("#usersTable tbody").html('<br /><br />').spin();
				fetchTable();
			}
		} 
	});
}

function pagination(page) {
	window.location.href="manage.action?groupName=" + prepare(findGetParameter('groupName')) + "&page=" + page.toString();
}

function getExport(type) {
    var content = "data:text/" + type + ";charset=utf-8,";
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(findGetParameter('groupName')) + "/user?getAll=true",
        success: function(data) {
            if(type == "csv") {
                content += + " " + AJS.I18n.getText("group-ambassadors-user-manage-download-export-headers") + "\r\n";
                data.forEach(function(u) {
                    content += [u.fullname,u.username,u.email,u.directory,u.lastLogin,u.directMember].join(',') + "\r\n";
                });
            }
            if(type == "html") {
                content += "<html><head><style>table.customTable { text-align: center; width: 80%;  border-collapse: collapse;  border-width: 2px;  border-style: solid;  margin:auto;}table.customTable td, table.customTable th {  border-width: 2px; border-style: solid;  padding: 5px;}</style></head><body><center><h1>Members of " + findGetParameter('groupName') + "</h1></center><table class=\"customTable\"><thead><tr><td>" + AJS.I18n.getText("group-ambassadors-admin-browse.fullname") + "</td><td>" + AJS.I18n.getText("group-ambassadors-admin-browse.name") + "</td><td>Email</td><td>" + AJS.I18n.getText("group-ambassadors-admin-browse.directory") + "</td><td>" + AJS.I18n.getText("group-ambassadors-admin-browse.lastLogin") + "</td><td>" + AJS.I18n.getText("group-ambassadors-admin-browse.directMember") + "</td></tr></thead><tbody>";
                data.forEach(function(u) {
                    content += "<tr><td>" + u.fullname + "</td><td>" + u.username + "</td><td>" + u.email + "</td><td>" + u.directory + "</td><td>" + u.lastLogin + "</td><td>" + ((u.directMember) ? "Yes" : "No") + "</td></tr>";
                });
                content += "</tbody></table><br /><br /><center><small>Generated on 2019-09-18</small></center></body></html>";
            }
            var encodedUri = encodeURI(content);
            var link = document.createElement("a");
            link.setAttribute("href", encodedUri);
            link.setAttribute("download", "GroupAmbassadors_Export_" + new Date().toLocaleDateString() + "." + type);
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    });
}

function fetchTable() {
	var page = "";
	var group = "";
	if(findGetParameter('groupName')!=null) group = findGetParameter('groupName');
	else {
		window.location.href="home.action";
	}
	if(findGetParameter('page')!=null) page = "?page=" + findGetParameter('page');
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/user" + page,
		statusCode: {
			403: function() {
				AJS.$("#usersTable tbody").html(AJS.I18n.getText("group-ambassadors-user-browse.actions-restricted")).spinStop();
				AJS.$('#csvButton').attr('aria-disabled','true');
			}
		},
        success: function(data) {
			if(data.length==0) {
				AJS.$.ajax({
					url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/user?countOnly=true",
					dataType: 'text',
					success: function(data) {
						var total = parseInt(data);
						if(findGetParameter('page') > 0) pagination(Math.ceil(total/25));
						else {
							AJS.$("#usersTable tbody").html(AJS.I18n.getText("group-ambassadors-user-manage-browse.no-results")).spinStop();
                            AJS.$('#csvButton').attr('aria-disabled','true');
						}
					} 
				});
			}
			AJS.$("#usersTable tbody").html("").spinStop();
			data.forEach(function(u) {
				var actions = "";
				var indirectflag = "";
				// If Ambassador (checked by Java and REST API in case of injection
				if(AJS.$("input[id=user-select]").length > 0) {
					if(!(u.directMember)) {
						actions += AJS.I18n.getText("group-ambassadors-user-manage-browse.action-remove-indirect");
					}
					else {
						actions += "<a style=\"cursor: pointer\" onclick=\"removeUser('" + prepare(u.apiUsername) + "')\">" + AJS.I18n.getText("group-ambassadors-user-manage-browse.action-remove") + "</a>";
					}
				} else {
					actions += AJS.I18n.getText("group-ambassadors-user-manage-browse.action-none");
				}
				if(!(u.directMember)) indirectflag = "&nbsp;&nbsp;<span class=\"aui-icon aui-icon-small aui-iconfont-devtools-submodule\" title=\"" + AJS.I18n.getText("group-ambassadors-user-manage-browse.tooltip-indirect") + "\"></span>";
				var user_groups = (AJS.$('meta[name=ga-user-groups-setting]').length > 0) ? "&nbsp;<a onclick=\"browse_groups('" + prepare(u.apiUsername) + "')\" style=\"cursor: pointer\"><span class=\"aui-icon aui-icon-small aui-iconfont-group\"></span></a>" : "";
				AJS.$("#usersTable tbody").append("<tr><td>" + u.fullname + indirectflag + user_groups + "<br /><a href=\"mailto:" + u.email + "\">" + u.email + "</a></td><td>" + u.username + "</td><td>" + u.directory + "</td><td>" + u.lastLogin + "</td><td>" + actions + "</td></tr>");
			});
			AJS.$(".aui-iconfont-devtools-submodule").tooltip();
			AJS.$('#csvButton').attr('aria-disabled','false');
        } 
    });
	pagination_show();
}

function browse_groups(user) {
	AJS.$.ajax({
		url: contextPath + "/rest/api/2/user?username=" + user + "&expand=groups",
		type: 'GET',
		success: function(data) {
			AJS.$("#grpsTable tbody").html("");
			data.groups.items.forEach(function(a) {
				AJS.$("#grpsTable tbody").append("<tr><td>" + a.name + "</td></tr>");
			});
			AJS.dialog2("#browse-dialog").show();
		} 
	});
}

function pagination_show() {
	var total = 0;
	var per_page = 25;
	var currentPage = 1;
	if(findGetParameter('page')!=null) currentPage = parseInt(findGetParameter('page'));
	if(currentPage < 1) currentPage = 1;
	var group = "";
	if(findGetParameter('groupName')!=null) group = findGetParameter('groupName');
	else {
		window.location.href="home.action";
	}
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/user?countOnly=true",
		dataType: 'text',
        success: function(data) {
			total = parseInt(data);
			if(total > per_page) {
				AJS.$("#GA_browse_pagination").html('');
				// Previous page
				if(currentPage>1) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-previous" style="cursor:pointer;" onclick="pagination(' + (currentPage - 1) + ')"><span>Previous &gt;&gt;</span></a>&nbsp;&nbsp;');
				}
				var maxPage = Math.ceil(total/per_page);
				if(Math.ceil(total/per_page) > 10) {
					for(i = 1; i < 4; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
					AJS.$("#GA_browse_pagination").append(' ... ');
					if(currentPage > 3 && currentPage < (maxPage - 2)) AJS.$("#GA_browse_pagination").append(currentPage + ' ... ');
					for(i = (maxPage - 2); i < (maxPage + 1); i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				} else {
					for(i = 1; i < maxPage +1; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				}
				AJS.$("#GA_browse_pagination").append('&nbsp;&nbsp;');
				// Next page
				if(total-(currentPage*per_page)>0) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-next" style="cursor:pointer;" onclick="pagination(' + (currentPage + 1) + ')"><span>Next &gt;&gt;</span></a>');
				}
			}
        } 
    });
}

function addUsers(load) {
	var group = "";
	if(findGetParameter('groupName')!=null) group = findGetParameter('groupName');
	if(load===undefined) {
		var load = {"data": AJS.$("#user-select").select2('data'), "error":0, "success":0, "already":0, "already_text": "<ul>", "error_text": "<ul>", "success_text": "<ul>", "parsed": 0};
	}
	// Selection not empty
	if(load.data.length > 0) {
		// At least one element left
		if(load.data.length >= load.parsed) {
			load.parsed++;
			AJS.$.ajax({
				url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/user?user=" + prepare(load.data[load.parsed-1].name),
				type: 'PUT',
				dataType: 'text',
				success: function(data) {
					if(data=='USER_ADDED') {
						load.success++;
						load.success_text += "<li>" + load.data[load.parsed-1].displayName + "</li>";
					}
					else {
						if(data=='ALREADY_MEMBER') {
							load.already++;
							load.already_text += "<li>" + load.data[load.parsed-1].displayName + "</li>";
						} else {
							load.error++;
							load.error_text += "<li>" + load.data[load.parsed-1].displayName + "</li>";
						}
					}
					if(AJS.$("#user-select").select2('data') != null) AJS.$("#user-select").select2('data',null);
					// Finished load
					if(load.parsed == load.data.length) {
						load.success_text += "</ul>";
						load.error_text += "</ul>";
						load.already_text += "</ul>";
						AJS.$("#user-select").val(null).trigger('change');
						if(load.error > 0) {
							createFlag("PARTIAL",load.error_text);
						} 
						if(load.success > 0) {
							createFlag("USER_ADDED",load.success_text);
						}
						if(load.already > 0) {
							createFlag("ALREADY",load.already_text);
						}
						AJS.$("#usersTable tbody").html('<br /><br />').spin();
						fetchTable();
					} else {
						addUsers(load);
					}
				} 
			});
		}
	}
}

function createFlag(message,details) {
	var title = "";
	var body = "";
	var type = "info";
	var c = 'auto';
	switch(String(message)) {
		case "USER_REMOVED":
			title = AJS.I18n.getText("group-ambassadors-user-manage-flag.success-remove-title");
			body = AJS.I18n.getText("group-ambassadors-user-manage-flag.success-remove-body");
			type = 'success';
		break;
		case "USER_ADDED":
			title = AJS.I18n.getText("group-ambassadors-user-manage-flag.success-add-title");
			body = AJS.I18n.getText("group-ambassadors-user-manage-flag.success-add-body") + details;
			type = 'success';
		break;
		case "PARTIAL":
			title = AJS.I18n.getText("group-ambassadors-user-manage-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-user-manage-flag.error-add-body") + details;
			type = 'error';
			c = 'manual';
		break;
		case "ALREADY":
			title = AJS.I18n.getText("group-ambassadors-user-manage-flag.warn-add-title");
			body = AJS.I18n.getText("group-ambassadors-user-manage-flag.warn-add-body") + details;
			type = 'warning';
			c = 'manual';
		break;
		default:
			title = AJS.I18n.getText("group-ambassadors-user-manage-flag.error-title");
			body = AJS.I18n.getText("group-ambassadors-user-manage-flag.error-body",message);
			type= 'error';
		break;
	}
	var flag = AJS.flag({
		type: type,
		title: title,
		close: c,
		body: body
	});
}