AJS.$(document).ready(function() {
	window.onbeforeunload = null;
	document.activeElement.blur();
	group_picker(AJS.$("#group-select"),false);
	user_picker(AJS.$("#user-select"),false);
	user_picker(AJS.$("#user-select-revoke"),false);
	AJS.$("#cancelLinkBrowse").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#browse-dialog").hide();
	});
});

function browse_ambassadors() {
	if(AJS.$("#group-select").select2('data') == null) return;
	var groupname = AJS.$("#group-select").select2('data').name;
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(groupname) + "/users",
		type: 'GET',
		success: function(data) {
			if(data.length == 0) {
				AJS.$("#emptyCaption").css("visibility","visible");
			} else {
			    AJS.$("#emptyCaption").css("visibility","hidden");
				AJS.$("#ambsTable tbody").html("");
				data.forEach(function(a) {
					AJS.$("#ambsTable tbody").append("<tr id=\"amb_" + prepare(a.username) + "\"><td>" + a.fullname + "<br /><a href=\"mailto:" + a.email + "\">" + a.email + "</a></td><td>" + a.username + "</td><td><a style=\"cursor: pointer\" onclick=\"delRelationship('" + prepare(a.username) + "','" + prepare(groupname) + "'); return false;\">" + AJS.I18n.getText("group-ambassadors-admin-browse.remove-link") + "</a></td></tr>");
				});
				AJS.dialog2("#browse-dialog").show();
				AJS.$("#group-select").select2('data',null)
			}
		} 
	});
}

function delRelationship(username,group) {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/users?user=" + prepare(username),
		type: 'DELETE',
		dataType: 'text',
		success: function(data) {
			createFlag(data);
			if(data=="USER_REVOKED") {
				if(AJS.$('#amb_' + escapeSelector(prepare(username))).length > 0) {
				    AJS.$('#amb_' + escapeSelector(prepare(username))).remove();
				    if(AJS.$('#ambsTable tr').length <= 1) AJS.dialog2("#browse-dialog").hide();
				}
			}
		}
	});
}

function createFlag(message,details) {
	var title = "";
	var body = "";
	var type = "info";
	var c = 'auto';
	switch(String(message)) {
		case "CLEARED_ALL":
            title = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title");
            body = AJS.I18n.getText("group-ambassadors-admin-flag.success-clear-all-body");
            type = 'success';
        break;
		case "USER_ADDED_ALL":
            title = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title");
            body = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-all-body");
            type = 'success';
        break;
        case "USER_REVOKED":
            title = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-title");
            body = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-body");
            type = 'success';
        break;
        case "USER_REVOKED_ALL":
            title = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-title");
            body = AJS.I18n.getText("group-ambassadors-admin-flag.success-revoke-body");
            type = 'success';
        break;
		case "PARTIAL_ALL":
        	title = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title");
        	body = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-all-partial-body");
        	type = 'success';
        break;
		case "UNLICENSED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-body-unlicensed");
			type = 'error';
			c = 'manual';
		break;
		default:
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = "Unknown error";
			type = 'error';
		break;
	}
	var flag = AJS.flag({
		type: type,
		title: title,
		close: c,
		body: body
	});
}

function addToAll() {
    if(AJS.$("#user-select").select2('data') == null) return;
    AJS.$('#button_addall').attr('disabled',true);
    var username = AJS.$("#user-select").select2('data').name;
    AJS.$.ajax({
    	url: contextPath + "/rest/groupambassadors/1.0/groups/ALL/user?user=" + prepare(username),
    	type: 'PUT',
    	dataType: 'text',
    	success: function(data) {
    	    AJS.dialog2("#confirm-dialog").hide();
    		createFlag(data);
    		AJS.$("#user-select").select2('data',null);
    		AJS.$('#button_addall').attr('disabled',false);
    	}
    });
}

function removeFromAll() {
    if(AJS.$("#user-select-revoke").select2('data') == null) return;
    var username = AJS.$("#user-select-revoke").select2('data').name;
    AJS.$.ajax({
    	url: contextPath + "/rest/groupambassadors/1.0/groups/ALL/user?user=" + prepare(username),
    	type: 'DELETE',
    	dataType: 'text',
    	success: function(data) {
    		createFlag(data);
    		AJS.$("#user-select-revoke").select2('data',null)
    	}
    });
}

function clearAll() {
    AJS.$("#noclearCaption").css("visibility","hidden");
    AJS.$.ajax({
    	url: contextPath + "/rest/groupambassadors/1.0/cleanup/clean/",
    	type: 'DELETE',
    	dataType: 'text',
    	success: function(data) {
            if(data.startsWith("CLEARED_")) {
                createFlag(data);
            }
            else
                AJS.$("#noclearCaption").css("visibility","visible");
        }
    });
}

function interactive_clear() {
    AJS.$("#noclearCaption").css("visibility","hidden");
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/cleanup/ambassadors",
		type: 'GET',
		success: function(data) {
			if(data.length == 0) {
				AJS.$("#noclearCaption").css("visibility","visible");
			} else {
				AJS.$("#aTable tbody").html("");
				data.forEach(function(a) {
					AJS.$("#aTable tbody").append("<tr><td><input type=\"checkbox\" /></td><td>" + a.username + "</td></tr>");
				});
				AJS.dialog2("#clear-dialog").show();
			}
		}
	});
}

function clearValidate() {
    var t = [];
    AJS.$('#aTable tr').filter(':has(:checkbox:checked)').find('td:last').each(function(){
        t.push($(this).html());
    });
    AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/cleanup/clean/interactive?aList=" + t.join(),
        type: 'DELETE',
        dataType: 'text',
        success: function(data) {
        	if(data.startsWith("CLEARED_"))
        	    var flag = AJS.flag({
                		type: 'success',
                		title: AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title"),
                		close: 'auto',
                		body: AJS.I18n.getText("group-ambassadors-admin-flag.success-clear-body",data.substr(-(data.length - "CLEARED_".length)))
                	});
        	else
        	    createFlag(data);
        	AJS.dialog2("#clear-dialog").hide();
        }
    });
}

function showConfirm() {
    if(AJS.$("#user-select").select2('data') == null) return;
    AJS.dialog2("#confirm-dialog").show();
}