String.prototype.replaceAll = function(search, replacement) {
    var target = this;
    return target.replace(new RegExp(search, 'g'), replacement);
};

function user_picker(element,multiple) {
	return element.auiSelect2({
        hasAvatar: true, 
        multiple: multiple,
        ajax: {
            url: contextPath + "/rest/groupambassadors/1.0/user/picker",
            type: "GET",
			//data: 'json',
            dataType: 'json',
            cache: true,
            data: function data(term) {
                return {
                    query: term,
                    maxResults: 1000,
                    showAvatar: true
                };
            },
            results: function results(data) {
                var i, dataLength;
                return {
                    results: data.users
                };
            }
        },
        id: function id(user) {
            return user.name;
        },
        formatSelection: function formatSelection(user) {
            var avatarHtml = aui.avatar.avatar({
                size: 'xsmall',
                avatarImageUrl: user.avatarUrl
            });
            return avatarHtml + Select2.util.escapeMarkup(user.displayName);
        },
        formatResult: function formatResult(user, container, query, escapeMarkup) {
            var avatarHtml = aui.avatar.avatar({
                size: 'small',
                avatarImageUrl: user.avatarUrl
            });
            return avatarHtml + user.html;
        },
        formatNoMatches: function formatNoMatches(query) {
            return AJS.I18n.getText("group-ambassadors-global-no-results-pickers");
        }
    });
}

function group_picker(element,multiple) {
	return element.auiSelect2({
        multiple: multiple,
        ajax: {
            url: contextPath + "/rest/groupambassadors/1.0/groups/picker",
            type: "GET",
			//data: 'json',
            dataType: 'json',
            cache: true,
            data: function data(term) {
                return {
                    query: term,
                    maxResults: 100
                };
            },
            results: function results(data) {
                var i, dataLength;
                return {
                    results: data.groups
                };
            }
        },
        id: function id(group) {
            return group.name;
        },
        formatSelection: function formatSelection(group) {
            return group.name;
        },
        formatResult: function formatResult(group, container, query, escapeMarkup) {
            return group.html;
        },
        formatNoMatches: function formatNoMatches(query) {
            return "No matches found";
        }
    });
}

var escapeSelector = function(sel) { // $.escapeSelector()
    var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g;
    var fcssescape = function(ch, asCodePoint) {
        if (asCodePoint) {
            // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
            if (ch === "\0") {
                return "\uFFFD";
            }
            // Control characters and (dependent upon position) numbers get escaped as code points
            return ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " ";
        }
        // Other potentially-special ASCII characters get backslash-escaped
        return "\\" + ch;
    };

    return (sel + '').replace(rcssescape, fcssescape);
};

function prepare(string) {
    return encodeURIComponent(string).replaceAll("%2F","___").replaceAll("%5C","@@@").replaceAll("'","_-_-");
}

function unprep(string) {
    return decodeURIComponent(string.replaceAll("___", "%2F").replaceAll("@@@", "%5C").replaceAll("_-_-","'"));
}


function findGetParameter(parameterName) {
    var result = null,
        tmp = [];
    var items = location.search.substr(1).split("&");
    for (var index = 0; index < items.length; index++) {
        tmp = items[index].split("=");
        if (tmp[0] === parameterName) result = decodeURIComponent(tmp[1]);
    }
    return result;
}
