AJS.$(document).ready(function() {
	window.onbeforeunload = null;
	toggle();
	group_picker(AJS.$("#group-select"),true);
	group_picker(AJS.$("#group-select-restrict"),true);
	user_picker(AJS.$("#user-select-restrict"),true);
	AJS.$("#policy-type").auiSelect2();
	AJS.$("#policiesTable tbody").html("<br /><br />").spin();
	AJS.$("#policy-type").change(function() { 
		toggle();
	});
	AJS.$("#all_groups").change(function() {
    	if(AJS.$("#all_groups").prop("checked") == true) {
    	    AJS.$("#group-select").select2('data',null);
    	}
    });
    AJS.$("#group-select").change(function() {
        if(AJS.$("#all_groups").prop("checked") == true) {
            AJS.$("#all_groups").prop("checked", false);
        }
    });
	if(AJS.$(".aui-lozenge-error:visible").length == 1) disabled();
	fetchTable();
});

function toggle() {
	if(AJS.$("#policy-type option:selected").attr('id') == 'RESTRICT') {
		AJS.$("#restrict_subform").show();
		AJS.$("#regularButton").hide();
	} else {
		AJS.$("#restrict_subform").hide();
		AJS.$("#regularButton").show();
	}
}

function disabled() {
	AJS.$("#regularButton").attr('disabled','disabled');
	AJS.$("#policy-type").attr('disabled','disabled');
}

function pagination_show() {
	var total = 0;
	var per_page = 15;
	var currentPage = 1;
	if(findGetParameter('page')!=null) currentPage = parseInt(findGetParameter('page'));
	if(currentPage < 1) currentPage = 1;
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/policies/?countOnly=true",
		dataType: 'text',
        success: function(data) {
			total = parseInt(data);
			if(total > per_page) {
				AJS.$("#GA_browse_pagination").html('');
				// Previous page
				if(currentPage>1) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-previous" style="cursor:pointer;" onclick="pagination(' + (currentPage - 1) + ')"><span>Previous &gt;&gt;</span></a>&nbsp;&nbsp;');
				}
				var maxPage = Math.ceil(total/per_page);
				if(Math.ceil(total/per_page) > 10) {
					for(i = 1; i < 4; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
					AJS.$("#GA_browse_pagination").append(' ... ');
					if(currentPage > 3 && currentPage < (maxPage - 3)) AJS.$("#GA_browse_pagination").append(currentPage + ' ... ');
					for(i = (maxPage - 2); i < (maxPage + 1); i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				} else {
					for(i = 1; i < maxPage +1; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				}
				AJS.$("#GA_browse_pagination").append('&nbsp;&nbsp;');
				// Next page
				if(total-(currentPage*per_page)>0) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-next" style="cursor:pointer;" onclick="pagination(' + (currentPage + 1) + ')"><span>Next &gt;&gt;</span></a>');
				}
			}
        } 
    });
}

function pagination(page) {
	window.location.href="GroupAmbassadorsPolicies.jspa?page=" + page.toString();
}

function fetchTable() {
	var page = (findGetParameter('page')!=null) ? "?page=" + findGetParameter('page') : "?page=1";
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/policies/" + page,
        success: function(data) {
			if(data.length==0) {
				AJS.$.ajax({
					url: contextPath + "/rest/groupambassadors/1.0/policies/?countOnly=true",
					dataType: 'text',
					success: function(data) {
						var total = parseInt(data);
						if(parseInt(findGetParameter('page')) > 0) pagination(Math.ceil(total/15));
						else {
							AJS.$("#policiesTable tbody").html(AJS.I18n.getText("group-ambassadors-admin-logs-filter.filter-noresult")).spinStop();
						}
					} 
				});
			}
			AJS.$("#policiesTable tbody").html("").spinStop();
			data.forEach(function(policy) {
				var evt = "";
				var params = "<ul style=\"list-style-type: none;\">";
				var gname = policy.group;
				if(gname == "*_ALLGROUPS_*") gname = AJS.I18n.getText("group-ambassadors-admin-policies.all-groups");
				switch(policy.policy) {
					case "DENY":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-devtools-task-disabled\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-policies-browse.policy-deny");
						params = AJS.I18n.getText("group-ambassadors-admin-policies-browse.parameter-global") + "&nbsp;&nbsp;&nbsp;<a onclick=\"delPolicy('" + policy.policy + "','" + prepare(policy.group) + "')\" style=\"cursor: pointer\"><span class=\"aui-icon aui-icon-small aui-iconfont-delete\"></span></a>";
					break;
					case "RESTRICT":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-watch\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-policies-browse.policy-restrict");
						for(var idx in policy.entities.GROUP) {
							params += "<li><span class=\"aui-icon aui-icon-small aui-iconfont-group\"></span>&nbsp;&nbsp;" + policy.entities.GROUP[idx] + "&nbsp;&nbsp;&nbsp;<a onclick=\"delPolicy('" + policy.policy + "','" + prepare(policy.group) + "','GROUP','" + prepare(policy.entities.GROUP[idx]) + "')\" style=\"cursor: pointer\"><span class=\"aui-icon aui-icon-small aui-iconfont-delete\"></span></a></li>";
						}
						for(var idx in policy.entities.USER) {
							params += "<li><span class=\"aui-icon aui-icon-small aui-iconfont-user\"></span>&nbsp;&nbsp;" + policy.entities.USER[idx] + "&nbsp;&nbsp;&nbsp;<a onclick=\"delPolicy('" + policy.policy + "','" + prepare(policy.group) + "','USER','" + prepare(policy.entities.USER[idx]) + "')\" style=\"cursor: pointer\"><span class=\"aui-icon aui-icon-small aui-iconfont-delete\"></span></a></li>";
						}
					break;
					default:
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-warning\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-error");
					break;
				}
				params += "</ul>";
				AJS.$("#policiesTable tbody").append("<tr><td>" + gname + "</td><td>" + evt + "</td><td>" + params + "</td></tr>");
			});
        } 
    });
	pagination_show();
}

function delPolicy(policy,group,policy_entity_type,policy_entity_value) {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(group) + "/policy?policy=" + policy + "&policy_entity_type=" + policy_entity_type + "&policy_entity_value=" + prepare(policy_entity_value),
		type: 'DELETE',
		dataType: 'text',
		success: function(data) {
			if(data=='POLICY_REMOVED') {
				createFlag("POLICY_REMOVED");
				AJS.$("#policiesTable tbody").html('<br /><br />').spin();
				fetchTable();
			}
		} 
	});
}

function addPolicy() {
	var groups = AJS.$("#group-select").select2('data');
	if(AJS.$("#all_groups").prop("checked") == true) {
	    groups = [{"name":"*_ALLGROUPS_*"}];
	}
	var policy = AJS.$("#policy-type").select2('data');
	var warn = "<ul>";
	var fail = "<ul>";
	var failcount = 0;
	var warncount = 0;
	var successcount = 0;
	if(!(policy == null || groups == null || groups.length == 0 || policy.length == 0)) {
		groups.forEach(function add(g,index) {
			AJS.$.ajax({
				url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(g.name) + "/policy?policy=DENY",
				type: 'PUT',
				dataType: 'text',
				success: function(data) {
					if(data=='POLICY_ADDED') {
						successcount++;
					} else if(data == 'POLICY_ALREADY_EXISTS') {
						warn += "<li>" + g.name + "</li>";
						warncount++;
					} else {
						fail += "<li>" + g.name + "</li>";
						failcount++;
					}
					if(index == (groups.length - 1)) {
						warn += "</ul>";
						fail += "</ul>";
						if(successcount > 0) createFlag("POLICY_ADDED");
						if(warncount > 0) createFlag("POLICY_ALREADY_EXISTS",warn);
						if(failcount > 0) createFlag("POLICY_FAILED",fail);
						AJS.$("#group-select").select2('data',null);
						AJS.$("#policiesTable tbody").html('<br /><br />').spin();
						fetchTable();
					}
				} 
			});
		});
	}
}

function policiesUpdate(index,total,warn,fail,warncount,failcount,successcount) {
	var groups = AJS.$("#group-select").select2('data');
	if(AJS.$("#all_groups").prop("checked") == true) {
        groups = [{"name":"*_ALLGROUPS_*"}];
    }
	if(index == (groups.length - 1) && (successcount + warncount + failcount) >= total) {
		warn += "</ul>";
		fail += "</ul>";
		if(successcount > 0) createFlag("POLICY_ADDED");
		if(warncount > 0) createFlag("POLICY_ALREADY_EXISTS",warn);
		if(failcount > 0) createFlag("POLICY_FAILED",fail);
		AJS.$("#group-select").select2('data',null);
		AJS.$("#group-select-restrict").select2('data',null);
		AJS.$("#user-select-restrict").select2('data',null);
		AJS.$("#policiesTable tbody").html('<br /><br />').spin();
		fetchTable();
	}
}

function process(g,groups,users,index,type,idx,total,warn,fail,warncount,failcount,successcount) {
	var entity = "";
	if(type == 'GROUP') {
		if(groups != null && groups.length >= (index + 1)) {
			entity = groups[index].name;
		} else {
			process(g,groups,users,0,'USER',idx,total,warn,fail,warncount,failcount,successcount);
		}
	}
	if(type == 'USER' && users != null && users.length > 0 && users.length >= (index + 1)) {
		entity = users[index].key;
	}
	if(entity != "") {
		AJS.$.ajax({
			url: contextPath + "/rest/groupambassadors/1.0/group/" + prepare(g.name) + "/policy?policy=RESTRICT&policy_entity_type=" + type + "&policy_entity_value=" + prepare(entity),
			type: 'PUT',
			dataType: 'text',
			success: function(data) {
				if(data=='POLICY_ADDED') {
					successcount++;
				} else if(data == 'POLICY_ALREADY_EXISTS') {
					warn += "<li>" + g.name + " -> " + entity + "</li>";
					warncount++;
				} else {
					fail += "<li>" + g.name + " -> " + entity+ "</li>";
					failcount++;
				}
				policiesUpdate(idx,total,warn,fail,warncount,failcount,successcount);
				if(type == 'GROUP') {
					if(groups.length > (index + 1))	process(g,groups,users,index+1,type,idx,total,warn,fail,warncount,failcount,successcount);
					else process(g,groups,users,0,'USER',idx,total,warn,fail,warncount,failcount,successcount);
				}
				if(type=='USER' && users.length > (index+1)) process(g,groups,users,index+1,type,idx,total,warn,fail,warncount,failcount,successcount);
			} 
		});
	}
}

function addPolicies() {
	var groups = AJS.$("#group-select").select2('data');
	if(AJS.$("#all_groups").prop("checked") == true) {
    	groups = [{"name":"*_ALLGROUPS_*"}];
    }
	var policy = AJS.$("#policy-type").select2('data');
	var groups_restrict = AJS.$("#group-select-restrict").select2('data');
	var users_restrict = AJS.$("#user-select-restrict").select2('data');
	var warn = "<ul>";
	var fail = "<ul>";
	var failcount = 0;
	var warncount = 0;
	var successcount = 0;
	var total = groups_restrict.length + users_restrict.length;
	if(((groups_restrict != null && groups_restrict.length > 0) || (users_restrict != null && users_restrict.length > 0)) && !(policy == null || groups == null || groups.length == 0 || policy.length == 0)) {
		groups.forEach(function add(g,index) {
			process(g,groups_restrict,users_restrict,0,'GROUP',index,total,warn,fail,warncount,failcount,successcount);
		});
	}
}

function createFlag(message,details) {
	var title = "";
	var body = "";
	var type = "info";
	var c = 'auto';
	switch(String(message)) {
		case "POLICY_ADDED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.success-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-policies-flag.success-body");
			type = 'success';
		break;
		case "POLICY_ALREADY_EXISTS":
			title = AJS.I18n.getText("group-ambassadors-admin-policies-flag.warning-title");
			body = AJS.I18n.getText("group-ambassadors-admin-policies-flag.warning-body") + details;
			type = 'warning';
		break;
		case "POLICY_FAILED":
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = AJS.I18n.getText("group-ambassadors-admin-policies-flag.fail-body") + details;
			type = 'error';
			c = 'manual';
		break;
		case "POLICY_REMOVED":
			title = AJS.I18n.getText("group-ambassadors-admin-policies-flag.success-remove-title");
			body = AJS.I18n.getText("group-ambassadors-admin-policies-flag.success-remove-body");
			type = 'success';
		break;
		default:
			title = AJS.I18n.getText("group-ambassadors-admin-flag.error-add-title");
			body = "Unknown error";
			type = 'error';
		break;
	}
	var flag = AJS.flag({
		type: type,
		title: title,
		close: c,
		body: body
	});
}