AJS.$(document).ready(function() {
	window.onbeforeunload = null;
	AJS.$("#logsTable tbody").html("<br /><br />").spin();
	user_picker(AJS.$("#user-select"),false);
	group_picker(AJS.$("#group-select"),false);
	if(findGetParameter('ambassador') != null) {
		AJS.$.ajax({
			url: contextPath + "/rest/api/2/user/?key=" + unprep(findGetParameter('ambassador')),
			type: "GET",
			//data: 'json',
			dataType: 'json',
			success: function(user) {
				user.avatarUrl = user.avatarUrls['16x16'];
				AJS.$("#user-select").select2("data",user);
				AJS.$("#user-select").trigger('change');
			} 
		});
	}
	if(findGetParameter('group') != null) {
		AJS.$.ajax({
			url: contextPath + "/rest/api/2/group/?groupname=" + unprep(findGetParameter('group')),
			type: "GET",
			//data: 'json',
			dataType: 'json',
			success: function(group) {
				AJS.$("#group-select").select2("data",group);
				AJS.$("#group-select").trigger('change');
			} 
		});
	}
	fetchTable();
});

function resetFilters() {
	AJS.$("#user-select").select2('data',null);
	AJS.$("#group-select").select2('data',null);
	window.location.href="GroupAmbassadorsLogs.jspa";
}

function pagination_show() {
	var total = 0;
	var per_page = 15;
	var currentPage = 1;
	var criteria = getCriteria();
	if(findGetParameter('page')!=null) currentPage = parseInt(findGetParameter('page'));
	if(currentPage < 1) currentPage = 1;
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/logs/?countOnly=true" + criteria,
		dataType: 'text',
        success: function(data) {
			total = parseInt(data);
			if(total > per_page) {
				AJS.$("#GA_browse_pagination").html('');
				// Previous page
				if(currentPage>1) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-previous" style="cursor:pointer;" onclick="pagination(' + (currentPage - 1) + ')"><span>Previous &gt;&gt;</span></a>&nbsp;&nbsp;');
				}
				var maxPage = Math.ceil(total/per_page);
				if(Math.ceil(total/per_page) > 10) {
					for(i = 1; i < 4; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
					AJS.$("#GA_browse_pagination").append(' ... ');
					if(currentPage > 3 && currentPage < (maxPage - 3)) AJS.$("#GA_browse_pagination").append(currentPage + ' ... ');
					for(i = (maxPage - 2); i < (maxPage + 1); i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				} else {
					for(i = 1; i < maxPage +1; i++) {
						if(i==currentPage) AJS.$("#GA_browse_pagination").append(i + '&nbsp;');
						else AJS.$("#GA_browse_pagination").append('<a style="cursor:pointer;" onclick="pagination(' + i + ')">' + i + '</a>&nbsp;');
					}
				}
				AJS.$("#GA_browse_pagination").append('&nbsp;&nbsp;');
				// Next page
				if(total-(currentPage*per_page)>0) {
					AJS.$("#GA_browse_pagination").append('<a class="icon icon-next" style="cursor:pointer;" onclick="pagination(' + (currentPage + 1) + ')"><span>Next &gt;&gt;</span></a>');
				}
			}
        } 
    });
}

function filter() {
	var criteria = "";
	if(AJS.$("#user-select").select2('data') != null) criteria += "&ambassador=" + prepare(AJS.$("#user-select").select2('data').key);
	if(AJS.$("#group-select").select2('data') != null) criteria += "&group=" + prepare(AJS.$("#group-select").select2('data').name);
	var page = (findGetParameter('page')==null) ? 1 : findGetParameter('page');
	window.location.href="GroupAmbassadorsLogs.jspa?page=" + page.toString() + criteria;
}

function pagination(page) {
	var criteria = getCriteria();
	window.location.href="GroupAmbassadorsLogs.jspa?page=" + page.toString() + criteria;
}

function getCriteria() {
	var criteria = "";
	if(findGetParameter('ambassador') != null) criteria += "&ambassador=" + findGetParameter('ambassador');
	if(findGetParameter('group') != null) criteria += "&group=" + findGetParameter('group');
	return criteria;
}

function fetchTable() {
	var page = (findGetParameter('page')!=null) ? "?page=" + findGetParameter('page') : "?page=1";
	var criteria = getCriteria();
	AJS.$.ajax({
        url: contextPath + "/rest/groupambassadors/1.0/logs/" + page + criteria,
        success: function(data) {
			if(data.length==0) {
				AJS.$.ajax({
					url: contextPath + "/rest/groupambassadors/1.0/logs/?countOnly=true" + criteria,
					dataType: 'text',
					success: function(data) {
						var total = parseInt(data);
						if(parseInt(findGetParameter('page')) > 0) pagination(Math.ceil(total/15));
						else {
							AJS.$("#logsTable tbody").html(AJS.I18n.getText("group-ambassadors-admin-logs-filter.filter-noresult")).spinStop();
						}
					} 
				});
			}
			AJS.$("#logsTable tbody").html("").spinStop();
			data.forEach(function(log) {
				var date = new Date(log.date);
				
				var evt = "";
				switch(log.event) {
					case "REVOKE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-remove\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-revoke");
					break;
					case "GRANT":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-approve\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-grant");
					break;
					case "FLUSHED":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-delete\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-flushed");
					break;
					case "POLICY_DENY_ADD":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-locked\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-policy-deny-add");
					break;
					case "POLICY_DENY_REMOVE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-unlocked\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-policy-deny-remove");
					break;
					case "POLICY_RESTRICT_ADD":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-watch\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-policy-restrict-add");
					break;
					case "POLICY_RESTRICT_NEW_RULE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-focus\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-policy-restrict-rule-add");
					break;
					case "POLICY_RESTRICT_REMOVED_RULE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-unfocus\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-policy-restrict-rule-remove");
					break;
					case "POLICY_RESTRICT_REMOVE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-unwatch\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-policy-restrict-remove");
					break;
					case "ENABLED_GROUP_BROWSING":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-group-browsing");
					break;
					case "DISABLED_GROUP_BROWSING":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-group-browsing");
					break;
					case "ENABLED_ADVANCED_LOGGING":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-advanced-logging");
					break;
					case "DISABLED_ADVANCED_LOGGING":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-advanced-logging");
					break;
					case "ENABLED_SELF_PROMOTE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-self-promote");
					break;
					case "DISABLED_SELF_PROMOTE":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-self-promote");
					break;
					case "ENABLED_EXTENDED_BROWSING":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-extended-browsing");
					break;
					case "DISABLED_EXTENDED_BROWSING":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-extended-browsing");
					break;
					case "ENABLED_SUPER_POWERS":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-super-powers");
					break;
					case "DISABLED_SUPER_POWERS":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-super-powers");
					break;
					case "ENABLED_EXT_SUPER_POWERS":
                    	evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-ext-super-powers");
                    break;
                    case "DISABLED_EXT_SUPER_POWERS":
                    	evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-ext-super-powers");
                    break;
					case "ENABLED_USER_GROUPS":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-user-groups");
					break;
					case "DISABLED_USER_GROUPS":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-user-groups");
					break;
					case "ENABLED_PERFORMANCE_MODE":
                    	evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-success\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-enable-performance-mode");
                	break;
                    case "DISABLED_PERFORMANCE_MODE":
                    	evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-disable-performance-mode");
                    break;
					case "ADDED_MEMBER":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-list-add\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-add-member");
					break;
					case "REMOVED_MEMBER":
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-list-remove\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-remove-member");
					break;
					default:
						evt += "<span class=\"aui-icon aui-icon-small aui-iconfont-warning\"></span>&nbsp;&nbsp;" + AJS.I18n.getText("group-ambassadors-admin-logs-browse.event-error");
					break;
				}
                var g = (log.group == '*_ALLGROUPS_*') ? "<i>" + AJS.I18n.getText("group-ambassadors-admin-policies.all-groups") + "</i>" : log.group;
				AJS.$("#logsTable tbody").append("<tr><td>" + log.author + "</td><td>" + formatDate(date) + "</td><td>" + evt + "</td><td>" + log.ambassador + "</td><td>" + g + "</td></tr>");
			});
        } 
    });
	pagination_show();
}

function flushLogs() {
	AJS.$.ajax({
		url: contextPath + "/rest/groupambassadors/1.0/logs/",
		type: 'DELETE',
		dataType: 'text',
		success: function(data) {
			if(data=='OK') {
				pagination(1);
			}
		} 
	});
}

function appendLeadingZeroes(n){
  if(n <= 9){
    return "0" + n;
  }
  return n;
}

function formatDate(current_datetime) {
	var formatted_date = current_datetime.getFullYear() + "-" + appendLeadingZeroes(current_datetime.getMonth() + 1) + "-" + appendLeadingZeroes(current_datetime.getDate()) + " " + appendLeadingZeroes(current_datetime.getHours()) + ":" + appendLeadingZeroes(current_datetime.getMinutes()) + ":" + appendLeadingZeroes(current_datetime.getSeconds());
	return formatted_date;	
}
