/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.user;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.caritteprod.group.ambassadors.conf.ao.GroupAmbassadorsActiveObjectHelper;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAmbassadorsUser
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(GroupAmbassadorsUser.class);
    private ActiveObjects activeObjects;

    @Inject
    public GroupAmbassadorsUser(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public String execute() throws Exception {
        return "group-ambassadors-user-success";
    }

    public String getAvatar() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        return userAccessor.getUserProfilePicture((User)this.getAuthenticatedUser()).getUriReference();
    }

    private void getRedirect(String location) {
        try {
            HttpServletResponse response = ServletContextThreadLocal.getResponse();
            response.sendRedirect(location);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public String getExplorer() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "USER_GROUPS", "DISABLED") == 0 ? "" : "display: none;";
    }
}

