/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.user;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.caritteprod.group.ambassadors.conf.ao.Ambassador;
import com.caritteprod.group.ambassadors.conf.ao.GroupAmbassadorsActiveObjectHelper;
import com.caritteprod.group.ambassadors.conf.ao.ManagedGroup;
import com.caritteprod.group.ambassadors.conf.rest.GroupAmbassadorsResource;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAmbassadorsManage
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(GroupAmbassadorsManage.class);
    private ActiveObjects activeObjects;

    @Inject
    public GroupAmbassadorsManage(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public String execute() throws Exception {
        return "group-ambassadors-user-manage-success";
    }

    public boolean isAmbassador() {
        Ambassador a;
        log.debug("I am here trying to debug , is ambassador");
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        ConfluenceUser user = this.getAuthenticatedUser();
        String group = GroupAmbassadorsResource.unprep(request.getQueryString().replaceAll("groupName=", ""));
        if (group.contains("&page=")) {
            group = group.substring(0, group.indexOf("&page="));
        }
        if ((a = GroupAmbassadorsActiveObjectHelper.findAmbassador2(this.activeObjects, user.getName())) != null) {
            for (ManagedGroup grp : a.getManagedGroups()) {
                if (!grp.getGroupName().equalsIgnoreCase(group)) continue;
                return true;
            }
        }
        return false;
    }

    public String checkUserGroups() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "USER_GROUPS", "DISABLED") >= 1 ? "" : "<meta name=\"ga-user-groups-setting\" content=\"enabled\">";
    }

    public String getName() {
        log.debug("I am here trying to debug , getName");
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        String gname = "";
        GroupManager gm = (GroupManager)ContainerManager.getComponent((String)"groupManager");
        if (request.getParameter("groupName") == null) {
            this.getRedirect("GroupAmbassadorsUser.jspa");
        } else {
            gname = GroupAmbassadorsResource.unprep(request.getQueryString().replaceAll("groupName=", ""));
            gname = gname.split("&page=")[0];
            try {
                if (gm.getGroup(gname) == null) {
                    this.getRedirect("GroupAmbassadorsUser.jspa");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return gname;
    }

    @HtmlSafe
    public String addUser() {
        Object ret = "";
        if (this.isAmbassador()) {
            ret = (String)ret + "<h2>" + this.getText("group-ambassadors-user-manage-add.title") + "</h2>";
            ret = (String)ret + "<form class=\"aui\"><p><label for=\"user-select\">" + this.getText("group-ambassadors-user-manage-add.user-label") + ":<br /><input type=\"text\" id=\"user-select\" class=\"text long-field\" data-placeholder=\"" + this.getText("group-ambassadors-admin-add.placeholder") + "\"></label></p>";
            ret = (String)ret + "</form><br /><button class=\"aui-button aui-button-primary\" onClick=\"addUsers()\">" + this.getText("group-ambassadors-user-manage-add.add-button") + "</button>";
        }
        return ret;
    }

    public String self_promote_message() {
        Object ret = "";
        if (GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "SELF_PROMOTE", "ENABLED") < 1) {
            ret = (String)ret + "<div class=\"aui-message aui-message-warning\"><p class=\"title\"><strong>" + this.getText("group-ambassadors-user-manage.warning-self-promote.title") + "</strong></p><p>" + this.getText("group-ambassadors-user-manage.warning-self-promote.message") + "</p></div>";
        }
        return ret;
    }

    public String getAvatar() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        return userAccessor.getUserProfilePicture((User)this.getAuthenticatedUser()).getUriReference();
    }

    private void getRedirect(String location) {
        try {
            log.debug("I am here trying to redirect");
            HttpServletResponse response = ServletActionContext.getResponse();
            response.sendRedirect(location);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

