/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.rest;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Entity;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="users")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserResourceModel {
    private static final Logger logger = LoggerFactory.getLogger(UserResourceModel.class);
    private static final UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    @XmlElement(name="username")
    private String username;
    @XmlElement(name="fullname")
    private String fullname;
    @XmlElement(name="email")
    private String email;
    @XmlElement(name="directory")
    private String directory;
    @XmlElement(name="lastLogin")
    private String lastLogin;
    @XmlElement(name="apiUsername")
    private String apiUsername;
    @XmlElement(name="directMember")
    private boolean directMember;

    public UserResourceModel() {
    }

    public UserResourceModel(User usr, String fromGroup) {
        this.username = userAccessor.isDeactivated(usr) ? "<del>" + usr.getName() + "</del> (inactive)" : usr.getName();
        this.apiUsername = usr.getName();
        this.fullname = userAccessor.isDeactivated(usr) ? "<del>" + usr.getFullName() + "</del>" : usr.getFullName();
        this.email = usr.getEmail();
        CrowdService cs = (CrowdService)ContainerManager.getComponent((String)"crowdService");
        FormatSettingsManager fsm = (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
        UserManager um = (UserManager)ContainerManager.getComponent((String)"userManager");
        this.directMember = true;
        try {
            this.directory = um.getRepository((Entity)usr).getName() + " [" + um.getRepository((Entity)usr).getKey() + "]";
            if (!cs.isUserDirectGroupMember(cs.getUser(usr.getName()), cs.getGroup(fromGroup))) {
                this.directMember = false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        LoginManager lm = (LoginManager)ContainerManager.getComponent((String)"loginManager");
        Date lastLoginDate = lm.getLoginInfo(usr.getName()).getLastSuccessfulLoginDate();
        if (lastLoginDate == null || userAccessor.isDeactivated(usr)) {
            this.lastLogin = "N/A";
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern(fsm.getDateFormat());
            this.lastLogin = sdf.format(lastLoginDate);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean getDirectMember() {
        return this.directMember;
    }

    public void setDirectMember(boolean directMember) {
        this.directMember = directMember;
    }
}

