/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.AuthenticatedUserImpersonator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.caritteprod.group.ambassadors.conf.ao.Ambassador;
import com.caritteprod.group.ambassadors.conf.ao.AmbassadorLog;
import com.caritteprod.group.ambassadors.conf.ao.AmbassadorToGroup;
import com.caritteprod.group.ambassadors.conf.ao.GroupAmbassadorsActiveObjectHelper;
import com.caritteprod.group.ambassadors.conf.ao.GroupPolicy;
import com.caritteprod.group.ambassadors.conf.ao.ManagedGroup;
import com.caritteprod.group.ambassadors.conf.ao.Setting;
import com.caritteprod.group.ambassadors.conf.rest.AmbassadorResourceModel;
import com.caritteprod.group.ambassadors.conf.rest.GroupPolicyResourceModel;
import com.caritteprod.group.ambassadors.conf.rest.GroupResourceModel;
import com.caritteprod.group.ambassadors.conf.rest.LogResourceModel;
import com.caritteprod.group.ambassadors.conf.rest.UserResourceModel;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class GroupAmbassadorsResource {
    private ActiveObjects activeObjects;
    private static final Logger logger = LoggerFactory.getLogger(GroupAmbassadorsResource.class);
    private UserManager userManager;
    private ConfluenceUserManager confUserManager;
    private UserAccessor userAccessor;
    private GroupManager groupManager;
    private PluginLicenseManager plm;

    @Inject
    public GroupAmbassadorsResource(ActiveObjects activeObjects, UserManager userManager, UserAccessor userAccessor, GroupManager groupManager, PluginLicenseManager plm, ConfluenceUserManager confUserManager) {
        this.activeObjects = activeObjects;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.confUserManager = confUserManager;
        this.plm = plm;
    }

    @Path(value="/groups")
    @GET
    @Produces(value={"application/json"})
    public Response getManagedGroups(final @QueryParam(value="start") int start, @QueryParam(value="withGroups") boolean withUsers) {
        ManagedGroup[] groups = (ManagedGroup[])this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<ManagedGroup[]>(){

            public ManagedGroup[] doInTransaction() {
                return (ManagedGroup[])GroupAmbassadorsResource.this.activeObjects.find(ManagedGroup.class, Query.select().order("GROUP_NAME ASC").limit(10).offset(start));
            }
        });
        ArrayList<GroupResourceModel> grps = new ArrayList<GroupResourceModel>();
        for (ManagedGroup grp : groups) {
            if (withUsers) {
                ArrayList<String> users = new ArrayList<String>();
                for (Ambassador a : grp.getAmbassadors()) {
                    users.add(a.getUserName());
                }
                grps.add(new GroupResourceModel(grp.getID(), grp.getGroupName(), users));
                continue;
            }
            grps.add(new GroupResourceModel(grp.getID(), grp.getGroupName()));
        }
        return Response.ok(grps).build();
    }

    @Path(value="/ambassadors")
    @GET
    @Produces(value={"application/json"})
    public Response getAmbassadors(@QueryParam(value="page") int page, @QueryParam(value="withGroups") boolean withGroups, final @QueryParam(value="query") String q, @QueryParam(value="countOnly") boolean countOnly) {
        final boolean queried = null != q && q.length() > 0;
        int offset = (page - 1) * 10;
        if (offset < 0) {
            offset = 0;
        }
        Ambassador[] ambassadors = (Ambassador[])this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Ambassador[]>(){

            public Ambassador[] doInTransaction() {
                if (queried) {
                    String query = GroupAmbassadorsResource.unprep(q);
                    Ambassador[] all = (Ambassador[])GroupAmbassadorsResource.this.activeObjects.find(Ambassador.class, Query.select().order("USER_NAME ASC"));
                    ArrayList<Ambassador> to_ret = new ArrayList<Ambassador>();
                    for (Ambassador a : all) {
                        if (!a.getUserName().contains(query) && !GroupAmbassadorsResource.this.userManager.getUserProfile(a.getUserName()).getFullName().contains(query)) continue;
                        to_ret.add(a);
                    }
                    return to_ret.toArray(new Ambassador[to_ret.size()]);
                }
                return (Ambassador[])GroupAmbassadorsResource.this.activeObjects.find(Ambassador.class, Query.select().order("USER_NAME ASC"));
            }
        });
        if (countOnly) {
            return Response.ok((Object)Integer.toString(ambassadors.length)).build();
        }
        ArrayList<AmbassadorResourceModel> ambs = new ArrayList<AmbassadorResourceModel>();
        int added = 0;
        int idx = 0;
        for (Ambassador amb : ambassadors) {
            if (idx >= offset && added < 10) {
                AmbassadorResourceModel a = new AmbassadorResourceModel(amb.getID(), amb.getUserName());
                if (withGroups) {
                    ArrayList<String> groups = new ArrayList<String>();
                    for (ManagedGroup g : amb.getManagedGroups()) {
                        Object gname = "";
                        if (this.getGroupObject(g.getGroupName()) == null) {
                            gname = (String)gname + "<span class=\"aui-icon aui-icon-small aui-iconfont-error useless\" style=\"color:red; margin-right:5px\"></span>";
                        }
                        gname = (String)gname + g.getGroupName();
                        groups.add((String)gname);
                    }
                    a.setGroups(groups);
                }
                ambs.add(a);
                ++added;
            }
            ++idx;
        }
        return Response.ok(ambs).build();
    }

    @Path(value="/logs")
    @GET
    @Produces(value={"application/json"})
    public Response getLogs(final @QueryParam(value="page") int page, final @QueryParam(value="countOnly") boolean countOnly, @QueryParam(value="ambassador") String amb, @QueryParam(value="group") String grpp, @Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String ambassador = GroupAmbassadorsResource.unprep(amb);
        if (this.userManager.isAdmin(remote_user)) {
            AmbassadorLog[] logs = (AmbassadorLog[])this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<AmbassadorLog[]>(){

                public AmbassadorLog[] doInTransaction() {
                    boolean g;
                    int offset = (page - 1) * 15;
                    if (offset < 0) {
                        offset = 0;
                    }
                    boolean a = ambassador != null && !ambassador.equals("");
                    boolean bl = g = group != null && !group.equals("");
                    if (countOnly) {
                        if (a && g) {
                            return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().where("AMBASSADOR = ? AND GROUP = ?", new Object[]{ambassador, group}).order("DATE DESC"));
                        }
                        if (a) {
                            return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().where("AMBASSADOR = ?", new Object[]{ambassador}).order("DATE DESC"));
                        }
                        if (g) {
                            return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().where("GROUP = ?", new Object[]{group}).order("DATE DESC"));
                        }
                        return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().order("DATE DESC"));
                    }
                    if (a && g) {
                        return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().where("AMBASSADOR = ? AND GROUP = ?", new Object[]{ambassador, group}).order("DATE DESC").limit(15).offset(offset));
                    }
                    if (a) {
                        return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().where("AMBASSADOR = ?", new Object[]{ambassador}).order("DATE DESC").limit(15).offset(offset));
                    }
                    if (g) {
                        return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().where("GROUP = ?", new Object[]{group}).order("DATE DESC").limit(15).offset(offset));
                    }
                    return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select().order("DATE DESC").limit(15).offset(offset));
                }
            });
            if (countOnly) {
                return Response.ok((Object)Integer.toString(logs.length)).build();
            }
            ArrayList<LogResourceModel> ls = new ArrayList<LogResourceModel>();
            for (AmbassadorLog log : logs) {
                ls.add(new LogResourceModel(log));
            }
            return Response.ok(ls).build();
        }
        return Response.ok((Object)"WRONG_PERMISSIONS").build();
    }

    @Path(value="/logs")
    @DELETE
    @Produces(value={"application/json"})
    public Response flushLogs(@Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isSystemAdmin(remote_user)) {
            AmbassadorLog[] logs;
            for (AmbassadorLog log : logs = (AmbassadorLog[])this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<AmbassadorLog[]>(){

                public AmbassadorLog[] doInTransaction() {
                    return (AmbassadorLog[])GroupAmbassadorsResource.this.activeObjects.find(AmbassadorLog.class, Query.select());
                }
            })) {
                this.activeObjects.delete(new RawEntity[]{log});
            }
            AmbassadorLog log = (AmbassadorLog)this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
            log.setAuthor(remote_user);
            log.setAmbassador("");
            log.setGroup("");
            log.setDate(new Date());
            log.setAction("FLUSHED");
            log.save();
            return Response.ok((Object)"OK").build();
        }
        return Response.ok((Object)"WRONG_PERMISSIONS").build();
    }

    @Path(value="/group/{group}/users")
    @GET
    @Produces(value={"application/json"})
    public Response getAmbassadorsForGroup(@PathParam(value="group") String grpp) {
        String group = GroupAmbassadorsResource.unprep(grpp);
        if (this.getGroupObject(group) == null) {
            return Response.ok((Object)"GROUP_DOES_NOT_EXISTS").build();
        }
        ManagedGroup[] groups = (ManagedGroup[])this.activeObjects.executeInTransaction(() -> (ManagedGroup[])this.activeObjects.find(ManagedGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{group})));
        ArrayList<AmbassadorResourceModel> ambassadors = new ArrayList<AmbassadorResourceModel>();
        if (groups != null && groups.length > 0) {
            for (Ambassador amb : groups[0].getAmbassadors()) {
                if (GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "EXT_SUPER_POWERS", "DISABLED") != 1) {
                    ambassadors.add(new AmbassadorResourceModel((Integer)amb.getID(), amb.getUserName(), true));
                    continue;
                }
                ambassadors.add(new AmbassadorResourceModel(amb.getID(), amb.getUserName()));
            }
        }
        return Response.ok(ambassadors).build();
    }

    @Path(value="/group/{group}/users")
    @PUT
    @Produces(value={"application/json"})
    public Response addAmbassador(@QueryParam(value="user") String usr, @PathParam(value="group") String grpp, @Context HttpServletRequest request) {
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String user = GroupAmbassadorsResource.unprep(usr);
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user) || GroupAmbassadorsActiveObjectHelper.canNominate(this.activeObjects, remote_user, group)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    AmbassadorToGroup relationship;
                    ManagedGroup grp;
                    boolean licensed = true;
                    if (GroupAmbassadorsResource.this.plm.getLicense().isDefined()) {
                        PluginLicense pl = (PluginLicense)GroupAmbassadorsResource.this.plm.getLicense().get();
                        if (pl.getError().isDefined()) {
                            licensed = false;
                        }
                    } else {
                        licensed = false;
                    }
                    if (!licensed) {
                        return new Integer(4);
                    }
                    if (GroupAmbassadorsResource.this.userManager.getUserProfile(user) == null) {
                        return new Integer(1);
                    }
                    if (GroupAmbassadorsResource.this.getGroupObject(group) == null) {
                        return new Integer(2);
                    }
                    Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador2(GroupAmbassadorsResource.this.activeObjects, user.toLowerCase());
                    if (amb == null) {
                        amb = (Ambassador)GroupAmbassadorsResource.this.activeObjects.create(Ambassador.class, new DBParam[]{new DBParam("USER_NAME", (Object)user.toLowerCase())});
                        amb.save();
                    }
                    if ((grp = GroupAmbassadorsActiveObjectHelper.findManagedGroup(GroupAmbassadorsResource.this.activeObjects, group)) == null) {
                        grp = (ManagedGroup)GroupAmbassadorsResource.this.activeObjects.create(ManagedGroup.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)group)});
                        grp.save();
                    }
                    if ((relationship = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb, grp)) == null) {
                        relationship = (AmbassadorToGroup)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorToGroup.class, new DBParam[0]);
                        relationship.setGroup(grp);
                        relationship.setAmbassador(amb);
                        AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                        log.setAuthor(remote_user);
                        log.setAmbassador(user);
                        log.setGroup(group);
                        log.setDate(new Date());
                        log.setAction("GRANT");
                        relationship.save();
                        log.save();
                        return new Integer(0);
                    }
                    return new Integer(3);
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "USER_DOES_NOT_EXISTS";
                    break;
                }
                case 2: {
                    state = "GROUP_DOES_NOT_EXISTS";
                    break;
                }
                case 3: {
                    state = "ALREADY_AMBASSADOR";
                    break;
                }
                case 4: {
                    state = "NOT_LICENSED";
                    break;
                }
                case 0: {
                    state = "USER_ADDED";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/groups/ALL/user")
    @PUT
    @Produces(value={"application/json"})
    public Response addAmbassadorToAllGroups(@QueryParam(value="user") String usr, @Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        final String user = GroupAmbassadorsResource.unprep(usr);
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    boolean licensed = true;
                    if (GroupAmbassadorsResource.this.plm.getLicense().isDefined()) {
                        PluginLicense pl = (PluginLicense)GroupAmbassadorsResource.this.plm.getLicense().get();
                        if (pl.getError().isDefined()) {
                            licensed = false;
                        }
                    } else {
                        licensed = false;
                    }
                    if (!licensed) {
                        return new Integer(4);
                    }
                    if (GroupAmbassadorsResource.this.userManager.getUserProfile(user) == null) {
                        return new Integer(1);
                    }
                    Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador2(GroupAmbassadorsResource.this.activeObjects, user);
                    if (amb == null) {
                        amb = (Ambassador)GroupAmbassadorsResource.this.activeObjects.create(Ambassador.class, new DBParam[]{new DBParam("USER_NAME", (Object)user.toLowerCase())});
                        amb.save();
                    }
                    int total = 0;
                    int success = 0;
                    try {
                        for (Group g : GroupAmbassadorsResource.this.groupManager.getGroups()) {
                            AmbassadorToGroup relationship;
                            ++total;
                            ManagedGroup grp = GroupAmbassadorsActiveObjectHelper.findManagedGroup(GroupAmbassadorsResource.this.activeObjects, g.getName());
                            if (grp == null) {
                                grp = (ManagedGroup)GroupAmbassadorsResource.this.activeObjects.create(ManagedGroup.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)g.getName())});
                                grp.save();
                            }
                            if ((relationship = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb, grp)) != null) continue;
                            relationship = (AmbassadorToGroup)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorToGroup.class, new DBParam[0]);
                            relationship.setGroup(grp);
                            relationship.setAmbassador(amb);
                            AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                            log.setAuthor(remote_user);
                            log.setAmbassador(user);
                            log.setGroup(g.getName());
                            log.setDate(new Date());
                            log.setAction("GRANT");
                            relationship.save();
                            log.save();
                            ++success;
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    return success == total ? 0 : 2;
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "USER_DOES_NOT_EXISTS";
                    break;
                }
                case 2: {
                    state = "PARTIAL_ALL";
                    break;
                }
                case 4: {
                    state = "NOT_LICENSED";
                    break;
                }
                case 0: {
                    state = "USER_ADDED_ALL";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/groups/ALL/user")
    @DELETE
    @Produces(value={"application/json"})
    public Response removeAmbassadorFromAllGroups(@QueryParam(value="user") String usr, @Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        final String user = GroupAmbassadorsResource.unprep(usr);
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador2(GroupAmbassadorsResource.this.activeObjects, user);
                    if (amb == null) {
                        return new Integer(1);
                    }
                    AmbassadorToGroup[] relationships = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb);
                    if (relationships != null) {
                        for (AmbassadorToGroup r : relationships) {
                            String gname = r.getGroup().getGroupName();
                            GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{r});
                            AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                            log.setAuthor(remote_user);
                            log.setAmbassador(user);
                            log.setGroup(gname);
                            log.setDate(new Date());
                            log.setAction("REVOKE");
                            log.save();
                        }
                    }
                    GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{amb});
                    return 0;
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "USER_DOES_NOT_EXISTS";
                    break;
                }
                case 0: {
                    state = "USER_REVOKED_ALL";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/group/{group}/users")
    @DELETE
    @Produces(value={"application/json"})
    public Response removeAmbassador(@QueryParam(value="user") String usr, @PathParam(value="group") String grpp, @Context HttpServletRequest request) {
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String user = GroupAmbassadorsResource.unprep(usr);
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user) || GroupAmbassadorsActiveObjectHelper.canRevoke(this.activeObjects, remote_user, group)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador2(GroupAmbassadorsResource.this.activeObjects, user);
                    if (amb == null) {
                        return new Integer(1);
                    }
                    ManagedGroup grp = GroupAmbassadorsActiveObjectHelper.findManagedGroup(GroupAmbassadorsResource.this.activeObjects, group);
                    if (grp == null) {
                        return new Integer(2);
                    }
                    AmbassadorToGroup relationship = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb, grp);
                    if (relationship == null) {
                        return new Integer(3);
                    }
                    AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                    log.setAuthor(remote_user);
                    log.setAmbassador(user);
                    log.setGroup(group);
                    log.setDate(new Date());
                    log.setAction("REVOKE");
                    GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{relationship});
                    log.save();
                    AmbassadorToGroup[] check = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb);
                    if (check == null) {
                        GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{amb});
                    }
                    if ((check = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, grp)) == null) {
                        GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{grp});
                    }
                    return new Integer(0);
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "AMBASSADOR_DOES_NOT_EXISTS";
                    break;
                }
                case 2: {
                    state = "MANAGED_GROUP_DOES_NOT_EXISTS";
                    break;
                }
                case 3: {
                    state = "WAS_NOT_AMBASSADOR";
                    break;
                }
                case 0: {
                    state = "USER_REVOKED";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/group/{group}/user")
    @DELETE
    @Produces(value={"application/json"})
    public Response removeUser(@QueryParam(value="user") String usr, @PathParam(value="group") String grpp, @Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String user = GroupAmbassadorsResource.unprep(usr);
        Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction() {
                Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador2(GroupAmbassadorsResource.this.activeObjects, remote_user);
                if (amb == null) {
                    return new Integer(1);
                }
                if (GroupAmbassadorsResource.this.getGroupObject(group) == null) {
                    return new Integer(4);
                }
                ManagedGroup grp = GroupAmbassadorsActiveObjectHelper.findManagedGroup(GroupAmbassadorsResource.this.activeObjects, group);
                if (grp == null) {
                    return new Integer(2);
                }
                AmbassadorToGroup relationship = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb, grp);
                if (relationship == null) {
                    return new Integer(3);
                }
                try {
                    ConfluenceUser u = GroupAmbassadorsResource.this.userAccessor.getUserByName(user);
                    AuthenticatedUserImpersonator.REQUEST_AGNOSTIC.asUser(() -> this.lambda$doInTransaction$0(group, (User)u), GroupAmbassadorsResource.this.getAdminName());
                    if (GroupAmbassadorsActiveObjectHelper.checkSetting(GroupAmbassadorsResource.this.activeObjects, "ADVANCED_LOGGING", "DISABLED") == 0) {
                        AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                        log.setAuthor(remote_user);
                        log.setAmbassador(user);
                        log.setGroup(group);
                        log.setDate(new Date());
                        log.setAction("REMOVED_MEMBER");
                        log.save();
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    return new Integer(5);
                }
                return new Integer(0);
            }

            private /* synthetic */ Boolean lambda$doInTransaction$0(String group2, User u) throws Exception {
                return GroupAmbassadorsResource.this.userAccessor.removeMembership(GroupAmbassadorsResource.this.groupManager.getGroup(group2), u);
            }
        });
        String state = "";
        switch (status) {
            case 1: {
                state = "NOT_AMBASSADOR";
                break;
            }
            case 2: {
                state = "MANAGED_GROUP_DOES_NOT_EXISTS";
                break;
            }
            case 3: {
                state = "WAS_NOT_AMBASSADOR";
                break;
            }
            case 4: {
                state = "GROUP_DOES_NOT_EXISTS";
                break;
            }
            case 5: {
                state = "UNKNOWN_ERROR";
                break;
            }
            case 0: {
                state = "USER_REMOVED";
            }
        }
        return Response.ok((Object)state).build();
    }

    @Path(value="/group/{group}/user")
    @PUT
    @Produces(value={"application/json"})
    public Response addUser(@QueryParam(value="user") String usr, @PathParam(value="group") String grpp, @Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String user = GroupAmbassadorsResource.unprep(usr);
        Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction() {
                Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador2(GroupAmbassadorsResource.this.activeObjects, remote_user);
                if (amb == null) {
                    return new Integer(1);
                }
                if (GroupAmbassadorsResource.this.getGroupObject(group) == null) {
                    return new Integer(4);
                }
                ManagedGroup grp = GroupAmbassadorsActiveObjectHelper.findManagedGroup(GroupAmbassadorsResource.this.activeObjects, group);
                if (grp == null) {
                    return new Integer(2);
                }
                if (user.equalsIgnoreCase(remote_user) && GroupAmbassadorsActiveObjectHelper.checkSetting(GroupAmbassadorsResource.this.activeObjects, "SELF_PROMOTE", "ENABLED") < 1) {
                    return new Integer(7);
                }
                AmbassadorToGroup relationship = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, amb, grp);
                if (relationship == null) {
                    return new Integer(3);
                }
                try {
                    ConfluenceUser u = GroupAmbassadorsResource.this.userAccessor.getUserByName(user);
                    Group g = GroupAmbassadorsResource.this.groupManager.getGroup(group);
                    if (GroupAmbassadorsResource.this.groupManager.hasMembership(g, (User)u)) {
                        return new Integer(6);
                    }
                    AuthenticatedUserImpersonator.REQUEST_AGNOSTIC.asUser(() -> this.lambda$doInTransaction$0(g, (User)u), GroupAmbassadorsResource.this.getAdminName());
                    if (GroupAmbassadorsActiveObjectHelper.checkSetting(GroupAmbassadorsResource.this.activeObjects, "ADVANCED_LOGGING", "DISABLED") == 0) {
                        AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                        log.setAuthor(remote_user);
                        log.setAmbassador(user);
                        log.setGroup(group);
                        log.setDate(new Date());
                        log.setAction("ADDED_MEMBER");
                        log.save();
                    }
                }
                catch (Exception e) {
                    logger.error("Add user failed: ", (Throwable)e);
                    return new Integer(5);
                }
                return new Integer(0);
            }

            private /* synthetic */ Object lambda$doInTransaction$0(Group g, User u) throws Exception {
                GroupAmbassadorsResource.this.userAccessor.addMembership(g, u);
                return null;
            }
        });
        String state = "";
        switch (status) {
            case 1: {
                state = "NOT_AMBASSADOR";
                break;
            }
            case 2: {
                state = "MANAGED_GROUP_DOES_NOT_EXISTS";
                break;
            }
            case 3: {
                state = "WAS_NOT_AMBASSADOR";
                break;
            }
            case 4: {
                state = "GROUP_DOES_NOT_EXISTS";
                break;
            }
            case 5: {
                state = "UNKNOWN_ERROR";
                break;
            }
            case 6: {
                state = "ALREADY_MEMBER";
                break;
            }
            case 7: {
                state = "SELF_PROMOTE_DISABLED";
                break;
            }
            case 0: {
                state = "USER_ADDED";
            }
        }
        return Response.ok((Object)state).build();
    }

    @Path(value="/group/{group}/user")
    @GET
    @Produces(value={"application/json"})
    public Response getUsers(@QueryParam(value="getAll") boolean getAll, @QueryParam(value="page") int page, @PathParam(value="group") String grpp, @QueryParam(value="countOnly") boolean countOnly, @Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        String group = GroupAmbassadorsResource.unprep(grpp);
        if (!GroupAmbassadorsActiveObjectHelper.isGroupBrowsable(this.activeObjects, group, remote_user)) {
            return Response.status((int)403).build();
        }
        if (this.getGroupObject(group) == null) {
            return Response.ok((Object)"GROUP_DOES_NOT_EXISTS").build();
        }
        if (countOnly) {
            List total = this.userAccessor.getMemberNamesAsList(this.getGroupObject(group));
            return Response.ok((Object)total.size()).build();
        }
        if (page < 1) {
            page = 1;
        }
        List<User> users = this.getUsersInGroup(this.getGroupObject(group));
        ArrayList<UserResourceModel> userlist = new ArrayList<UserResourceModel>();
        for (User usr : users) {
            userlist.add(new UserResourceModel(usr, group));
        }
        return Response.ok(userlist).build();
    }

    @Path(value="/ambassador/{user}/groups")
    @GET
    @Produces(value={"application/json"})
    public Response getGroupsForAmbassador(@PathParam(value="user") String usr) {
        String user = GroupAmbassadorsResource.unprep(usr);
        if (this.userManager.getUserProfile(user) == null) {
            return Response.ok((Object)"USER_DOES_NOT_EXISTS").build();
        }
        Ambassador ambassador = GroupAmbassadorsActiveObjectHelper.findAmbassador2(this.activeObjects, user);
        ArrayList<GroupResourceModel> groups = new ArrayList<GroupResourceModel>();
        if (ambassador != null) {
            for (ManagedGroup grp : ambassador.getManagedGroups()) {
                groups.add(new GroupResourceModel(grp.getID(), grp.getGroupName()));
            }
        }
        TreeSet<GroupResourceModel> sorted = new TreeSet<GroupResourceModel>();
        sorted.addAll(groups);
        return Response.ok(sorted).build();
    }

    @Path(value="/ambassador/myGroups")
    @GET
    @Produces(value={"application/json"})
    public Response getGroupsForCurrentUser(@QueryParam(value="countOnly") boolean countOnly, @QueryParam(value="query") String query, @Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        Ambassador ambassador = GroupAmbassadorsActiveObjectHelper.findAmbassador2(this.activeObjects, remote_user);
        HashMap res = new HashMap();
        ArrayList<GroupResourceModel> groups = new ArrayList<GroupResourceModel>();
        if (ambassador != null) {
            for (ManagedGroup grp : ambassador.getManagedGroups()) {
                if (this.getGroupObject(grp.getGroupName()) == null) continue;
                GroupResourceModel grm = new GroupResourceModel(grp.getID(), grp.getGroupName());
                grm.setBrowsable(GroupAmbassadorsActiveObjectHelper.isGroupBrowsable(this.activeObjects, grp.getGroupName(), remote_user));
                grm.setCanNominate(GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "SUPER_POWERS", "DISABLED") < 1);
                groups.add(grm);
            }
        }
        ArrayList<GroupResourceModel> groupsJira = new ArrayList<GroupResourceModel>();
        for (String grpName : this.userAccessor.getGroupNames(this.getUserObject(remote_user))) {
            GroupResourceModel to_add = new GroupResourceModel(0, grpName);
            to_add.setBrowsable(GroupAmbassadorsActiveObjectHelper.isGroupBrowsable(this.activeObjects, grpName, remote_user));
            if (groups.contains(to_add) || GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "EXTENDED_BROWSING", "DISABLED") >= 1 && !to_add.getBrowsable()) continue;
            groupsJira.add(to_add);
        }
        TreeSet<GroupResourceModel> sortedManaged = new TreeSet<GroupResourceModel>();
        TreeSet<GroupResourceModel> sortedJira = new TreeSet<GroupResourceModel>();
        if (null != query && query.length() > 0) {
            for (GroupResourceModel g : groups) {
                if (!g.getGroupname().toLowerCase().contains(query.toLowerCase())) continue;
                sortedManaged.add(g);
            }
            for (GroupResourceModel g : groupsJira) {
                if (!g.getGroupname().toLowerCase().contains(query.toLowerCase())) continue;
                sortedJira.add(g);
            }
        } else {
            sortedManaged.addAll(groups);
            sortedJira.addAll(groupsJira);
        }
        if (countOnly) {
            return Response.ok((Object)(sortedManaged.size() + sortedJira.size())).build();
        }
        res.put("managed", sortedManaged);
        res.put("jira", sortedJira);
        return Response.ok(res).build();
    }

    @Path(value="/ambassador/expGroups")
    @GET
    @Produces(value={"application/json"})
    public Response getGroupsForOtherUser(@QueryParam(value="user") String usr, @Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        String user = GroupAmbassadorsResource.unprep(usr);
        boolean isAdmin = this.userManager.isAdmin(remote_user);
        List<Group> remote_groups = this.getGroupsForUser(this.getUserObject(remote_user));
        if (this.userManager.getUserProfile(user) == null) {
            return Response.ok((Object)"USER_DOES_NOT_EXISTS").build();
        }
        HashMap res = new HashMap();
        ArrayList<GroupResourceModel> groups = new ArrayList<GroupResourceModel>();
        Ambassador remote_ambassador = GroupAmbassadorsActiveObjectHelper.findAmbassador2(this.activeObjects, remote_user);
        for (Group grp : this.getGroupsForUser(this.getUserObject(user))) {
            GroupResourceModel to_add;
            ManagedGroup mgrp = GroupAmbassadorsActiveObjectHelper.findManagedGroup(this.activeObjects, grp.getName());
            if (!remote_groups.contains(grp) && !isAdmin && (remote_ambassador == null || mgrp == null || GroupAmbassadorsActiveObjectHelper.findRelationship(this.activeObjects, remote_ambassador, mgrp) == null) || groups.contains(to_add = new GroupResourceModel(0, grp.getName()))) continue;
            groups.add(to_add);
        }
        TreeSet<GroupResourceModel> sorted = new TreeSet<GroupResourceModel>();
        sorted.addAll(groups);
        res.put("groups", sorted);
        return Response.ok(res).build();
    }

    @Path(value="/group/{group}/policy")
    @PUT
    @Produces(value={"application/json"})
    public Response addPolicy(final @QueryParam(value="policy_entity_type") String policy_entity_type, @QueryParam(value="policy_entity_value") String policy_entity_val, final @QueryParam(value="policy") String policy, @PathParam(value="group") String grpp, @Context HttpServletRequest request) {
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String policy_entity_value = GroupAmbassadorsResource.unprep(policy_entity_val);
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    if (!(policy_entity_type == null || policy_entity_type.equalsIgnoreCase("GROUP") || policy_entity_type.equalsIgnoreCase("USER") || policy.equalsIgnoreCase("DENY"))) {
                        return new Integer(3);
                    }
                    if (policy_entity_type == "USER" && GroupAmbassadorsResource.this.userManager.getUserProfile(policy_entity_value) == null || policy_entity_type == "GROUP" && GroupAmbassadorsResource.this.getGroupObject(policy_entity_value) == null) {
                        return new Integer(1);
                    }
                    if (!group.equalsIgnoreCase("*_ALLGROUPS_*") && GroupAmbassadorsResource.this.getGroupObject(group) == null) {
                        return new Integer(2);
                    }
                    if (GroupAmbassadorsActiveObjectHelper.policyCrossCheck(GroupAmbassadorsResource.this.activeObjects, group, policy)) {
                        return new Integer(5);
                    }
                    GroupPolicy gp = GroupAmbassadorsActiveObjectHelper.findGroupPolicy(GroupAmbassadorsResource.this.activeObjects, group, policy, policy_entity_type, policy_entity_value);
                    if (gp == null) {
                        GroupPolicy gp2 = (GroupPolicy)GroupAmbassadorsResource.this.activeObjects.create(GroupPolicy.class, new DBParam[0]);
                        gp2.setGroup(group);
                        gp2.setPolicy(policy);
                        gp2.setPolicyEntityType(policy_entity_type);
                        gp2.setPolicyEntityValue(policy_entity_value);
                        if (policy.equalsIgnoreCase("RESTRICT") && !GroupAmbassadorsActiveObjectHelper.isGroupRestricted(GroupAmbassadorsResource.this.activeObjects, group) || policy.equalsIgnoreCase("DENY")) {
                            AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                            log.setAuthor(remote_user);
                            log.setGroup(group);
                            log.setAmbassador("");
                            log.setDate(new Date());
                            log.setAction("POLICY_" + policy + "_ADD");
                            log.save();
                        }
                        gp2.save();
                        if (policy.equalsIgnoreCase("RESTRICT")) {
                            AmbassadorLog log2 = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                            log2.setAuthor(remote_user);
                            log2.setGroup(group);
                            if (policy_entity_type.equalsIgnoreCase("GROUP")) {
                                log2.setAmbassador(policy_entity_value + "&nbsp;&nbsp;<span class=\"aui-icon aui-icon-small aui-iconfont-group\"></span>");
                            } else {
                                log2.setAmbassador(policy_entity_value);
                            }
                            log2.setDate(new Date());
                            log2.setAction("POLICY_RESTRICT_NEW_RULE");
                            log2.save();
                        }
                        return new Integer(0);
                    }
                    return new Integer(4);
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "ENTITY_DOES_NOT_EXISTS";
                    break;
                }
                case 2: {
                    state = "GROUP_DOES_NOT_EXISTS";
                    break;
                }
                case 3: {
                    state = "ENTITY_TYPE_NOT_SUPPORTED";
                    break;
                }
                case 4: {
                    state = "POLICY_ALREADY_EXISTS";
                    break;
                }
                case 5: {
                    state = "POLICY_CONFLICT";
                    break;
                }
                case 0: {
                    state = "POLICY_ADDED";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/policies")
    @GET
    @Produces(value={"application/json"})
    public Response getPolicies(@QueryParam(value="page") int page, @QueryParam(value="countOnly") boolean countOnly, @Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            int pageNum = page >= 1 ? page : 1;
            GroupPolicy[] policies = GroupAmbassadorsActiveObjectHelper.findPolicies(this.activeObjects, pageNum);
            ArrayList<GroupPolicyResourceModel> list = new ArrayList<GroupPolicyResourceModel>();
            HashMap<String, GroupPolicyResourceModel> restricted = new HashMap<String, GroupPolicyResourceModel>();
            if (policies != null) {
                for (GroupPolicy gp : policies) {
                    if (gp.getPolicy().equalsIgnoreCase("DENY")) {
                        list.add(new GroupPolicyResourceModel(gp));
                        continue;
                    }
                    if (restricted.get(gp.getGroup()) == null) {
                        restricted.put(gp.getGroup(), new GroupPolicyResourceModel(gp));
                    }
                    ((GroupPolicyResourceModel)restricted.get(gp.getGroup())).addEntity(gp.getPolicyEntityType(), gp.getPolicyEntityValue());
                }
            }
            for (GroupPolicyResourceModel entry : restricted.values()) {
                list.add(entry);
            }
            if (countOnly) {
                return Response.ok((Object)list.size()).build();
            }
            return Response.ok(list).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/group/{group}/policy")
    @DELETE
    @Produces(value={"application/json"})
    public Response removePolicy(final @QueryParam(value="policy_entity_type") String policy_entity_type, @QueryParam(value="policy_entity_value") String policy_entity_val, final @QueryParam(value="policy") String policy, @PathParam(value="group") String grpp, @Context HttpServletRequest request) {
        final String group = GroupAmbassadorsResource.unprep(grpp);
        final String policy_entity_value = GroupAmbassadorsResource.unprep(policy_entity_val);
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    if (!(policy_entity_type == null || policy_entity_type.equalsIgnoreCase("GROUP") || policy_entity_type.equalsIgnoreCase("USER") || policy.equalsIgnoreCase("DENY"))) {
                        return new Integer(3);
                    }
                    if (policy_entity_type == null || policy_entity_type.equalsIgnoreCase("USER") && GroupAmbassadorsResource.this.userManager.getUserProfile(policy_entity_value) == null || policy_entity_type == "GROUP" && GroupAmbassadorsResource.this.getGroupObject(policy_entity_value) == null) {
                        return new Integer(1);
                    }
                    if (GroupAmbassadorsResource.this.getGroupObject(group) == null && !group.equalsIgnoreCase("*_ALLGROUPS_*")) {
                        return new Integer(2);
                    }
                    GroupPolicy gp = GroupAmbassadorsActiveObjectHelper.findGroupPolicy(GroupAmbassadorsResource.this.activeObjects, group, policy, policy_entity_type, policy_entity_value);
                    if (gp != null) {
                        GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{gp});
                        if (policy.equalsIgnoreCase("RESTRICT")) {
                            AmbassadorLog log2 = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                            log2.setAuthor(remote_user);
                            log2.setGroup(group);
                            if (policy_entity_type.equalsIgnoreCase("GROUP")) {
                                log2.setAmbassador(policy_entity_value + "&nbsp;&nbsp;<span class=\"aui-icon aui-icon-small aui-iconfont-group\"></span>");
                            } else {
                                log2.setAmbassador(policy_entity_value);
                            }
                            log2.setDate(new Date());
                            log2.setAction("POLICY_RESTRICT_REMOVED_RULE");
                            log2.save();
                        }
                        if (policy.equalsIgnoreCase("RESTRICT") && !GroupAmbassadorsActiveObjectHelper.isGroupRestricted(GroupAmbassadorsResource.this.activeObjects, group) || policy.equalsIgnoreCase("DENY")) {
                            AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                            log.setAuthor(remote_user);
                            log.setAmbassador("");
                            log.setGroup(group);
                            log.setDate(new Date());
                            log.setAction("POLICY_" + policy + "_REMOVE");
                            log.save();
                        }
                        return new Integer(0);
                    }
                    return new Integer(4);
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "ENTITY_DOES_NOT_EXISTS";
                    break;
                }
                case 2: {
                    state = "GROUP_DOES_NOT_EXISTS";
                    break;
                }
                case 3: {
                    state = "ENTITY_TYPE_NOT_SUPPORTED";
                    break;
                }
                case 4: {
                    state = "POLICY_DOES_NOT_EXISTS";
                    break;
                }
                case 0: {
                    state = "POLICY_REMOVED";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/settings")
    @PUT
    @Produces(value={"application/json"})
    public Response updateSetting(final @QueryParam(value="key") String key, final @QueryParam(value="value") String value, @Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    Setting[] setRes;
                    if (!(key.equalsIgnoreCase("EXTENDED_BROWSING") || key.equalsIgnoreCase("GROUP_BROWSING") || key.equalsIgnoreCase("ADVANCED_LOGGING") || key.equalsIgnoreCase("SELF_PROMOTE") || key.equalsIgnoreCase("SUPER_POWERS") || key.equalsIgnoreCase("EXT_SUPER_POWERS") || key.equalsIgnoreCase("USER_GROUPS"))) {
                        return new Integer(1);
                    }
                    if (!value.equalsIgnoreCase("ENABLED") && !value.equalsIgnoreCase("DISABLED")) {
                        return new Integer(3);
                    }
                    int status = GroupAmbassadorsActiveObjectHelper.checkSetting(GroupAmbassadorsResource.this.activeObjects, key, value);
                    if (status == 1) {
                        return new Integer(2);
                    }
                    if (status != 2 && (setRes = (Setting[])GroupAmbassadorsResource.this.activeObjects.find(Setting.class, Query.select().where("KEY = ?", new Object[]{key}))) != null && setRes.length > 0) {
                        setRes[0].setValue(value);
                        AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                        log.setAuthor(remote_user);
                        log.setAmbassador("");
                        log.setGroup("");
                        log.setDate(new Date());
                        log.setAction(value + "_" + key);
                        setRes[0].save();
                        log.save();
                    }
                    return new Integer(0);
                }
            });
            String state = "";
            switch (status) {
                case 1: {
                    state = "WRONG_PROPERTY_KEY";
                    break;
                }
                case 2: {
                    state = "PROPERTY_ALREADY_SET";
                    break;
                }
                case 3: {
                    state = "WRONG_PROPERTY_VALUE";
                    break;
                }
                case 0: {
                    state = "PROPERTY_UPDATED";
                }
            }
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/cleanup/ambassadors")
    @GET
    @Produces(value={"application/json"})
    public Response getAmbassadorsForCleanup(@Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            Ambassador[] ambassadors = (Ambassador[])this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Ambassador[]>(){

                public Ambassador[] doInTransaction() {
                    return (Ambassador[])GroupAmbassadorsResource.this.activeObjects.find(Ambassador.class, Query.select().order("USER_NAME ASC"));
                }
            });
            ArrayList<AmbassadorResourceModel> r = new ArrayList<AmbassadorResourceModel>();
            for (Ambassador a : ambassadors) {
                if (this.userManager.getUserProfile(a.getUserName()) != null) continue;
                r.add(new AmbassadorResourceModel(a.getID(), a.getUserName()));
            }
            return Response.ok(r).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/cleanup/clean/interactive")
    @DELETE
    @Produces(value={"application/json"})
    public Response cleanSome(final @QueryParam(value="aList") String aList, @Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    Ambassador[] ambassadors = (Ambassador[])GroupAmbassadorsResource.this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Ambassador[]>(){

                        public Ambassador[] doInTransaction() {
                            return (Ambassador[])GroupAmbassadorsResource.this.activeObjects.find(Ambassador.class, Query.select().order("USER_NAME ASC"));
                        }
                    });
                    String[] ambassadorsList = aList.split(",");
                    int cleared = 0;
                    for (Ambassador a : ambassadors) {
                        if (GroupAmbassadorsResource.this.userManager.getUserProfile(a.getUserName()) != null || !Arrays.asList(ambassadorsList).contains(a.getUserName())) continue;
                        AmbassadorToGroup[] relationships = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, a);
                        if (relationships != null) {
                            for (AmbassadorToGroup r : relationships) {
                                String gname = r.getGroup().getGroupName();
                                GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{r});
                                AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                                log.setAuthor(remote_user);
                                log.setAmbassador(a.getUserName());
                                log.setGroup(gname);
                                log.setDate(new Date());
                                log.setAction("REVOKE");
                                log.save();
                            }
                        }
                        GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{a});
                        ++cleared;
                    }
                    return cleared;
                }
            });
            String state = status >= 0 ? "CLEARED_" + status.toString() : "UNKNOWN_ERROR";
            return Response.ok((Object)state).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/cleanup/clean/")
    @DELETE
    @Produces(value={"application/json"})
    public Response clean(@Context HttpServletRequest request) {
        final String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            Integer status = (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    AmbassadorToGroup[] relationships;
                    Ambassador[] ambassadors = (Ambassador[])GroupAmbassadorsResource.this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Ambassador[]>(){

                        public Ambassador[] doInTransaction() {
                            return (Ambassador[])GroupAmbassadorsResource.this.activeObjects.find(Ambassador.class, Query.select().order("USER_NAME ASC"));
                        }
                    });
                    ManagedGroup[] groups = (ManagedGroup[])GroupAmbassadorsResource.this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<ManagedGroup[]>(){

                        public ManagedGroup[] doInTransaction() {
                            return (ManagedGroup[])GroupAmbassadorsResource.this.activeObjects.find(ManagedGroup.class, Query.select().order("GROUP_NAME ASC"));
                        }
                    });
                    int ret = 0;
                    for (Ambassador a : ambassadors) {
                        if (GroupAmbassadorsResource.this.userManager.getUserProfile(a.getUserName()) != null) continue;
                        relationships = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, a);
                        if (relationships != null) {
                            for (AmbassadorToGroup r : relationships) {
                                String gname = r.getGroup().getGroupName();
                                GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{r});
                                AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                                log.setAuthor(remote_user);
                                log.setAmbassador(a.getUserName());
                                log.setGroup(gname);
                                log.setDate(new Date());
                                log.setAction("REVOKE");
                                log.save();
                                ++ret;
                            }
                        }
                        GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{a});
                    }
                    for (ManagedGroup g : groups) {
                        if (GroupAmbassadorsResource.this.getGroupObject(g.getGroupName()) != null) continue;
                        relationships = GroupAmbassadorsActiveObjectHelper.findRelationship(GroupAmbassadorsResource.this.activeObjects, g);
                        if (relationships != null) {
                            for (AmbassadorToGroup r : relationships) {
                                GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{r});
                                AmbassadorLog log = (AmbassadorLog)GroupAmbassadorsResource.this.activeObjects.create(AmbassadorLog.class, new DBParam[0]);
                                log.setAuthor(remote_user);
                                if (r.getAmbassador() != null) {
                                    log.setAmbassador(r.getAmbassador().getUserName());
                                }
                                log.setGroup(g.getGroupName());
                                log.setDate(new Date());
                                log.setAction("REVOKE");
                                log.save();
                            }
                        }
                        GroupAmbassadorsResource.this.activeObjects.delete(new RawEntity[]{g});
                    }
                    return ret;
                }
            });
            return Response.ok((Object)(switch (status) {
                case 0 -> "NOTHING_TO_CLEAR";
                default -> "CLEARED_ALL";
            })).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/cleanup/groups")
    @GET
    @Produces(value={"application/json"})
    public Response getGroupsForCleanup(@Context HttpServletRequest request) {
        String remote_user = this.userManager.getRemoteUser(request).getUsername();
        if (this.userManager.isAdmin(remote_user)) {
            ManagedGroup[] groups = (ManagedGroup[])this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<ManagedGroup[]>(){

                public ManagedGroup[] doInTransaction() {
                    return (ManagedGroup[])GroupAmbassadorsResource.this.activeObjects.find(ManagedGroup.class, Query.select().order("GROUP_NAME ASC"));
                }
            });
            ArrayList<GroupResourceModel> r = new ArrayList<GroupResourceModel>();
            for (ManagedGroup g : groups) {
                if (this.getGroupObject(g.getGroupName()) != null) continue;
                r.add(new GroupResourceModel(0, g.getGroupName()));
            }
            return Response.ok(r).build();
        }
        return Response.status((int)403).build();
    }

    @Path(value="/user/picker")
    @GET
    @Produces(value={"application/json"})
    public Response getUserPickerFeed(@Context HttpServletRequest request, @QueryParam(value="query") String query, @QueryParam(value="maxResults") int maxResults) {
        if (null == query || query.isEmpty()) {
            return Response.ok((Object)"Missing query parameter.").build();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ArrayList users = new ArrayList();
        int total = 0;
        int max = maxResults > 0 ? maxResults : 10;
        for (String username : this.userAccessor.getUserNames()) {
            if (username.toLowerCase().contains(query)) {
                if (total < max) {
                    HashMap<String, String> usr = new HashMap<String, String>();
                    usr.put("name", username);
                    usr.put("key", username);
                    usr.put("html", this.userAccessor.getUserByName(username).getFullName().replaceAll(query, "<strong>" + query + "</strong>"));
                    usr.put("displayName", this.userAccessor.getUserByName(username).getFullName());
                    usr.put("avatarUrl", this.userAccessor.getUserProfilePicture((User)this.userAccessor.getUserByName(username)).getUriReference());
                    users.add(usr);
                }
                ++total;
            }
            ret.put("users", users);
            ret.put("total", total);
            ret.put("header", "Showing " + users.size() + " of " + total + " matching users.");
        }
        return Response.ok(ret).build();
    }

    @Path(value="/groups/picker")
    @GET
    @Produces(value={"application/json"})
    public Response getGroupPickerFeed(@Context HttpServletRequest request, @QueryParam(value="query") String query, @QueryParam(value="maxResults") int maxResults) {
        if (null == query || query.isEmpty()) {
            return Response.ok((Object)"Missing query parameter.").build();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ArrayList groups = new ArrayList();
        int total = 0;
        int max = maxResults > 0 ? maxResults : 10;
        for (Group group : this.userAccessor.getGroups()) {
            if (group.getName().toLowerCase().contains(query)) {
                if (total < max) {
                    HashMap<String, String> grp = new HashMap<String, String>();
                    grp.put("name", group.getName());
                    grp.put("html", group.getName().replaceAll(query, "<strong>" + query + "</strong>"));
                    groups.add(grp);
                }
                ++total;
            }
            ret.put("groups", groups);
            ret.put("total", total);
            ret.put("header", "Showing " + groups.size() + " of " + total + " matching groups.");
        }
        return Response.ok(ret).build();
    }

    public static String unprep(String prepared) {
        try {
            return URLDecoder.decode(prepared.replaceAll("___", "%2F").replaceAll("@@@", "%5C").replaceAll("_-_-", "'"), "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    private Group getGroupObject(String groupname) {
        try {
            return this.groupManager.getGroup(groupname);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private User getUserObject(String username) {
        try {
            return this.userAccessor.getUserByName(username);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private List<User> getUsersInGroup(Group g) {
        try {
            ArrayList<User> ret = new ArrayList<User>();
            for (String username : this.groupManager.getMemberNames(g)) {
                ConfluenceUser u = this.userAccessor.getUserByName(username);
                if (u == null) continue;
                ret.add((User)u);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private List<Group> getGroupsForUser(User u) {
        try {
            ArrayList<Group> ret = new ArrayList<Group>();
            for (Group g : this.groupManager.getGroups(u)) {
                ret.add(g);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private ConfluenceUser getAdminName() {
        return this.userAccessor.getUserByName((String)this.userAccessor.getMemberNamesAsList(this.userAccessor.getGroup("confluence-administrators")).get(0));
    }
}

