/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.rest;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Entity;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.caritteprod.group.ambassadors.conf.rest.UserResourceModel;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="ambassadors")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AmbassadorResourceModel {
    private static final Logger logger = LoggerFactory.getLogger(UserResourceModel.class);
    private static final UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    @XmlElement(name="id")
    private Integer id;
    @XmlElement(name="username")
    private String username;
    @XmlElement(name="fullname")
    private String fullname;
    @XmlElement(name="email")
    private String email;
    @XmlElement(name="directory")
    private String directory;
    @XmlElement(name="groups")
    private List<String> groups;
    @XmlElement(name="isRevokable")
    private boolean isRevokable;

    public AmbassadorResourceModel() {
    }

    public AmbassadorResourceModel(Integer id, String username) {
        this.id = id;
        ConfluenceUser usr = userAccessor.getUserByName(username);
        CrowdService cs = (CrowdService)ContainerManager.getComponent((String)"crowdService");
        UserManager um = (UserManager)ContainerManager.getComponent((String)"userManager");
        try {
            this.directory = um.getRepository((Entity)usr).getName() + " [" + um.getRepository((Entity)usr).getKey() + "]";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        this.username = userAccessor.isDeactivated((User)usr) ? "<del>" + usr.getName() + "</del> (inactive)" : usr.getName();
        this.fullname = userAccessor.isDeactivated((User)usr) ? "<del>" + usr.getFullName() + "</del>" : usr.getFullName();
        this.email = usr == null ? "User not retrieved" : usr.getEmail();
    }

    public AmbassadorResourceModel(Integer id, String username, boolean revokable) {
        this(id, username);
        this.isRevokable = revokable;
    }

    public AmbassadorResourceModel(Integer id, String username, List<String> groups) {
        this(id, username);
        this.groups = groups;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public boolean isRevokable() {
        return this.isRevokable;
    }

    public void setRevokable(boolean revokable) {
        this.isRevokable = revokable;
    }
}

