/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.GroupManager;
import com.caritteprod.group.ambassadors.conf.ao.Ambassador;
import com.caritteprod.group.ambassadors.conf.ao.AmbassadorToGroup;
import com.caritteprod.group.ambassadors.conf.ao.GroupPolicy;
import com.caritteprod.group.ambassadors.conf.ao.ManagedGroup;
import com.caritteprod.group.ambassadors.conf.ao.Setting;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAmbassadorsActiveObjectHelper {
    private static final Logger log = LoggerFactory.getLogger(GroupAmbassadorsActiveObjectHelper.class);

    public static Ambassador findAmbassador(ActiveObjects activeObjects, String username) {
        Ambassador[] ambRes = (Ambassador[])activeObjects.find(Ambassador.class, Query.select().where("USER_NAME = ?", new Object[]{username.toLowerCase()}));
        if (ambRes != null && ambRes.length > 0) {
            return ambRes[0];
        }
        return null;
    }

    public static Ambassador findAmbassador2(ActiveObjects activeObjects, String username) {
        Ambassador[] ambRes = (Ambassador[])activeObjects.find(Ambassador.class, Query.select());
        if (ambRes != null && ambRes.length > 0) {
            for (Ambassador a : ambRes) {
                if (!a.getUserName().equalsIgnoreCase(username.toLowerCase())) continue;
                return a;
            }
        }
        return null;
    }

    public static ManagedGroup findManagedGroup(ActiveObjects activeObjects, String groupname) {
        ManagedGroup[] groupRes = (ManagedGroup[])activeObjects.find(ManagedGroup.class, Query.select().where("GROUP_NAME = ?", new Object[]{groupname}));
        if (groupRes != null && groupRes.length > 0) {
            return groupRes[0];
        }
        return null;
    }

    public static AmbassadorToGroup findRelationship(ActiveObjects activeObjects, Ambassador ambassador, ManagedGroup group) {
        AmbassadorToGroup[] relationships = (AmbassadorToGroup[])activeObjects.find(AmbassadorToGroup.class, Query.select().where("AMBASSADOR_ID = ? AND GROUP_ID = ?", new Object[]{ambassador.getID(), group.getID()}));
        if (relationships != null && relationships.length > 0) {
            return relationships[0];
        }
        return null;
    }

    public static AmbassadorToGroup[] findRelationship(ActiveObjects activeObjects, Ambassador ambassador) {
        AmbassadorToGroup[] relationships = (AmbassadorToGroup[])activeObjects.find(AmbassadorToGroup.class, Query.select().where("AMBASSADOR_ID = ?", new Object[]{ambassador.getID()}));
        if (relationships != null && relationships.length > 0) {
            return relationships;
        }
        return null;
    }

    public static AmbassadorToGroup[] findRelationship(ActiveObjects activeObjects, ManagedGroup group) {
        AmbassadorToGroup[] relationships = (AmbassadorToGroup[])activeObjects.find(AmbassadorToGroup.class, Query.select().where("GROUP_ID = ?", new Object[]{group.getID()}));
        if (relationships != null && relationships.length > 0) {
            return relationships;
        }
        return null;
    }

    public static GroupPolicy[] findPolicies(ActiveObjects activeObjects, int page) {
        GroupPolicy[] grpRes = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().order("GROUP ASC").limit(20).offset((page - 1) * 20));
        if (grpRes != null && grpRes.length > 0) {
            return grpRes;
        }
        return null;
    }

    public static GroupPolicy findGroupPolicy(ActiveObjects activeObjects, String group, String policy, String policy_entity_type, String policy_entity_value) {
        GroupPolicy[] grpRes = policy.equalsIgnoreCase("DENY") ? (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{policy, group})) : (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ? AND POLICY_ENTITY_TYPE = ? AND POLICY_ENTITY_VALUE = ?", new Object[]{policy, group, policy_entity_type, policy_entity_value}));
        if (grpRes != null && grpRes.length > 0) {
            return grpRes[0];
        }
        return null;
    }

    public static boolean policyCrossCheck(ActiveObjects activeObjects, String group, String policy) {
        GroupPolicy[] grpRes = policy.equalsIgnoreCase("DENY") ? (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"RESTRICT", group})) : (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"DENY", group}));
        return grpRes != null && grpRes.length > 0;
    }

    public static boolean isGroupBrowsable(ActiveObjects activeObjects, String group, String username) {
        if (GroupAmbassadorsActiveObjectHelper.checkSetting(activeObjects, "GROUP_BROWSING", "DISABLED") == 1) {
            return false;
        }
        GroupPolicy[] grpRes = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"DENY", group}));
        GroupPolicy[] grpResAll = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"DENY", "*_ALLGROUPS_*"}));
        if (grpRes != null && grpRes.length > 0 || grpResAll != null && grpResAll.length > 0) {
            return false;
        }
        GroupPolicy[] grpRest = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"RESTRICT", group}));
        GroupPolicy[] grpRestAll = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"RESTRICT", "*_ALLGROUPS_*"}));
        if (grpRest != null && grpRest.length > 0 || grpRestAll != null && grpRestAll.length > 0) {
            GroupPolicy[] grpRestUser;
            log.error("In big IF");
            if (grpRestAll != null && grpRestAll.length > 0) {
                group = "*_ALLGROUPS_*";
            }
            if ((grpRestUser = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ? AND POLICY_ENTITY_TYPE = ? AND POLICY_ENTITY_VALUE = ?", new Object[]{"RESTRICT", group, "USER", username}))) != null && grpRestUser.length > 0) {
                return true;
            }
            GroupPolicy[] grpRestGroups = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ? AND POLICY_ENTITY_TYPE = ?", new Object[]{"RESTRICT", group, "GROUP"}));
            if (grpRestGroups != null && grpRestGroups.length > 0) {
                GroupManager gm = (GroupManager)ContainerManager.getComponent((String)"groupManager");
                for (GroupPolicy gp : grpRestGroups) {
                    try {
                        for (String name : gm.getMemberNames(gm.getGroup(gp.getPolicyEntityValue()))) {
                            if (!name.equalsIgnoreCase(username)) continue;
                            return true;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean canNominate(ActiveObjects activeObjects, String user, String group) {
        Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador(activeObjects, user);
        if (amb != null && GroupAmbassadorsActiveObjectHelper.checkSetting(activeObjects, "SUPER_POWERS", "DISABLED") < 1) {
            for (ManagedGroup grp : amb.getManagedGroups()) {
                if (!grp.getGroupName().equalsIgnoreCase(group)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canRevoke(ActiveObjects activeObjects, String user, String group) {
        Ambassador amb = GroupAmbassadorsActiveObjectHelper.findAmbassador(activeObjects, user);
        if (amb != null && GroupAmbassadorsActiveObjectHelper.checkSetting(activeObjects, "EXT_SUPER_POWERS", "DISABLED") < 1) {
            for (ManagedGroup grp : amb.getManagedGroups()) {
                if (!grp.getGroupName().equalsIgnoreCase(group)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGroupRestricted(ActiveObjects activeObjects, String group) {
        GroupPolicy[] grpRes = (GroupPolicy[])activeObjects.find(GroupPolicy.class, Query.select().where("POLICY = ? AND GROUP = ?", new Object[]{"RESTRICT", group}));
        return grpRes != null && grpRes.length > 0;
    }

    public static int checkSetting(ActiveObjects activeObjects, String key, String value) {
        Setting[] setRes = (Setting[])activeObjects.find(Setting.class, Query.select().where("KEY = ? OR KEY = ?", new Object[]{key, key.toLowerCase()}));
        if (setRes != null && setRes.length > 0) {
            return value.equalsIgnoreCase(setRes[0].getValue()) ? 1 : 0;
        }
        Setting s = (Setting)activeObjects.create(Setting.class, new DBParam[0]);
        s.setKey(key);
        s.setValue(value);
        s.save();
        return 2;
    }
}

