/*
 * Decompiled with CFR 0.152.
 */
package com.caritteprod.group.ambassadors.conf.admin;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.caritteprod.group.ambassadors.conf.ao.GroupAmbassadorsActiveObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupAmbassadorsSettings
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(GroupAmbassadorsSettings.class);
    private final PluginLicenseManager plm;
    private final ActiveObjects activeObjects;

    @Autowired
    public GroupAmbassadorsSettings(@ComponentImport PluginLicenseManager plm, @ComponentImport ActiveObjects activeObjects) {
        this.plm = plm;
        this.activeObjects = activeObjects;
    }

    public String execute() throws Exception {
        return "group-ambassadors-admin-settings-success";
    }

    public String generateGroupBrowsingOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "GROUP_BROWSING", "ENABLED") >= 1 ? " checked" : "";
    }

    public String generateAdvancedLoggingOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "ADVANCED_LOGGING", "DISABLED") >= 1 ? "" : " checked";
    }

    public String generateSelfPromoteOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "SELF_PROMOTE", "ENABLED") >= 1 ? " checked" : "";
    }

    public String generateExtendedBrowsingOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "EXTENDED_BROWSING", "DISABLED") >= 1 ? "" : " checked";
    }

    public String generateSuperPowersOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "SUPER_POWERS", "DISABLED") >= 1 ? "" : " checked";
    }

    public String generateExtSuperPowersOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "EXT_SUPER_POWERS", "DISABLED") >= 1 ? "" : " checked";
    }

    public String generateUserGroupsOption() {
        return GroupAmbassadorsActiveObjectHelper.checkSetting(this.activeObjects, "USER_GROUPS", "DISABLED") >= 1 ? "" : " checked";
    }

    public String checkLicense() {
        String ret = "none";
        if (this.plm.getLicense().isDefined()) {
            PluginLicense pl = (PluginLicense)this.plm.getLicense().get();
            if (pl.getError().isDefined()) {
                ret = "block";
            }
        } else {
            ret = "block";
        }
        return ret;
    }
}

