/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.compat.struts2.actioncontext;

import aQute.bnd.annotation.component.Component;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompat;
import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextStruts2;
import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextStruts6;
import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextWW;
import io.atlassian.util.concurrent.Lazy;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ActionContextCompatManager
implements ActionContextCompat {
    private static final Logger log = LoggerFactory.getLogger(ActionContextCompatManager.class);
    public static final String WW_ACTION_CONTEXT = "com.opensymphony.xwork.ActionContext";
    public static final String STRUTS_ACTION_CONTEXT = "com.opensymphony.xwork2.ActionContext";
    private final Supplier<ActionContextCompat> delegate = Lazy.supplier(() -> this.initialiseActionContextCompat(classLoader));

    public ActionContextCompatManager() {
        this(ActionContextCompatManager.class.getClassLoader());
    }

    public ActionContextCompatManager(ClassLoader classLoader) {
    }

    private ActionContextCompat initialiseActionContextCompat(ClassLoader classLoader) {
        try {
            Class<?> strutsActionContext = Class.forName(STRUTS_ACTION_CONTEXT, false, classLoader);
            try {
                strutsActionContext.getMethod("of", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return new ActionContextStruts2(classLoader);
                }
                catch (ReflectiveOperationException ex) {
                    throw new ServiceException("Struts2 ActionContext couldn't be initialized.", (Throwable)ex);
                }
            }
            try {
                return new ActionContextStruts6(classLoader);
            }
            catch (ReflectiveOperationException ex) {
                throw new ServiceException("Struts6 ActionContext couldn't be initialized.", (Throwable)ex);
            }
        }
        catch (ClassNotFoundException e) {
            try {
                return new ActionContextWW(classLoader);
            }
            catch (ReflectiveOperationException ex) {
                throw new ServiceException("WebWork ActionContext couldn't be initialized.", (Throwable)ex);
            }
        }
    }

    @VisibleForTesting
    String getDelegateClassName() {
        return this.delegate.get().getClass().getName();
    }

    @Override
    public void setApplication(Map<String, ?> application) {
        try {
            this.delegate.get().setApplication(application);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the Application");
        }
    }

    @Override
    public Map<?, ?> getApplication() {
        try {
            return this.delegate.get().getApplication();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the Application");
            return null;
        }
    }

    @Override
    public void setContextMap(Map<String, ?> contextMap) {
        try {
            this.delegate.get().setContextMap(contextMap);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the ContextMap");
        }
    }

    @Override
    public Map<?, ?> getContextMap() {
        try {
            return this.delegate.get().getContextMap();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the ContextMap");
            return null;
        }
    }

    @Override
    public void setConversionErrors(Map<String, ?> conversionErrors) {
        try {
            this.delegate.get().setConversionErrors(conversionErrors);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the ConversionErrors");
        }
    }

    @Override
    public Map<?, ?> getConversionErrors() {
        try {
            return this.delegate.get().getConversionErrors();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the ConversionErrors");
            return null;
        }
    }

    @Override
    public void setLocale(Locale locale) {
        try {
            this.delegate.get().setLocale(locale);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the Locale");
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return this.delegate.get().getLocale();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the Locale");
            return null;
        }
    }

    @Override
    public void setName(String name) {
        try {
            this.delegate.get().setName(name);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the Name");
        }
    }

    @Override
    public String getName() {
        try {
            return this.delegate.get().getName();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the Name");
            return null;
        }
    }

    @Override
    public void setParameters(Map<String, ?> parameters) {
        try {
            this.delegate.get().setParameters(parameters);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the Parameters");
        }
    }

    @Override
    public Map<?, ?> getParameters() {
        try {
            return this.delegate.get().getParameters();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the Parameters");
            return null;
        }
    }

    @Override
    public void setSession(Map<String, ?> session) {
        try {
            this.delegate.get().setSession(session);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the Session");
        }
    }

    @Override
    public Map<?, ?> getSession() {
        try {
            return this.delegate.get().getSession();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the Session");
            return null;
        }
    }

    @Override
    public Object get(String key) {
        try {
            return this.delegate.get().get(key);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the value");
            return null;
        }
    }

    @Override
    public void put(String key, Object value) {
        try {
            this.delegate.get().put(key, value);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't pet the value");
        }
    }
}

