(function ($) {
	
	if (ThemePress.Browser.mobile) return;

	ThemePress.PageTab = {
		
		designerFocusCookie: "com.brikit.designer.page.focus",
		
		addBlock: function () {
			return ThemePress.PageTab.addElement(this, "block");
		},

		addColumn: function () {
			return ThemePress.PageTab.addElement(this, "column");
		},

        addElement: function(element, elementType, data = {}) {
			ThemePress.PageTab.clearFocusState();
			$("span", element).removeClass("aui-iconfont-add").addClass("waiting");
			const $positionSelection = $(element).closest(".group").find("." + elementType + "-position .aui-button[aria-pressed='true']");
			if ($positionSelection.hasClass("after")) data.after = true;
			if ($positionSelection.hasClass("duplicate")) data.duplicate = true;
			ThemePress.post($(element).attr("href"), data, ThemePress.PageTab.updateForAdd, "json");
            return false;
        },

		addLayer: function () {
			var $layerSelection = $(this).closest(".group").find(".layer-selector .aui-button[aria-pressed='true']");
            const data = {layerType: "layer-" + $layerSelection.data("layer")}
			return ThemePress.PageTab.addElement(this, "layer", data);
		},
        
		ajaxDesignerCall: function (data) {
			ThemePress.post(ThemePress.contextPath + "/plugins/brikit/pages/apply.action", data, ThemePress.PageTab.designUpdateResponse, "json");
		},

		applyChange: function () {
			var data = ThemePress.PageTab.dataForChange(this);
			ThemePress.PageTab.ajaxDesignerCall(data);
		},
		
		applyChangeWithReturn: function (event) {
			var keypress = event.which;
			if (keypress == 13) {
				ThemePress.PageTab.applyChange.call(this);
				return false;
			}
		},
		
		applyWithReturn: function (event, callback) {
			var keypress = event.which;
			if (keypress == 13) {
				callback.call(this);
				return false;
			}
		},
		
		asynchronousLoadChanged: function () {
			var data = ThemePress.PageTab.dataForChange(this);
			ThemePress.post(ThemePress.contextPath + "/plugins/brikit/pages/deferredloadchange.action", data, ThemePress.PageTab.designUpdateResponse, "json");
		},
		
		autoSizeTextareas: function () {
			if (ThemePress.Designer.isPageMode()) ThemePress.Designer.autoSizeTextareas(ThemePress.PageTab.focusedElementToggle());
		},
		
		blockPositionChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			$(this).closest(".block-position").find(".aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			return false;
		},
		
		cacheRenderedPageChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = this.checked;
			ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/pages/setcacherenderedpage.action",
				data,
				ThemePress.PageTab.updateForCacheRenderedPageChange, 
				"json"
			);
			return false;
		},
		
		convertForMobileChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = this.checked;
			ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/pages/setconvertformobile.action",
				data,
				ThemePress.PageTab.updateForConvertForMobile, 
				"json"
			);
			return false;
		},
		
		clearFocusState: function () {
			ThemePress.PageTab.saveFocusState(null);
		},

		columnPositionChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			$(this).closest(".column-position").find(".aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			return false;
		},

		dataForChange: function (changedElement) {
			var value = $(changedElement).val();
			if ($(changedElement).attr("type") == "checkbox") value = changedElement.checked;
			var $panel = $(changedElement).closest(".brikit-designer-layer, .brikit-designer-layer-container, .brikit-designer-column, .brikit-designer-block");
			var data = {
				pageId: ThemePress.pageId,
				elementType: $panel.data("element-type"), 
				elementId: $panel.data("id"),
				containerName: $panel.data("container"),
				name: $(changedElement).attr("name"), 
				value: value,
				reload: $(changedElement).hasClass("reload-page")
			};
			return data;
		},
		
		// Return the layer, column, and blocks on the page that can be designed
		designableElements: function () {
			return $(".designable-element");
		},

		designerModeWillChange: function () {
			if (!ThemePress.Designer.designerInitialized) return;
			if (ThemePress.Designer.isPageMode() && ThemePress.PageTab.focusState()) ThemePress.Focus.showFocusBlanket();
		},
		
		designUpdateElements: function (elements) {
			// Process any element updates
			$(elements).each(function () {
				var $element = $("#content-" + this.type + "-" + this.id);
				$.map(this.css, function(value, name) {
					value = ThemePress.html.toRGB(value);	// Convert any palette colors to CSS values
					$element.css(name, value);
				});
				ThemePress.PageTab.designUpdateElements(this.contains);
			});
		},
		
		designUpdateResponse: function (data, textStatus, jqXHR) {
			if (data.success) {
				// console.log(data);
				if (data.reload) return ThemePress.Designer.messageUser("Page updated", true);
				
				// Update the explicit value that changed
				var $element = $(".brikit-content-layers #content-" + data.elementType + "-" + data.elementId);
				if (data.container) $element = $element.find(data.container).find(".brikit-container-content, .brikit-architect-container-content");
				var value = ThemePress.html.toRGB(data.value);	// Convert any palette colors to CSS values
				$element.css(data.name, value);
				
				// Process any element updates
				ThemePress.PageTab.designUpdateElements(data.elements);

				// Special nasty handling of gradients requires reload
				if (data.name.indexOf("gradient-") == 0) ThemePress.Designer.messageUser("Page updated", true);
				else ThemePress.Focus.updateFocusBlanket();
			}
			else {
				alert(data.message);
			}
			
		},
		
		doNotAddFakeLayerChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = this.checked;
            ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/pages/setdonotaddfakelayer.action",
				data,
				ThemePress.PageTab.updateForDoNotAddFakeLayerChanged, 
				"json"
			);
			return false;
		},

		elementSelector: function (element) {
			return $(element).data("selector");
		},

		focus: function () {
			if (!ThemePress.Designer.openState()) return;

			if ($(this).hasClass("closed") || $(this).closest(".accordion-switch").hasClass("closed")) {
				ThemePress.Focus.hideFocusBlanket();
				ThemePress.PageTab.clearFocusState();
			}
			else {
				var selector = ThemePress.PageTab.elementSelector(this);

				// For blocks that are tabbed, make sure they're visible before trying to focus on them
				ThemePress.Tabs.clickTab(selector);

				ThemePress.PageTab.saveFocusState(selector);
				ThemePress.Focus.showFocusBlanket();
			}
	    },
	
		focusedElement: function () {
			return $(ThemePress.PageTab.focusState());
		},
		
		focusedElementToggle: function () {
			return ThemePress.PageTab.pageElementAccordions(ThemePress.PageTab.focusState());
		},
	
		focusState: function () {
			return ThemePress.cookie(ThemePress.PageTab.designerFocusCookie);
		},
		
		imagePreviewAttachment: function () {
			var $propertyField = $(this).closest(".property-field-group").find(".image-field");
			var updateImage = function (dialog, imageName) {
				$propertyField.val(imageName);
				ThemePress.PageTab.applyChange.call($propertyField);
				dialog.remove();
				if (!ThemePress.Designer.shouldReloadOnChange($propertyField)) ThemePress.Designer.reloadDesigner();
			};
			AJS.InlineDialog(
				$(this), 
				"imagePreview" + new Date().getTime(),
				ThemePress.contextPath + "/plugins/brikit/pages/selectimage.action?key=" + encodeURIComponent(ThemePress.spaceKey) +
					"&pageId=" + ThemePress.pageId + "&imageName=" + encodeURIComponent($(this).data("image")) + ThemePress.atlTokenParam(true), 
				{
					onHover: false, 
					width: 400, 
					arrowOffsetX: 8,
					offsetX: -10,
					showDelay: 0, 
					initCallback: function () {
						var $popup = $(this.popup);
						$popup.css({zIndex: 10000});
						// Make the tooltips use the fancy AUI decoration
						$(".image-list .image", $popup).tooltip({aria:true});
						$(".image-list", $popup).on("click", ".image", function () {
							updateImage($popup, $(this).data("image"));
						});
						// Zap the "remove" icons from images that are used by the page contents
						var $imagesInUse = ThemePress.PageTab.pageElementAccordions().find(".attached-image input.image-field").map(function () { return $(this).val() });
						$(".image-list .image .remove").filter(function () { return $.inArray($(this).closest(".image").data("image"), $imagesInUse) != -1; }).remove();
						// Wire the "remove" icons
						$(".image-list .image").on("click", ".remove", function () {
							var imageName = $(this).closest(".image").data("image");
                            const data = {pageId: ThemePress.pageId, imageName: imageName};
							ThemePress.Dialog2.confirm("<p>Delete the attachment " + imageName + " from the page?</p><p>This cannot be undone.</p>", { title: "Delete Image" }, function (dialog) {
								dialog.hide();
								ThemePress.post(ThemePress.contextPath + "/plugins/brikit/pages/removeimage.action", 
									data,
									function () { ThemePress.Designer.messageUser("Image removed", true); }
								);
							});
							return false;
						});
						
						// When the file upload filename changes, automagically upload and apply the file to the current image field
						$("form.uploader .upfile", $popup).change(function () { $(this).closest("form.uploader").submit(); });
						
						// Make the file upload form work via ajax (using the jquery.form plugin)
						$("form.uploader", $popup).ajaxForm(function () {
							var filename = $("form.uploader .upfile", $popup).val().split('\\').pop();
							updateImage($popup, filename);
						});
					}
				}
			);
		},
		
		imagePreviewTheme: function () {
			var $propertyField = $(this).closest(".property-field-group").find(".image-field");
			var updateImage = function (dialog, imageName) {
				$propertyField.val(imageName);
				ThemePress.PageTab.applyChange.call($propertyField);
				dialog.remove();
				if (!ThemePress.Designer.shouldReloadOnChange($propertyField)) ThemePress.Designer.reloadDesigner();
			};
			var dialog = AJS.InlineDialog(
				$(this), 
				"imagePreview" + new Date().getTime(),
				ThemePress.contextPath + "/plugins/brikit/designer/selectimage.action?key=" + encodeURIComponent(ThemePress.spaceKey) +
					"&pageId=" + ThemePress.pageId + "&imageName=" + encodeURIComponent($(this).data("image")) + ThemePress.atlTokenParam(true), 
				{
					onHover: false, 
					width: 400, 
					arrowOffsetX: 8,
					offsetX: -10,
					showDelay: 0, 
					initCallback: function () {
						var $popup = $(this.popup);
						$popup.css({zIndex: 10000});
						// Make the tooltips use the fancy AUI decoration
						$(".image-list .image", $popup).tooltip({aria:true});
						$(".image-list", $popup).on("click", ".image", function () {
							updateImage($popup, $(this).data("image"));
						});
						// Zap the "remove" icons from images that are used by the theme
						var $imagesInUse = ThemePress.Designer.designForm().find("input.image-field").map(function () { return $(this).val() });
						$(".image-list .image .remove").filter(function () { return $.inArray($(this).closest(".image").data("image"), $imagesInUse) != -1; }).remove();
						// Wire the "remove" icons
						$(".image-list .image").on("click", ".remove", function () {
							var imageName = $(this).closest(".image").data("image");
							ThemePress.Dialog2.confirm("<p>Remove " + imageName + " from the theme?</p><p>This cannot be undone.</p>", { title: "Delete Image" }, function (dialog) {
								dialog.hide();
                                const data = {key: ThemePress.spaceKey, imageName: imageName};
                                ThemePress.post(ThemePress.contextPath + "/plugins/brikit/designer/removeimage.action", 
									data,
									function () { ThemePress.Designer.messageUser("Image removed", true); }
								);
							});
							return false;
						});
						
						// When the file upload filename changes, automagically upload and apply the file to the current image field
						$("form.uploader .upfile", $popup).change(function () { $(this).closest("form.uploader").submit(); });
						
						// Make the file upload form work via ajax (using the jquery.form plugin)
						$("form.uploader", $popup).ajaxForm(function () {
							var filename = $("form.uploader .upfile", $popup).val().split('\\').pop();
							updateImage($popup, filename);
						});
					}
				}
			);
		},
		
		// Called only after the designer is loaded into the page from the server
		initializeAfterLoad: function (speed) {
			
			// Wire the add layer, column, and block buttons
			ThemePress.PageTab.pageElementAccordions().on("click", ".layer-selector .aui-button", ThemePress.PageTab.layerSelectorChanged);
			ThemePress.PageTab.pageElementAccordions().on("click", ".layer-position .aui-button", ThemePress.PageTab.layerPositionChanged);
			ThemePress.PageTab.pageElementAccordions().on("click", ".add-layer", ThemePress.PageTab.addLayer);

			ThemePress.PageTab.pageElementAccordions().on("click", ".column-position .aui-button", ThemePress.PageTab.columnPositionChanged);
			ThemePress.PageTab.pageElementAccordions().on("click", ".add-column", ThemePress.PageTab.addColumn);

			ThemePress.PageTab.pageElementAccordions().on("click", ".block-position .aui-button", ThemePress.PageTab.blockPositionChanged);
			ThemePress.PageTab.pageElementAccordions().on("click", ".add-block", ThemePress.PageTab.addBlock);
			
			// Wire the remove layer, column, and block buttons
			ThemePress.PageTab.pageElementAccordions().on("click", ".remove-layer", ThemePress.PageTab.removeLayer);
			ThemePress.PageTab.pageElementAccordions().on("click", ".remove-column", ThemePress.PageTab.removeColumn);
			ThemePress.PageTab.pageElementAccordions().on("click", ".remove-block", ThemePress.PageTab.removeBlock);
			
			// Wire the visibility multi-select
			ThemePress.PageTab.pageDesignerElement(".category-multi-select").initializeSpaceCategoryMultiSelect().each(function () {
				$(this).data("properties", { pageId: ThemePress.pageId });
			});

			// Set up accordion elements
			ThemePress.PageTab.pageElementAccordions()
				// Turn on the accordion feature of the list so only one element is open at a time
				.brikitAccordion(false, true, ".clickable-control", ".designer-panel", function () { $(this).find(".designer-panel textarea").autoSizingTextarea(); })
				.accordionSpeed("fast");

			// Make each accordian element click to focus the designer on it
			ThemePress.PageTab.pageElementAccordions().on("click", ".clickable-control", ThemePress.PageTab.focus);
			ThemePress.PageTab.pageElementAccordions().find(".clickable-control").each(function () {
				var selector = ThemePress.PageTab.elementSelector(this);
				$(selector)
					.addClass("designable")
					.attr("data-selector", selector);
			});

			// Open the accordion element that was last open (if any)
			if (ThemePress.Designer.isPageMode()) ThemePress.PageTab.pageElementAccordions(ThemePress.PageTab.focusState()).click();
			
			// Make hovering over layers, columns, and blocks highlight the corresponding accordion element
			// TODO: investigate hover => .on
			ThemePress.PageTab.designableElements().hover(ThemePress.PageTab.lightOnAccordion, ThemePress.PageTab.lightOffAccordion);

			// Wire the text input fields and text areas to apply changes to the theme
			// TODO: investigate change => .on
			ThemePress.PageTab.pageElementAccordions().on("keypress", "input:not(#brikitContentContainerDefaultWidth):not(.group-multi-select-search-field)", ThemePress.PageTab.applyChangeWithReturn);
			ThemePress.PageTab.pageElementAccordions().on("change", "input:not(#brikitContentContainerDefaultWidth):not(#brikitPresentationMode):not(#brikitSectionsDefineLayout), textarea, select", ThemePress.PageTab.applyChange);

			// Wire the override-default-page-layout toggle
			ThemePress.PageTab.pageDesignerElement(".layout-selector").on("click", ".aui-button", ThemePress.PageTab.overrideDefaultLayoutChanged);
			ThemePress.PageTab.pageDesignerElement(".architect-source-select input.radio").unbind().change(ThemePress.PageTab.layoutPageSelectionChanged);
			ThemePress.PageTab.pageDesignerElement(".architect-source-select .radio label").unbind().click(ThemePress.PageTab.layoutPageSelectionChanged);
			// TODO: investigate unbind => .off & change => .on
			ThemePress.PageTab.pageDesignerElement(".override-layout-form input, .override-layout-form select").unbind().change(ThemePress.PageTab.layoutOptionChanged);
			
			// Wire the layout content container options
			ThemePress.PageTab.pageDesignerElement("#brikitContentContainerDefaultWidth")
				.unbind()
				.keypress(function (e) { ThemePress.PageTab.applyWithReturn.call(this, e, ThemePress.PageTab.layoutContentContainerOptionChanged); } )
				.change(ThemePress.PageTab.layoutContentContainerOptionChanged);
			
			// Wire the rendering and caching options (for banner, header, menu, footer)
			ThemePress.PageTab.pageDesignerElement("#brikitDoNotAddFakeLayer").unbind().change(ThemePress.PageTab.doNotAddFakeLayerChanged);
			ThemePress.PageTab.pageDesignerElement("#brikitRenderInPageContext").unbind().change(ThemePress.PageTab.renderContextChanged);
			ThemePress.PageTab.pageDesignerElement("#brikitDoNotCacheRenderedPage").unbind().change(ThemePress.PageTab.cacheRenderedPageChanged);
			ThemePress.PageTab.pageDesignerElement("#brikitCacheRenderedPage").unbind().change(ThemePress.PageTab.instantPageCacheChanged);
			ThemePress.PageTab.pageDesignerElement("#brikitDoNotConvertForMobile").unbind().change(ThemePress.PageTab.convertForMobileChanged);
			ThemePress.PageTab.pageDesignerElement("#brikitMultiLevelMenu").unbind().change(ThemePress.PageTab.multiLevelMenuChanged);

			// Wire the deferred loading block option
			ThemePress.PageTab.pageDesignerElement("#asynchronous-load").unbind().change(ThemePress.PageTab.asynchronousLoadChanged);

			// Initialize the color picker fields
			ThemePress.PageTab.pageElementAccordions().find(".color").beColorPicker();
			
			// Set up the image preview popups
			ThemePress.PageTab.pageElementAccordions().find(".theme-image a.image-thumbnail").each(ThemePress.PageTab.imagePreviewTheme);
			ThemePress.PageTab.pageElementAccordions().find(".attached-image a.image-thumbnail").each(ThemePress.PageTab.imagePreviewAttachment);
			
			// Wire the links to go back and forth from mobile and desktop page views
			ThemePress.PageTab.pageDesignerElement(".mobile-page-link").click(ThemePress.PageTab.switchMobileView);
			
			// Wire the link to load layout usage
			ThemePress.PageTab.pageDesignerElement("#find-layout-pages").click(ThemePress.PageTab.loadLayoutUsage);
			
			// Stop the designer form from submitting; it gets ajax-ed one field at a time
			ThemePress.PageTab.pageElementAccordions().find("form").submit(function () { return false; });
			
			// If blocks on the page are showing because no page frame block is available for them, change the expander to display a message
			ThemePress.PageTab.pageDesignerElement(".brikit-designer-block").each(function () {
				if (!$(".unframed#content-block-" + $(this).data("id")).length) return;
				$(this).closest("td").find(".clickable-control").addClass("content-not-shown");
				$(this).closest(".accordion-content").empty().append($("<div>").addClass("aui-message").append(ThemePress.getText("com.brikit.themepress.block.not.shown.because.no.space.on.page.frame")));
			});

		},
		
		instantPageCacheChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = this.checked;
            ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/pages/setinstantpagecache.action",
				data,
				ThemePress.PageTab.updateForInstantPageCacheChange, 
				"json"
			);
			return false;
		},
		
		layerPositionChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			$(this).closest(".layer-position").find(".aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			$(this).closest(".new-layer").find(".layer-selector .aui-button").adjustAttr("aria-disabled", "true", $(this).hasClass("duplicate"));
			return false;
		},

		layerSelectorChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			$(this).closest(".layer-selector").find(".aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			return false;
		},
		
		layoutContentContainerOptionChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = $(this).val();
            ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/layout/setcontainerwidth.action",
				data,
				ThemePress.PageTab.updateForContainerOptionChange, 
				"json"
			);
			return false;
		},

		layoutOptionChanged: function () {
			var data = { pageId: ThemePress.pageId };
			ThemePress.PageTab.pageDesignerElement(".override-layout-form select").each(function () { data[$(this).attr("name")] = $("option:selected", this).val(); });
			ThemePress.PageTab.pageDesignerElement(".override-layout-form input").each(function () { data[$(this).attr("name")] = $("#" + $(this).attr("id") + ":checked").length > 0; });
            ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/layout/setlayouthideoptions.action",
				data,
				ThemePress.PageTab.updateForLayoutChange, 
				"json"
			);
			return false;
		},

		layoutPageSelectionChanged: function (event) {
			var radioButtonClicked = $(this).data("page-title");
			var $radioButton = radioButtonClicked ? $(this) : $(this).closest("div.radio").find("input.radio");
			var href = ThemePress.contextPath + "/plugins/brikit/layout/setlayoutpage.action?pageId=" + ThemePress.pageId + 
						"&layoutSelection=" + encodeURIComponent($radioButton.data("page-title")) + ThemePress.atlTokenParam(true);
			var alreadySelected = !radioButtonClicked && $radioButton.prop("checked");
			if (!alreadySelected) location.href = href;
			event.stopImmediatePropagation();
			return false;
		},
		
		lightOffAccordion: function (event) {
			$(".light-up").removeClass("light-up");
		},

		lightOnAccordion: function (event) {
			// if (!ThemePress.Edit.isEditMode()) return;
			ThemePress.PageTab.lightOffAccordion();
			if (ThemePress.Focus.focusBlanketShowing()) return;
			ThemePress.PageTab.pageElementAccordions("#" + $(event.target).attr("id")).parents("tr").addClass("light-up");
			if ($("body").hasClass("menu-page")) {
				var menuName = $(event.target).closest(".brikit-content-layer").data("name");
				$(".top-level.has-menu-panel[data-panel-name='" + menuName + "']").addClass("light-up");
			}
			event.stopPropagation();
		},
		
		loadLayoutUsage: function (event) {
			event.preventDefault();
			event.stopPropagation();
            const data = {pageId: ThemePress.pageId};
            ThemePress.addToken(data);
			ThemePress.Dialog2.confirm("<p>" + $(this).attr("original-title") + "?</p><p>(This may take a while.)</p>", { title: "Find Usage" }, function (dialog) {
							dialog.hide();
							ThemePress.PageTab.pageDesignerElement("#layout-usage-list")
								.html("<p><span class='aui-icon aui-icon-wait'>Wait</span> Calculating...</p>")
								.load(contextPath + "/plugins/brikit/architect/pagesusinglayout.action", 
										data,
										ThemePress.Designer.resizeDesigner);
						});
		},
		
		multiLevelMenuChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = this.checked;
            ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/pages/setmultilevelmenu.action",
				data,
				ThemePress.PageTab.updateForMultiLevelMenuChange, 
				"json"
			);
			return false;
		},

		overrideDefaultLayoutChanged: function () {
			if ($(this).attr("aria-pressed")) return false;
			ThemePress.Designer.designer(".layout-selector .aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			location.href = ThemePress.contextPath + "/plugins/brikit/layout/setoverridedefault.action?pageId=" + ThemePress.pageId + "&overrideDefaultLayout=" + ($(this).data("layout") == "override") + ThemePress.atlTokenParam(true);
			return false;
		},

		pageDesignerElement: function (selector) {
			return ThemePress.PageTab.pageElementAccordions().find(selector);
		},

		pageElementAccordions: function (selector) {
			var elements = ThemePress.Designer.designer(".page-element-list");
			return selector ? elements.find("[data-selector~='" + selector + "'], [data-selector='" + selector + "']") : elements;
		},
		
		removeBlock: function () {
			var $this = $(this);
			var href = $this.attr("href");
			ThemePress.Dialog2.confirm("<p>Remove this block from the page?</p>", { title: "Delete Block" }, function (dialog) {
				dialog.hide();
				$("span", $this).removeClass("aui-iconfont-remove").addClass("waiting");
				ThemePress.post(href, {}, ThemePress.PageTab.updateForRemove, "json");
			});
			return false;
		},

		removeColumn: function () {
			var $this = $(this);
			var href = $this.attr("href");
			ThemePress.Dialog2.confirm("<p>Remove this column from the page?</p>", { title: "Delete Column" }, function (dialog) {
				dialog.hide();
				$("span", $this).removeClass("aui-iconfont-remove").addClass("waiting");
				ThemePress.post(href, {}, ThemePress.PageTab.updateForRemove, "json");
			});
			return false;
		},

		removeLayer: function () {
			var $this = $(this);
			var href = $this.attr("href");
			ThemePress.Dialog2.confirm("<p>Remove this layer from the page?</p>", { title: "Delete Layer" }, function (dialog) {
				dialog.hide();
				$("span", $this).removeClass("aui-iconfont-remove").addClass("waiting");
				ThemePress.post(href, {}, ThemePress.PageTab.updateForRemove, "json");
			});
			return false;
		},

		renderContextChanged: function () {
			var data = { pageId: ThemePress.pageId };
			data[$(this).attr("name")] = this.checked;
			ThemePress.post(
				ThemePress.contextPath + "/plugins/brikit/pages/setrendercontext.action",
				data,
				ThemePress.PageTab.updateForRenderContextChange, 
				"json"
			);
			return false;
		},

		reopenFieldsets: function () {
			if (ThemePress.Designer.isPageMode()) ThemePress.Designer.reopenFieldsets(ThemePress.PageTab.focusedElementToggle());
		},
		
		resizeDesigner: function () {
			if (ThemePress.Designer.isPageMode()) ThemePress.Designer.resizeDesigner();
		},
		
		saveFocusState: function (selector) {
			// Lose state after 60 minutes 
			ThemePress.cookie(ThemePress.PageTab.designerFocusCookie, selector, 60);
		},
		
		saveOpenFieldsets: function () {
			if (ThemePress.Designer.isPageMode()) ThemePress.Designer.saveOpenFieldsets(ThemePress.PageTab.focusedElementToggle());
		},
		
		scrollToFocusedAccordion: function () {
			if (ThemePress.PageTab.focusState()) ThemePress.PageTab.pageElementAccordions(ThemePress.PageTab.focusState()).scrollToBeVisible(ThemePress.Designer.designerHolder());
		},
		
		switchMobileView: function () {
			location.href = $("a", this).data("href");
			return false;
		},
		
		updateForAdd: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Add Error" }, true);
		},
		
		updateForCacheRenderedPageChange: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Update Error" }, true);
		},
		
		updateForContainerOptionChange: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Add Error" }, true);
		},
		
		updateForDoNotAddFakeLayerChanged: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Update Error" }, true);
		},
		
		updateForInstantPageCacheChange: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Update Error" }, true);
		},

		updateForLayoutChange: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Update Error" }, true);
		},
		
		updateForConvertForMobile: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Add Error" }, true);
		},

		updateForMultiLevelMenuChange: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Update Error" }, true);
		},

		updateForRemove: function (data, textStatus, jqXHR) {
			if (data.success) {
				// Get the element to remove, but if there are no more blocks in that layer, remove the layer instead
				var $remove = $("#" + data.id, ".brikit-content-layers");
				
				// If it's a tabbed block, just reload the page
				if (ThemePress.Tabs.isTabbedBlock($remove)) return ThemePress.Designer.forceReload(true);
				
				if (!$remove.hasClass("brikit-content-layer-backdrop")) {
					var $layer = $remove.closest(".brikit-content-layer-backdrop");
					if ($layer.length && !$(".brikit-content-block", $layer).length) $remove = $layer;
				}
				$remove.remove();
				ThemePress.PageTab.designUpdateElements(data.elements);
				ThemePress.PageTab.clearFocusState();
				ThemePress.Events.fireCallbacks(["structureDidChange"]);
				ThemePress.Designer.reloadDesigner();
				ThemePress.Events.fireCallbacks("pageElementChanged");
			}
			else {
				ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Remove Error" }, true);
			}
		},
		
		updateForRenderContextChange: function (data, textStatus, jqXHR) {
			if (data.success) ThemePress.Designer.forceReload(true);
			else ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Update Error" }, true);
		}

	};
	
	ThemePress.toInit(function ($) {
		ThemePress.registerCookie(ThemePress.PageTab.designerFocusCookie);	
	});
	
	ThemePress.toFinalize(function ($) {
		ThemePress.Events.addCallback("designerModeWillChange", ThemePress.PageTab.designerModeWillChange);
		ThemePress.Events.addCallback("accordionDidToggle", ThemePress.PageTab.reopenFieldsets);
		ThemePress.Events.addCallback("accordionDidToggle fieldsetContainerToggled", ThemePress.PageTab.saveOpenFieldsets);
		ThemePress.Events.addCallback("accordionDidToggle fieldsetContainerToggled", ThemePress.PageTab.autoSizeTextareas);
		ThemePress.Events.addCallback("fieldsetContainerToggled", ThemePress.PageTab.resizeDesigner);
	});

})(jQuery);
