/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitFile;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceExporter;
import com.brikit.themepress.util.ThemePress;
import java.io.File;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ExportArchitectPagesAction
extends ThemePressActionSupport {
    protected List<String> titles;
    protected String downloadPath;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        SpaceExporter exporter = new SpaceExporter(null, ThemePress.getThemePressDefaultSpace(), true, "theme-press-architect-pages");
        exporter.exportPages(this.getTitles());
        File zipFile = exporter.getZipFile();
        this.setDownloadPath(BrikitFile.prepareDownloadPath((String)zipFile.getPath()) + "?contentType=application/zip");
        BrikitFile.allowUserToDownload((File)zipFile);
        return "success";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    @StrutsParameter
    public void setTitles(List<String> titles) {
        this.titles = titles;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

