/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.WikiRenderException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogo;
import com.atlassian.confluence.util.ContentEntityObjectTitleComparator;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitApps;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.designer.ArchitectPageVisibility;
import com.brikit.themepress.designer.PageDesignRestrictions;
import com.brikit.themepress.designer.ThemeDesignerAccess;
import com.brikit.themepress.license.LicenseBugCache;
import com.brikit.themepress.model.BrowserTweakerCache;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.module.ThemePressModuleDescriptor;
import com.brikit.themepress.profiling.RenderPerformanceProfiling;
import com.brikit.themepress.settings.BrikitConfigProperties;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.SpaceCategorySettings;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.settings.ThemePropertiesCache;
import com.brikit.themepress.util.RenderedPageCache;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.apache.velocity.context.Context;

public class ThemePress {
    public static String PLUGIN_KEY = "brikit-theme-press";
    protected static long lastFileChange = 0L;
    protected static final String BRIKIT_SHOW_HEADER_COOKIE = "com.brikit.show.header";
    protected static final String BRIKIT_SHOW_HEADER_COOKIE_OFF = "off";
    protected static final String BRIKIT_SHOW_HEADER_COOKIE_ON = "on";
    protected static final String BRIKIT_SHOW_HEADER_BY_DEFAULT_ANONYMOUS = "anonymous";
    protected static final String BRIKIT_SHOW_HEADER_BY_DEFAULT_NOBODY = "nobody";

    public static boolean alwaysBugForLicense() {
        return BrikitFile.getBrikitFile((String)"always-bug.txt").exists();
    }

    protected static void appendLayoutMacroAsRendered(StringBuilder builder, MacroDefinition layoutMacro, AbstractPage abstractPage) throws Exception {
        MacroParser.setParameter((MacroDefinition)layoutMacro, (String)"from-layout", (String)"true", (AbstractPage)abstractPage);
        builder.append(Confluence.render((MacroDefinition)layoutMacro, (AbstractPage)abstractPage));
    }

    public static boolean architectPageExists(String architectPageName) {
        return ThemePress.getArchitectPage(architectPageName) != null;
    }

    public static List<Page> architectPages(String anArchitectPageType, String spaceKey) {
        return ThemePress.architectPages(anArchitectPageType, spaceKey, false);
    }

    public static List<Page> architectPages(String anArchitectPageType, String spaceKey, boolean includeMobileVersions) {
        Space space = Confluence.getSpace((String)spaceKey);
        String oldDefaultTitle = anArchitectPageType.endsWith(".") ? anArchitectPageType.substring(0, anArchitectPageType.lastIndexOf(".")) : anArchitectPageType;
        ArrayList<Page> architectPages = new ArrayList<Page>();
        boolean isDefaultSpace = "themepressdefault".equals(spaceKey);
        for (Page architectPage : ThemePress.getAllArchitectPages(includeMobileVersions)) {
            boolean shouldSee;
            if (!architectPage.getTitle().startsWith(anArchitectPageType) && !architectPage.getTitle().equalsIgnoreCase(oldDefaultTitle) || !(shouldSee = Confluence.isConfluenceAdministrator() || isDefaultSpace && Confluence.canEdit((AbstractPage)architectPage) || !isDefaultSpace && ArchitectPageVisibility.isVisible((AbstractPage)architectPage, spaceKey) && PageDesignRestrictions.visibleToUser(space, architectPage))) continue;
            architectPages.add(architectPage);
        }
        Collections.sort(architectPages, ContentEntityObjectTitleComparator.getInstance());
        return architectPages;
    }

    public static boolean bugForLicense(PluginLicenseManager pluginLicenseManager) {
        try {
            return !ThemePress.isLicensed(pluginLicenseManager) && !LicenseBugCache.doNotBug(Confluence.getSession().getId());
        }
        catch (ExecutionException ex) {
            BrikitLog.logWarning((String)"Unable to check license. Defaulting to bugging user.");
            return true;
        }
    }

    public static boolean canAdministerArchitectPages() {
        return Confluence.canEdit((String)"themepressdefault");
    }

    public static boolean canBlockEditPage(AbstractPage abstractPage) {
        if (abstractPage == null || !ThemePress.isThemePress(abstractPage)) {
            return false;
        }
        if (!Confluence.canEdit((AbstractPage)abstractPage)) {
            return false;
        }
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        if (wrapper.isAutomaticLayout()) {
            return false;
        }
        return ThemeDesignerAccess.hasPageTabAccess(abstractPage) || wrapper.hasLayerMacros();
    }

    public static boolean canView(ContentEntityObject ceo) {
        return Confluence.getPermissionManager().hasPermission(Confluence.getConfluenceUser(), Permission.VIEW, (Object)ceo);
    }

    public static boolean didDevelopmentFilesChange(String themeName) {
        if (!ExternalDevelopmentMode.isDeveloperMode()) {
            return false;
        }
        long latestChange = lastFileChange;
        BrikitList cssFiles = new BrikitList();
        cssFiles.add((Object)"velocity");
        cssFiles.add((Object)BrikitConfigProperties.getCssPrintFilesList());
        cssFiles.add((Object)BrikitConfigProperties.getCssEditFilesList());
        cssFiles.add((Object)BrikitConfigProperties.getCssAllFilesList());
        cssFiles.add((Object)BrikitThemeSettings.cssFilesForThemePressPlugins("all"));
        cssFiles.add((Object)BrikitThemeSettings.cssFilesForThemePressPlugins("print"));
        cssFiles.add((Object)BrikitThemeSettings.cssFilesForThemePressPlugins("edit"));
        latestChange = ThemePress.latestTimestampForCssFiles(cssFiles.join(" "), themeName, "Brikit Theme Press", latestChange);
        ThemeProperties themeProperties = ThemeProperties.getThemeProperties(themeName);
        BrikitList themeCssFiles = new BrikitList();
        themeCssFiles.add((Object)themeProperties.getCssFilesForPrintMedia());
        themeCssFiles.add((Object)themeProperties.getCssFilesForAllMedia());
        latestChange = ThemePress.latestTimestampForCssFiles(themeCssFiles.join(" "), themeName, "Theme Custom Code", latestChange);
        if (BrikitString.isSet((String)themeName)) {
            String javascriptFromTheme = ThemeProperties.getThemeProperties(themeName).getJavascriptFiles();
            latestChange = ThemePress.latestTimestampForJavascriptFiles(javascriptFromTheme, themeName, "Theme Custom Code", latestChange);
        }
        String javascriptList = BrikitConfigProperties.getJavaScriptFilesList(true);
        latestChange = ThemePress.latestTimestampForJavascriptFiles(javascriptList, themeName, "Brikit Theme Press", latestChange);
        javascriptList = BrikitThemeSettings.javascriptFilesForThemePressPlugins();
        latestChange = ThemePress.latestTimestampForJavascriptFiles(javascriptList, themeName, "Third-Party Theme Press Plugin", latestChange);
        boolean changeFound = latestChange > lastFileChange;
        lastFileChange = latestChange;
        return changeFound;
    }

    public static int distanceBetween(Page ancestorPage, Page descendantPage) {
        if (!Confluence.isPageInSubtree((Page)descendantPage, (Page)ancestorPage)) {
            return -1;
        }
        if (ancestorPage.equals((Object)descendantPage)) {
            return 0;
        }
        List ancestors = Confluence.getAncestors((AbstractPage)descendantPage);
        return ancestors.size() - ancestors.indexOf(ancestorPage);
    }

    protected static String evaluationLicenseMessage() {
        String message = Confluence.getText((String)"com.brikit.theme.press.evaluation.license");
        String marketplaceURL = "https://marketplace.atlassian.com/plugins/com.brikit.themepress";
        return BrikitString.isSet((String)message) && message.contains(marketplaceURL) ? message : "<p>EVALUATION LICENSE Are you enjoying Theme Press? Please consider <a href=\"" + marketplaceURL + "\">purchasing</a> it today.</p>";
    }

    public static List<Page> getAllArchitectPages(boolean includeMobilePhoneVersions) {
        Space defaultsSpace = ThemePress.getThemePressDefaultSpace();
        if (defaultsSpace == null) {
            return new ArrayList<Page>();
        }
        List allArchitectPages = Confluence.getPageManager().getPages(defaultsSpace, true);
        if (allArchitectPages == null) {
            return new ArrayList<Page>();
        }
        ArrayList<Page> architectPages = new ArrayList<Page>();
        for (Page architectPage : allArchitectPages) {
            String title = architectPage.getTitle();
            if (!title.startsWith(".brikit.menu") && !title.startsWith(".brikit.banner") && !title.startsWith(".brikit.footer") && !title.startsWith(".brikit.header") && !title.startsWith(".brikit.frame") && !title.startsWith(".brikit.grid") && !title.startsWith(".brikit.layout") || !includeMobilePhoneVersions && ThemePress.isMobilePhoneTitle(title)) continue;
            architectPages.add(architectPage);
        }
        return architectPages;
    }

    public static Page getArchitectHomePage() throws WikiRenderException {
        if (!ThemePress.themePressDefaultSpaceExists()) {
            return null;
        }
        return SpaceWrapper.getThemePressDefaultSpaceWrapper().getOrCreateArchitectPageRoot();
    }

    public static Page getArchitectPage(String architectPageName) {
        return Confluence.getPage((Space)ThemePress.getThemePressDefaultSpace(), (String)architectPageName);
    }

    public static String getArchitectTypeForArchitectPage(AbstractPage abstractPage) {
        String title = Confluence.getTitle((AbstractPage)abstractPage);
        String afterBrikit = title.substring(".brikit".length() + 1);
        int split = afterBrikit.indexOf(".");
        return split == -1 ? BrikitString.titleize((String)afterBrikit) : BrikitString.titleize((String)afterBrikit.substring(0, split));
    }

    public static String getBlogURLForSpace(String aSpaceKey) {
        return Confluence.getContextPath() + "/display/blog-" + HtmlUtil.htmlEncode((String)aSpaceKey);
    }

    public static List<Page> getChildren(Page aPage) {
        if (aPage == null) {
            return new ArrayList<Page>();
        }
        ArrayList<Page> children = new ArrayList<Page>();
        for (Page child : aPage.getSortedChildren()) {
            if (!ThemePress.canView((ContentEntityObject)child)) continue;
            children.add(child);
        }
        return children;
    }

    public static String getDescriptiveTitleForArchitectPage(AbstractPage abstractPage) {
        String title = Confluence.getTitle((AbstractPage)abstractPage);
        if (title.equals(".brikit")) {
            return "Theme Press Default Space";
        }
        String afterBrikit = title.substring(".brikit".length() + 1);
        int split = afterBrikit.indexOf(".");
        return split == -1 ? "Default " + BrikitString.titleize((String)afterBrikit) : afterBrikit.substring(split + 1) + " " + BrikitString.titleize((String)afterBrikit.substring(0, split));
    }

    public static String getDescriptiveTitleForArchitectPage(String pageIdAsString) {
        return ThemePress.getDescriptiveTitleForArchitectPage(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public static Page getLastDepthFirstNode(Page aPage) {
        if (aPage == null) {
            return null;
        }
        Page lastChild = (Page)new BrikitList(ThemePress.getChildren(aPage)).last();
        if (lastChild != null) {
            return ThemePress.getLastDepthFirstNode(lastChild);
        }
        return aPage;
    }

    public static Page getNextPage(Page aPage) {
        Page next = (Page)new BrikitList(ThemePress.getChildren(aPage)).first();
        if (next != null) {
            return next;
        }
        next = ThemePress.getOlderSibling(aPage);
        if (next != null) {
            return next;
        }
        Page parent = Confluence.getParent((Page)aPage);
        if (parent == null) {
            return null;
        }
        while (parent != null) {
            next = ThemePress.getOlderSibling(parent);
            if (next != null) {
                return next;
            }
            parent = Confluence.getParent((Page)parent);
        }
        return null;
    }

    public static Page getOlderSibling(Page aPage) {
        return (Page)ThemePress.getSiblings(aPage).after((Object)aPage);
    }

    public static AbstractPage getPageForDraft(Draft draftPage) {
        return draftPage == null ? null : Confluence.getPageOrBlogPost((String)draftPage.getPageId());
    }

    public static Page getPreviousPage(Page aPage) {
        Page previous = ThemePress.getYoungerSibling(aPage);
        if (previous != null) {
            return ThemePress.getLastDepthFirstNode(previous);
        }
        return Confluence.getParent((Page)aPage);
    }

    public static String getProductVersion() {
        return ThemeResourceServlet.getZenPlugin().getPluginInformation().getVersion();
    }

    public static boolean getShowConfluenceHeader(String themeName) {
        String cookie = Confluence.getCookieValue((String)BRIKIT_SHOW_HEADER_COOKIE);
        if (BRIKIT_SHOW_HEADER_COOKIE_OFF.equals(cookie)) {
            return false;
        }
        if (BRIKIT_SHOW_HEADER_COOKIE_ON.equals(cookie)) {
            return true;
        }
        String showByDefault = ThemeProperties.getThemeProperties(themeName).showHeaderByDefault();
        return Confluence.isAnonymousUser() ? BRIKIT_SHOW_HEADER_BY_DEFAULT_ANONYMOUS.equals(showByDefault) : !BRIKIT_SHOW_HEADER_BY_DEFAULT_NOBODY.equals(showByDefault);
    }

    public static BrikitList getSiblings(Page aPage) {
        if (aPage == null) {
            return new BrikitList();
        }
        Page parent = Confluence.getParent((Page)aPage);
        List<Page> pages = parent == null ? ThemePress.getTopLevelPages(Confluence.getSpace((AbstractPage)aPage)) : ThemePress.getChildren(parent);
        return new BrikitList(pages);
    }

    public static BrikitList<Space> getThemedSpaces() {
        BrikitList themedSpaces = new BrikitList();
        for (Space space : Confluence.getAllSpaces()) {
            if (!ThemePress.isThemePress(space)) continue;
            themedSpaces.add((Object)space);
        }
        return themedSpaces;
    }

    public static File getThemePluginLocation() {
        File location = BrikitFile.getBrikitFile((String)"themes");
        try {
            BrikitFile.ensurePathExists((File)location);
        }
        catch (IOException e) {
            BrikitLog.logError((String)("Unable to create theme plugin location: " + location), (Exception)e);
        }
        return location;
    }

    public static Space getThemePressDefaultSpace() {
        return Confluence.getSpace((String)"themepressdefault");
    }

    @Deprecated
    public static Space getThemePressDemoSpace() {
        return Confluence.getSpace((String)"themepressdemo");
    }

    public static Space getThemePressSplashDemoSpace() {
        return Confluence.getSpace((String)"brikitdemoSPLASH");
    }

    public static ThemePressModuleDescriptor getThemePressPluginModule(String appKey) {
        for (ThemePressModuleDescriptor module : ThemePress.getThemePressPluginModules()) {
            if (!module.getPluginKey().equals(appKey)) continue;
            return module;
        }
        return null;
    }

    public static BrikitMap<String, String> getThemePressPluginModuleAppKeys() {
        BrikitMap keys = new BrikitMap();
        for (ThemePressModuleDescriptor module : ThemePress.getThemePressPluginModules()) {
            keys.put((Object)module.getPluginKey(), (Object)module.getName());
        }
        return keys;
    }

    public static List<ThemePressModuleDescriptor> getThemePressPluginModules() {
        return Confluence.getPluginAccessor().getEnabledModuleDescriptorsByClass(ThemePressModuleDescriptor.class);
    }

    public static Space getThemePressVanillaDemoSpace() {
        return Confluence.getSpace((String)"brikitdemoVANILLA");
    }

    public static String getThemeResourcePath() {
        return Confluence.getContextPath() + "/download/resources/" + "com.brikit.themepress:theme-base" + "/theme-press";
    }

    public static List<Page> getTopLevelPages(Space aSpace) {
        return aSpace == null ? new ArrayList() : Confluence.getPageManager().getTopLevelPages(aSpace);
    }

    public static Page getYoungerSibling(Page aPage) {
        return (Page)ThemePress.getSiblings(aPage).before((Object)aPage);
    }

    public static boolean hasLogo(String spaceKey) {
        SpaceLogo logo = Confluence.getSpaceManager().getLogoForSpace(spaceKey);
        if (!logo.isGlobalLogo()) {
            return !Confluence.getSettingsManager().getSpaceSettings(spaceKey).isDisableLogo() && logo.isCustomLogo();
        }
        return !Confluence.getSettingsManager().getGlobalSettings().isDisableLogo() && !logo.isDefaultLogo();
    }

    public static boolean hasTeamCalendars(AbstractPage abstractPage) {
        return MacroParser.hasMacro((AbstractPage)abstractPage, (String)"calendar");
    }

    public static boolean isArchitectPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && "themepressdefault".equals(Confluence.getSpaceKey((AbstractPage)abstractPage)) && abstractPage.getTitle().startsWith(".brikit");
    }

    public static boolean isBannerPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && abstractPage.getTitle().startsWith(".brikit.banner");
    }

    public static boolean isConfluenceMobilePluginEnabled() {
        return Confluence.isAddOnEnabled((String)"com.atlassian.confluence.plugins.confluence-mobile");
    }

    public static boolean isConfluenceMobileWebPluginEnabled() {
        return Confluence.isAddOnEnabled((String)"com.atlassian.confluence.plugins.confluence-mobile-plugin");
    }

    public static boolean isDarkFeatureEnabled(String darkFeatureKey) {
        return Confluence.getDarkFeaturesManager().getDarkFeatures(Confluence.getConfluenceUser()).isFeatureEnabled(darkFeatureKey);
    }

    public static boolean isDarkFeaturesEnabled() {
        return BrikitFile.getBrikitFile((String)"let-there-be-dark.txt").exists();
    }

    public static boolean isDefaultSpace(Space aSpace) {
        return aSpace != null && aSpace.getKey().equals("themepressdefault");
    }

    public static boolean isDesignerEnabled(Space aSpace, AbstractPage abstractPage) {
        if (aSpace == null && abstractPage == null) {
            return ThemePress.isThemePressSiteTheme() && ThemeDesignerAccess.hasThemeTabAccess() && !Confluence.isViewingAdminConsole();
        }
        if (abstractPage == null) {
            return ThemePress.isThemePress(aSpace) && ThemeDesignerAccess.hasThemeTabAccess();
        }
        return ThemePress.isThemePress(aSpace) && ThemeDesignerAccess.hasPageTabAccess(abstractPage);
    }

    public static boolean isDesignerEnabled(String spaceKey, String pageIdAsString) {
        return ThemePress.isDesignerEnabled(Confluence.getSpace((String)spaceKey), Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public static boolean isFrame(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && ThemePress.isFrameTitle(abstractPage.getTitle());
    }

    public static boolean isFrameTitle(String aPageTitle) {
        return aPageTitle.startsWith(".brikit.frame");
    }

    public static boolean isGrid(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && ThemePress.isGridTitle(abstractPage.getTitle());
    }

    public static boolean isGridTitle(String aPageTitle) {
        return aPageTitle.startsWith(".brikit.grid");
    }

    public static boolean isFooterPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && abstractPage.getTitle().startsWith(".brikit.footer");
    }

    public static boolean isEvaluationLicense(PluginLicenseManager pluginLicenseManager) {
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                return false;
            }
            return license.isEvaluation();
        }
        return false;
    }

    public static boolean isHeaderPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && abstractPage.getTitle().startsWith(".brikit.header");
    }

    public static boolean isLayoutPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && ThemePress.isLayoutPageTitle(abstractPage.getTitle());
    }

    public static boolean isLayoutPageTitle(String aPageTitle) {
        return aPageTitle.startsWith(".brikit.layout");
    }

    public static boolean isLicensed(PluginLicenseManager pluginLicenseManager) {
        if (ThemePress.alwaysBugForLicense()) {
            return false;
        }
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                return false;
            }
            return license.isActive();
        }
        return BrikitDate.daysBetween((Calendar)BrikitDate.getToday(), (Calendar)BrikitDate.getCalendar((int)2015, (int)9, (int)30)) > 0;
    }

    public static boolean isMenuPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && abstractPage.getTitle().startsWith(".brikit.menu");
    }

    public static boolean isMobilePhonePage(AbstractPage abstractPage) {
        return ThemePress.isMobilePhoneTitle(Confluence.getTitle((AbstractPage)abstractPage));
    }

    public static boolean isMobilePhoneTitle(String pageTitle) {
        return BrikitString.isSet((String)pageTitle) && pageTitle.endsWith(".mobile.phone");
    }

    public static boolean isThemePress(AbstractPage abstractPage) {
        return ThemePress.isThemePress(Confluence.getSpace((AbstractPage)abstractPage));
    }

    public static boolean isThemePress(Space aSpace) {
        return aSpace != null && ThemePress.isThemePress(aSpace.getKey());
    }

    public static boolean isThemePress(String spaceKey) {
        if (spaceKey == null) {
            return false;
        }
        return "com.brikit.themepress:theme-base".equals(Confluence.getSpaceThemeKey((String)spaceKey));
    }

    public static boolean isThemePressSiteTheme() {
        return "com.brikit.themepress:theme-base".equals(Confluence.getSiteThemeKey());
    }

    public static boolean isThemePress3Enabled() {
        return ThemePress.isDarkFeatureEnabled("com.brikit.themepress.3.dark.features");
    }

    public static boolean isVersionAtLeast(String versionString) {
        return ThemePress.getProductVersion().compareTo(versionString) >= 0;
    }

    protected static long latestTimestampForCssFiles(String cssList, String themeName, String source, long latestChange) {
        for (String cssFilename : BrikitString.split((String)cssList)) {
            String resourcePath = cssFilename.lastIndexOf("/") == -1 ? "css/" : "";
            resourcePath = resourcePath + cssFilename + ".css";
            String filePath = ThemeResourceServlet.getServerFileLocation((String)resourcePath);
            try {
                if ("Brikit Theme Press".equals(source)) {
                    latestChange = Math.max(latestChange, new File(filePath).lastModified());
                    continue;
                }
                if (!"Theme Custom Code".equals(source)) continue;
                File themeFile = ThemePlugin.getThemeResourceFile(themeName, resourcePath);
                latestChange = Math.max(latestChange, themeFile.lastModified());
            }
            catch (Exception ex) {
                BrikitLog.logError((String)("Failed to read CSS file in " + source + ": " + filePath));
            }
        }
        return latestChange;
    }

    protected static long latestTimestampForJavascriptFiles(String javascriptList, String themeName, String source, long latestChange) {
        for (String filename : BrikitString.split((String)javascriptList)) {
            if (filename.endsWith("i18n")) continue;
            String resourcePath = "Third-Party Theme Press Plugin".equals(source) ? "" : "scripts/";
            resourcePath = resourcePath + filename + ".js";
            String filePath = ThemeResourceServlet.getServerFileLocation((String)resourcePath);
            Object contents = null;
            try {
                if ("Brikit Theme Press".equals(source) || "Third-Party Theme Press Plugin".equals(source)) {
                    latestChange = Math.max(latestChange, new File(filePath).lastModified());
                    continue;
                }
                if (!"Theme Custom Code".equals(source)) continue;
                File themeFile = ThemePlugin.getThemeResourceFile(themeName, resourcePath);
                latestChange = Math.max(latestChange, themeFile.lastModified());
            }
            catch (Exception ex) {
                BrikitLog.logError((String)("Failed to find JavaScript file in " + source + ": " + filePath));
            }
        }
        return latestChange;
    }

    public static String pageTitleWithDocumentIdentifier(Page page) {
        Object contentFlow = BrikitApps.getContentFlowVelocityContext();
        BrikitList bits = new BrikitList(2);
        if (contentFlow != null) {
            String identifier = "";
            try {
                Method method = contentFlow.getClass().getMethod("documentIdentifier", Page.class);
                identifier = (String)method.invoke(contentFlow, page);
            }
            catch (Exception ex) {
                BrikitLog.logDebug((String)"Content Flow object does not have documentIdentifier(Page) method.");
            }
            if (BrikitString.isSet((String)identifier)) {
                bits.add((Object)identifier);
            }
        }
        bits.add((Object)Confluence.getTitle((AbstractPage)page));
        return bits.join(" ");
    }

    public static Page randomChild(Page parentPage, List<String> labels, Page lastDisplayedPage) {
        if (parentPage == null) {
            return null;
        }
        List selections = ThemePress.getChildren(parentPage);
        if ((selections = Confluence.filterByLabels(selections, labels)).size() < 1) {
            return null;
        }
        if (selections.size() == 1) {
            return (Page)selections.get(0);
        }
        Page selected = lastDisplayedPage;
        Random random = new Random();
        while (selected == lastDisplayedPage) {
            int selectedIdx = random.nextInt(selections.size());
            selected = (Page)selections.get(selectedIdx);
        }
        return selected;
    }

    public static String renderCacheableArchitectPage(Page aPage, AbstractPage viewingPage, PluginLicenseManager pluginLicenseManager) {
        String renderedContent;
        boolean renderInPageContext;
        if (aPage == null) {
            return "";
        }
        PageWrapper wrapper = PageWrapper.get((AbstractPage)aPage);
        if (wrapper == null) {
            return "";
        }
        boolean bl = renderInPageContext = viewingPage != null && wrapper.getRenderInPageContext();
        if (!renderInPageContext && !wrapper.getDoNotCacheRenderedPage() && (renderedContent = RenderedPageCache.cachedContent(aPage)) != null) {
            return renderedContent;
        }
        try {
            Calendar start = RenderPerformanceProfiling.startTimer("Rendering page: " + aPage);
            wrapper.ensureLayer();
            List<MacroDefinition> blocks = wrapper.blocks();
            if (blocks.size() == 1 && !BrikitString.isSet((String)blocks.get(0).getBodyText())) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            for (MacroDefinition layer : wrapper.getLayerMacros()) {
                MacroParser.setParameter((MacroDefinition)layer, (String)"architect-page", (String)"true", (AbstractPage)aPage);
                builder.append(Confluence.macroAsStorage((AbstractPage)aPage, (MacroDefinition)layer));
            }
            if (ThemePress.isGrid((AbstractPage)aPage)) {
                builder.append(aPage.getBodyAsString());
            }
            if (ThemePress.isFooterPage((AbstractPage)aPage) && ThemePress.isEvaluationLicense(pluginLicenseManager)) {
                builder.append(ThemePress.evaluationLicenseMessage());
            }
            String renderedContent2 = Confluence.render((String)builder.toString(), (AbstractPage)(renderInPageContext ? viewingPage : aPage));
            if (!renderInPageContext) {
                RenderedPageCache.cacheContent(renderedContent2, aPage);
            }
            RenderPerformanceProfiling.stopTimer("Rendering page: " + aPage, start);
            return renderedContent2;
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to render: " + aPage), (Exception)ex);
            return "<div>Unable to render: " + aPage.getTitle() + "</div>";
        }
    }

    public static Map<String, String> renderedTopAndBottomLayoutLayers(AbstractPage abstractPage) throws Exception {
        boolean doNotAddFakeLayer;
        HashMap<String, String> renderedLayers = new HashMap<String, String>();
        if (abstractPage == null) {
            return renderedLayers;
        }
        Page layoutPage = PageWrapper.getLayout(abstractPage);
        PageWrapper layoutWrapper = PageWrapper.get((AbstractPage)layoutPage);
        if (layoutWrapper == null) {
            layoutWrapper = PageWrapper.get((AbstractPage)BrikitThemeSettings.getDefaultLayout());
        }
        PageWrapper pageWrapper = PageWrapper.get(abstractPage);
        StringBuilder topBuilder = new StringBuilder();
        StringBuilder bottomBuilder = new StringBuilder();
        for (MacroDefinition layoutLayer : pageWrapper.getLayoutLayerTopMacros()) {
            ThemePress.appendLayoutMacroAsRendered(topBuilder, layoutLayer, abstractPage);
        }
        List<Object> pageLayers = pageWrapper == null ? new ArrayList() : pageWrapper.getLayerMacros();
        boolean bl = doNotAddFakeLayer = layoutWrapper != null && layoutWrapper.getDoNotAddFakeLayer();
        if (!doNotAddFakeLayer) {
            int count;
            if (pageLayers.isEmpty()) {
                List<String> layerComponents = pageWrapper.fakeLayerComponents();
                topBuilder.append(layerComponents.get(0));
                bottomBuilder.append(layerComponents.get(1));
            }
            for (int i = count = Math.max(1, pageLayers.size()); i < pageWrapper.getLayoutLayerMergeMacros().size(); ++i) {
                MacroDefinition layoutLayer = pageWrapper.getLayoutLayerMergeMacros().get(i);
                ThemePress.appendLayoutMacroAsRendered(bottomBuilder, layoutLayer, abstractPage);
            }
            for (MacroDefinition layoutLayer : pageWrapper.getLayoutLayerBottomMacros()) {
                ThemePress.appendLayoutMacroAsRendered(bottomBuilder, layoutLayer, abstractPage);
            }
        }
        if (layoutWrapper != null && layoutWrapper.hasAppliedLayoutMacro()) {
            bottomBuilder.append(Confluence.render((MacroDefinition)layoutWrapper.getAppliedLayoutMacro(), (AbstractPage)abstractPage));
        }
        renderedLayers.put("top", topBuilder.toString());
        renderedLayers.put("bottom", bottomBuilder.toString());
        return renderedLayers;
    }

    public static String renderWithVelocityContext(String filePathName, Context velocityContext) throws IOException {
        String extraResourceLocation = "";
        int split = filePathName.indexOf("/");
        if (split == -1) {
            split = filePathName.indexOf(BrikitFile.separator());
        }
        if (split != -1) {
            extraResourceLocation = filePathName.substring(0, split + 1);
            filePathName = filePathName.substring(split + 1);
        }
        String resourcePath = extraResourceLocation + filePathName;
        String filePath = ThemeResourceServlet.getServerFileLocation((String)resourcePath);
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            String templateContent = BrikitFile.readFile((String)filePath);
            return Confluence.getVelocityHelperService().getRenderedContent(templateContent, velocityContext);
        }
        return Confluence.getRenderedVelocityTemplate((String)filePath, (Context)velocityContext);
    }

    public static void resetCaches() {
        ThemePlugin.resetThemes();
        ThemePropertiesCache.reset();
        BrowserTweakerCache.reset();
        BrikitThemeSettings.resetThemeOverridesCache();
        ThemePress.resetCachesNonTheme();
    }

    public static void resetCachesNonTheme() {
        RenderedPageCache.resetCache();
        SpaceCategorySettings.reset();
        PageWrapperCache.reset();
        SpaceWrapper.reset();
        LicenseBugCache.reset();
    }

    public static boolean themePressDefaultSpaceExists() {
        return ThemePress.getThemePressDefaultSpace() != null;
    }

    public static String timeZoneCaption(TimeZone timeZone) {
        String key = timeZone.getMessageKey();
        if (key.equals(Confluence.getText((String)key))) {
            return timeZone.getID();
        }
        return Confluence.getText((String)"time.zone.caption", (Object[])new Object[]{timeZone.getDisplayOffset(), Confluence.getText((String)key)});
    }

    public static String timeZoneCaptionDefaut(TimeZone defaultTimeZone) {
        return Confluence.getText((String)"time.zone.server.default", (Object[])new Object[]{ThemePress.timeZoneCaption(defaultTimeZone)});
    }
}

