/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.diff.Differ;
import com.atlassian.confluence.diff.beans.ConfluenceDiffDraftBean;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.themepress.model.PageWrapper;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ViewBlockDiffOfDraftAction
extends AbstractPageAwareAction
implements Beanable {
    private ConfluenceDiffDraftBean bean;
    private DraftManager draftManager;
    private String blockId;
    private String username;
    private Draft draft;
    private Differ htmlDiffer;

    public void validate() {
        if (this.getDraft() == null) {
            this.addActionError("No draft could be found");
        }
    }

    public String execute() {
        try {
            MacroDefinition block = PageWrapper.get(this.getPage()).block(this.getBlockId());
            Page page = (Page)this.getPage().clone();
            page.setBodyAsString(block.getBody().toString());
            this.bean = new ConfluenceDiffDraftBean((ContentEntityObject)page, this.draft, this.htmlDiffer);
            return "success";
        }
        catch (Exception e) {
            return "error";
        }
    }

    public Draft getDraft() {
        if (this.draft == null) {
            this.draft = this.draftManager.findDraft(Long.valueOf(this.getPageId()), this.getUsername(), this.getPage().getType(), this.getSpaceKey());
        }
        return this.draft;
    }

    public ConfluenceDiffDraftBean getBean() {
        return this.bean;
    }

    public void setDraftManager(DraftManager draftManager) {
        this.draftManager = draftManager;
    }

    public String getUsername() {
        ConfluenceUser user = this.userAccessor.getUserByName(this.username);
        return user != null ? user.getName() : null;
    }

    @StrutsParameter
    public void setUsername(String username) {
        this.username = username;
    }

    public String getBlockId() {
        return this.blockId;
    }

    @StrutsParameter
    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    @StrutsParameter
    public void setHtmlDiffer(Differ htmlDiffer) {
        this.htmlDiffer = htmlDiffer;
    }
}

