/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeCssCacheHelper;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThemeCssCache {
    public static final String MEDIA_TYPE_ALL = "all";
    public static final String MEDIA_TYPE_PRINT = "print";
    public static final String MEDIA_TYPE_EDIT = "edit";
    protected static long compiledAt = 0L;
    protected static Cache<String, String> cache;
    protected static CacheSettings cacheSettings;

    public static String getBundleName(String themeName, String tweaker, String mediaType) {
        return themeName + "~~~" + tweaker + "~~~" + (BrikitString.isSet((String)mediaType) ? mediaType : MEDIA_TYPE_ALL);
    }

    public static String getCSS(String cacheKey) {
        String key = (String)new BrikitList((Object[])cacheKey.split("/")).first();
        ThemeCssCacheHelper cacheHelper = new ThemeCssCacheHelper(key, ThemeCssCache.getCompiledAt());
        if (cacheHelper.needsUpdate()) {
            ThemeCssCache.reset(key);
        }
        return (String)ThemeCssCache.getCache().get((Object)key);
    }

    public static long getCompiledAt() {
        return compiledAt;
    }

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache(Confluence.getText((String)"com.brikit.themepress.theme.css.cache"), (CacheLoader)new CacheLoader<String, String>(){

                public String load(String cacheKey) {
                    ThemeCssCacheHelper cacheHelper = new ThemeCssCacheHelper(cacheKey);
                    String themeName = cacheHelper.getThemeName();
                    StringBuilder buffer = new StringBuilder();
                    Map velocityContext = BrikitThemeSettings.getCSSVelocityContext(ThemeProperties.getThemeProperties(themeName));
                    BrikitThemeSettings.readCssFiles(buffer, cacheHelper.filesFromThemePress(), themeName, velocityContext, "Brikit Theme Press");
                    BrikitThemeSettings.readCssFiles(buffer, cacheHelper.filesFromPlugins(), themeName, velocityContext, "Third-Party Theme Press Plugin");
                    BrikitThemeSettings.readCssFiles(buffer, cacheHelper.filesFromTheme(), themeName, velocityContext, "Theme Custom Code");
                    compiledAt = BrikitDate.nowMs();
                    String result = buffer.toString().replaceAll("\\s*[a-zA-Z-]+\\s*:\\s*;\\s*", "").replaceAll("\\s*[a-zA-Z-]+\\s*:\\s*(\\$[a-zA-Z.]+\\s*)+;\\s*", "");
                    return result;
                }
            }, cacheSettings);
        }
        return cache;
    }

    public static void reset() {
        ThemeCssCache.getCache().removeAll();
    }

    protected static void reset(String cacheKey) {
        ThemeCssCache.getCache().remove((Object)cacheKey);
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(5L, TimeUnit.HOURS).maxEntries(50).build();
    }
}

