(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];

	BrikitCore.Dialog = {
		
		alert: function (message, options, callback) {
			
			options = options || {};
			options.id = options.id || "brikit-alert-dialog";
			
			$("#" + options.id).remove();

			var dialogOptions = BrikitCore.Dialog.dialogDefaults(options);
			var dialog = new AJS.Dialog(dialogOptions);

			dialog.addHeader(options.title || BrikitCore.getText("com.brikit.core.alert"));
			dialog.addPanel("SinglePanel", message, "singlePanel");

			dialog.addButton((options.okButton || BrikitCore.getText("com.brikit.core.ok")), function (dialog) { 
				dialog.hide();
				if (callback) callback.call(this, dialog);
			});

		    // start first page, first panel
		    dialog.gotoPanel(0);
		    dialog.show();
		
			return false;
		},
		
		confirm: function (message, options, callback, closeCallback) {
			
			options = options || {};
			options.id = options.id || "brikit-confirm-dialog";

			$("#" + options.id).remove();

			var dialogOptions = BrikitCore.Dialog.dialogDefaults(options);
			var dialog = new AJS.Dialog(dialogOptions);

			dialog.addHeader(options.title || BrikitCore.getText("com.brikit.core.confirm"));
			dialog.addPanel("SinglePanel", message, "singlePanel");

			dialog.addButton((options.okButton || BrikitCore.getText("com.brikit.core.ok")), callback);
			dialog.addLink((options.cancelButton || BrikitCore.getText("com.brikit.core.cancel")), function (dialog) { 
				dialog.hide();
				if (closeCallback) closeCallback.call(this, dialog);
			});

		    // start first page, first panel
		    dialog.gotoPanel(0);
		    dialog.show();
		
			return false;
		},
		
		dialog: function (panelContents, options, callback, closeCallback, preventCloseCallback) {
			
			options = options || {};
			options.id = options.id || "brikit-dialog";

			$("#" + options.id).remove();

			var dialogOptions = BrikitCore.Dialog.dialogDefaults(options);
			var dialog = new AJS.Dialog(dialogOptions);

			dialog.addHeader(options.title || BrikitCore.getText("com.brikit.core.confirm"));
			dialog.addPanel("SinglePanel", panelContents, "singlePanel");

			dialog.addButton((options.okButton || BrikitCore.getText("com.brikit.core.ok")), callback);
			preventCloseCallback = preventCloseCallback || function (dialog) { 
				dialog.hide();
				if (closeCallback) closeCallback.call(this, dialog);
			};
			dialog.addLink((options.cancelButton || BrikitCore.getText("com.brikit.core.cancel")), preventCloseCallback);

		    // start first page, first panel
		    dialog.gotoPanel(0);
		    dialog.show();
		
			return dialog;
		},
		
		dialogDefaults: function (options) {
			var dialogOptions = {
				width: 	options.width || 400, 
				height: options.height || 200, 
				id: 	options.id || "brikit-confirm-dialog", 
				closeOnOutsideClick: !options.closeWithButtonOnly
			};

			// Disable ESC presses
			if (options.closeWithButtonOnly) dialogOptions.keypressListener = function (event) { return event.keyCode != 27; };

			return dialogOptions;
		},
		
		doubleConfirm: function (message, options, proceedCallback, cancelCallback) {

			options.id = options.id || "brikit-double-confirm-dialog";
			options.doubleConfirmMessage = options.doubleConfirmMessage || 
						BrikitCore.getText("com.brikit.core.i.understand.the.above");
			options.notConfirmedMessage = options.notConfirmedMessage || 
						"<p>" + BrikitCore.getText("com.brikit.core.you.do.not.seem.confident.about.this") + "</p><p>" + BrikitCore.getText("com.brikit.core.if.you.are.check.the.box.and.try.again") + "</p>";
				
			var doubleConfirmCallback = function (dialog) {
				if (!$("#double-confirm:checked").length) {
					BrikitCore.Dialog.alert(options.notConfirmedMessage, { title: BrikitCore.getText("com.brikit.core.are.you.sure") });
					if (cancelCallback) cancelCallback.call(this, dialog);
					dialog.hide();
					return false;
				}
				dialog.hide();
				proceedCallback.call(this, dialog);
			};
			
			message = message + "<form class='aui'><fieldset><label for='double-confirm'>" + options.doubleConfirmMessage +"</label> <input id='double-confirm' class='checkbox' type='checkbox' /></fieldset></form>";
			options.closeWithButtonOnly = true;
			BrikitCore.Dialog.confirm(message, options, doubleConfirmCallback, cancelCallback);
		
			return false;
		},
		
		inline: function (element, title, message, options, callback) {

			options = options || {};
			options.initCallback = function () { $(this.popup).css({zIndex: 10000}); };
			if (callback) options.hideCallback = callback;

			var dialog = AJS.InlineDialog($(element), "brikit-dialog-inline" + new Date().getTime(),
			    function(content, trigger, showPopup) {
			        content
						.css({"padding":"20px"})
						.html("<h2>" + title + "</h2><p>" + message + "</p><br/><form class='aui'><a href='#' class='close-link'>" + BrikitCore.getText("com.brikit.core.close") + "</a>");
					content.find(".close-link").click(function () { dialog.hide(); return false; });
			        showPopup();
			        return false;
			    },
				options
			);
		}
	};

})(jQuery);
