/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.ImportedObjectPostProcessor;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.BrikitVelocityContext;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.BrikitDeveloperSettingsListener;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.develop.ExternalDevelopmentModeSettings;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.model.BrikitPageElementDefaults;
import com.brikit.themepress.model.BrowserTweakerCache;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.model.SpaceExporter;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.model.StorableArchitecturePageReference;
import com.brikit.themepress.module.ThemePressModuleDescriptor;
import com.brikit.themepress.module.ThemePressPluginModulePanel;
import com.brikit.themepress.settings.SpaceCategorySettings;
import com.brikit.themepress.settings.ThemeCssCache;
import com.brikit.themepress.settings.ThemeJavaScriptCache;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.util.ThemePress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

public class BrikitThemeSettings
implements Cloneable {
    public static final String THEME_PRESS_BUILT_IN_FILE = "Brikit Theme Press";
    public static final String THIRD_PARTY_THEME_PRESS_PLUGIN_FILE = "Third-Party Theme Press Plugin";
    public static final String THEME_CUSTOM_CODE_FILE = "Theme Custom Code";
    public static final String VELOCITY_EXTRAS_FOR_CSS = "velocity";
    public static final String SPACE_LOGO_TARGET_KEY = "com.brikit.space.logo.target";
    public static final String SPACE_LOGO_HORIZONTAL_MARGIN = "com.brikit.space.logo.horizontal.margin";
    public static final String SPACE_LOGO_VERTICAL_MARGIN = "com.brikit.space.logo.vertical.margin";
    public static final String SPACE_LOGO_HORIZONTAL_POSITION = "com.brikit.space.logo.horizontal.position";
    public static final String SPACE_LOGO_VERTICAL_POSITION = "com.brikit.space.logo.vertical.position";
    public static final String SPACE_LOGO_HEIGHT = "com.brikit.space.logo.height";
    public static final String SPACE_LOGO_WIDTH = "com.brikit.space.logo.width";
    public static final String SPACE_LAYOUT_PAGE_KEY = "com.brikit.space.layout.page";
    public static final String SPACE_MENU_PAGE_KEY = "com.brikit.space.menu.page";
    public static final String SPACE_HEADER_PAGE_KEY = "com.brikit.space.header.page";
    public static final String SPACE_FOOTER_PAGE_KEY = "com.brikit.space.footer.page";
    public static final String SPACE_BANNER_PAGE_KEY = "com.brikit.space.banner.page";
    public static final String SPACE_BLOG_LAYOUT_PAGE_KEY = "com.brikit.space.blog.layout.page";
    protected static final String KEY_DELIMITER = "~~~";
    public static final List<String> DEFAULT_ARCHITECT_PAGE_NAMES;
    protected static Map<String, String> backwardCompatibilityThemeDefaults;
    private static final String DEFAULT_SPACE_THEME = "vanilla";
    public static final String ANONYMOUS = "anonymous";
    public static final String DOMAIN_THEME_OVERRIDES_FILENAME = "domain-theme.properties";
    public static final String GROUP_THEME_OVERRIDES_FILENAME = "group-theme.properties";
    public static final String JAVASCRIPT_I18N_FILENAME = "javascriptI18N.properties";
    public static final String GENERATED_JAVASCRIPT_I18N_FILENAME = "i18n.js";
    public static final String EXPORT_ARCHITECT_PAGES_NAME = "theme-press-architect-pages";
    public static final String EXPORT_ARCHITECT_PAGES_FILENAME = "theme-press-architect-pages.zip";
    private static final String DEMO_SPACE_ZIP_FILE_LOCATION = "theme-press/install/spaces/";
    private static final String DEMO_ARCHITECT_PAGES_ZIP_FILE_LOCATION = "theme-press/install/architect-pages/theme-press-architect-pages.zip";
    private static final String DEMO_SPACE_THEME = "splash";
    protected static Properties domainThemeOverrides;
    protected static Properties groupThemeOverrides;

    public static void addArchitectSourceLabel(Page anArchitectSourcePage) {
        if (!ThemePress.isArchitectPage((AbstractPage)anArchitectSourcePage)) {
            return;
        }
        if (anArchitectSourcePage.getDisplayTitle().startsWith(".brikit.menu")) {
            Confluence.addLabel((String)"theme-press-menu", (AbstractPage)anArchitectSourcePage);
        }
        if (anArchitectSourcePage.getDisplayTitle().startsWith(".brikit.header")) {
            Confluence.addLabel((String)"theme-press-header", (AbstractPage)anArchitectSourcePage);
        }
        if (anArchitectSourcePage.getDisplayTitle().startsWith(".brikit.footer")) {
            Confluence.addLabel((String)"theme-press-footer", (AbstractPage)anArchitectSourcePage);
        }
        if (anArchitectSourcePage.getDisplayTitle().startsWith(".brikit.banner")) {
            Confluence.addLabel((String)"theme-press-banner", (AbstractPage)anArchitectSourcePage);
        }
        if (anArchitectSourcePage.getDisplayTitle().startsWith(".brikit.layout")) {
            Confluence.addLabel((String)"theme-press-layout", (AbstractPage)anArchitectSourcePage);
        }
    }

    public static void clearSpaceArchitectSettings(Space aSpace) {
        BrikitThemeSettings.setTheme(aSpace.getKey(), null);
        BrikitThemeSettings.setLogoTargetSpace(aSpace, null);
        BrikitThemeSettings.setBannerPage(aSpace, null);
        BrikitThemeSettings.setHeaderPage(aSpace, null);
        BrikitThemeSettings.setMenuPage(aSpace, null);
        BrikitThemeSettings.setLayoutPage(aSpace, null);
        BrikitThemeSettings.setBlogLayoutPage(aSpace, null);
        BrikitThemeSettings.setFooterPage(aSpace, null);
        SpaceWrapper wrapper = SpaceWrapper.get(aSpace);
        wrapper.setOverrideDefaultBanner(false);
        wrapper.setOverrideDefaultHeader(false);
        wrapper.setOverrideDefaultMenu(false);
        wrapper.setOverrideDefaultLayout(false);
        wrapper.setOverrideDefaultFooter(false);
        ThemePress.resetCachesNonTheme();
        BrikitLog.log((String)("Cleared all space architect settings for " + aSpace));
    }

    protected static String calculateArchitectDefaultPage(String oldDefaultTitle, String newDefaultTitle) {
        Page page = ThemePress.getArchitectPage(oldDefaultTitle);
        if (page == null) {
            page = ThemePress.getArchitectPage(newDefaultTitle);
        }
        return page == null ? null : page.getTitle();
    }

    protected static ImportedObjectPostProcessor createImportContextPostProcessor(final Date importStartTime) {
        return new ImportedObjectPostProcessor(){

            public boolean process(Object obj) {
                if (obj instanceof ConfluenceEntityObject) {
                    ConfluenceEntityObject entityObject = (ConfluenceEntityObject)obj;
                    if (entityObject instanceof Page) {
                        entityObject.setLastModificationDate(new Date());
                    } else {
                        entityObject.setLastModificationDate(importStartTime);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static String cssBundle(String mediaType, String pageIdAsString, String spaceKey) throws ExecutionException {
        if (!BrikitString.isSet((String)spaceKey)) {
            spaceKey = Confluence.getSpaceKeyFromPage((String)pageIdAsString);
        }
        String themeName = BrikitThemeSettings.getThemeName(spaceKey);
        return BrikitThemeSettings.cssBundle(mediaType, themeName);
    }

    public static String cssBundle(String mediaType, String themeName) throws ExecutionException {
        if (!ThemePlugin.isInstalled(themeName)) {
            themeName = BrikitThemeSettings.getDefaultThemeName();
        }
        String tweaker = BrowserTweakerCache.getTweaker(themeName);
        String cacheKey = ThemeCssCache.getBundleName(themeName, tweaker, mediaType);
        ThemeCssCache.getCSS(cacheKey);
        return cacheKey;
    }

    public static String cssFilesForThemePressPlugins(String mediaType) {
        BrikitList fullNames = new BrikitList();
        for (ThemePressModuleDescriptor pluginModule : ThemePress.getThemePressPluginModules()) {
            String cssList = null;
            if ("all".equalsIgnoreCase(mediaType)) {
                cssList = pluginModule.getCssAllMediaFileList();
            } else if ("edit".equalsIgnoreCase(mediaType)) {
                cssList = pluginModule.getCssEditFilesList();
            } else if ("print".equalsIgnoreCase(mediaType)) {
                cssList = pluginModule.getCssPrintMediaFileList();
            }
            if (!BrikitString.isSet((String)cssList)) continue;
            for (String file : BrikitString.split((String)cssList)) {
                fullNames.add((Object)(pluginModule.getCssResourceLocation() + "/" + file));
            }
        }
        return fullNames.join();
    }

    public static List<ThemePressPluginModulePanel> getThemePressPluginModulePanels(String appKey) {
        ArrayList<ThemePressPluginModulePanel> panels = new ArrayList<ThemePressPluginModulePanel>();
        ThemePressModuleDescriptor pluginModule = ThemePress.getThemePressPluginModule(appKey);
        String keyList = pluginModule.getPanelKeyList();
        if (!BrikitString.isSet((String)keyList)) {
            return panels;
        }
        Map<String, String> panelNames = pluginModule.getPanelNames();
        Map<String, String> panelTemplates = pluginModule.getPanelTemplates();
        Map<String, String> panelSelectors = pluginModule.getPanelSelectors();
        for (String key : BrikitString.split((String)keyList)) {
            ThemePressPluginModulePanel panel = new ThemePressPluginModulePanel();
            panel.setName(panelNames.get(key));
            panel.setTemplate(panelTemplates.get(key));
            panel.setTemplateLocation(pluginModule.getPanelsResourceLocation());
            panel.setSelector(panelSelectors.get(key));
            panels.add(panel);
        }
        return panels;
    }

    public static Page getArchitectPageForSpace(AbstractPage aPage, String anArchitectPageType) {
        if (aPage == null || !BrikitString.isSet((String)anArchitectPageType)) {
            return null;
        }
        String architectPageName = BrikitThemeSettings.getArchitectPageName(aPage, anArchitectPageType);
        Page architectPage = ThemePress.getArchitectPage(architectPageName);
        if (architectPage == null) {
            architectPage = ThemePress.getArchitectPage(anArchitectPageType);
        }
        return architectPage;
    }

    public static String getArchitectPageName(AbstractPage aPage, String anArchitectPageType) {
        if (aPage == null || !BrikitString.isSet((String)anArchitectPageType)) {
            return null;
        }
        Space space = Confluence.getSpace((AbstractPage)aPage);
        if (".brikit.menu.".equals(anArchitectPageType)) {
            return BrikitThemeSettings.getMenuPageTitle(space);
        }
        if (".brikit.header.".equals(anArchitectPageType)) {
            return BrikitThemeSettings.getHeaderPageTitle(space);
        }
        if (".brikit.footer.".equals(anArchitectPageType)) {
            return BrikitThemeSettings.getFooterPageTitle(space);
        }
        if (".brikit.banner.".equals(anArchitectPageType)) {
            return BrikitThemeSettings.getBannerPageTitle(space);
        }
        if (".brikit.layout.".equals(anArchitectPageType) && Confluence.isBlog((AbstractPage)aPage)) {
            return BrikitThemeSettings.getBlogLayoutPageTitle(aPage, space);
        }
        if (".brikit.layout.".equals(anArchitectPageType)) {
            return BrikitThemeSettings.getLayoutPageTitle(aPage, space);
        }
        return null;
    }

    public static String getArchitectPageSetting(Space aSpace, String key, String overrideKey, String defaultTitle, AbstractPage forPage) {
        String data = BrikitBandanaManager.getEntry((Space)aSpace, (String)key);
        String override = BrikitBandanaManager.getEntry((Space)aSpace, (String)overrideKey);
        Page page = StorableArchitecturePageReference.convert(data);
        if (page != null && !StorableArchitecturePageReference.dataMatches(data, page)) {
            BrikitThemeSettings.setArchitectPageSetting(aSpace, key, page);
        }
        if (aSpace != null && !BrikitBoolean.booleanValue((String)override)) {
            String categorySetting = SpaceCategorySettings.getSpaceCategoryArchitectPage(aSpace, key, forPage);
            return BrikitString.isSet((String)categorySetting) ? categorySetting : defaultTitle;
        }
        return page == null ? defaultTitle : page.getTitle();
    }

    protected static Map<String, String> getBackwardCompatibilityThemeDefaults() {
        if (backwardCompatibilityThemeDefaults == null) {
            backwardCompatibilityThemeDefaults = new HashMap<String, String>();
            backwardCompatibilityThemeDefaults.put("brikitHideBlogPostsMacroExcerptsMetadata", "on");
            backwardCompatibilityThemeDefaults.put("brikitHideBlogPostsMacroExcerptsLabels", "on");
        }
        return backwardCompatibilityThemeDefaults;
    }

    public static String getBannerPageTitle(Space aSpace) {
        if (ThemePress.isDefaultSpace(aSpace)) {
            return BrikitThemeSettings.getDefaultBannerTitle();
        }
        return BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_BANNER_PAGE_KEY, "com.brikit.space.override.banner", BrikitThemeSettings.getDefaultBannerTitle(), null);
    }

    public static String getBlogLayoutPageTitle(AbstractPage aPage, Space aSpace) {
        String title = BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_BLOG_LAYOUT_PAGE_KEY, "com.brikit.space.override.layout", null, aPage);
        if (!BrikitString.isSet((String)title) && ThemePress.getArchitectPage(".brikit.layout.Community") != null) {
            title = ".brikit.layout.Community";
        }
        return BrikitString.isSet((String)title) ? title : BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_LAYOUT_PAGE_KEY, "com.brikit.space.override.layout", ".brikit.layout.Community", aPage);
    }

    public static String getConfiguredDefaultBannerTitle() {
        return BrikitThemeSettings.getArchitectPageSetting(null, SPACE_BANNER_PAGE_KEY, "com.brikit.space.override.banner", null, null);
    }

    public static String getConfiguredDefaultFooterTitle() {
        return BrikitThemeSettings.getArchitectPageSetting(null, SPACE_FOOTER_PAGE_KEY, "com.brikit.space.override.footer", null, null);
    }

    public static String getConfiguredDefaultHeaderTitle() {
        return BrikitThemeSettings.getArchitectPageSetting(null, SPACE_HEADER_PAGE_KEY, "com.brikit.space.override.header", null, null);
    }

    public static String getConfiguredDefaultLayoutTitle() {
        return BrikitThemeSettings.getArchitectPageSetting(null, SPACE_LAYOUT_PAGE_KEY, "com.brikit.space.override.layout", null, null);
    }

    public static String getConfiguredDefaultMenuTitle() {
        return BrikitThemeSettings.getArchitectPageSetting(null, SPACE_MENU_PAGE_KEY, "com.brikit.space.override.menu", null, null);
    }

    public static String getConfiguredDefaultThemeName() {
        return BrikitBandanaManager.getEntry(null, (String)"com.brikit.site.theme");
    }

    protected static Map getCSSVelocityContext(ThemeProperties themeProperties) {
        Map context = BrikitVelocityContext.getDefaultVelocityContext();
        try {
            context.putAll(themeProperties.settingsAfterSubstitution());
        }
        catch (ExecutionException ex) {
            BrikitLog.logError((String)"Failed to add theme settings to velocity context when calculating theme css cache.", (Exception)ex);
        }
        return context;
    }

    public static Page getDefaultBanner() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getDefaultBannerTitle());
    }

    public static String getDefaultBannerTitle() {
        String title = BrikitThemeSettings.getConfiguredDefaultBannerTitle();
        if (!BrikitString.isSet((String)title)) {
            title = BrikitThemeSettings.calculateArchitectDefaultPage(".brikit.banner", ".brikit.banner.Empty");
        }
        return title;
    }

    public static Page getDefaultBlogLayout() {
        return ThemePress.getArchitectPage(".brikit.layout.Community");
    }

    public static Page getDefaultFooter() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getDefaultFooterTitle());
    }

    public static String getDefaultFooterTitle() {
        String title = BrikitThemeSettings.getConfiguredDefaultFooterTitle();
        if (!BrikitString.isSet((String)title)) {
            title = BrikitThemeSettings.calculateArchitectDefaultPage(".brikit.footer", ".brikit.footer.Simple");
        }
        return title;
    }

    public static Page getDefaultHeader() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getDefaultHeaderTitle());
    }

    public static String getDefaultHeaderTitle() {
        String title = BrikitThemeSettings.getConfiguredDefaultHeaderTitle();
        if (!BrikitString.isSet((String)title)) {
            title = BrikitThemeSettings.calculateArchitectDefaultPage(".brikit.header", ".brikit.header.Empty");
        }
        return title;
    }

    public static Page getDefaultLayout() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getDefaultLayoutTitle());
    }

    public static String getDefaultLayoutTitle() {
        String title = BrikitThemeSettings.getConfiguredDefaultLayoutTitle();
        if (!BrikitString.isSet((String)title)) {
            title = BrikitThemeSettings.calculateArchitectDefaultPage(".brikit.layout", ".brikit.layout.Community");
        }
        return title;
    }

    public static Page getDefaultMenu() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getDefaultMenuTitle());
    }

    public static String getDefaultMenuTitle() {
        String title = BrikitThemeSettings.getConfiguredDefaultMenuTitle();
        if (!BrikitString.isSet((String)title)) {
            title = BrikitThemeSettings.calculateArchitectDefaultPage(".brikit.menu", ".brikit.menu.Demo");
        }
        return title;
    }

    public static String getDefaultThemeName() {
        Confluence.waitForConfluenceSetupComplete();
        String themeName = BrikitThemeSettings.getOverrideTheme();
        if (!BrikitString.isSet((String)themeName)) {
            themeName = BrikitThemeSettings.getConfiguredDefaultThemeName();
        }
        if (!ThemePlugin.isInstalled(themeName)) {
            themeName = null;
        }
        if (themeName == null && !ThemePlugin.getPermittedThemes().isEmpty()) {
            themeName = ThemePlugin.getPermittedThemes().get(0);
        }
        if (themeName == null && !ThemePlugin.getAvailableThemes().isEmpty()) {
            themeName = ThemePlugin.getAvailableThemes().get(0);
        }
        return themeName;
    }

    private static File getDemoArchitectPagesZip() throws Exception {
        return BrikitThemeSettings.getTempFileFromAppResource(DEMO_ARCHITECT_PAGES_ZIP_FILE_LOCATION);
    }

    private static File getDemoSpaceZip(String spaceKey) throws Exception {
        return BrikitThemeSettings.getTempFileFromAppResource(DEMO_SPACE_ZIP_FILE_LOCATION + spaceKey + ".zip");
    }

    private static File getTempFileFromAppResource(String resourceName) throws Exception {
        int read;
        InputStream inputStream = BrikitThemeSettings.class.getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new Exception("Could not find " + resourceName + " in the app resources.");
        }
        File file = File.createTempFile("tempfile", ".zip");
        FileOutputStream out = new FileOutputStream(file);
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            ((OutputStream)out).write(bytes, 0, read);
        }
        return file;
    }

    protected static Properties getDomainThemeOverrides() {
        if (domainThemeOverrides == null) {
            File propertiesFile = BrikitFile.getBrikitFile((String)DOMAIN_THEME_OVERRIDES_FILENAME);
            domainThemeOverrides = BrikitFile.readProperties((File)propertiesFile);
        }
        return domainThemeOverrides;
    }

    public static String getFooterPageTitle(Space aSpace) {
        if (ThemePress.isDefaultSpace(aSpace)) {
            return BrikitThemeSettings.getDefaultFooterTitle();
        }
        return BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_FOOTER_PAGE_KEY, "com.brikit.space.override.footer", BrikitThemeSettings.getDefaultFooterTitle(), null);
    }

    protected static Properties getGroupThemeOverrides() {
        if (groupThemeOverrides == null) {
            File propertiesFile = BrikitFile.getBrikitFile((String)GROUP_THEME_OVERRIDES_FILENAME);
            groupThemeOverrides = BrikitFile.readProperties((File)propertiesFile);
        }
        return groupThemeOverrides;
    }

    public static String getHeaderPageTitle(Space aSpace) {
        if (ThemePress.isDefaultSpace(aSpace)) {
            return BrikitThemeSettings.getDefaultHeaderTitle();
        }
        return BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_HEADER_PAGE_KEY, "com.brikit.space.override.header", BrikitThemeSettings.getDefaultHeaderTitle(), null);
    }

    public static String getLayoutPageTitle(AbstractPage aPage, Space aSpace) {
        if (ThemePress.isDefaultSpace(aSpace)) {
            return BrikitThemeSettings.getDefaultLayoutTitle();
        }
        return BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_LAYOUT_PAGE_KEY, "com.brikit.space.override.layout", BrikitThemeSettings.getDefaultLayoutTitle(), aPage);
    }

    public static String getLogoTargetSpace(Space aSpace) {
        if (aSpace == null) {
            return null;
        }
        String key = BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_TARGET_KEY);
        if (!BrikitString.isSet((String)key)) {
            key = SpaceCategorySettings.getSpaceCategoryLogoTargetSpaceKey(aSpace);
        }
        return BrikitString.isSet((String)key) ? key : null;
    }

    public static String getLogoTargetSpace(String spaceKey) {
        return BrikitThemeSettings.getLogoTargetSpace(Confluence.getSpace((String)spaceKey));
    }

    public static String getMenuPageTitle(Space aSpace) {
        if (ThemePress.isDefaultSpace(aSpace)) {
            return BrikitThemeSettings.getDefaultMenuTitle();
        }
        return BrikitThemeSettings.getArchitectPageSetting(aSpace, SPACE_MENU_PAGE_KEY, "com.brikit.space.override.menu", BrikitThemeSettings.getDefaultMenuTitle(), null);
    }

    public static List<String> getMissingArchitectPageNames() {
        ArrayList<String> missing = new ArrayList<String>();
        for (String title : DEFAULT_ARCHITECT_PAGE_NAMES) {
            if (ThemePress.getArchitectPage(title) != null) continue;
            missing.add(title);
        }
        return missing;
    }

    public static List<String> getMissingThemeNames() {
        ArrayList<String> installed = new ArrayList<String>();
        for (File themeFolder : ThemePlugin.getInstalledThemeFolders()) {
            installed.add(themeFolder.getName());
        }
        ArrayList<String> missing = new ArrayList<String>();
        for (String theme : ThemePlugin.BUILT_IN_THEMES) {
            if (installed.contains(theme)) continue;
            missing.add(theme);
        }
        return missing;
    }

    public static String getOverrideTheme() {
        return null;
    }

    public static String getSpaceLogoHeight(Space aSpace) {
        return aSpace == null ? null : BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_HEIGHT);
    }

    public static String getSpaceLogoHeight(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoHeight(Confluence.getSpace((String)spaceKey));
    }

    public static String getSpaceLogoHorizontalMargin(Space aSpace) {
        return aSpace == null ? null : BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_HORIZONTAL_MARGIN);
    }

    public static String getSpaceLogoHorizontalMargin(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoHorizontalMargin(Confluence.getSpace((String)spaceKey));
    }

    public static String getSpaceLogoHorizontalPosition(Space aSpace) {
        return aSpace == null ? null : BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_HORIZONTAL_POSITION);
    }

    public static String getSpaceLogoHorizontalPosition(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoHorizontalPosition(Confluence.getSpace((String)spaceKey));
    }

    public static String getSpaceLogoVerticalMargin(Space aSpace) {
        return aSpace == null ? null : BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_VERTICAL_MARGIN);
    }

    public static String getSpaceLogoVerticalMargin(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoVerticalMargin(Confluence.getSpace((String)spaceKey));
    }

    public static String getSpaceLogoVerticalPosition(Space aSpace) {
        return aSpace == null ? null : BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_VERTICAL_POSITION);
    }

    public static String getSpaceLogoVerticalPosition(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoVerticalPosition(Confluence.getSpace((String)spaceKey));
    }

    public static String getSpaceLogoWidth(Space aSpace) {
        return aSpace == null ? null : BrikitBandanaManager.getEntry((Space)aSpace, (String)SPACE_LOGO_WIDTH);
    }

    public static String getSpaceLogoWidth(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoWidth(Confluence.getSpace((String)spaceKey));
    }

    public static String getThemeName(Space aSpace) {
        if (aSpace != null) {
            return SpaceWrapper.get(aSpace).getThemeName();
        }
        String overrideTheme = BrikitThemeSettings.getOverrideTheme();
        if (BrikitString.isSet((String)overrideTheme)) {
            return overrideTheme;
        }
        return BrikitThemeSettings.getDefaultThemeName();
    }

    public static String getThemeName(String spaceKey) {
        return BrikitThemeSettings.getThemeName(Confluence.getSpace((String)spaceKey));
    }

    public static ThemeProperties getThemeProperties(AbstractPage aPage) {
        return BrikitThemeSettings.getThemeProperties(Confluence.getSpaceKey((AbstractPage)aPage));
    }

    public static ThemeProperties getThemeProperties(AbstractPage aPage, String spaceKey) {
        return aPage == null ? BrikitThemeSettings.getThemeProperties(spaceKey) : BrikitThemeSettings.getThemeProperties(aPage);
    }

    public static ThemeProperties getThemeProperties(long pageId) {
        return BrikitThemeSettings.getThemeProperties(Confluence.getPageOrBlogPost((long)pageId));
    }

    public static ThemeProperties getThemeProperties(String pageIdAsString, String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(Confluence.getPageOrBlogPost((String)pageIdAsString), spaceKey);
    }

    public static ThemeProperties getThemeProperties(Space aSpace) {
        Confluence.waitForConfluenceSetupComplete();
        String themeName = BrikitThemeSettings.getThemeName(aSpace);
        return ThemeProperties.getThemeProperties(themeName);
    }

    public static ThemeProperties getThemeProperties(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(Confluence.getSpace((String)spaceKey));
    }

    public static boolean isConfiguredDefaultTheme(String themeName) {
        return themeName != null && themeName.equals(BrikitThemeSettings.getDefaultThemeName());
    }

    public static boolean isUsingTheme(String spaceKey, String themeName) {
        return ThemePress.isThemePress(spaceKey) && BrikitString.isSet((String)themeName) && themeName.equalsIgnoreCase(SpaceWrapper.get(spaceKey).getThemeName());
    }

    public static String javaScriptBundle(String pageIdAsString, String spaceKey, boolean customCode, boolean skipDesignerSupport) throws ExecutionException {
        if (!BrikitString.isSet((String)spaceKey) && BrikitString.isSet((String)pageIdAsString)) {
            spaceKey = Confluence.getSpaceKeyFromPage((String)pageIdAsString);
        }
        String themeName = BrikitThemeSettings.getThemeName(spaceKey);
        return BrikitThemeSettings.javaScriptBundle(themeName, customCode, skipDesignerSupport);
    }

    public static String javaScriptBundle(String themeName, boolean customCode, boolean skipDesignerSupport) throws ExecutionException {
        String tweaker = BrowserTweakerCache.getTweaker(themeName);
        String cacheKey = ThemeJavaScriptCache.getBundleName(themeName, tweaker, customCode, skipDesignerSupport);
        ThemeJavaScriptCache.getJavaScript(cacheKey);
        return cacheKey;
    }

    public static String javascriptFilesForThemePressPlugins() {
        if (!ExternalDevelopmentMode.isDeveloperMode()) {
            return "";
        }
        BrikitList fullNames = new BrikitList();
        for (ThemePressModuleDescriptor pluginModule : ThemePress.getThemePressPluginModules()) {
            String scriptList = pluginModule.getScriptsFileList();
            if (!BrikitString.isSet((String)scriptList)) continue;
            for (String file : BrikitString.split((String)scriptList)) {
                fullNames.add((Object)(pluginModule.getScriptsResourceLocation() + "/" + file));
            }
        }
        return fullNames.join();
    }

    public static Map<String, String> javascriptI18nPropertiesFiles() {
        HashMap<String, String> filenames = new HashMap<String, String>();
        filenames.put("ThemePress", "scripts/javascriptI18N.properties");
        for (ThemePressModuleDescriptor pluginModule : ThemePress.getThemePressPluginModules()) {
            String root = pluginModule.getJavascriptRoot();
            if (root == null) continue;
            filenames.put(root, pluginModule.getScriptsResourceLocation() + "/" + JAVASCRIPT_I18N_FILENAME);
        }
        return filenames;
    }

    public static File getExternalDevelopmentFile(String pluginKey, String filename, String type, String extension) {
        return new File(BrikitThemeSettings.getExternalDevelopmentFilePath(pluginKey, filename, type, extension));
    }

    public static String getExternalDevelopmentFilePath(String pluginKey, String filename, String type, String extension) {
        String location = ExternalDevelopmentModeSettings.getResourceLocation((String)pluginKey, (String)type);
        String addExtension = BrikitString.isSet((String)extension) ? "." + extension : "";
        return location + "/" + filename + addExtension;
    }

    protected static void readCssFile(StringBuilder buffer, String themeName, Map velocityContext, String source, String filename) {
        String type = "css";
        String extension = "css";
        String contents = null;
        try {
            if (THEME_PRESS_BUILT_IN_FILE.equals(source)) {
                if (ExternalDevelopmentMode.isDeveloperMode()) {
                    String filePath = BrikitThemeSettings.getExternalDevelopmentFilePath(ThemePress.PLUGIN_KEY, filename, type, extension);
                    if (!new File(filePath).exists()) {
                        throw new Exception("File not found: " + filePath);
                    }
                    contents = BrikitFile.readFileUTF8((String)filePath);
                } else {
                    String filePath = ThemeResourceServlet.getServerFileLocation((String)(type + "/" + filename + "." + extension));
                    contents = BrikitFile.readInputStreamUTF8((InputStream)ClassLoaderUtils.getResourceAsStream((String)filePath, BrikitThemeSettings.class));
                }
            } else if (THEME_CUSTOM_CODE_FILE.equals(source)) {
                File themeFile = ThemePlugin.getThemeResourceFile(themeName, type + "/" + filename + "." + extension);
                if (!themeFile.exists()) {
                    throw new Exception("File not found: " + themeFile.getAbsolutePath());
                }
                contents = BrikitFile.readFileUTF8((File)themeFile);
            } else if (ExternalDevelopmentMode.isDeveloperMode()) {
                String filePath = BrikitThemeSettings.getExternalDevelopmentFilePath(source, filename, type, extension);
                contents = BrikitFile.readFileUTF8((String)filePath);
            } else {
                contents = BrikitFile.readInputStreamUTF8((InputStream)Confluence.getPluginAccessor().getDynamicResourceAsStream(filename + "." + extension));
            }
        }
        catch (Exception ex) {
            if (ExternalDevelopmentModeSettings.cachesEnabled()) {
                BrikitLog.logWarning((String)("Failed to read CSS file in " + source + ": " + filename));
            }
            return;
        }
        buffer.append("\n\n/********************\n " + filename + ".css \n********************/\n\n");
        buffer.append(Confluence.renderSafeVelocityTemplate((String)contents, (Map)velocityContext));
        buffer.append("\n\n");
    }

    protected static void readCssFiles(StringBuilder buffer, String cssList, String themeName, Map velocityContext, String source) {
        for (String filename : BrikitString.split((String)VELOCITY_EXTRAS_FOR_CSS)) {
            BrikitThemeSettings.readCssFile(buffer, themeName, velocityContext, THEME_PRESS_BUILT_IN_FILE, filename);
        }
        for (String filename : BrikitString.split((String)cssList)) {
            BrikitThemeSettings.readCssFile(buffer, themeName, velocityContext, source, filename);
        }
    }

    protected static void readJavascriptFile(StringBuilder buffer, String themeName, String source, String filename) {
        String type = "scripts";
        String extension = "js";
        String contents = null;
        try {
            if (THEME_PRESS_BUILT_IN_FILE.equals(source)) {
                if (ExternalDevelopmentMode.isDeveloperMode()) {
                    String filePath = BrikitThemeSettings.getExternalDevelopmentFilePath(ThemePress.PLUGIN_KEY, filename, type, extension);
                    if (!new File(filePath).exists()) {
                        throw new Exception("File not found: " + filePath);
                    }
                    contents = BrikitFile.readFileUTF8((String)filePath);
                } else {
                    String filePath = ThemeResourceServlet.getServerFileLocation((String)(type + "/" + filename + "." + extension));
                    InputStream inputStream = ClassLoaderUtils.getResourceAsStream((String)filePath, BrikitThemeSettings.class);
                    contents = BrikitFile.readInputStreamUTF8((InputStream)inputStream);
                }
            } else if (THEME_CUSTOM_CODE_FILE.equals(source)) {
                File themeFile = ThemePlugin.getThemeResourceFile(themeName, type + "/" + filename + "." + extension);
                if (!themeFile.exists()) {
                    throw new Exception("File not found: " + themeFile.getAbsolutePath());
                }
                contents = BrikitFile.readFileUTF8((File)themeFile);
            } else if (ExternalDevelopmentMode.isDeveloperMode()) {
                String filePath = BrikitThemeSettings.getExternalDevelopmentFilePath(source, filename, type, extension);
                contents = BrikitFile.readFileUTF8((String)filePath);
            } else {
                contents = BrikitFile.readInputStreamUTF8((InputStream)Confluence.getPluginAccessor().getDynamicResourceAsStream(filename + "." + extension));
            }
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Failed to read JavaScript file in " + source + ": " + filename));
            return;
        }
        buffer.append("\n\n// ******************** " + filename + ".js start\n\n");
        buffer.append(contents);
        buffer.append("\n\n// ******************** " + filename + ".js end\n\n");
    }

    protected static void readJavascriptFiles(StringBuilder buffer, String javascriptList, String themeName, String source) {
        for (String filename : BrikitString.split((String)javascriptList)) {
            BrikitThemeSettings.readJavascriptFile(buffer, themeName, source, filename);
        }
    }

    public static void removeDefaultSpace() throws Exception {
        Space defaultSpace = ThemePress.getThemePressDefaultSpace();
        if (defaultSpace != null) {
            Confluence.getSpaceManager().removeSpace(defaultSpace);
        }
        BrikitBandanaManager.saveEntry(null, (String)"com.brikit.site.theme", null);
    }

    public static void removeDemoSpaces() throws Exception {
        Space demoSpace = ThemePress.getThemePressSplashDemoSpace();
        if (demoSpace != null) {
            Confluence.getSpaceManager().removeSpace(demoSpace);
        }
        if ((demoSpace = ThemePress.getThemePressVanillaDemoSpace()) != null) {
            Confluence.getSpaceManager().removeSpace(demoSpace);
        }
    }

    public static void resetThemeOverridesCache() {
        domainThemeOverrides = null;
        groupThemeOverrides = null;
    }

    public static void setArchitectPageName(AbstractPage aPage, String anArchitectPageType, String selectedPageTitle) throws Exception {
        if (!ThemePress.architectPageExists(selectedPageTitle)) {
            throw new Exception(Confluence.getText((String)"com.brikit.architect.page.does.not.exist"));
        }
        Space space = Confluence.getSpace((AbstractPage)aPage);
        if (".brikit.menu.".equals(anArchitectPageType)) {
            BrikitThemeSettings.setMenuPage(space, selectedPageTitle);
        } else if (".brikit.header.".equals(anArchitectPageType)) {
            BrikitThemeSettings.setHeaderPage(space, selectedPageTitle);
        } else if (".brikit.footer.".equals(anArchitectPageType)) {
            BrikitThemeSettings.setFooterPage(space, selectedPageTitle);
        } else if (".brikit.banner.".equals(anArchitectPageType)) {
            BrikitThemeSettings.setBannerPage(space, selectedPageTitle);
        } else if (".brikit.layout.".equals(anArchitectPageType) && Confluence.isBlog((AbstractPage)aPage)) {
            BrikitThemeSettings.setBlogLayoutPage(space, selectedPageTitle);
        } else if (".brikit.layout.".equals(anArchitectPageType)) {
            BrikitThemeSettings.setLayoutPage(space, selectedPageTitle);
        }
        PageWrapperCache.reset();
    }

    public static void setArchitectPageSetting(Space aSpace, String key, Page aPage) {
        BrikitLog.log((String)("Updating architect page setting to " + StorableArchitecturePageReference.data(aPage) + " for " + aSpace));
        BrikitBandanaManager.saveEntry((Space)aSpace, (String)key, (Object)StorableArchitecturePageReference.data(aPage));
    }

    public static void setArchitectPageSetting(Space aSpace, String key, String pageTitle, String prefix) {
        if (!(pageTitle == null || prefix.startsWith(pageTitle) || pageTitle.startsWith(".brikit.frame") && prefix.startsWith(".brikit.layout") || pageTitle.startsWith(prefix))) {
            pageTitle = prefix + pageTitle;
        }
        Page page = BrikitString.isSet((String)pageTitle) ? ThemePress.getArchitectPage(pageTitle) : null;
        BrikitThemeSettings.setArchitectPageSetting(aSpace, key, page);
    }

    public static void setBannerPage(Space aSpace, String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(aSpace, SPACE_BANNER_PAGE_KEY, aPageName, ".brikit.banner.");
    }

    public static void setBlogLayoutPage(Space aSpace, String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(aSpace, SPACE_BLOG_LAYOUT_PAGE_KEY, aPageName, ".brikit.layout.");
    }

    public static void setDefaultBanner(String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(null, SPACE_BANNER_PAGE_KEY, aPageName, ".brikit.banner.");
    }

    public static void setDefaultFooter(String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(null, SPACE_FOOTER_PAGE_KEY, aPageName, ".brikit.footer.");
    }

    public static void setDefaultHeader(String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(null, SPACE_HEADER_PAGE_KEY, aPageName, ".brikit.header.");
    }

    public static void setDefaultLayout(String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(null, SPACE_LAYOUT_PAGE_KEY, aPageName, ".brikit.layout.");
    }

    public static void setDefaultMenu(String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(null, SPACE_MENU_PAGE_KEY, aPageName, ".brikit.menu.");
    }

    public static void setDefaultThemeName(String themeName) {
        BrikitBandanaManager.saveEntry(null, (String)"com.brikit.site.theme", (Object)themeName);
    }

    public static void setFooterPage(Space aSpace, String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(aSpace, SPACE_FOOTER_PAGE_KEY, aPageName, ".brikit.footer.");
    }

    public static void setHeaderPage(Space aSpace, String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(aSpace, SPACE_HEADER_PAGE_KEY, aPageName, ".brikit.header.");
    }

    public static void setLayoutPage(Space aSpace, String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(aSpace, SPACE_LAYOUT_PAGE_KEY, aPageName, ".brikit.layout.");
    }

    public static void setSpaceLogoHeight(Space aSpace, String newValue) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_HEIGHT, (Object)newValue);
        }
    }

    public static void setSpaceLogoHorizontalMargin(Space aSpace, String newValue) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_HORIZONTAL_MARGIN, (Object)newValue);
        }
    }

    public static void setSpaceLogoHorizontalPosition(Space aSpace, String newValue) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_HORIZONTAL_POSITION, (Object)newValue);
        }
    }

    public static void setLogoTargetSpace(Space aSpace, String targetSpaceKey) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_TARGET_KEY, (Object)targetSpaceKey);
        }
    }

    public static void setSpaceLogoVerticalMargin(Space aSpace, String newValue) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_VERTICAL_MARGIN, (Object)newValue);
        }
    }

    public static void setSpaceLogoWidth(Space aSpace, String newValue) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_WIDTH, (Object)newValue);
        }
    }

    public static void setSpaceLogoVerticalPosition(Space aSpace, String newValue) {
        if (aSpace != null) {
            BrikitBandanaManager.saveEntry((Space)aSpace, (String)SPACE_LOGO_VERTICAL_POSITION, (Object)newValue);
        }
    }

    public static void setMenuPage(Space aSpace, String aPageName) {
        BrikitThemeSettings.setArchitectPageSetting(aSpace, SPACE_MENU_PAGE_KEY, aPageName, ".brikit.menu.");
    }

    public static void setTheme(String spaceKey, String themeName) {
        SpaceWrapper.get(spaceKey).setThemeName(themeName);
        ThemePress.resetCaches();
    }

    public static void setupDefaults(TransactionTemplate transactionTemplate) throws Exception {
        Exception exception = (Exception)transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                try {
                    Space defaultsSpace = ThemePress.getThemePressDefaultSpace();
                    if (defaultsSpace == null) {
                        defaultsSpace = Confluence.createPrivateSpace((String)"themepressdefault", (String)"Theme Press Default", (String)"Pages that define all menus, headers, footers, banners, etc. for Brikit Theme Press");
                        Confluence.setSpaceThemeKey((Space)defaultsSpace, (String)"com.brikit.themepress:theme-base");
                    }
                    for (String permissionString : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                        defaultsSpace.addPermission(SpacePermission.createUserSpacePermission((String)permissionString, (Space)defaultsSpace, (ConfluenceUser)Confluence.getConfluenceUser()));
                    }
                    Page defaultsHome = defaultsSpace.getHomePage();
                    if (!defaultsHome.getDisplayTitle().equals(".brikit")) {
                        Confluence.savePageTitle((AbstractPage)defaultsHome, (String)".brikit");
                    }
                    Confluence.savePageWithoutPermissionCheck((AbstractPage)defaultsHome, (String)BrikitPageElementDefaults.getDefaultPageContents(".brikit"), null, (boolean)false);
                    SpaceExporter exporter = new SpaceExporter(BrikitThemeSettings.getDemoArchitectPagesZip(), defaultsSpace, false, BrikitThemeSettings.EXPORT_ARCHITECT_PAGES_NAME);
                    exporter.importSpace(false);
                    BrikitThemeSettings.getDemoArchitectPagesZip().delete();
                    if (!BrikitString.isSet((String)BrikitThemeSettings.getConfiguredDefaultBannerTitle())) {
                        BrikitThemeSettings.setDefaultBanner(".brikit.banner.Empty");
                    }
                    if (!BrikitString.isSet((String)BrikitThemeSettings.getConfiguredDefaultHeaderTitle())) {
                        BrikitThemeSettings.setDefaultHeader(".brikit.header.Empty");
                    }
                    if (!BrikitString.isSet((String)BrikitThemeSettings.getConfiguredDefaultMenuTitle())) {
                        BrikitThemeSettings.setDefaultMenu(".brikit.menu.Demo");
                    }
                    if (!BrikitString.isSet((String)BrikitThemeSettings.getConfiguredDefaultLayoutTitle())) {
                        BrikitThemeSettings.setDefaultLayout(".brikit.layout.Community");
                    }
                    if (!BrikitString.isSet((String)BrikitThemeSettings.getConfiguredDefaultFooterTitle())) {
                        BrikitThemeSettings.setDefaultFooter(".brikit.footer.Simple");
                    }
                    if (!BrikitString.isSet((String)BrikitBandanaManager.getEntry(null, (String)"com.brikit.site.theme"))) {
                        BrikitThemeSettings.setDefaultThemeName(BrikitThemeSettings.DEFAULT_SPACE_THEME);
                    }
                    return null;
                }
                catch (Exception ex) {
                    return ex;
                }
            }
        });
        if (exception != null) {
            throw exception;
        }
    }

    public static void setupDemoSpace(final String spaceKey, TransactionTemplate transactionTemplate) throws Exception {
        Exception exception = (Exception)transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                try {
                    File tempFile = BrikitThemeSettings.getDemoSpaceZip(spaceKey);
                    SpaceExporter exporter = new SpaceExporter(tempFile, null, false, spaceKey);
                    exporter.importSpace(true);
                    tempFile.delete();
                    return null;
                }
                catch (Exception ex) {
                    return ex;
                }
            }
        });
        if (exception != null) {
            throw exception;
        }
    }

    public static void setupDemoSpaces(TransactionTemplate transactionTemplate) throws Exception {
        if (ThemePress.getThemePressSplashDemoSpace() == null) {
            BrikitThemeSettings.setupDemoSpace("brikitdemoSPLASH", transactionTemplate);
        }
        if (ThemePress.getThemePressVanillaDemoSpace() == null) {
            BrikitThemeSettings.setupDemoSpace("brikitdemoVANILLA", transactionTemplate);
        }
    }

    protected static void updateJavascriptI18nProperties(Map<String, String> javascriptI18nFilenames) {
        if (!ExternalDevelopmentMode.isDeveloperMode()) {
            return;
        }
        for (Map.Entry<String, String> entry : javascriptI18nFilenames.entrySet()) {
            String filePath = ThemeResourceServlet.getServerFileLocation((String)entry.getValue());
            StringBuilder builder = new StringBuilder();
            try {
                FileInputStream inputStream = new FileInputStream(new File(filePath));
                JSONObject map = new JSONObject();
                for (String prop : BrikitFile.readInputStreamUTF8Lines((InputStream)inputStream)) {
                    map.put(prop, (Object)Confluence.getText((String)prop));
                }
                builder.append(entry.getKey()).append(".i18n.extend(").append(map.toString()).append(");").append(BrikitString.lineSeparator());
                File scriptsFolder = new File(filePath).getParentFile();
                File i18nFile = new File(scriptsFolder, GENERATED_JAVASCRIPT_I18N_FILENAME);
                BrikitFile.writeFileUTF8((String)("/* THIS FILE IS AUTO-GENERATED BY THEME PRESS. DO NOT EDIT. */" + BrikitString.lineSeparator() + builder.toString()), (File)i18nFile);
            }
            catch (Exception ex) {
                BrikitLog.logError((String)("Failed to read JavaScript I18n properties file for " + entry.getKey() + ": " + entry.getValue()), (Exception)ex);
            }
        }
    }

    static {
        ExternalDevelopmentModeSettings.addListener((BrikitDeveloperSettingsListener)new BrikitDeveloperSettingsListener(){

            public void externalDevelopmentModeSettingsChanged() {
                ThemePress.resetCaches();
            }
        });
        DEFAULT_ARCHITECT_PAGE_NAMES = Arrays.asList(".brikit.header.Empty", ".brikit.footer.Splash Demo", ".brikit.footer.Vanilla Demo", ".brikit.banner.Empty", ".brikit.banner.Maintenance", ".brikit.layout.Landing Page", ".brikit.layout.Announcement", ".brikit.layout.Documentation", ".brikit.layout.Community", ".brikit.layout.Basic Confluence");
    }
}

