/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.html;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.core.confluence.BrikitVelocityContext;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.html.BrikitHTML;
import com.brikit.themepress.html.RichLinkContentCache;
import com.brikit.themepress.model.PageWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Document;

public class RichLinkContent
implements Serializable {
    public static final String RICH_LINK_TEMPLATE = "/theme-press/templates/rich-link.vm";
    protected String url;
    protected String title;
    protected String description;
    protected String image;
    protected String imageThumbnail;
    protected String siteLogo;
    protected List<String> labels;
    protected String spaceKey;
    protected long pageId;
    protected long commentId;
    protected String username;
    protected transient AbstractPage abstractPage;
    protected transient Space space;
    protected transient Comment comment;
    protected transient ConfluenceUser user;

    protected RichLinkContent(String url, String title, String description, String image, String imageThumbnail, String siteLogo) {
        this.url = url;
        this.title = title;
        this.description = description;
        this.image = image;
        this.imageThumbnail = imageThumbnail;
        this.siteLogo = siteLogo;
    }

    protected RichLinkContent(String url, String title, String description, String image, String imageThumbnail, String siteLogo, List<String> labels, AbstractPage abstractPage) {
        this(url, title, description, image, imageThumbnail, siteLogo);
        this.labels = labels;
        this.setAbstractPage(abstractPage);
    }

    protected RichLinkContent(String url, String title, String description, String image, String imageThumbnail, String siteLogo, Comment comment) {
        this(url, title, description, image, imageThumbnail, siteLogo);
        this.setComment(comment);
    }

    protected RichLinkContent(String url, String title, String description, String image, String imageThumbnail, String siteLogo, Space space) {
        this(url, title, description, image, imageThumbnail, siteLogo);
        this.setSpace(space);
    }

    protected RichLinkContent(String url, String title, String description, String image, String imageThumbnail, String siteLogo, ConfluenceUser user) {
        this(url, title, description, image, imageThumbnail, siteLogo);
        this.setUser(user);
    }

    public static RichLinkContent get(AbstractPage abstractPage) {
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        String title = wrapper.metaPropertyTitle();
        if (!BrikitString.isSet((String)title)) {
            title = Confluence.getTitle((AbstractPage)abstractPage);
        }
        return new RichLinkContent(Confluence.getPageURL((AbstractPage)abstractPage), title, wrapper.metaPropertyDescription(), wrapper.metaPropertyImage(), wrapper.metaPropertyImageThumbnail(), null, (List<String>)wrapper.getLabelsIncludingInherited(), abstractPage);
    }

    public static RichLinkContent get(Attachment attachment) {
        AbstractPage abstractPage = Confluence.getPage((Attachment)attachment);
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        String downloadPath = Confluence.attachmentDownloadPath((Attachment)attachment);
        return new RichLinkContent(Confluence.getAttachmentPreviewURL((Attachment)attachment), Confluence.getTitle((Attachment)attachment), attachment.getNiceType() + " (" + attachment.getNiceFileSize() + " " + attachment.getMediaType() + ")", downloadPath, Confluence.attachmentImageThumbnailDownloadPath((String)downloadPath), null, Confluence.getLabelNames((Attachment)attachment), abstractPage);
    }

    public static RichLinkContent get(Comment comment) {
        AbstractPage abstractPage = Confluence.getPage((Comment)comment);
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        String title = wrapper.metaPropertyTitle();
        if (!BrikitString.isSet((String)title)) {
            title = Confluence.getTitle((AbstractPage)abstractPage);
        }
        return new RichLinkContent(Confluence.getUrlPath((ContentEntityObject)comment), comment.getDisplayTitle(), comment.getBodyAsStringWithoutMarkup(), wrapper.metaPropertyImage(), wrapper.metaPropertyImageThumbnail(), null, comment);
    }

    public static RichLinkContent get(Space space) {
        return new RichLinkContent(Confluence.getSpaceURL((Space)space), Confluence.getTitle((Space)space), Confluence.getSpaceDescription((String)space.getKey()), Confluence.getSpaceLogo((Space)space), null, null, space);
    }

    public static RichLinkContent get(ConfluenceUser user) {
        return new RichLinkContent(Confluence.getUrlPath((ConfluenceUser)user), user.getFullName(), user.getEmail(), Confluence.getUserLogo((ConfluenceUser)user), null, null, user);
    }

    public static RichLinkContent get(String url) {
        return RichLinkContentCache.getRichLinkContent(url);
    }

    public static String render(AbstractPage abstractPage) {
        return RichLinkContent.render(abstractPage, false);
    }

    public static String render(AbstractPage abstractPage, boolean ignoreThumbnails) {
        return RichLinkContent.render(RichLinkContentCache.getRichLinkContent(abstractPage), ignoreThumbnails);
    }

    public static String render(Attachment attachment) {
        return RichLinkContent.render(RichLinkContent.get(attachment));
    }

    public static String render(Attachment attachment, boolean ignoreThumbnails) {
        return RichLinkContent.render(RichLinkContent.get(attachment), ignoreThumbnails);
    }

    public static String render(RichLinkContent richLinkContent) {
        return RichLinkContent.render(richLinkContent, false);
    }

    public static String render(RichLinkContent richLinkContent, boolean ignoreThumbnails) {
        Map velocityContext = BrikitVelocityContext.getDefaultVelocityContext();
        velocityContext.put("ignoreThumbnails", ignoreThumbnails);
        velocityContext.put("richLinkContent", richLinkContent);
        return Confluence.getRenderedVelocityTemplate((String)RICH_LINK_TEMPLATE, (Map)velocityContext);
    }

    public static String render(String url) {
        return RichLinkContent.render(url, false);
    }

    public static String render(String url, boolean ignoreThumbnails) {
        return RichLinkContent.render(RichLinkContent.get(url), ignoreThumbnails);
    }

    public static RichLinkContent wget(String url) {
        Document document = BrikitHTML.getDocument(url);
        String title = BrikitHTML.getMeta(document, "twitter:title", "og:title", "title");
        if (!BrikitString.isSet((String)title)) {
            title = BrikitHTML.getText(document, "title");
        }
        String description = BrikitHTML.getMeta(document, "twitter:description", "og:description", "description");
        String image = BrikitHTML.getMeta(document, "twitter:image", "og:image", "image");
        String siteLogo = BrikitHTML.getValue(document, "link[rel~=icon]", "href");
        if (BrikitString.isSet((String)siteLogo) && !siteLogo.contains("://")) {
            siteLogo = BrikitHTML.getProtocol(url) + "//" + BrikitHTML.getHostName(url) + siteLogo;
        }
        return new RichLinkContent(url, title, description, image, image, siteLogo);
    }

    public AbstractPage getAbstractPage() {
        if (this.abstractPage == null) {
            this.abstractPage = Confluence.getPageOrBlogPost((long)this.getPageId());
        }
        return this.abstractPage;
    }

    public Comment getComment() {
        return this.comment;
    }

    public long getCommentId() {
        return this.commentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHostName() {
        return BrikitHTML.getHostName(this.getUrl());
    }

    public String getImage() {
        return this.image;
    }

    public String getImageThumbnail() {
        return this.imageThumbnail;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public long getPageId() {
        return this.pageId;
    }

    public String getSiteLogo() {
        return this.siteLogo;
    }

    public Space getSpace() {
        return this.space;
    }

    public String getSpaceKey() {
        return BrikitString.isSet((String)this.spaceKey) ? this.spaceKey : Confluence.getSpaceKey((AbstractPage)this.getAbstractPage());
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public ConfluenceUser getUser() {
        return this.user;
    }

    public String imagePath(boolean ignoreThumbnail) {
        return !ignoreThumbnail && BrikitString.isSet((String)this.getImageThumbnail()) ? this.getImageThumbnail() : this.getImage();
    }

    protected void setAbstractPage(AbstractPage abstractPage) {
        this.abstractPage = abstractPage;
        this.pageId = abstractPage == null ? 0L : abstractPage.getId();
    }

    public void setTitle(String title) {
        this.title = BrikitString.unescape((String)title);
    }

    public void setDescription(String description) {
        this.description = BrikitString.unescape((String)description);
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setImageThumbnail(String imageThumbnail) {
        this.imageThumbnail = imageThumbnail;
    }

    public void setSiteLogo(String siteLogo) {
        this.siteLogo = siteLogo;
    }

    protected void setComment(Comment comment) {
        this.comment = comment;
        this.commentId = comment.getId();
    }

    protected void setSpace(Space space) {
        this.space = space;
        this.setSpaceKey(space.getKey());
    }

    protected void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    protected void setUser(ConfluenceUser user) {
        this.user = user;
        this.setUsername(user.getName());
    }

    protected void setUsername(String username) {
        this.username = username;
    }
}

