(function ($) {

	ThemePress.RichLinks = {
		
		adjustColumns: function () {
			if (ThemePress.Browser.mobile) return;
			
			$(".brikit-content-block[data-rich-links-columns]").each(function () {
				// Set the width of each rich link to create columns
				var width = 100.0 / $(this).data("rich-links-columns") + "%";
				$(".rich-link-wrapper", this).css({width: width, display: "inline-block", float: "left"});

				// If the images height isn't set on the block, make the height match the column width
				var imageHeight = $(this).data("rich-links-image-height") || $(".rich-link-image:first", this).width();
				$(".rich-link-image", this).height(imageHeight);

				// Equalize the height of the rich links in columns
                var height = 0;
                $(".rich-link-container", this).each(function () {
                    height = Math.max(height, $(this).height());
					if (height == 0) height = 'auto';
                });
                $(".rich-link-container", this).height(height);
			});
		},
		
		adjustRichLinks: function () {
			$(".rich-link:not(.details-length-limit-applied)").each(ThemePress.RichLinks.applyDetailsLengthLimit);
			$(".rich-link-container").each(ThemePress.RichLinks.applyGridLayout);
            $(".rich-link:not(.filter-groups-displayed)").each(ThemePress.RichLinks.displayFilterGroups);
			ThemePress.RichLinks.adjustColumns();
		},
		
		applyDetailsLengthLimit: function () {
			var $richLink = $(this);
            $richLink.addClass("details-length-limit-applied");
			var $block = $richLink.closest(".brikit-content-block, .rich-links-container");

			var mobileTitleLimit = ThemePress.Browser.mobile ? $block.data("rich-links-title-length-mobile") : false;
			var titleLimit = mobileTitleLimit || $block.data("rich-links-title-length");
			var $title = $richLink.find(".rich-link-title");
			if (titleLimit) $title.text(ThemePress.String.truncateString($title.text(), titleLimit));

			var mobileDetailsLimit = ThemePress.Browser.mobile ? $block.data("rich-links-details-length-mobile") : false;
			var detailsLimit = mobileDetailsLimit || $block.data("rich-links-details-length");
			var $excerpt = $richLink.find(".rich-link-excerpt");
			if (!detailsLimit || !$excerpt.length) return;
			$richLink.find(".rich-link-description").text(ThemePress.String.truncateWords($excerpt.text(), detailsLimit));
		},
		
		applyGridLayout: function () {
			var $container = $(this);
			var gridClass = $container.closest(".rich-link-grid-layout").data("grid-layout-class");
			if (!gridClass) return;
		
			$container
				.addClass(gridClass)
				.append($(".rich-link-image", $container))
				.append($(".rich-link-site-logo", $container))
				.append($(".rich-link-document-identifier", $container))
				.append($(".rich-link-title", $container))
				.append($(".rich-link-space-name", $container))
				.append($(".rich-link-publish-date", $container))
				.append($(".rich-link-creation-date", $container))
				.append($(".rich-link-space-owner-image", $container))
				.append($(".rich-link-space-owner", $container))
				.append($(".rich-link-page-owner-image", $container))
				.append($(".rich-link-page-owner", $container))
				.append($(".rich-link-creator-image", $container))
				.append($(".rich-link-creator", $container))
				.append($(".rich-link-last-modified", $container))
				.append($(".rich-link-last-modifier-image", $container))
				.append($(".rich-link-last-modifier", $container))
				.append($(".rich-link-page-status", $container))
				.append($(".rich-link-site-name", $container))
				.append($(".rich-link-description", $container))
				.append($(".rich-link-labels", $container))
				.append($(".rich-link-page-comment-count", $container))
				.append($(".rich-link-page-descendant-count", $container))
                .append($(".rich-link-filter-group-display", $container));

			$(".image-struct, .rich-link-details", $container).remove();
			
		},
        
        displayFilterGroups: function() {
			var $richLink = $(this);
            $richLink.addClass("filter-groups-displayed");
			var $block = $richLink.closest(".brikit-content-block.rich-links-show-filter-groups");
            if (!$block.length) return;

            var $grid = $(".row-grid", $richLink);
            if (!$grid.length) return;
            
            $(".rich-link-labels .aui-label", $richLink).each(function () {
                var $label = $(this);
                var label = $label.data("label");
                var filterGroup = $block.data("filter-group-name-" + label);
                if (filterGroup) {
                    var labelDisplayName = $block.data("filter-group-filter-" + label);
                    var groupNameSafe = $block.data("filter-group-name-safe-" + label);
                    var $filterGroupDisplay = $(".rich-link-filter-group-display.filter-group-" + groupNameSafe, $grid).css("grid-area", groupNameSafe);
                    if (!$filterGroupDisplay.length) {
                        $filterGroupDisplay = $("<div class='rich-link-filter-group-display filter-group-" + groupNameSafe + "'>");
                        $filterGroupDisplay.append($("<div class='filter-group-title'>").append(filterGroup));
                        $filterGroupDisplay.append($("<ul class='filter-group-labels'>"));
                        $grid.append($filterGroupDisplay);
                    }
                    var $labelList = $(".filter-group-labels", $filterGroupDisplay);
                    $labelList.append($label);
                }
            });
        },
		
		initialize: function ($blocks) {
			$(".rich-link").each(ThemePress.RichLinks.applyDetailsLengthLimit);
			$(".rich-links a:not(.aui-button):not(.rich-link)").each(ThemePress.RichLinks.removeParents);
			$(".rich-links a:not(.aui-button):not(.rich-link)").each(function () {
				var $link = $(this);
				var href = ThemePress.RichLinks.urlFromLink($link);
                var ignoreThumbnails = $link.closest(".rich-links-ignore-thumbnails").length > 0; // Needs to be a boolean for sending to the server
				
				// var $richLink = ThemePress.RichLinks.convertLink($link, href);
				// var callback = function (data, textStatus, jqXHR) { ThemePress.RichLinks.enrichLink($richLink, href, data); }
				var $waitLink = $("<div>").addClass("rich-link waiting");
				$link.replaceWith($waitLink)
				var $linkContainer = $("<h3>").addClass("rich-link-title").append($link);
				$waitLink.append($linkContainer).spin();
				
				var callback = function (data, textStatus, jqXHR) { ThemePress.RichLinks.replaceLink($waitLink, data); }
				$.ajax({
		            url: ThemePress.contextPath + "/plugins/brikit/richlinks/display.action", 
		            data: {url: href, ignoreThumbnails: ignoreThumbnails}, 
					success: callback,
		            // error: callback,
					// dataType: "json",
					type: "POST",
					timeout: 120000
		        });
			});
			
			ThemePress.RichLinks.adjustRichLinks();
		},
		
		removeParents: function () {

			var $link = $(this);
			
			// For content-by-label macro, strip out the extra garbage to leave just the link
			if ($link.closest(".content-by-label").length) {
				var $unwanted = $link.closest(".smalltext, .label-details");
				if ($unwanted.length) return $unwanted.remove(); // Stop if it's a link in the excerpt or other bits
				
				var $li = $link.closest("li");
				$li.find("span.icon").parent("div").remove(); 	// Remove the content type icon
				$li.find("span.smalltext").remove(); 			// Remove the excerpt
				$li.empty().append($link);						// Replace everything else with just the link
				return;
			}
			
			// Remove containing spans, paragraphs, and list elements if otherwise empty
			var $container = $link.parent("span, p, li");
			while ($container.length) {
				var $nextContainer = $container.parent("span, p, li");
				// if (jQuery.trim($container.children().not($container).html()).length)
				if ($nextContainer.length) $container = $nextContainer;
				else break;
			}
			if ($container.length) $container.replaceWith($link);
			
			// Remove containing lists
			var $list = $link.parent("ol, ul");
			if ($list.length) $list.replaceWith($list.contents());
		},

		replaceLink: function ($link, data) {
			if ($(".rich-link-error", data).length) {
				console.error("Failed to convert rich link for " + href);
				console.log(data);
				return;
			}
			
			var $richLink = $(data);
			if ($link.closest(".target-new-window").length) $("a", $richLink).attr("target", "_blank");
			
			$link.replaceWith($richLink);
		},
		
		urlFromLink: function ($link) {
			var href = $link.attr("href");
			if (!href) href = window.location.href;
			else if (href.toLowerCase().indexOf("http") != 0) {
				if (href.indexOf("/") != 0) href = window.location.pathname + "/" + href;
				href = window.location.protocol + "//" + window.location.host + href;
			}
			return href;
		}
		
		// waitLink: function ($link) {
		//
		// 	var $waitLink = $("<div>").addClass("rich-link waiting");
		//
		// 	// Remove containing spans, paragraphs, and lists if otherwise empty
		// 	var $container = $link.parent("span, p, li");
		//
		// 	while ($container.length) {
		// 		var $nextContainer = $container.parent("span, p, li");
		// 		// if (jQuery.trim($container.children().not($container).html()).length)
		// 		if ($nextContainer.length) $container = $nextContainer;
		// 		else break;
		// 	}
		//
		// 	if (!$container.length) $container = $link;
		//
		// 	$container.replaceWith($waitLink);
		//
		// 	var $list = $waitLink.parent("ol, ul");
		// 	if ($list.length) $list.replaceWith($list.contents());
		//
		// 	$waitLink.append($link).spin();
		//
		// 	return $waitLink;
		// }
		
	};

	ThemePress.toFinalize(ThemePress.RichLinks.initialize);
	$(document).ajaxComplete(ThemePress.RichLinks.adjustRichLinks);
	
})(jQuery);

