/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitConfigProperties;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThemeJavaScriptCache {
    public static final String BASE_CODE_KEY = "base";
    public static final String CUSTOM_CODE_KEY = "theme";
    public static final String DESIGNER_KEY = "designer";
    public static final String EDIT_KEY = "edit";
    protected static Cache<String, String> cache;
    protected static CacheSettings cacheSettings;

    protected static String customCodeKey(boolean customCode) {
        return customCode ? CUSTOM_CODE_KEY : BASE_CODE_KEY;
    }

    public static String getBundleName(String themeName, String tweaker, boolean customCode, boolean skipDesignerSupport) {
        return themeName + "~~~" + tweaker + "~~~" + ThemeJavaScriptCache.customCodeKey(customCode) + "~~~" + ThemeJavaScriptCache.skipDesignerSupportKey(skipDesignerSupport);
    }

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache(Confluence.getText((String)"com.brikit.themepress.theme.js.cache"), (CacheLoader)new CacheLoader<String, String>(){

                public String load(String cacheKey) {
                    BrikitList bits = BrikitString.split((String)cacheKey, (String)"~~~");
                    String themeName = (String)bits.first();
                    String tweaker = bits.size() > 1 ? (String)bits.get(1) : "";
                    boolean customCode = bits.size() > 2 && ThemeJavaScriptCache.CUSTOM_CODE_KEY.equals(bits.get(2));
                    boolean skipDesignerSupport = ThemeJavaScriptCache.EDIT_KEY.equals(bits.last());
                    StringBuilder buffer = new StringBuilder(500000);
                    if (customCode) {
                        String javascriptFromTheme = ThemeProperties.getThemeProperties(themeName).getJavascriptFiles();
                        BrikitThemeSettings.readJavascriptFiles(buffer, javascriptFromTheme, themeName, "Theme Custom Code");
                    } else {
                        Map<String, String> i18nPropertiesFiles = BrikitThemeSettings.javascriptI18nPropertiesFiles();
                        BrikitThemeSettings.updateJavascriptI18nProperties(i18nPropertiesFiles);
                        String javascriptList = BrikitConfigProperties.getJavaScriptFilesList(!skipDesignerSupport && ExternalDevelopmentMode.isDesigning());
                        BrikitThemeSettings.readJavascriptFiles(buffer, javascriptList, themeName, "Brikit Theme Press");
                        String javascriptFromPlugins = BrikitThemeSettings.javascriptFilesForThemePressPlugins();
                        BrikitThemeSettings.readJavascriptFiles(buffer, javascriptFromPlugins, themeName, "Third-Party Theme Press Plugin");
                    }
                    return buffer.toString();
                }
            }, cacheSettings);
        }
        return cache;
    }

    public static String getJavaScript(String cacheKey) {
        return (String)ThemeJavaScriptCache.getCache().get((Object)cacheKey);
    }

    protected static void reset(String cacheKey) {
        ThemeJavaScriptCache.getCache().remove((Object)cacheKey);
    }

    public static void reset() {
        ThemeJavaScriptCache.getCache().removeAll();
    }

    protected static String skipDesignerSupportKey(boolean skipDesignerSupport) {
        return skipDesignerSupport ? EDIT_KEY : DESIGNER_KEY;
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(5L, TimeUnit.HOURS).maxEntries(50).build();
    }
}

