/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.toolkit.macros.BrikitColorHandlingMacro;
import com.brikit.themepress.util.ThemePress;
import java.util.List;
import java.util.Map;

public class ContentColumnMacro
extends BrikitColorHandlingMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/content-column.vm";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        macroContext.velocityContextAdd((Object)"isRemote", (Object)Confluence.isRemotePageView());
        this.convertColorPaletteReference("background-color", macroContext);
        this.convertColorPaletteReference("gradient-top-color", macroContext);
        this.convertColorPaletteReference("gradient-bottom-color", macroContext);
        try {
            if (!ThemePress.isArchitectPage(macroContext.getPage()) && !macroContext.booleanValue("from-layout")) {
                if (!Confluence.isRemotePageView()) {
                    body = this.mergeLayoutColumn(body, macroContext);
                }
                macroContext.velocityContextAdd((Object)"body", (Object)body);
            }
        }
        catch (Exception ex) {
            BrikitLog.logError((String)"Failed to process column macro for layout.", (Exception)ex);
            throw new MacroExecutionException("Failed to process column macro for layout.", (Throwable)ex);
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    protected String mergeLayoutColumn(String body, BrikitMacroContext macroContext) throws Exception {
        List<List<MacroDefinition>> allLayoutBlocks;
        String columnID;
        Map originalContext = macroContext.getVelocityContext();
        PageWrapper pageWrapper = PageWrapper.get(macroContext.getPage());
        MacroDefinition myLayer = pageWrapper.layerMacroForColumn(columnID = macroContext.stringValue("id"));
        if (myLayer == null) {
            return body;
        }
        int layerPosition = pageWrapper.positionForLayer(pageWrapper.getId(myLayer));
        if (layerPosition == -1 || layerPosition >= pageWrapper.getLayoutLayerMergeMacros().size()) {
            return body;
        }
        MacroDefinition mergeLayer = pageWrapper.getLayoutLayerMergeMacros().get(layerPosition);
        List<List<MacroDefinition>> allPageColumns = pageWrapper.groupColumnsFromLayer(myLayer);
        List<List<MacroDefinition>> allLayoutColumns = pageWrapper.groupColumnsFromLayer(mergeLayer);
        List<MacroDefinition> mergedLeftColumns = pageWrapper.columnsWhenMerged(allPageColumns.get(0), allLayoutColumns.get(0), macroContext.getPage());
        List<MacroDefinition> mergedRightColumns = pageWrapper.columnsWhenMerged(allPageColumns.get(2), allLayoutColumns.get(2), macroContext.getPage());
        MacroDefinition layoutColumn = null;
        List<MacroDefinition> leftColumnsToAdd = pageWrapper.columnsToAdd(allPageColumns.get(0), allLayoutColumns.get(0));
        List<MacroDefinition> rightColumnsToAdd = pageWrapper.columnsToAdd(allPageColumns.get(2), allLayoutColumns.get(2));
        float width = 0.0f;
        MacroDefinition mainColumn = pageWrapper.mainColumnMacro(myLayer);
        if (mainColumn != null && columnID.equals(pageWrapper.getId(mainColumn))) {
            layoutColumn = pageWrapper.mainColumnMacro(mergeLayer);
            width = pageWrapper.columnWidth(layoutColumn);
            originalContext.put("leftColumnsFromLayoutHTML", pageWrapper.renderLayoutMacros(leftColumnsToAdd));
            originalContext.put("rightColumnsFromLayoutHTML", pageWrapper.renderLayoutMacros(rightColumnsToAdd));
            macroContext.getParameters().remove("from-layout");
            originalContext.put("from-layout", false);
        } else {
            MacroDefinition columnMacro = pageWrapper.macroWithId(columnID, mergedLeftColumns);
            if (columnMacro == null) {
                columnMacro = pageWrapper.macroWithId(columnID, mergedRightColumns);
            }
            if (columnMacro != null && pageWrapper.isFromLayout(columnMacro)) {
                layoutColumn = columnMacro;
                width = pageWrapper.columnWidth(layoutColumn);
            }
        }
        if (width > 0.0f) {
            originalContext.put("width", Float.toString(width) + "%");
        }
        if ((allLayoutBlocks = pageWrapper.groupBlocksFromLayoutColumn(layoutColumn)) != null) {
            body = pageWrapper.renderLayoutMacros(allLayoutBlocks.get(0)) + body + pageWrapper.renderLayoutMacros(allLayoutBlocks.get(1));
        }
        return body;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

