/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.servlet;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitMobile;
import com.brikit.core.util.BrikitServletFilter;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.util.ThemePress;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MobileVersionFilter
extends AbstractHttpFilter {
    private static final String BRIKIT_MOBILE_SWITCH_COOKIE = "com.brikit.themepress.confluence.mobile.switch";
    private static final String CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE = "confluence.mobile.desktop.switch";
    protected FilterConfig filterConfig = null;

    private static String getConfluenceMobileBypassURL(HttpServletRequest request, AbstractPage abstractPage) {
        String requestURL = Confluence.getBaseUrl() + "/plugins/brikit/mobile/confluencemobilebypass.action?mobileBypass=true";
        String queryString = request.getQueryString();
        return queryString == null ? requestURL : requestURL + '&' + queryString;
    }

    public void destroy() {
    }

    protected void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        if (!ThemePress.isConfluenceMobilePluginEnabled() && !ThemePress.isConfluenceMobileWebPluginEnabled()) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        AbstractPage abstractPage = BrikitServletFilter.getPage((HttpServletRequest)servletRequest);
        if (abstractPage == null || !ThemePress.canView((ContentEntityObject)abstractPage)) {
            try {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
            catch (Exception ex) {
                BrikitLog.logDebug((String)"Theme Press mobile filter caught an exception being thrown by Confluence or another plugin in page-not-found or page-not-authorized scenarios.", (Exception)ex);
            }
            return;
        }
        if (!BrikitMobile.isPhone((HttpServletRequest)servletRequest) || "true".equals(servletRequest.getParameter("mobileBypass"))) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        if (ThemePress.isThemePress(abstractPage)) {
            if (Confluence.getCookie((String)BRIKIT_MOBILE_SWITCH_COOKIE) == null) {
                Cookie brikitCookie = new Cookie(BRIKIT_MOBILE_SWITCH_COOKIE, Confluence.getCookieValue((String)CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE) == null ? "false" : "true");
                brikitCookie.setPath("/");
                servletResponse.addCookie(brikitCookie);
            }
            Cookie desktopCookie = new Cookie(CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE, "true");
            desktopCookie.setPath(BrikitString.isSet((String)Confluence.getContextPath()) ? Confluence.getContextPath() : "/");
            servletResponse.addCookie(desktopCookie);
            servletResponse.sendRedirect(MobileVersionFilter.getConfluenceMobileBypassURL(servletRequest, abstractPage));
            return;
        }
        if (Confluence.getCookie((String)BRIKIT_MOBILE_SWITCH_COOKIE) != null) {
            Cookie brikitCookie = Confluence.getCookie((String)BRIKIT_MOBILE_SWITCH_COOKIE);
            Confluence.removeCookie((HttpServletResponse)servletResponse, (String)CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE);
            Confluence.removeCookie((HttpServletResponse)servletResponse, (String)BRIKIT_MOBILE_SWITCH_COOKIE);
            if (BrikitBoolean.booleanValue((String)brikitCookie.getValue())) {
                Cookie desktopCookie = new Cookie(CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE, "true");
                desktopCookie.setPath("/display/" + abstractPage.getSpaceKey());
                servletResponse.addCookie(desktopCookie);
            }
        }
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

