/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitApps;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMobile;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.CaseInsensitiveComparator;
import com.brikit.core.util.SafeId;
import com.brikit.themepress.cache.InstantPageCache;
import com.brikit.themepress.html.BrikitHTML;
import com.brikit.themepress.model.BrikitPageElementDefaults;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.model.StorableArchitecturePageReference;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.SpaceCategorySettings;
import com.brikit.themepress.util.ThemePress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class PageWrapper
implements Serializable {
    public static final String LAYOUT_MACRO_KEY = "content-layout";
    public static final String LAYER_MACRO_KEY = "content-layer";
    public static final String COLUMN_MACRO_KEY = "content-column";
    public static final String BLOCK_MACRO_KEY = "content-block";
    public static final String EXCERPT_MACRO_KEY = "excerpt";
    public static final String FROM_LAYOUT_KEY = "from-layout";
    public static final String DEFERRED_LOADING_BLOCK_MACRO_KEY = "deferred-loading-content-block";
    public static final String RENDER_CONTEXT_KEY = "render-context";
    public static final String CACHE_RENDERED_PAGE_KEY = "cache-rendered-page";
    public static final String DO_NOT_ADD_FAKE_LAYER_KEY = "do-not-add-fake-layer";
    public static final String MULTI_LEVEL_MENU_KEY = "multi-level-menu";
    public static final String DO_NOT_CACHE_RENDERED_PAGE_KEY = "do-not-cache-rendered-page";
    public static final String DO_NOT_CONVERT_FOR_MOBILE_KEY = "do-not-convert-for-mobile";
    public static final String CONTAINER_WIDTH = "container-width";
    public static final String BREADCRUMBS_DISPLAY = "breadcrumbs-display";
    public static final String METADATA_BANNER_DISPLAY = "metadata-banner-display";
    public static final String PAGE_TITLE_DISPLAY = "page-title-display";
    public static final String PAGE_INFO_DISPLAY = "page-info-display";
    public static final String LIKES_AND_LABELS_DISPLAY = "likes-and-labels-display";
    public static final String COMMENTS_DISPLAY = "comments-display";
    public static final String TOOLBAR_DISPLAY = "toolbar-display";
    public static final String SIDEBAR_DISPLAY = "sidebar-display";
    public static final String PRESENTATION_MODE_DISPLAY = "presentation-mode-display";
    public static final String AUTOMATIC_LAYOUT = "automatic-layout";
    public static final String IGNORE_SECTIONS = "ignore-sections";
    public static final String DEFER_LOADING_LABELS = "defer-loading-labels";
    public static final String ID_PARAM = "id";
    public static final String NAME_PARAM = "name";
    public static final String POSITION_PARAM = "position";
    public static final String POSITION_TOP = "top";
    public static final String POSITION_MERGE = "merge";
    public static final String POSITION_BOTTOM = "bottom";
    public static final String POSITION_IGNORE = "ignore";
    public static final String PAGE_ELEMENT_DISPLAY_HEADER = "header";
    public static final String PAGE_ELEMENT_DISPLAY_HIDE = "hide";
    public static final String PAGE_ELEMENT_DISPLAY_INTEGRATED = "integrated";
    public static final String PAGE_ELEMENT_DISPLAY_LAYER = "layer";
    public static final String WIDTH_PARAM = "width";
    public static final String ALTERNATE_STYLE = "alternate-style";
    public static final String MOBILE_HIDE = "mobile-hide";
    public static final String ARCHITECT_PAGE = "architect-page";
    public static final String MAIN_COLUMN_PARAM = "main-column";
    public static final String META_PROPERTIES_PARAM = "meta-properties";
    public static final String BACKGROUND_IMAGE_PARAM = "background-image";
    public static final String CONTAINER_BACKGROUND_IMAGE_PARAM = "container-background-image";
    public static final String RICH_LINK_LABEL = "rich-link";
    public static final String LAYOUT_OVERRIDE_KEY = "com.brikit.themepress.layout.override";
    public static final String LAYOUT_PAGE_ID_KEY = "com.brikit.themepress.layout.page.id";
    public static final String FAKE_LAYER_DELIM = ":::::";
    protected long pageId;
    protected transient boolean initialized;
    protected int pageVersion;
    protected long pageModificationTimeAtWrapperCreate;
    protected transient MacroDefinition layoutMacro;
    protected transient List<MacroDefinition> layerMacros;
    protected transient List<MacroDefinition> layoutLayerTopMacros;
    protected transient List<MacroDefinition> layoutLayerMergeMacros;
    protected transient List<MacroDefinition> layoutLayerBottomMacros;
    protected transient List<MacroDefinition> mobileLayoutLayerTopMacros;
    protected transient List<MacroDefinition> mobileLayoutLayerMergeMacros;
    protected transient List<MacroDefinition> mobileLayoutLayerBottomMacros;
    protected transient BrikitList<String> labelsIncludingInherited;
    protected String layoutPageId;
    protected PageWrapper layoutPageWrapper;
    protected PageWrapper mobilePhoneLayoutPageWrapper;
    protected static final String NOT_SET = "PROPERTY_NOT_SET_PLACEHOLDER";
    protected String metaPropertiesBlockContents = "PROPERTY_NOT_SET_PLACEHOLDER";
    protected String blockParagraphText = "PROPERTY_NOT_SET_PLACEHOLDER";
    protected String metaPropertyDescription = "PROPERTY_NOT_SET_PLACEHOLDER";
    protected String metaPropertyImage = "PROPERTY_NOT_SET_PLACEHOLDER";
    protected String metaPropertyTitle = "PROPERTY_NOT_SET_PLACEHOLDER";
    protected String excerptMacroContents = "PROPERTY_NOT_SET_PLACEHOLDER";

    protected PageWrapper(AbstractPage confluencePage) {
        this.setPageId(confluencePage.getId());
    }

    protected PageWrapper(String pageIdAsString) {
        this.metaPropertyImage = NOT_SET;
        this.setPageId(Long.parseLong(pageIdAsString));
    }

    public static boolean cacheRenderedPage(AbstractPage abstractPage) {
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        return wrapper == null ? false : wrapper.getCacheRenderedPage();
    }

    public static PageWrapper get(AbstractPage confluencePage) {
        try {
            return confluencePage == null ? null : PageWrapperCache.getPageWrapper(confluencePage);
        }
        catch (ExecutionException ex) {
            BrikitLog.logError((String)"Couldn't retrieve Page Wrapper object from cache.", (Exception)ex);
            return null;
        }
    }

    public static PageWrapper getBypassingCache(AbstractPage confluencePage) {
        return confluencePage == null ? null : new PageWrapper(confluencePage);
    }

    public static PageWrapper get(String pageIdAsString) {
        return PageWrapper.get(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public static Page getLayout(AbstractPage abstractPage) {
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        return wrapper == null ? null : wrapper.getLayoutPage();
    }

    public static Page getMobilePhoneVersion(AbstractPage aPage) {
        PageWrapper wrapper = PageWrapper.get(aPage);
        return wrapper == null ? null : wrapper.getMobilePhoneVersion();
    }

    public static boolean isUsingFrame(AbstractPage abstractPage) {
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        return wrapper != null && wrapper.isUsingFrame();
    }

    public static String refreshIds(AbstractPage abstractPage, MacroDefinition macro) throws Exception {
        return PageWrapper.refreshIds(abstractPage, MacroParser.macroAsStorageFormat((AbstractPage)abstractPage, (MacroDefinition)macro));
    }

    public static String refreshIds(AbstractPage abstractPage, String storageFormat) throws Exception {
        storageFormat = PageWrapper.refreshIds(abstractPage, storageFormat, LAYER_MACRO_KEY);
        storageFormat = PageWrapper.refreshIds(abstractPage, storageFormat, COLUMN_MACRO_KEY);
        storageFormat = PageWrapper.refreshIds(abstractPage, storageFormat, BLOCK_MACRO_KEY);
        storageFormat = PageWrapper.refreshIds(abstractPage, storageFormat, DEFERRED_LOADING_BLOCK_MACRO_KEY);
        return storageFormat;
    }

    public static String refreshIds(AbstractPage abstractPage, String storageFormat, String macroName) throws Exception {
        for (MacroDefinition macro : MacroParser.extractMacrosFromStorageFormat((AbstractPage)abstractPage, (String)storageFormat, (String)macroName)) {
            MacroDefinition newMacro = MacroParser.clone((MacroDefinition)macro);
            MacroParser.setParameter((MacroDefinition)newMacro, (String)ID_PARAM, (String)PageWrapper.safeId(abstractPage), (AbstractPage)abstractPage);
            storageFormat = MacroParser.replaceMacroInStorageFormat((AbstractPage)abstractPage, (String)storageFormat, (MacroDefinition)macro, (MacroDefinition)newMacro);
        }
        return storageFormat;
    }

    protected static String safeId(AbstractPage abstractPage) {
        return SafeId.globalSafeId((String)"", (Object)abstractPage);
    }

    public String addBlock(String relativeToBlockId, boolean before) throws Exception {
        MacroDefinition newBlock = this.composeBlock();
        this.addBlock(newBlock, relativeToBlockId, before);
        return this.getId(newBlock);
    }

    public void addBlock(MacroDefinition newBlock, String relativeToBlockId, boolean before) throws Exception {
        MacroDefinition relativeToBlock = this.block(relativeToBlockId = this.ensureBlock(relativeToBlockId));
        if (relativeToBlock == null && !this.hasLayerMacros()) {
            this.ensureLayer();
            relativeToBlock = this.blocks().get(0);
        }
        if (relativeToBlock == null) {
            throw new Exception("Couldn't find block: " + relativeToBlockId + " on page " + this.getConfluencePage());
        }
        MacroParser.insertMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)newBlock, (MacroDefinition)relativeToBlock, (boolean)before);
    }

    public String addBlocks(int blockCount) throws Exception {
        MacroDefinition lastColumn;
        String lastBlockId = "0";
        if (!this.hasLayerMacros()) {
            this.ensureLayer();
            --blockCount;
        }
        if ((lastColumn = (MacroDefinition)new BrikitList(this.columns()).last()) == null) {
            return lastBlockId;
        }
        return this.addBlocksToColumn(lastColumn, blockCount);
    }

    public String addBlockToColumn(String columnId) throws Exception {
        MacroDefinition column = this.column(columnId = this.ensureColumn(columnId));
        if (column == null) {
            throw new Exception("Couldn't find column: " + columnId + " on page " + this.getConfluencePage());
        }
        return this.addBlocksToColumn(column, 1);
    }

    public String addBlocksToColumn(MacroDefinition column, int blockCount) throws Exception {
        String lastBlockId = "0";
        if (column == null) {
            return lastBlockId;
        }
        MacroDefinition newColumn = MacroParser.clone((MacroDefinition)column);
        StringBuilder newColumnContent = new StringBuilder();
        newColumnContent.append(newColumn.getBodyText());
        while (blockCount > 0) {
            MacroDefinition block = this.composeBlock();
            newColumnContent.append(MacroParser.macroAsStorageFormat((AbstractPage)this.getConfluencePage(), (MacroDefinition)block));
            lastBlockId = this.getId(block);
            --blockCount;
        }
        MacroParser.setBody((MacroDefinition)newColumn, (String)newColumnContent.toString());
        MacroParser.replaceMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)column, (MacroDefinition)newColumn, (String)"block added", (boolean)false);
        return lastBlockId;
    }

    public String addColumn(String relativeToColumnId, boolean before) throws Exception {
        MacroDefinition newColumn = this.composeColumn();
        this.addColumn(newColumn, relativeToColumnId, before);
        return this.getId(newColumn);
    }

    public void addColumn(MacroDefinition newColumn, String relativeToColumnId, boolean before) throws Exception {
        MacroDefinition relativeToColumn = this.column(relativeToColumnId = this.ensureColumn(relativeToColumnId));
        if (relativeToColumn == null && !this.hasLayerMacros()) {
            this.ensureLayer();
            relativeToColumn = this.columns().get(0);
        }
        if (relativeToColumn == null) {
            throw new Exception("Couldn't find column: " + relativeToColumnId + " on page " + this.getConfluencePage());
        }
        String newBody = Confluence.getBodyAsString((ContentEntityObject)this.getConfluencePage());
        newBody = MacroParser.insertMacroIntoStorageFormat((AbstractPage)this.getConfluencePage(), (String)newBody, (MacroDefinition)newColumn, (MacroDefinition)relativeToColumn, (boolean)before);
        newBody = this.rebalanceColumnsFromStorageFormat(newBody);
        this.updatePage(newBody, "column added", false);
    }

    public String addColumnToLayer(String layerId) throws Exception {
        MacroDefinition layer = this.layer(layerId = this.ensureLayer(layerId));
        if (layer == null) {
            throw new Exception("Couldn't find layer: " + layerId + " on page " + this.getConfluencePage());
        }
        MacroDefinition newLayer = MacroParser.clone((MacroDefinition)layer);
        MacroDefinition column = this.composeColumn();
        String newBody = newLayer.getBodyText() + MacroParser.macroAsStorageFormat((AbstractPage)this.getConfluencePage(), (MacroDefinition)column);
        newBody = this.rebalanceColumnsFromStorageFormat(newBody);
        MacroParser.setBody((MacroDefinition)newLayer, (String)newBody);
        MacroParser.replaceMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)layer, (MacroDefinition)newLayer, (String)"column added", (boolean)false);
        return this.getId(column);
    }

    public String addLayer(String relativeToLayerId, String layerType, boolean before) throws Exception {
        MacroDefinition newLayer = this.composeLayer(layerType);
        this.addLayer(newLayer, relativeToLayerId, before);
        return this.getId(newLayer);
    }

    public void addLayer(MacroDefinition newLayer, String relativeToLayerId, boolean before) throws Exception {
        MacroDefinition relativeToLayer = this.layer(relativeToLayerId = this.ensureLayer(relativeToLayerId));
        if (relativeToLayer == null) {
            relativeToLayer = MacroParser.lastMacro((AbstractPage)this.getConfluencePage(), (String)LAYER_MACRO_KEY);
        }
        if (relativeToLayer == null) {
            this.ensureLayer();
            relativeToLayer = MacroParser.lastMacro((AbstractPage)this.getConfluencePage(), (String)LAYER_MACRO_KEY);
        }
        MacroParser.insertMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)newLayer, (MacroDefinition)relativeToLayer, (boolean)before);
    }

    public MacroDefinition block(String id) throws XhtmlException {
        MacroDefinition block = this.contentMacro(BLOCK_MACRO_KEY, id);
        return block;
    }

    public MacroDefinition blockFromStorageFormat(String storageFormat, String id) throws XhtmlException {
        MacroDefinition block = this.contentMacroFromStorageFormat(storageFormat, BLOCK_MACRO_KEY, id);
        return block;
    }

    public List<String> blockIds() throws XhtmlException {
        ArrayList<String> blocks = new ArrayList<String>();
        for (MacroDefinition block : this.blocks()) {
            blocks.add(this.getId(block));
        }
        return blocks;
    }

    public String blockName(String blockId) throws XhtmlException {
        MacroDefinition block = this.block(blockId);
        return block == null ? null : this.getName(block);
    }

    public List<MacroDefinition> blocks() throws XhtmlException {
        return this.blocksFromStorageFormat(Confluence.getBodyAsString((ContentEntityObject)this.getConfluencePage()));
    }

    public List<MacroDefinition> blocksForced() throws Exception {
        List<MacroDefinition> blocks = this.blocks();
        if (blocks.isEmpty()) {
            blocks.add(this.composeBlockMacro());
        }
        return blocks;
    }

    public List<MacroDefinition> blocksFromStorageFormat(String storageFormat) throws XhtmlException {
        List<MacroDefinition> blocks = this.contentMacrosFromStorageFormat(storageFormat, BLOCK_MACRO_KEY);
        blocks.addAll(this.contentMacrosFromStorageFormat(storageFormat, DEFERRED_LOADING_BLOCK_MACRO_KEY));
        return blocks;
    }

    protected void calculateAllLayoutLayerMacros() {
        this.calculateDesktopLayoutLayerMacros();
        this.calculateMobileLayoutLayerMacros();
    }

    protected void calculateDesktopLayoutLayerMacros() {
        this.layoutLayerTopMacros = new ArrayList<MacroDefinition>();
        this.layoutLayerMergeMacros = new ArrayList<MacroDefinition>();
        this.layoutLayerBottomMacros = new ArrayList<MacroDefinition>();
        PageWrapper layoutWrapper = this.getLayoutPageWrapper();
        if (layoutWrapper == null) {
            return;
        }
        List<MacroDefinition> layoutLayers = layoutWrapper.getLayerMacros();
        this.calculateLayoutLayerMacros(layoutLayers, this.layoutLayerTopMacros, this.layoutLayerMergeMacros, this.layoutLayerBottomMacros);
    }

    protected void calculateLayoutLayerMacros(List<MacroDefinition> layerMacros, List<MacroDefinition> topMacros, List<MacroDefinition> mergeMacros, List<MacroDefinition> bottomMacros) {
        for (MacroDefinition layoutLayer : layerMacros) {
            String position = MacroParser.getStringParameter((MacroDefinition)layoutLayer, (String)POSITION_PARAM);
            if (POSITION_IGNORE.equals(position)) continue;
            MacroDefinition fixedLayer = this.fixArchitectLayer(layoutLayer);
            if (POSITION_TOP.equals(position)) {
                topMacros.add(fixedLayer);
                continue;
            }
            if (POSITION_BOTTOM.equals(position)) {
                bottomMacros.add(fixedLayer);
                continue;
            }
            mergeMacros.add(fixedLayer);
        }
    }

    protected void calculateMobileLayoutLayerMacros() {
        this.mobileLayoutLayerTopMacros = new ArrayList<MacroDefinition>();
        this.mobileLayoutLayerMergeMacros = new ArrayList<MacroDefinition>();
        this.mobileLayoutLayerBottomMacros = new ArrayList<MacroDefinition>();
        if (!this.hasMobilePhoneLayout()) {
            return;
        }
        List<MacroDefinition> layoutLayers = this.getMobilePhoneLayoutPageWrapper().getLayerMacros();
        this.calculateLayoutLayerMacros(layoutLayers, this.mobileLayoutLayerTopMacros, this.mobileLayoutLayerMergeMacros, this.mobileLayoutLayerBottomMacros);
    }

    public MacroDefinition column(String id) throws XhtmlException {
        return this.contentMacro(COLUMN_MACRO_KEY, id);
    }

    public MacroDefinition macroWithId(String id, List<MacroDefinition> macros) {
        if (!BrikitString.isSet((String)id)) {
            return null;
        }
        for (MacroDefinition macro : macros) {
            if (!id.equals(this.getId(macro))) continue;
            return macro;
        }
        return null;
    }

    public MacroDefinition columnFromStorageFormat(String storageFormat, String id) throws XhtmlException {
        return this.contentMacroFromStorageFormat(storageFormat, COLUMN_MACRO_KEY, id);
    }

    public float columnWidth(MacroDefinition columnMacro) {
        String widthString = MacroParser.getStringParameter((MacroDefinition)columnMacro, (String)WIDTH_PARAM);
        return BrikitNumber.parseFloat((String)widthString);
    }

    public List<MacroDefinition> columns() throws XhtmlException {
        return this.contentMacros(COLUMN_MACRO_KEY);
    }

    public List<MacroDefinition> columnsFromStorageFormat(String storageFormat) throws XhtmlException {
        return this.contentMacrosFromStorageFormat(storageFormat, COLUMN_MACRO_KEY);
    }

    public MacroDefinition composeBlock() throws Exception {
        return this.composePageElement("block");
    }

    public MacroDefinition composeBlockMacro() throws Exception {
        if (this.hasLayerMacros()) {
            throw new XhtmlException("Compose block called on page that already has layers: " + this.getConfluencePage());
        }
        return this.composeBlockMacro(Confluence.getBodyAsString((ContentEntityObject)this.getConfluencePage()));
    }

    public MacroDefinition composeBlockMacro(String storageFormat) throws Exception {
        MacroDefinition newBlockMacro = MacroParser.createMacroDefinition((String)BLOCK_MACRO_KEY);
        MacroParser.setParameter((MacroDefinition)newBlockMacro, (String)ID_PARAM, (String)this.safeId(), (AbstractPage)this.getConfluencePage());
        MacroParser.setBody((MacroDefinition)newBlockMacro, (String)storageFormat);
        return newBlockMacro;
    }

    public MacroDefinition composeColumn() throws Exception {
        return this.composePageElement("column");
    }

    public MacroDefinition composeColumnMacro(String storageFormat) throws Exception {
        MacroDefinition newColumnMacro = MacroParser.createMacroDefinition((String)COLUMN_MACRO_KEY);
        MacroParser.setParameter((MacroDefinition)newColumnMacro, (String)ID_PARAM, (String)this.safeId(), (AbstractPage)this.getConfluencePage());
        MacroParser.setBody((MacroDefinition)newColumnMacro, (String)storageFormat);
        return newColumnMacro;
    }

    public MacroDefinition composeDefaultLayer() throws Exception {
        String newLayerId = this.safeId();
        MacroDefinition newBlockMacro = this.composeBlockMacro();
        MacroDefinition newColumnMacro = this.composeColumnMacro(Confluence.macroToStorageFormat((MacroDefinition)newBlockMacro, (AbstractPage)this.getConfluencePage()));
        MacroDefinition newLayerMacro = this.composeLayerMacro(Confluence.macroToStorageFormat((MacroDefinition)newColumnMacro, (AbstractPage)this.getConfluencePage()));
        MacroParser.setParameter((MacroDefinition)newLayerMacro, (String)ID_PARAM, (String)newLayerId, (AbstractPage)this.getConfluencePage());
        return newLayerMacro;
    }

    public MacroDefinition composeLayer(String layerType) throws Exception {
        return this.composePageElement(PAGE_ELEMENT_DISPLAY_LAYER, layerType);
    }

    public MacroDefinition composeLayerMacro(String storageFormat) throws Exception {
        MacroDefinition newLayerMacro = MacroParser.createMacroDefinition((String)LAYER_MACRO_KEY);
        MacroParser.setParameter((MacroDefinition)newLayerMacro, (String)ID_PARAM, (String)this.safeId(), (AbstractPage)this.getConfluencePage());
        MacroParser.setBody((MacroDefinition)newLayerMacro, (String)storageFormat);
        return newLayerMacro;
    }

    public MacroDefinition composePageElement(String type) throws Exception {
        return this.composePageElement(type, type);
    }

    public MacroDefinition composePageElement(String type, String filename) throws Exception {
        String wikiMarkup = BrikitPageElementDefaults.getDefaultPageContents(filename);
        String renderedContent = Confluence.migrateWikiMarkupToStorage((String)wikiMarkup, (AbstractPage)this.getConfluencePage());
        renderedContent = PageWrapper.refreshIds(this.getConfluencePage(), renderedContent);
        List<MacroDefinition> elements = this.contentMacrosFromStorageFormat(renderedContent, "content-" + type);
        return elements.get(0);
    }

    public MacroDefinition contentMacro(String macroName, String id) throws XhtmlException {
        if (!this.hasConfluencePage()) {
            return null;
        }
        MacroDefinition macro = MacroParser.firstMacro((AbstractPage)this.getConfluencePage(), (String)macroName, (String)ID_PARAM, (String)id);
        if (macro == null && BLOCK_MACRO_KEY.equals(macroName)) {
            macro = MacroParser.firstMacro((AbstractPage)this.getConfluencePage(), (String)DEFERRED_LOADING_BLOCK_MACRO_KEY, (String)ID_PARAM, (String)id);
        }
        return macro;
    }

    public MacroDefinition contentMacroFromStorageFormat(String storageFormat, String macroName, String id) throws XhtmlException {
        if (!this.hasConfluencePage()) {
            return null;
        }
        MacroDefinition macro = MacroParser.firstMacroFromStorageFormat((AbstractPage)this.getConfluencePage(), (String)storageFormat, (String)macroName, (String)ID_PARAM, (String)id);
        if (macro == null && BLOCK_MACRO_KEY.equals(macroName)) {
            macro = MacroParser.firstMacroFromStorageFormat((AbstractPage)this.getConfluencePage(), (String)storageFormat, (String)DEFERRED_LOADING_BLOCK_MACRO_KEY, (String)ID_PARAM, (String)id);
        }
        return macro;
    }

    public List<MacroDefinition> contentMacros(String macroName) throws XhtmlException {
        if (!this.hasConfluencePage()) {
            return new ArrayList<MacroDefinition>();
        }
        return MacroParser.extractMacros((AbstractPage)this.getConfluencePage(), (String)macroName);
    }

    public List<MacroDefinition> contentMacrosFromStorageFormat(String storageFormat, String macroName) throws XhtmlException {
        if (!this.hasConfluencePage()) {
            return new ArrayList<MacroDefinition>();
        }
        return MacroParser.extractMacrosFromStorageFormat((AbstractPage)this.getConfluencePage(), (String)storageFormat, (String)macroName);
    }

    public String displayableArchitectPageTitle() {
        if (!this.hasConfluencePage()) {
            return "";
        }
        String pageTitle = this.getConfluencePage().getDisplayTitle();
        String trimmedPageTitle = this.getConfluencePage().getDisplayTitle();
        int nextDotIndex = trimmedPageTitle.indexOf(".");
        if (nextDotIndex >= 0) {
            trimmedPageTitle = trimmedPageTitle.substring(nextDotIndex + 1, trimmedPageTitle.length());
        }
        if ((nextDotIndex = trimmedPageTitle.indexOf(".")) >= 0) {
            trimmedPageTitle = trimmedPageTitle.substring(nextDotIndex + 1, trimmedPageTitle.length());
        }
        if ((nextDotIndex = trimmedPageTitle.indexOf(".")) >= 0) {
            return trimmedPageTitle.substring(nextDotIndex + 1, trimmedPageTitle.length());
        }
        return "Default";
    }

    public String duplicateBlock(String relativeToBlockId) throws Exception {
        MacroDefinition relativeToBlock = this.block(relativeToBlockId = this.ensureBlock(relativeToBlockId));
        if (relativeToBlock == null) {
            throw new Exception("Couldn't find block: " + relativeToBlockId + " on page " + this.getConfluencePage());
        }
        String storageFormat = PageWrapper.refreshIds(this.getConfluencePage(), relativeToBlock);
        List<MacroDefinition> newBlocks = this.blocksFromStorageFormat(storageFormat);
        MacroDefinition newBlock = newBlocks.get(0);
        this.addBlock(newBlock, relativeToBlockId, false);
        return this.getId(newBlock);
    }

    public String duplicateColumn(String relativeToColumnId) throws Exception {
        MacroDefinition relativeToColumn = this.column(relativeToColumnId = this.ensureColumn(relativeToColumnId));
        if (relativeToColumn == null) {
            throw new Exception("Couldn't find column: " + relativeToColumnId + " on page " + this.getConfluencePage());
        }
        String storageFormat = PageWrapper.refreshIds(this.getConfluencePage(), relativeToColumn);
        List<MacroDefinition> newColumns = this.columnsFromStorageFormat(storageFormat);
        MacroDefinition newColumn = newColumns.get(0);
        this.addColumn(newColumn, relativeToColumnId, false);
        return this.getId(newColumn);
    }

    public String duplicateLayer(String relativeToLayerId) throws Exception {
        MacroDefinition relativeToLayer = this.layer(relativeToLayerId = this.ensureLayer(relativeToLayerId));
        if (relativeToLayer == null) {
            throw new Exception("Couldn't find layer: " + relativeToLayerId + " on page " + this.getConfluencePage());
        }
        String storageFormat = PageWrapper.refreshIds(this.getConfluencePage(), relativeToLayer);
        List<MacroDefinition> newLayers = this.layersFromStorageFormat(storageFormat);
        MacroDefinition newLayer = newLayers.get(0);
        this.addLayer(newLayer, relativeToLayerId, false);
        return this.getId(newLayer);
    }

    public String ensureBlock(String blockId) throws Exception {
        if (!"0".equals(blockId)) {
            return blockId;
        }
        this.ensureLayer();
        return this.getId(this.blocks().get(0));
    }

    public String ensureColumn(String columnId) throws Exception {
        if (!"0".equals(columnId)) {
            return columnId;
        }
        this.ensureLayer();
        return this.getId(this.columns().get(0));
    }

    public String ensureLayer() throws Exception {
        return this.ensureLayer(null);
    }

    public String ensureLayer(String existingLayerId) throws Exception {
        if (this.isGrid()) {
            return "-1";
        }
        if (!this.layers().isEmpty()) {
            return "0".equals(existingLayerId) ? this.getId(this.layers().get(0)) : existingLayerId;
        }
        if (!Confluence.canEdit((AbstractPage)this.getConfluencePage())) {
            return "-1";
        }
        MacroDefinition newLayerMacro = this.composeDefaultLayer();
        this.updatePage(Confluence.macroAsStorage((AbstractPage)this.getConfluencePage(), (MacroDefinition)newLayerMacro), null, false);
        return this.getId(newLayerMacro);
    }

    public MacroDefinition fixArchitectLayer(MacroDefinition layerMacro) {
        MacroDefinition fixedLayer = MacroParser.clone((MacroDefinition)layerMacro);
        String fixedStorage = this.fixArchitectPageAttachmentReferences((Page)this.getLayoutPageWrapper().getConfluencePage(), fixedLayer.getBodyText());
        MacroParser.setBody((MacroDefinition)fixedLayer, (String)fixedStorage);
        return fixedLayer;
    }

    public String fixArchitectPageAttachmentReferences(Page architectPage, String storageFormat) {
        return storageFormat.replaceAll("(?s)(<\\s*ri:attachment\\s+ri:filename=['\"][^'^\"]+['\"])\\s*/>", "$1><ri:page ri:content-title=\"" + architectPage.getTitle() + "\" ri:space-key=\"" + Confluence.getSpaceKey((AbstractPage)architectPage) + "\"/></ri:attachment>");
    }

    public MacroDefinition getAppliedLayoutMacro() {
        this.initializeFromPage();
        return this.layoutMacro;
    }

    public List<MacroDefinition> blockMacros(MacroDefinition columnMacro) {
        try {
            return this.blocksFromStorageFormat(columnMacro.getBodyText());
        }
        catch (XhtmlException ex) {
            BrikitLog.logError((String)"Unable to extract block macros from column.", (Exception)((Object)ex));
            return new ArrayList<MacroDefinition>();
        }
    }

    public String getBreadcrumbsDisplay() {
        return this.getLayoutMacroParameter(BREADCRUMBS_DISPLAY, PAGE_ELEMENT_DISPLAY_HEADER);
    }

    public String getMetadataBannerDisplay() {
        String setting = this.getLayoutMacroParameter(METADATA_BANNER_DISPLAY, PAGE_ELEMENT_DISPLAY_HIDE);
        return BrikitString.isSet((String)setting) ? setting : PAGE_ELEMENT_DISPLAY_HIDE;
    }

    public MacroDefinition columnMacroForBlock(String blockID) throws Exception {
        if ("0".equals(blockID)) {
            return null;
        }
        for (MacroDefinition pageColumn : this.columns()) {
            for (MacroDefinition pageBlock : this.blockMacros(pageColumn)) {
                String pageID = BrikitString.trimToString((String)MacroParser.getStringParameter((MacroDefinition)pageBlock, (String)ID_PARAM));
                if (!pageID.equals(blockID)) continue;
                return pageColumn;
            }
        }
        return null;
    }

    public List<MacroDefinition> columnMacros(MacroDefinition layerMacro) {
        try {
            return this.columnsFromStorageFormat(layerMacro.getBodyText());
        }
        catch (XhtmlException ex) {
            BrikitLog.logError((String)"Unable to extract column macros from layer.", (Exception)((Object)ex));
            return new ArrayList<MacroDefinition>();
        }
    }

    public boolean getCacheRenderedPage() {
        return false;
    }

    public String getCommentsDisplay() {
        return this.getLayoutMacroParameter(COMMENTS_DISPLAY, PAGE_ELEMENT_DISPLAY_LAYER);
    }

    public AbstractPage getConfluencePage() {
        this.initializeFromPage();
        return (AbstractPage)Confluence.getPageVersion((ContentEntityObject)Confluence.getPageOrBlogPost((long)this.getPageId()), (int)this.getPageVersion());
    }

    public String getContainerWidth() {
        return this.getLayoutMacroParameter(CONTAINER_WIDTH, "");
    }

    public Page getDesktopVersion() {
        return Confluence.getPage((Space)this.getSpace(), (String)this.getDesktopVersionPageTitle());
    }

    public String getDesktopVersionPageTitle() {
        String title = this.hasConfluencePage() ? Confluence.getTitle((AbstractPage)this.getConfluencePage()) : "";
        return this.isMobilePhoneVersion() ? title.substring(0, title.lastIndexOf(".mobile.phone")) : title;
    }

    public boolean getDoNotAddFakeLayer() {
        PageWrapper layoutWrapper = this.getLayoutPageWrapper();
        AbstractPage confluencePage = layoutWrapper == null || layoutWrapper.getConfluencePage() == null ? this.getConfluencePage() : layoutWrapper.getConfluencePage();
        return this.hasConfluencePage() && BrikitBoolean.booleanValue((String)Confluence.getMetaData((ContentEntityObject)confluencePage, (String)DO_NOT_ADD_FAKE_LAYER_KEY));
    }

    public boolean getDoNotCacheRenderedPage() {
        return this.hasConfluencePage() && BrikitBoolean.booleanValue((String)Confluence.getMetaData((ContentEntityObject)this.getConfluencePage(), (String)DO_NOT_CACHE_RENDERED_PAGE_KEY));
    }

    public boolean getDoNotConvertForMobile() {
        return this.hasConfluencePage() && BrikitBoolean.booleanValue((String)Confluence.getMetaData((ContentEntityObject)this.getConfluencePage(), (String)DO_NOT_CONVERT_FOR_MOBILE_KEY));
    }

    public String getId(MacroDefinition macro) {
        return MacroParser.getStringParameter((MacroDefinition)macro, (String)ID_PARAM);
    }

    public void setId(MacroDefinition macro, String value, AbstractPage abstractPage) throws Exception {
        MacroParser.setParameter((MacroDefinition)macro, (String)ID_PARAM, (String)value, (AbstractPage)abstractPage);
    }

    public boolean isFromLayout(MacroDefinition macro) {
        return BrikitBoolean.booleanValue((String)MacroParser.getStringParameter((MacroDefinition)macro, (String)FROM_LAYOUT_KEY));
    }

    public List<MacroDefinition> getLayoutLayerBottomMacros() {
        if (this.layoutLayerBottomMacros == null) {
            this.calculateAllLayoutLayerMacros();
        }
        return BrikitMobile.isPhone() && this.hasMobilePhoneLayout() ? this.mobileLayoutLayerBottomMacros : this.layoutLayerBottomMacros;
    }

    public List<MacroDefinition> getLayoutLayerMergeMacros() {
        if (this.layoutLayerMergeMacros == null) {
            this.calculateAllLayoutLayerMacros();
        }
        return BrikitMobile.isPhone() && this.hasMobilePhoneLayout() ? this.mobileLayoutLayerMergeMacros : this.layoutLayerMergeMacros;
    }

    public List<MacroDefinition> getLayoutLayerTopMacros() {
        if (this.layoutLayerTopMacros == null) {
            this.calculateAllLayoutLayerMacros();
        }
        return BrikitMobile.isPhone() && this.hasMobilePhoneLayout() ? this.mobileLayoutLayerTopMacros : this.layoutLayerTopMacros;
    }

    public PageWrapper getLayoutPageWrapper() {
        if (this.layoutPageWrapper == null) {
            Page layoutPage = PageWrapper.getLayout(this.getConfluencePage());
            this.layoutPageWrapper = PageWrapper.get((AbstractPage)layoutPage);
            if (this.layoutPageWrapper == null) {
                this.layoutPageWrapper = PageWrapper.get((AbstractPage)BrikitThemeSettings.getDefaultLayout());
            }
        }
        return this.layoutPageWrapper;
    }

    public PageWrapper getMobilePhoneLayoutPageWrapper() {
        Page mobilePhoneVersion;
        if (this.mobilePhoneLayoutPageWrapper == null && this.getLayoutPageWrapper() != null && (mobilePhoneVersion = this.getLayoutPageWrapper().getMobilePhoneVersion()) != null) {
            this.mobilePhoneLayoutPageWrapper = PageWrapper.get((AbstractPage)mobilePhoneVersion);
        }
        return this.mobilePhoneLayoutPageWrapper;
    }

    public BrikitList<String> getLabelsIncludingInherited() {
        if (this.labelsIncludingInherited == null) {
            this.labelsIncludingInherited = new BrikitList();
            this.labelsIncludingInherited.addAll((Collection)Confluence.getLabelNames((AbstractPage)this.getConfluencePage()));
            this.labelsIncludingInherited.addAll((Collection)BrikitApps.inheritedLabelsForPage((AbstractPage)this.getConfluencePage()));
            this.labelsIncludingInherited.sort((Comparator)CaseInsensitiveComparator.SINGLETON);
        }
        return this.labelsIncludingInherited;
    }

    public List<MacroDefinition> getLayerMacros() {
        if (this.isGrid()) {
            return Collections.EMPTY_LIST;
        }
        if (this.layerMacros == null) {
            try {
                this.layerMacros = this.layers();
            }
            catch (XhtmlException ex) {
                BrikitLog.logError((String)("Failed to extract content-layer macros from " + this.getConfluencePage()), (Exception)((Object)ex));
                this.layerMacros = new ArrayList<MacroDefinition>();
            }
        }
        return this.layerMacros;
    }

    public MacroDefinition getLayoutMacroFromContent() throws XhtmlException {
        if (!this.hasConfluencePage()) {
            return null;
        }
        return MacroParser.firstMacro((AbstractPage)this.getConfluencePage(), (String)LAYOUT_MACRO_KEY);
    }

    public String getLayoutMacroParameter(String paramKey, String defaultWhenNoLayoutExists) {
        return this.hasAppliedLayoutMacro() ? MacroParser.getStringParameter((MacroDefinition)this.getAppliedLayoutMacro(), (String)paramKey) : defaultWhenNoLayoutExists;
    }

    public Page getLayoutPage() {
        AbstractPage abstractPage = this.getConfluencePage();
        if (abstractPage == null) {
            return null;
        }
        if (ThemePress.isLayoutPage(abstractPage) || ThemePress.isFrame(abstractPage) || ThemePress.isGrid(abstractPage)) {
            return (Page)abstractPage;
        }
        if (ThemePress.isArchitectPage(abstractPage)) {
            return null;
        }
        if (ThemePress.isMobilePhonePage(abstractPage)) {
            try {
                PageWrapper desktopWrapper = PageWrapper.get((AbstractPage)this.getDesktopVersion());
                return desktopWrapper.getLayoutPage();
            }
            catch (Exception ex) {
                BrikitLog.logWarning((String)"Couldn't retrieve Page Wrapper object from cache.");
                return null;
            }
        }
        try {
            Page layoutPage = this.getLayoutPageOverride();
            if (layoutPage == null) {
                layoutPage = BrikitThemeSettings.getArchitectPageForSpace(abstractPage, ".brikit.layout.");
            }
            return layoutPage;
        }
        catch (Exception ex) {
            BrikitLog.logWarning((String)"Couldn't retrieve Page Wrapper object from cache.");
            return null;
        }
    }

    public Page getLayoutPageOverride() {
        if (!this.hasConfluencePage()) {
            return null;
        }
        if (this.layoutPageId == null) {
            if (!this.getOverridesLayout()) {
                this.layoutPageId = "";
                return null;
            }
            String data = Confluence.getMetaData((ContentEntityObject)this.getConfluencePage().getLatestVersion(), (String)LAYOUT_PAGE_ID_KEY);
            if (!BrikitString.isSet((String)data)) {
                Page homePageLayoutOverride = SpaceCategorySettings.getSpaceCategoryHomePageLayoutOverride(this.getConfluencePage());
                if (homePageLayoutOverride != null) {
                    this.layoutPageId = homePageLayoutOverride.getIdAsString();
                    return homePageLayoutOverride;
                }
                this.layoutPageId = "";
                return null;
            }
            Page layoutPageOverride = StorableArchitecturePageReference.convert(data);
            String string = this.layoutPageId = layoutPageOverride == null ? "" : layoutPageOverride.getIdAsString();
            if (layoutPageOverride != null && !StorableArchitecturePageReference.dataMatches(data, layoutPageOverride)) {
                this.setLayoutPage(layoutPageOverride);
            }
            return layoutPageOverride;
        }
        return (Page)Confluence.getPageOrBlogPost((String)this.layoutPageId);
    }

    public String getLikesAndLabelsDisplay() {
        return this.getLayoutMacroParameter(LIKES_AND_LABELS_DISPLAY, PAGE_ELEMENT_DISPLAY_LAYER);
    }

    public String getMobilePhonePageTitle() {
        return Confluence.getTitle((AbstractPage)this.getConfluencePage()) + ".mobile.phone";
    }

    public Page getMobilePhoneVersion() {
        return Confluence.isPage((AbstractPage)this.getConfluencePage()) ? Confluence.getPage((Space)this.getSpace(), (String)this.getMobilePhonePageTitle()) : null;
    }

    public boolean getMultiLevelMenu() {
        return this.hasConfluencePage() && BrikitBoolean.booleanValue((String)Confluence.getMetaData((ContentEntityObject)this.getConfluencePage(), (String)MULTI_LEVEL_MENU_KEY));
    }

    public String getName(MacroDefinition macro) {
        return MacroParser.getStringParameter((MacroDefinition)macro, (String)NAME_PARAM);
    }

    public MacroDefinition getOrCreateLayoutMacro() throws Exception {
        if (!this.hasConfluencePage()) {
            return null;
        }
        if (this.getLayoutMacroFromContent() == null) {
            this.ensureLayer();
            MacroDefinition newLayoutMacro = MacroParser.createMacroDefinition((String)LAYOUT_MACRO_KEY);
            String xhtml = Confluence.getBodyAsString((ContentEntityObject)this.getConfluencePage()) + "\n" + Confluence.macroAsStorage((AbstractPage)this.getConfluencePage(), (MacroDefinition)newLayoutMacro);
            this.updatePage(xhtml, null, false);
        }
        return this.getLayoutMacroFromContent();
    }

    public boolean getOverridesLayout() {
        return this.hasConfluencePage() && BrikitBoolean.booleanValue((String)Confluence.getMetaData((ContentEntityObject)this.getConfluencePage().getLatestVersion(), (String)LAYOUT_OVERRIDE_KEY));
    }

    public long getPageId() {
        return this.pageId;
    }

    public String getPageInfoDisplay() {
        return this.getLayoutMacroParameter(PAGE_INFO_DISPLAY, PAGE_ELEMENT_DISPLAY_LAYER);
    }

    public long getPageModificationTimeAtWrapperCreate() {
        return this.pageModificationTimeAtWrapperCreate;
    }

    public String getPageTitleDisplay() {
        return this.getLayoutMacroParameter(PAGE_TITLE_DISPLAY, PAGE_ELEMENT_DISPLAY_LAYER);
    }

    public int getPageVersion() {
        return this.pageVersion;
    }

    public boolean getRenderInPageContext() {
        return this.hasConfluencePage() && (BrikitBoolean.booleanValue((String)Confluence.getMetaData((ContentEntityObject)this.getConfluencePage(), (String)RENDER_CONTEXT_KEY)) || this.isGrid());
    }

    public Space getSpace() {
        return this.hasConfluencePage() ? Confluence.getSpace((AbstractPage)this.getConfluencePage()) : null;
    }

    public String getSpaceKey() {
        return this.hasConfluencePage() ? Confluence.getSpaceKey((AbstractPage)this.getConfluencePage()) : null;
    }

    protected String getValue(String aKey, String defaultValue) {
        String value = this.hasConfluencePage() ? Confluence.getContentPropertyManager().getStringProperty((ContentEntityObject)this.getConfluencePage(), aKey) : null;
        return value == null ? defaultValue : value;
    }

    public boolean hasAppliedLayoutMacro() {
        return this.getAppliedLayoutMacro() != null;
    }

    public boolean hasConfluencePage() {
        return this.getConfluencePage() != null;
    }

    public boolean hasLayerMacros() {
        return !this.getLayerMacros().isEmpty();
    }

    public boolean hasMobilePhoneLayout() {
        return this.getMobilePhoneLayoutPageWrapper() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFromPage() {
        Long l = this.getPageId();
        synchronized (l) {
            if (this.isInitialized()) {
                return;
            }
            try {
                this.setInitialized(true);
                AbstractPage abstractPage = Confluence.getPageOrBlogPost((long)this.getPageId());
                abstractPage = (AbstractPage)Confluence.getVersionForUserRequest((ContentEntityObject)abstractPage);
                if (abstractPage == null) {
                    return;
                }
                this.setPageVersion(abstractPage.getVersion());
                this.layoutPageId = null;
                this.layoutMacro = null;
                this.layerMacros = null;
                Page layout = this.getLayoutPage();
                if (layout != null) {
                    if (layout.equals((Object)this.getConfluencePage())) {
                        this.setLayoutMacro(this.getLayoutMacroFromContent());
                    } else {
                        PageWrapper layoutWrapper = PageWrapper.get((AbstractPage)layout);
                        if (layoutWrapper != null) {
                            this.setLayoutMacro(layoutWrapper.getLayoutMacroFromContent());
                        }
                    }
                }
            }
            catch (XhtmlException ex) {
                BrikitLog.logError((String)("Failed to extract content-layer macros from " + this.getConfluencePage()), (Exception)((Object)ex));
            }
        }
    }

    public boolean isAutomaticLayout() {
        return BrikitBoolean.booleanValue((String)this.getLayoutMacroParameter(AUTOMATIC_LAYOUT, "false"));
    }

    public boolean isDeferLoadingLabels() {
        return BrikitBoolean.booleanValue((String)this.getLayoutMacroParameter(DEFER_LOADING_LABELS, "false"));
    }

    public boolean isIgnoreSections() {
        return BrikitBoolean.booleanValue((String)this.getLayoutMacroParameter(IGNORE_SECTIONS, "false"));
    }

    protected boolean isInitialized() {
        return this.initialized && this.getPageId() != 0L && this.getPageVersion() != 0;
    }

    public boolean isMobilePhoneVersion() {
        return Confluence.getTitle((AbstractPage)this.getConfluencePage()).endsWith(".mobile.phone");
    }

    public boolean isPresentationMode() {
        return BrikitBoolean.booleanValue((String)this.getLayoutMacroParameter(PRESENTATION_MODE_DISPLAY, "false"));
    }

    public boolean isStale() {
        return this.hasConfluencePage() && this.getConfluencePage().getLastModificationDate().getTime() > this.getPageModificationTimeAtWrapperCreate();
    }

    public boolean isUsingFrame() {
        return ThemePress.isFrame((AbstractPage)this.getLayoutPage()) && !ThemePress.isFrame(this.getConfluencePage());
    }

    public boolean isUsingGrid() {
        return ThemePress.isGrid((AbstractPage)this.getLayoutPage()) && !ThemePress.isGrid(this.getConfluencePage());
    }

    public MacroDefinition layer(String id) throws XhtmlException {
        return this.contentMacro(LAYER_MACRO_KEY, id);
    }

    public MacroDefinition layerFromStorageFormat(String storageFormat, String id) throws XhtmlException {
        return this.contentMacroFromStorageFormat(storageFormat, LAYER_MACRO_KEY, id);
    }

    public List<MacroDefinition> layers() throws XhtmlException {
        return this.contentMacros(LAYER_MACRO_KEY);
    }

    public List<MacroDefinition> layersFromStorageFormat(String storageFormat) throws XhtmlException {
        return this.contentMacrosFromStorageFormat(storageFormat, LAYER_MACRO_KEY);
    }

    public List<List<MacroDefinition>> groupBlocksFromLayoutColumn(MacroDefinition columnMacro) {
        ArrayList<List<MacroDefinition>> blocksList = new ArrayList<List<MacroDefinition>>(2);
        if (columnMacro == null) {
            blocksList.add(new ArrayList(0));
            blocksList.add(new ArrayList(0));
            return blocksList;
        }
        List<MacroDefinition> blockMacros = this.blockMacros(columnMacro);
        ArrayList<MacroDefinition> topBlocks = new ArrayList<MacroDefinition>();
        ArrayList<MacroDefinition> bottomBlocks = new ArrayList<MacroDefinition>();
        for (MacroDefinition block : blockMacros) {
            String position = MacroParser.getStringParameter((MacroDefinition)block, (String)POSITION_PARAM);
            if (POSITION_TOP.equals(position)) {
                topBlocks.add(block);
            }
            if (!POSITION_BOTTOM.equals(position)) continue;
            bottomBlocks.add(block);
        }
        blocksList.add(topBlocks);
        blocksList.add(bottomBlocks);
        return blocksList;
    }

    public List<List<MacroDefinition>> groupColumnsFromLayer(MacroDefinition layerMacro) {
        ArrayList<List<MacroDefinition>> columnsList = new ArrayList<List<MacroDefinition>>(3);
        columnsList.add(new ArrayList(0));
        columnsList.add(new ArrayList(0));
        columnsList.add(new ArrayList(0));
        if (layerMacro == null) {
            return columnsList;
        }
        List<MacroDefinition> columnMacros = this.columnMacros(layerMacro);
        MacroDefinition mainColumn = this.widestColumn(columnMacros);
        if (mainColumn == null) {
            return columnsList;
        }
        ArrayList<MacroDefinition> mainColumns = new ArrayList<MacroDefinition>();
        mainColumns.add(mainColumn);
        BrikitList leftLayoutColumns = new BrikitList(columnMacros).objectsBefore((Object)mainColumn);
        BrikitList rightLayoutColumns = new BrikitList(columnMacros).objectsAfter((Object)mainColumn);
        columnsList = new ArrayList(3);
        columnsList.add(this.filterOutPositionIgnore((List<MacroDefinition>)leftLayoutColumns));
        columnsList.add(this.filterOutPositionIgnore(mainColumns));
        columnsList.add(this.filterOutPositionIgnore((List<MacroDefinition>)rightLayoutColumns));
        return columnsList;
    }

    public MacroDefinition mainColumnMacro(MacroDefinition layerMacro) throws XhtmlException {
        return this.widestColumn(this.columnMacros(layerMacro));
    }

    public String columnsBefore() {
        StringBuilder builder = new StringBuilder();
        return builder.toString();
    }

    public Document excerptMacroContents() {
        if (NOT_SET.equals(this.excerptMacroContents)) {
            this.excerptMacroContents = "";
            try {
                MacroDefinition macro = MacroParser.firstMacro((AbstractPage)this.getConfluencePage(), (String)EXCERPT_MACRO_KEY);
                if (macro != null) {
                    this.excerptMacroContents = Confluence.render((String)macro.getBodyText(), (AbstractPage)this.getConfluencePage());
                }
            }
            catch (XhtmlException ex) {
                BrikitLog.logError((String)"Unable to read excerpt macro.", (Exception)((Object)ex));
            }
        }
        return Jsoup.parse((String)this.excerptMacroContents);
    }

    public List<String> fakeLayerComponents() throws Exception {
        MacroDefinition layer = this.fakeLayerMacro();
        String renderedLayer = Confluence.render((MacroDefinition)layer, (AbstractPage)this.getConfluencePage());
        return BrikitString.split((String)renderedLayer, (String)FAKE_LAYER_DELIM);
    }

    public MacroDefinition fakeLayerMacro() throws Exception {
        MacroDefinition block = MacroParser.createMacroDefinition((String)BLOCK_MACRO_KEY);
        MacroParser.setParameter((MacroDefinition)block, (String)ID_PARAM, (String)"0", (AbstractPage)this.getConfluencePage());
        MacroParser.setBody((MacroDefinition)block, (String)FAKE_LAYER_DELIM);
        MacroDefinition column = MacroParser.createMacroDefinition((String)COLUMN_MACRO_KEY);
        MacroParser.setParameter((MacroDefinition)column, (String)ID_PARAM, (String)"0", (AbstractPage)this.getConfluencePage());
        MacroParser.setBody((MacroDefinition)column, (String)Confluence.macroToStorageFormat((MacroDefinition)block, (AbstractPage)this.getConfluencePage()));
        MacroDefinition layer = MacroParser.createMacroDefinition((String)LAYER_MACRO_KEY);
        MacroParser.setParameter((MacroDefinition)layer, (String)ID_PARAM, (String)"0", (AbstractPage)this.getConfluencePage());
        MacroParser.setBody((MacroDefinition)layer, (String)Confluence.macroToStorageFormat((MacroDefinition)column, (AbstractPage)this.getConfluencePage()));
        return layer;
    }

    public List<MacroDefinition> filterOutPositionIgnore(List<MacroDefinition> macros) {
        ArrayList<MacroDefinition> filtered = new ArrayList<MacroDefinition>(macros.size());
        for (MacroDefinition macro : macros) {
            if (POSITION_IGNORE.equals(MacroParser.getStringParameter((MacroDefinition)macro, (String)POSITION_PARAM))) continue;
            filtered.add(macro);
        }
        return filtered;
    }

    public List<MacroDefinition> columnsToAdd(List<MacroDefinition> pageColumns, List<MacroDefinition> layoutColumns) {
        ArrayList<MacroDefinition> columnsToAdd = new ArrayList<MacroDefinition>();
        for (int i = 0; i < Math.max(pageColumns.size(), layoutColumns.size()); ++i) {
            MacroDefinition layoutColumn;
            MacroDefinition pageColumn = i < pageColumns.size() && pageColumns.get(i) != null ? pageColumns.get(i) : null;
            MacroDefinition macroDefinition = layoutColumn = i < layoutColumns.size() && layoutColumns.get(i) != null ? layoutColumns.get(i) : null;
            if (layoutColumn == null || pageColumn != null) continue;
            columnsToAdd.add(layoutColumn);
        }
        return columnsToAdd;
    }

    public List<MacroDefinition> columnsWhenMerged(List<MacroDefinition> pageColumns, List<MacroDefinition> layoutColumns, AbstractPage abstractPage) throws Exception {
        ArrayList<MacroDefinition> combinedColumns = new ArrayList<MacroDefinition>();
        for (int i = 0; i < Math.max(pageColumns.size(), layoutColumns.size()); ++i) {
            MacroDefinition layoutColumn;
            MacroDefinition pageColumn = i < pageColumns.size() && pageColumns.get(i) != null ? pageColumns.get(i) : null;
            MacroDefinition macroDefinition = layoutColumn = i < layoutColumns.size() && layoutColumns.get(i) != null ? layoutColumns.get(i) : null;
            if (layoutColumn != null) {
                String id = pageColumn != null ? this.getId(pageColumn) : "0";
                this.setId(layoutColumn, id, abstractPage);
                MacroParser.setParameter((MacroDefinition)layoutColumn, (String)FROM_LAYOUT_KEY, (String)"true", (AbstractPage)abstractPage);
                combinedColumns.add(layoutColumn);
                continue;
            }
            if (pageColumn == null) continue;
            combinedColumns.add(pageColumn);
        }
        return combinedColumns;
    }

    protected void appendLayoutMacroAsStorageFormat(StringBuilder builder, MacroDefinition layoutMacro, AbstractPage abstractPage) throws Exception {
        MacroParser.setParameter((MacroDefinition)layoutMacro, (String)FROM_LAYOUT_KEY, (String)"true", (AbstractPage)abstractPage);
        builder.append(Confluence.macroToStorageFormat((MacroDefinition)layoutMacro, (AbstractPage)abstractPage));
    }

    public Document metaPropertiesBlockContents() {
        if (NOT_SET.equals(this.metaPropertiesBlockContents)) {
            this.metaPropertiesBlockContents = "";
            try {
                MacroDefinition macro = MacroParser.firstMacro((AbstractPage)this.getConfluencePage(), (String)BLOCK_MACRO_KEY, (String)META_PROPERTIES_PARAM, (String)"true");
                if (macro != null) {
                    this.metaPropertiesBlockContents = Confluence.render((String)macro.getBodyText(), (AbstractPage)this.getConfluencePage());
                }
            }
            catch (Exception ex) {
                BrikitLog.logError((String)"Unable to read block for meta-properties", (Exception)ex);
            }
        }
        return Jsoup.parse((String)this.metaPropertiesBlockContents);
    }

    public String metaPropertyDescription() {
        if (NOT_SET.equals(this.metaPropertyDescription)) {
            this.metaPropertyDescription = "";
            this.metaPropertyDescription = BrikitHTML.getText(this.metaPropertiesBlockContents(), "p");
            if (!BrikitString.isSet((String)this.metaPropertyDescription)) {
                this.metaPropertyDescription = BrikitHTML.getText(this.excerptMacroContents(), "p");
            }
            if (!BrikitString.isSet((String)this.metaPropertyDescription)) {
                this.metaPropertyDescription = this.textFromFirstBlockWithFullParagraphs();
            }
        }
        return NOT_SET.equals(this.metaPropertyDescription) ? "" : this.metaPropertyDescription;
    }

    public boolean isArchitectPage() {
        return ThemePress.isArchitectPage(this.getConfluencePage());
    }

    public boolean isGrid() {
        return ThemePress.isGrid(this.getConfluencePage());
    }

    public String metaPropertyImage() {
        if (this.isArchitectPage()) {
            this.metaPropertyImage = Confluence.getContextPath() + "/download/resources/com.brikit.themepress:theme-base/images/brikit-logo.png";
        } else if (NOT_SET.equals(this.metaPropertyImage)) {
            Attachment image;
            Element img;
            this.metaPropertyImage = "";
            this.metaPropertyImage = BrikitHTML.getValue(this.metaPropertiesBlockContents(), "img", "src");
            if (!BrikitString.isSet((String)this.metaPropertyImage)) {
                for (Attachment attachment : Confluence.getImageAttachments((AbstractPage)this.getConfluencePage())) {
                    if (!Confluence.hasLabel((AbstractLabelableEntityObject)attachment, (String)RICH_LINK_LABEL)) continue;
                    this.metaPropertyImage = Confluence.attachmentDownloadPath((Attachment)attachment);
                    break;
                }
            }
            String imageBlackList = ":not(.emoticon):not(.wait):not(.userLogo):not(.user-profile)";
            if (!BrikitString.isSet((String)this.metaPropertyImage) && (img = BrikitHTML.getElements(this.excerptMacroContents(), "img" + imageBlackList).first()) != null) {
                this.metaPropertyImage = img.attr("src");
            }
            if (!BrikitString.isSet((String)this.metaPropertyImage)) {
                try {
                    for (MacroDefinition layer : MacroParser.extractMacros((AbstractPage)this.getConfluencePage(), (String)LAYER_MACRO_KEY, (String)BACKGROUND_IMAGE_PARAM)) {
                        this.metaPropertyImage = Confluence.attachmentDownloadPath((AbstractPage)this.getConfluencePage(), (String)MacroParser.getStringParameter((MacroDefinition)layer, (String)CONTAINER_BACKGROUND_IMAGE_PARAM));
                        if (!BrikitString.isSet((String)this.metaPropertyImage)) {
                            this.metaPropertyImage = Confluence.attachmentDownloadPath((AbstractPage)this.getConfluencePage(), (String)MacroParser.getStringParameter((MacroDefinition)layer, (String)BACKGROUND_IMAGE_PARAM));
                            if (!BrikitString.isSet((String)this.metaPropertyImage)) continue;
                        }
                        break;
                    }
                }
                catch (XhtmlException ex) {
                    BrikitLog.logError((String)("Unable to read layers macros on " + this.getConfluencePage()), (Exception)((Object)ex));
                }
            }
            if (!BrikitString.isSet((String)this.metaPropertyImage)) {
                try {
                    for (MacroDefinition layer : MacroParser.extractMacros((AbstractPage)this.getConfluencePage(), (String)BLOCK_MACRO_KEY, (String)BACKGROUND_IMAGE_PARAM)) {
                        this.metaPropertyImage = Confluence.attachmentDownloadPath((AbstractPage)this.getConfluencePage(), (String)MacroParser.getStringParameter((MacroDefinition)layer, (String)BACKGROUND_IMAGE_PARAM));
                        if (!BrikitString.isSet((String)this.metaPropertyImage)) continue;
                        break;
                    }
                }
                catch (XhtmlException ex) {
                    BrikitLog.logError((String)("Unable to read layers macros on " + this.getConfluencePage()), (Exception)((Object)ex));
                }
            }
            if (!BrikitString.isSet((String)this.metaPropertyImage)) {
                for (Element img2 : BrikitHTML.getElements(Jsoup.parse((String)this.renderConfluencePage()), "img" + imageBlackList)) {
                    boolean inRichLink = false;
                    for (Element parent : img2.parents()) {
                        inRichLink |= parent.hasClass(RICH_LINK_LABEL);
                    }
                    if (inRichLink) continue;
                    this.metaPropertyImage = img2.attr("src");
                    break;
                }
            }
            if (!BrikitString.isSet((String)this.metaPropertyImage) && (image = (Attachment)new BrikitList(Confluence.getImageAttachments((AbstractPage)this.getConfluencePage())).first()) != null) {
                this.metaPropertyImage = Confluence.attachmentDownloadPath((Attachment)image);
            }
        }
        return this.metaPropertyImage;
    }

    public String metaPropertyImageThumbnail() {
        return Confluence.attachmentImageThumbnailDownloadPath((String)this.metaPropertyImage());
    }

    public String metaPropertyTitle() {
        if (NOT_SET.equals(this.metaPropertyTitle)) {
            this.metaPropertyTitle = "";
            this.metaPropertyTitle = BrikitHTML.getText(this.metaPropertiesBlockContents(), "h1, h2, h3, h4, h5, h6");
            if (!BrikitString.isSet((String)this.metaPropertyTitle)) {
                this.metaPropertyTitle = Confluence.getTitle((AbstractPage)this.getConfluencePage());
            }
        }
        return NOT_SET.equals(this.metaPropertyTitle) ? "" : this.metaPropertyTitle;
    }

    protected String renderConfluencePage() {
        try {
            return Confluence.render((AbstractPage)this.getConfluencePage());
        }
        catch (Exception ex) {
            if (ex instanceof MacroExecutionException) {
                BrikitLog.logWarning((String)("Unable to render page " + this.getConfluencePage() + ", likely due to an improperly configured macro. Details:"), (Exception)ex);
            } else {
                BrikitLog.logWarning((String)("Unable to render page " + this.getConfluencePage() + " due to the following exception:"), (Exception)ex);
            }
            return "";
        }
    }

    public String renderLayoutMacros(List<MacroDefinition> macros) {
        return this.renderMacros(macros, true);
    }

    public String renderMacros(List<MacroDefinition> macros) {
        return this.renderMacros(macros, false);
    }

    public String renderMacros(List<MacroDefinition> macros, boolean markAsFromLayout) {
        StringBuilder builder = new StringBuilder();
        for (MacroDefinition macro : macros) {
            try {
                boolean fromLayout = MacroParser.hasBooleanParameter((MacroDefinition)macro, (String)FROM_LAYOUT_KEY, (boolean)true);
                if (markAsFromLayout && !fromLayout) {
                    MacroParser.setParameter((MacroDefinition)macro, (String)FROM_LAYOUT_KEY, (String)"true", (AbstractPage)this.getConfluencePage());
                }
                builder.append(Confluence.render((MacroDefinition)macro, (AbstractPage)this.getConfluencePage()));
                if (!markAsFromLayout || fromLayout) continue;
                MacroParser.removeParameter((MacroDefinition)macro, (String)FROM_LAYOUT_KEY, (AbstractPage)this.getConfluencePage());
            }
            catch (Exception ex) {
                BrikitLog.logError((String)"Failed to render macros.", (Exception)ex);
            }
        }
        return builder.toString();
    }

    protected MacroDefinition widestColumn(List<MacroDefinition> columns) {
        if (columns.isEmpty()) {
            return null;
        }
        ArrayList<MacroDefinition> widest = new ArrayList<MacroDefinition>();
        int maxWidth = 0;
        for (MacroDefinition column : columns) {
            int width = (int)(this.columnWidth(column) * 1000.0f);
            if (width > maxWidth) {
                maxWidth = width;
                widest.clear();
                widest.add(column);
                continue;
            }
            if (width != maxWidth) continue;
            widest.add(column);
        }
        return (MacroDefinition)widest.get(Math.min(1, widest.size() - 1));
    }

    public MacroDefinition layerMacroForColumn(String columnID) throws Exception {
        if ("0".equals(columnID)) {
            return this.fakeLayerMacro();
        }
        for (MacroDefinition pageLayer : this.getLayerMacros()) {
            for (MacroDefinition pageColumn : this.columnMacros(pageLayer)) {
                String pageID = BrikitString.trimToString((String)MacroParser.getStringParameter((MacroDefinition)pageColumn, (String)ID_PARAM));
                if (!pageID.equals(columnID)) continue;
                return pageLayer;
            }
        }
        return null;
    }

    public int positionForColumn(MacroDefinition layerMacro, String columnID) {
        if ("0".equals(columnID)) {
            return 0;
        }
        int count = -1;
        for (MacroDefinition columnLayer : this.columnMacros(layerMacro)) {
            ++count;
            String thisID = BrikitString.trimToString((String)MacroParser.getStringParameter((MacroDefinition)columnLayer, (String)ID_PARAM));
            if (!thisID.equals(columnID)) continue;
            return count;
        }
        return -1;
    }

    public int positionForLayer(String layerID) {
        if ("0".equals(layerID)) {
            return 0;
        }
        int count = -1;
        for (MacroDefinition pageLayer : this.getLayerMacros()) {
            ++count;
            String thisID = BrikitString.trimToString((String)MacroParser.getStringParameter((MacroDefinition)pageLayer, (String)ID_PARAM));
            if (!thisID.equals(layerID)) continue;
            return count;
        }
        return -1;
    }

    public String getSidebarDisplay() {
        return this.getLayoutMacroParameter(SIDEBAR_DISPLAY, PAGE_ELEMENT_DISPLAY_HIDE);
    }

    public String getToolbarDisplay() {
        return this.getLayoutMacroParameter(TOOLBAR_DISPLAY, PAGE_ELEMENT_DISPLAY_HIDE);
    }

    public float getTotalColumnWidth(List<MacroDefinition> columnMacros) {
        float width = 0.0f;
        for (MacroDefinition columnMacro : columnMacros) {
            width += this.columnWidth(columnMacro);
        }
        return width;
    }

    public List<MacroDefinition> rebalanceColumns(String layerBodyStorageFormat, List<MacroDefinition> ignoreColumns) throws Exception {
        List<MacroDefinition> columns = this.columnsFromStorageFormat(layerBodyStorageFormat);
        ArrayList<MacroDefinition> unsizedColumns = new ArrayList<MacroDefinition>();
        List<String> parametersForEquality = Arrays.asList(ID_PARAM);
        float smallest = 1000.0f;
        float used = 0.0f;
        float ignore = 0.0f;
        for (MacroDefinition column : columns) {
            float width = this.columnWidth(column);
            if ((double)width > 0.001) {
                used += width;
                smallest = Math.min(smallest, width);
                if (!MacroParser.containsUsingParameterMatch(ignoreColumns, (MacroDefinition)column, parametersForEquality)) continue;
                ignore += width;
                continue;
            }
            unsizedColumns.add(column);
        }
        for (MacroDefinition unsizedColumn : unsizedColumns) {
            MacroParser.setParameter((MacroDefinition)unsizedColumn, (String)WIDTH_PARAM, (String)(Float.toString(smallest) + "%"), (AbstractPage)this.getConfluencePage());
            used += smallest;
        }
        if ((double)used < 99.999 || (double)used > 100.001) {
            float goal = 100.0f - ignore;
            float increase = 1.0f + (goal - (used -= ignore)) / used;
            for (MacroDefinition column : columns) {
                if (MacroParser.containsUsingParameterMatch(ignoreColumns, (MacroDefinition)column, parametersForEquality)) continue;
                float width = BrikitNumber.parseFloat((String)MacroParser.getStringParameter((MacroDefinition)column, (String)WIDTH_PARAM)) * increase;
                MacroParser.setParameter((MacroDefinition)column, (String)WIDTH_PARAM, (String)(Float.toString(width) + "%"), (AbstractPage)this.getConfluencePage());
            }
            return columns;
        }
        return new ArrayList<MacroDefinition>();
    }

    public String rebalanceColumnsFromStorageFormat(String storageFormat) throws Exception {
        return this.rebalanceColumnsFromStorageFormat(storageFormat, null);
    }

    public String rebalanceColumnsFromStorageFormat(String storageFormat, List<MacroDefinition> ignoreColumns) throws Exception {
        List<MacroDefinition> layers = this.layersFromStorageFormat(storageFormat);
        if (layers.isEmpty()) {
            for (MacroDefinition changedColumn : this.rebalanceColumns(storageFormat, ignoreColumns)) {
                MacroDefinition column = this.columnFromStorageFormat(storageFormat, this.getId(changedColumn));
                storageFormat = MacroParser.replaceMacroInStorageFormat((AbstractPage)this.getConfluencePage(), (String)storageFormat, (MacroDefinition)column, (MacroDefinition)changedColumn);
            }
        } else {
            for (MacroDefinition layer : layers) {
                for (MacroDefinition changedColumn : this.rebalanceColumns(layer.getBodyText(), ignoreColumns)) {
                    MacroDefinition column = this.columnFromStorageFormat(storageFormat, this.getId(changedColumn));
                    storageFormat = MacroParser.replaceMacroInStorageFormat((AbstractPage)this.getConfluencePage(), (String)storageFormat, (MacroDefinition)column, (MacroDefinition)changedColumn);
                }
            }
        }
        return storageFormat;
    }

    public void removeBlock(String layerId, String columnId, String blockId) throws Exception {
        blockId = this.ensureBlock(blockId);
        columnId = this.ensureColumn(columnId);
        MacroDefinition layer = this.layer(layerId = this.ensureLayer(layerId));
        if (layer == null) {
            throw new Exception("Couldn't find layer: " + layerId + " on " + this.getConfluencePage() + ".");
        }
        MacroDefinition column = this.column(columnId);
        if (column == null) {
            throw new Exception("Couldn't find column: " + columnId + " on " + this.getConfluencePage() + ".");
        }
        MacroDefinition block = this.block(blockId);
        if (block == null) {
            throw new Exception("Couldn't remove block: " + blockId + " on " + this.getConfluencePage() + ". Block not found.");
        }
        List<MacroDefinition> blocksRemaining = this.blocksFromStorageFormat(layer.getBodyText());
        MacroParser.removeMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)(blocksRemaining.size() > 1 ? block : layer));
    }

    public void removeColumn(String layerId, String columnId) throws Exception {
        columnId = this.ensureColumn(columnId);
        MacroDefinition layer = this.layer(layerId = this.ensureLayer(layerId));
        if (layer == null) {
            throw new Exception("Couldn't find layer: " + layerId + " on " + this.getConfluencePage() + ".");
        }
        MacroDefinition column = this.column(columnId);
        if (column == null) {
            throw new Exception("Couldn't remove column: " + columnId + " on " + this.getConfluencePage() + ". Column not found.");
        }
        List<MacroDefinition> columnsRemaining = this.columnsFromStorageFormat(layer.getBodyText());
        String newBody = Confluence.getBodyAsString((ContentEntityObject)this.getConfluencePage());
        newBody = columnsRemaining.size() > 1 ? MacroParser.removeMacroFromStorageFormat((AbstractPage)this.getConfluencePage(), (String)newBody, (MacroDefinition)column) : MacroParser.removeMacroFromStorageFormat((AbstractPage)this.getConfluencePage(), (String)newBody, (MacroDefinition)layer);
        newBody = this.rebalanceColumnsFromStorageFormat(newBody);
        this.updatePage(newBody, "column removed", false);
    }

    public void removeLayer(String layerId) throws Exception {
        MacroDefinition layer = this.layer(layerId = this.ensureLayer(layerId));
        if (layer == null) {
            throw new Exception("Couldn't remove layer: " + layerId + " on " + this.getConfluencePage() + ". Layer not found.");
        }
        MacroParser.removeMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)layer);
    }

    public void setCacheRenderedPage(boolean cacheRenderedPage) throws Exception {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)CACHE_RENDERED_PAGE_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)cacheRenderedPage));
        InstantPageCache.reset(this.getConfluencePage());
        PageWrapperCache.reset();
    }

    protected String safeId() {
        return PageWrapper.safeId(this.getConfluencePage());
    }

    public void setContainerWidth(String widthString) throws Exception {
        MacroDefinition existingLayout = this.getOrCreateLayoutMacro();
        MacroDefinition newLayoutMacro = MacroParser.clone((MacroDefinition)existingLayout);
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)CONTAINER_WIDTH, (String)widthString, (AbstractPage)this.getConfluencePage());
        MacroParser.replaceMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)existingLayout, (MacroDefinition)newLayoutMacro, (String)("Change content container width: " + widthString), (boolean)false);
        this.initializeFromPage();
        PageWrapperCache.reset();
    }

    public void setDoNotAddFakeLayer(boolean doNotAddFakeLayer) throws Exception {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)DO_NOT_ADD_FAKE_LAYER_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)doNotAddFakeLayer));
        PageWrapperCache.reset();
    }

    public void setDoNotCacheRenderedPage(boolean cacheRenderedPage) throws Exception {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)DO_NOT_CACHE_RENDERED_PAGE_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)cacheRenderedPage));
        PageWrapperCache.reset();
    }

    public void setDoNotConvertForMobile(boolean convertForMobile) throws Exception {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)DO_NOT_CONVERT_FOR_MOBILE_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)convertForMobile));
        PageWrapperCache.reset();
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setLayoutDisplayOptions(String breadcrumbsDisplay, String metadataBannerDisplay, String pageTitleDisplay, String pageInfoDisplay, String likesAndLabelsDisplay, String commentsDisplay, String toolbarDisplay, String sidebarDisplay, String presentationMode, String automaticLayout, String ignoreSections, boolean deferLoadingLabels) throws Exception {
        MacroDefinition existingLayout = this.getOrCreateLayoutMacro();
        MacroDefinition newLayoutMacro = MacroParser.clone((MacroDefinition)existingLayout);
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)BREADCRUMBS_DISPLAY, (String)breadcrumbsDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)METADATA_BANNER_DISPLAY, (String)metadataBannerDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)PAGE_TITLE_DISPLAY, (String)pageTitleDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)PAGE_INFO_DISPLAY, (String)pageInfoDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)LIKES_AND_LABELS_DISPLAY, (String)likesAndLabelsDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)COMMENTS_DISPLAY, (String)commentsDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)TOOLBAR_DISPLAY, (String)toolbarDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)SIDEBAR_DISPLAY, (String)sidebarDisplay, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)PRESENTATION_MODE_DISPLAY, (String)presentationMode, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)AUTOMATIC_LAYOUT, (String)automaticLayout, (AbstractPage)this.getConfluencePage());
        MacroParser.setParameter((MacroDefinition)newLayoutMacro, (String)IGNORE_SECTIONS, (String)ignoreSections, (AbstractPage)this.getConfluencePage());
        MacroParser.setBooleanParameter((MacroDefinition)newLayoutMacro, (String)DEFER_LOADING_LABELS, (boolean)deferLoadingLabels, (AbstractPage)this.getConfluencePage());
        MacroParser.replaceMacro((AbstractPage)this.getConfluencePage(), (MacroDefinition)existingLayout, (MacroDefinition)newLayoutMacro, (String)"Change page elements display", (boolean)false);
        PageWrapperCache.reset();
    }

    protected void setLayoutMacro(MacroDefinition layoutMacro) {
        this.layoutMacro = layoutMacro;
    }

    public void setLayoutPage(Page layoutPage) {
        String data = StorableArchitecturePageReference.data(layoutPage);
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)LAYOUT_PAGE_ID_KEY, (String)data);
        PageWrapperCache.reset();
    }

    public void setMultiLevelMenu(boolean multiLevelMenu) throws Exception {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)MULTI_LEVEL_MENU_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)multiLevelMenu));
        PageWrapperCache.reset();
    }

    public void setOverrideLayout(boolean override) {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)LAYOUT_OVERRIDE_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)override));
        PageWrapperCache.reset();
    }

    protected void setPageId(long pageId) {
        this.pageId = pageId;
    }

    protected void setPageModificationTimeAtWrapperCreate(long pageModificationTimeAtWrapperCreate) {
        this.pageModificationTimeAtWrapperCreate = pageModificationTimeAtWrapperCreate;
    }

    protected void setPageVersion(int pageVersion) {
        this.pageVersion = pageVersion;
    }

    public void setRenderContext(boolean renderInViewPageContext) throws Exception {
        Confluence.setMetaData((ContentEntityObject)this.getConfluencePage(), (String)RENDER_CONTEXT_KEY, (String)BrikitBoolean.valueFromBoolean((boolean)renderInViewPageContext));
        PageWrapperCache.reset();
    }

    public String textFromFirstBlockWithFullParagraphs() {
        if (NOT_SET.equals(this.blockParagraphText)) {
            this.blockParagraphText = "";
            try {
                for (MacroDefinition macro : this.blocksForced()) {
                    Document dom = Jsoup.parse((String)Confluence.render((String)macro.getBodyText(), (AbstractPage)this.getConfluencePage()));
                    this.blockParagraphText = BrikitString.trimToString((String)BrikitHTML.getText(dom, "p"));
                    if (!BrikitString.isSet((String)this.blockParagraphText)) continue;
                    break;
                }
            }
            catch (Exception ex) {
                BrikitLog.logWarning((String)("Unable to render page " + this.getConfluencePage() + " due to the following exception:"), (Exception)ex);
            }
        }
        return this.blockParagraphText;
    }

    protected void updatePage(String storageFormat, String versionComment, boolean notifyWatchers) throws Exception {
        AbstractPage abstractPage = this.getConfluencePage();
        Confluence.savePage((AbstractPage)abstractPage, (String)storageFormat, (String)versionComment, (boolean)notifyWatchers);
        this.setInitialized(false);
    }
}

