/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitString;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class FormattedDateMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/formatted-date.vm";
    public static final String FORMATTED_DATE = "formattedDate";
    public static final String DATE_PARAM = "date";
    public static final String DATE_FORMAT_PARAM = "format";
    public static final String CREATED = "@created";
    public static final String MODIFIED = "@modified";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        Date date = null;
        String dateString = macroContext.stringValue(DATE_PARAM);
        if (CREATED.equals(dateString)) {
            date = macroContext.getPage().getCreationDate();
        } else if (MODIFIED.equals(dateString)) {
            date = macroContext.getPage().getLastModificationDate();
        } else if (!BrikitString.isSet((String)dateString)) {
            date = BrikitDate.getToday().getTime();
        } else {
            try {
                date = BrikitDate.parseCalendar((String)macroContext.stringValue(DATE_PARAM)).getTime();
            }
            catch (ParseException ex) {
                throw new MacroExecutionException("Invalid date.");
            }
        }
        if (macroContext.hasStringValue(DATE_FORMAT_PARAM)) {
            String format = macroContext.stringValue(DATE_FORMAT_PARAM);
            macroContext.velocityContextAdd((Object)FORMATTED_DATE, (Object)BrikitDate.formatDateTime((Date)date, (TimeZone)Confluence.getTimeZone(), (String)format, (boolean)true));
        } else {
            macroContext.velocityContextAdd((Object)FORMATTED_DATE, (Object)BrikitDate.formatFriendlyDate((Date)date));
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }
}

