(function ($) {

	ThemePress.Invite = {
		
		inProgress: false,
		
		foundInviteUserMacro: function () {
			return ThemePress.Invite.inviteUserMacro().length;
		},
		
		initialize: function () {
			Confluence.Binder.autocompleteUserOrGroup();
		
			ThemePress.Invite.inviteUserMacro().submit(ThemePress.Invite.invite);
		},

		inviteUserMacro: function () {
			return $("form.invite-user-macro");
		},
		
		invite: function (event) {
			event.preventDefault();
			
			if (ThemePress.Invite.inProgress) return;
			
			if (!$(".invite-username-field", this).val()) {
				ThemePress.Dialog2.alert(ThemePress.getText("com.brikit.themepress.invite-user.missing.username"),
					{title: ThemePress.getText("com.brikit.themepress.invite-user.invite.user.label")});
				return false;
			}

			ThemePress.Invite.startSpinner();
			var href = $(this).attr("action");
			var data = $(this).serialize();
            $.post(href, data, ThemePress.Invite.inviteUserResponse, "json");
		},
		
		inviteUserResponse: function (data, textStatus, jqXHR) {
			ThemePress.Invite.stopSpinner();
			
			if (data.success) {
				// Ask if an invite should be sent
				ThemePress.Dialog2.confirm(
					data.message + ThemePress.getText("com.brikit.themepress.invite-user.invite.user.confirm", [data.fullName]), 
					{
						title: ThemePress.getText("com.brikit.themepress.invite-user.invite.user.label"),
						okButton: ThemePress.getText("com.brikit.themepress.invite-user.send.invite"),
						cancelButton: ThemePress.getText("com.brikit.themepress.invite-user.do.not.send.invite")
					}, 
					function (dialog) {
						ThemePress.Invite.sendInvitation(dialog, data.homePageId, data.username, data.fullName);
					}
				);
			
				// Clear both user input fields
				$(".invite-username-field, .invite-user-search-field").val("");
			}
			else {
				ThemePress.Dialog2.alert("<p>" + data.message + "</p>",
					{title: ThemePress.getText("com.brikit.themepress.invite-user.invite.user.label")});
			}
			
		},
		
		sendInvitation: function (dialog, homePageId, username, fullName) {
			
			var dialogBody = dialog.$el;
			var $spinner = ThemePress.auiSpinner(dialogBody.find("p:last"));
			
	        var request = {
	            users: [username],
	            emails: [],
	            groups: [],
	            note: ThemePress.getText("com.brikit.themepress.invite-user.invite.user.message", [ThemePress.spaceName]),
	            entityId: homePageId,
				entityType: ThemePress.contentType,
				contextualPageId: ThemePress.pageId
	        };
			
	        $.ajax({
	            type: "POST",
	            contentType: "application/json; charset=utf-8",
	            url: Confluence.getContextPath() + "/rest/share-page/latest/share",
	            data: JSON.stringify(request),
	            dataType: "text",
				complete: function () { $spinner.remove(); },
	            success: function() {
					dialog.hide();
					ThemePress.Dialog2.alert(ThemePress.getText("com.brikit.themepress.invite-user.invite.sent", [fullName]),
						{title: ThemePress.getText("com.brikit.themepress.invite-user.invite.user.label")});
				},
	            error: function (data, status) {
					dialogBody.html(ThemePress.getText("com.brikit.themepress.invite-user.invite.email.error", [fullName, status]));
	            }
	        });
		},
		
		spinner: function () {
			return $(".invite-user-spinner");
		},
		
		startSpinner: function () {
			ThemePress.Invite.spinner().show();
			ThemePress.Invite.inProgress = true;
		},
		
		stopSpinner: function () {
			ThemePress.Invite.spinner().hide();
			ThemePress.Invite.inProgress = false;
		}
		
	};

	ThemePress.toInit( function ($) {
		if (!ThemePress.Invite.foundInviteUserMacro()) return;

		ThemePress.Invite.initialize();		
	});
	
})(jQuery);

