/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.AbstractPageDesignActionSupport;
import com.brikit.themepress.util.PageDesignerResponse;
import java.util.ArrayList;
import java.util.Arrays;

public class EditPageElementAction
extends AbstractPageDesignActionSupport {
    public String deferredLoadChanged() throws Exception {
        String parameterName;
        boolean conversion = this.ensureElementId();
        boolean wantsDeferred = BrikitBoolean.booleanValue((String)this.getValue());
        String newMacroName = wantsDeferred ? "deferred-loading-content-block" : "content-block";
        MacroDefinition macro = this.getPageWrapper().block(this.getElementId());
        if (macro == null) {
            return this.setJSONError("Cannot find content-block macro " + this.getElementId() + " on " + this.getPage());
        }
        MacroDefinition newMacro = MacroParser.clone((MacroDefinition)macro);
        MacroParser.setName((MacroDefinition)newMacro, (String)newMacroName);
        String string = parameterName = BrikitString.isSet((String)this.getContainerName()) ? "container-" + this.getName() : this.getName();
        if (wantsDeferred) {
            MacroParser.setParameter((MacroDefinition)newMacro, (String)parameterName, (String)this.getValue(), (AbstractPage)this.getPage());
        } else {
            MacroParser.removeParameter((MacroDefinition)newMacro, (String)parameterName, (AbstractPage)this.getPage());
        }
        String newBody = Confluence.getBodyAsString((ContentEntityObject)this.getPage());
        newBody = MacroParser.replaceMacroInStorageFormat((AbstractPage)this.getPage(), (String)newBody, (MacroDefinition)macro, (MacroDefinition)newMacro);
        Confluence.savePage((AbstractPage)this.getPage(), (String)newBody, (String)("change " + this.getElementType() + " " + this.getName() + " to " + this.getValue()), (boolean)false);
        JSONObject json = PageDesignerResponse.jsonResponse(this.getPage(), true, new ArrayList<MacroDefinition>(), "change", this.isReload() || conversion);
        this.setJSONResult(json);
        return "success";
    }

    protected boolean ensureElementId() throws Exception {
        boolean conversion = "0".equals(this.getElementId());
        if (conversion) {
            String matchingMacro = "content-" + this.getElementType();
            this.setLayerId(this.getPageWrapper().ensureLayer());
            if ("content-layer".equals(matchingMacro)) {
                this.setElementId(this.getLayerId());
            }
            MacroDefinition newLayer = this.getPageWrapper().layer(this.getLayerId());
            MacroDefinition newColumn = this.getPageWrapper().columnMacros(newLayer).get(0);
            this.setColumnId(this.getPageWrapper().getId(newColumn));
            if ("content-column".equals(matchingMacro)) {
                this.setElementId(this.getColumnId());
            }
            MacroDefinition newBlock = this.getPageWrapper().blockMacros(newColumn).get(0);
            this.setBlockId(this.getPageWrapper().getId(newBlock));
            if ("content-block".equals(matchingMacro)) {
                this.setElementId(this.getBlockId());
            }
        }
        return conversion;
    }

    public String execute() throws Exception {
        boolean columnWidthChange;
        boolean conversion = this.ensureElementId();
        MacroDefinition macro = this.getPageWrapper().contentMacro("content-" + this.getElementType(), this.getElementId());
        if (macro == null) {
            return this.setJSONError("Cannot find content-" + this.getElementType() + " macro " + this.getElementId() + " on " + this.getPage());
        }
        boolean bl = columnWidthChange = "width".equals(this.getName()) && "column".equals(this.getElementType());
        if (columnWidthChange) {
            if (!this.getValue().endsWith("%")) {
                return this.setJSONError("Widths must be percentages from 0% to 100%.");
            }
            if (BrikitNumber.parseFloat((String)this.getValue()) < 0.0f || BrikitNumber.parseFloat((String)this.getValue()) > 100.0f) {
                return this.setJSONError("Valid widths are from 0% to 100%.");
            }
        }
        MacroDefinition newMacro = MacroParser.clone((MacroDefinition)macro);
        String parameterName = BrikitString.isSet((String)this.getContainerName()) ? "container-" + this.getName() : this.getName();
        MacroParser.setParameter((MacroDefinition)newMacro, (String)parameterName, (String)this.getValue(), (AbstractPage)this.getPage());
        String newBody = Confluence.getBodyAsString((ContentEntityObject)this.getPage());
        newBody = MacroParser.replaceMacroInStorageFormat((AbstractPage)this.getPage(), (String)newBody, (MacroDefinition)macro, (MacroDefinition)newMacro);
        if (columnWidthChange) {
            newBody = this.getPageWrapper().rebalanceColumnsFromStorageFormat(newBody, Arrays.asList(newMacro));
        }
        Confluence.savePage((AbstractPage)this.getPage(), (String)newBody, (String)("change " + this.getElementType() + " " + this.getName() + " to " + this.getValue()), (boolean)false);
        ArrayList<MacroDefinition> elements = new ArrayList<MacroDefinition>();
        elements.add(this.getPageWrapper().layer(this.getLayerId()));
        JSONObject json = PageDesignerResponse.jsonResponse(this.getPage(), true, elements, "change", this.isReload() || conversion);
        json.put("elementType", (Object)this.getElementType());
        json.put("elementId", (Object)this.getElementId());
        json.put("container", (Object)this.getContainerName());
        json.put("name", (Object)this.getName());
        json.put("value", (Object)this.getValue());
        this.setJSONResult(json);
        return "success";
    }
}

